/*
 * Decompiled with CFR 0.152.
 */
package com.vs.ils;

import com.vs.ils.DomainLicenseCacheEntry;
import com.vs.ils.IlsUtil;
import com.vs.ils.ilsdb.AggInfo;
import com.vs.ils.ilsdb.Domain;
import com.vs.ils.ilsdb.ProdLicPCache;
import com.vs.ils.ilsdb.Product;
import com.vs.wdo.rtl.WdoBaseException;
import java.util.Date;
import java.util.HashMap;

class ProductLicenseCacheEntry {
    HashMap anonDomainEntries = new HashMap();
    HashMap namedDomainEntries = new HashMap();
    Date lastRefreshTime;
    ProdLicPCache pcache;

    public static synchronized ProductLicenseCacheEntry ProductLicenseCacheFactory(Date date, Product product) throws WdoBaseException {
        ProdLicPCache prodLicPCache = ProdLicPCache.Load((long)product.getProductId(), (long)date.getTime());
        ProductLicenseCacheEntry productLicenseCacheEntry = new ProductLicenseCacheEntry(date, product, prodLicPCache);
        if (productLicenseCacheEntry.getLicenseLimit() == (long)0) {
            productLicenseCacheEntry.refresh(date, product);
        }
        return productLicenseCacheEntry;
    }

    public synchronized void refresh(Date date, Product product) throws WdoBaseException {
        this.pcache.setProductName(product.getName());
        this.pcache.setLicenseLimit((long)product.getUserLimit());
        Date date2 = new Date();
        this.pcache.setNamedUserHighWatermark((long)product.getRegisteredUserCount());
        Date date3 = new Date();
        IlsUtil.Trace(7, "ProductLicenseCacheEntry", "refresh: time to getRegisteredActualUserCount: " + String.valueOf(date3.getTime() - date2.getTime()) + ".");
        date2 = date3;
        this.pcache.setDisabledNamedUserHighWatermark((long)product.getUserCount(true, false, date.getTime()));
        date3 = new Date();
        IlsUtil.Trace(7, "ProductLicenseCacheEntry", "refresh: time to getUserCount for disabled users: " + String.valueOf(date3.getTime() - date2.getTime()) + ".");
        date2 = date3;
        AggInfo aggInfo = product.getCheckoutTotalUserCounts(date.getTime());
        date3 = new Date();
        IlsUtil.Trace(7, "ProductLicenseCacheEntry", "refresh: time to getCheckoutTotalUserCounts: " + String.valueOf(date3.getTime() - date2.getTime()) + ".");
        this.pcache.setCheckoutPointsHighWatermark(aggInfo.getWeightedCount());
        this.pcache.setCheckoutActualUsersHighWatermark(aggInfo.getActualCount());
        date2 = date3;
        aggInfo = product.getCheckoutUserCounts(date.getTime());
        date3 = new Date();
        IlsUtil.Trace(7, "ProductLicenseCacheEntry", "refresh: time to getCheckoutUserCounts: " + String.valueOf(date3.getTime() - date2.getTime()) + ".");
        this.pcache.setAnonUsersHighWatermark(aggInfo.getWeightedCount());
        this.pcache.setAnonUsersActualHighWatermark(aggInfo.getActualCount());
        this.pcache.setUpdateTs(date.getTime());
        this.lastRefreshTime = date;
    }

    public ProductLicenseCacheEntry(Date date, Product product, ProdLicPCache prodLicPCache) throws WdoBaseException {
        this.pcache = prodLicPCache;
    }

    public synchronized boolean checkLimit(Date date, Product product, int n, long l) throws WdoBaseException {
        return this.checkLimit(date, product, null, n, l);
    }

    public synchronized boolean checkLimit(Date date, Product product, Domain domain, int n, long l) throws WdoBaseException {
        return this.checkLimit(date, product, domain, n, l, 0);
    }

    public synchronized boolean checkLimit(Date date, Product product, Domain domain, int n, long l, int n2) throws WdoBaseException {
        if (this.pcache.getLicenseLimit() != l) {
            this.pcache.setLicenseLimit(l);
        }
        return this.pcache.getNamedUserHighWatermark() + this.pcache.getAnonUsersHighWatermark() + (long)n - (long)n2 <= l;
    }

    public synchronized void setLicenseLimit(long l) throws WdoBaseException {
        if (l >= (long)0) {
            this.pcache.setLicenseLimit(l);
        }
    }

    public synchronized long getLicenseLimit() throws WdoBaseException {
        return this.pcache.getLicenseLimit();
    }

    public synchronized long getCurrLimit() throws WdoBaseException {
        return this.pcache.getNamedUserHighWatermark() + this.pcache.getAnonUsersHighWatermark();
    }

    public synchronized void adjustWatermark(Date date, Product product, int n, boolean bl) throws WdoBaseException {
        this.adjustWatermark2(date, product, n, n > 0 ? 1 : (n < 0 ? -1 : 0), bl);
    }

    public synchronized void adjustWatermark2(Date date, Product product, int n, int n2, boolean bl) throws WdoBaseException {
        if (n == 0) {
            return;
        }
        if (bl) {
            long l;
            if (this.pcache.getAnonUsersHighWatermark() + (long)n >= (long)0) {
                this.pcache.setAnonUsersHighWatermark(this.pcache.getAnonUsersHighWatermark() + (long)n);
            }
            if ((l = this.pcache.getAnonUsersActualHighWatermark() + (long)n2) >= (long)0) {
                this.pcache.setAnonUsersActualHighWatermark(l);
            }
            this.adjustCheckoutWatermark2(date, product, n, n2);
        } else if (this.pcache.getNamedUserHighWatermark() + (long)n >= (long)0) {
            this.pcache.setNamedUserHighWatermark(this.pcache.getNamedUserHighWatermark() + (long)n);
        }
    }

    public synchronized void adjustCheckoutWatermark(Date date, Product product, int n) throws WdoBaseException {
        this.adjustCheckoutWatermark2(date, product, n, n > 0 ? 1 : (n < 0 ? -1 : 0));
    }

    public synchronized void adjustCheckoutWatermark2(Date date, Product product, int n, int n2) throws WdoBaseException {
        if (n == 0 || n2 == 0) {
            return;
        }
        if (this.pcache.getCheckoutPointsHighWatermark() + (long)n >= (long)0) {
            this.pcache.setCheckoutPointsHighWatermark(this.pcache.getCheckoutPointsHighWatermark() + (long)n);
        }
        if (this.pcache.getCheckoutActualUsersHighWatermark() + (long)n2 >= (long)0) {
            this.pcache.setCheckoutActualUsersHighWatermark(this.pcache.getCheckoutActualUsersHighWatermark() + (long)n2);
        }
    }

    public synchronized void adjustDisabledUserWatermark(boolean bl) throws WdoBaseException {
        long l = this.pcache.getDisabledNamedUserHighWatermark();
        l = bl ? ++l : --l;
        if (l >= (long)0) {
            this.pcache.setDisabledNamedUserHighWatermark(l);
        }
    }

    public synchronized DomainLicenseCacheEntry getDomainEntry(Date date, Domain domain) throws WdoBaseException {
        return this.getDomainEntry(date, domain, domain.getLicenseModel().equals("NUSER"));
    }

    public synchronized DomainLicenseCacheEntry getDomainEntry(Date date, Domain domain, boolean bl) throws WdoBaseException {
        Long l;
        HashMap hashMap = bl ? this.anonDomainEntries : this.namedDomainEntries;
        DomainLicenseCacheEntry domainLicenseCacheEntry = (DomainLicenseCacheEntry)hashMap.get(l = new Long(domain.getDomainId()));
        if (domainLicenseCacheEntry == null) {
            domainLicenseCacheEntry = DomainLicenseCacheEntry.DomainLicenseCacheFactory(date, this, domain);
            hashMap.put(l, domainLicenseCacheEntry);
        }
        return domainLicenseCacheEntry;
    }

    public synchronized boolean dropDomainEntry(long l, boolean bl) {
        Long l2;
        HashMap hashMap = bl ? this.anonDomainEntries : this.namedDomainEntries;
        DomainLicenseCacheEntry domainLicenseCacheEntry = (DomainLicenseCacheEntry)hashMap.get(l2 = new Long(l));
        if (domainLicenseCacheEntry != null) {
            domainLicenseCacheEntry.pcache = null;
            hashMap.remove(l2);
        }
        return domainLicenseCacheEntry != null;
    }

    public synchronized boolean dropDomainEntry(long l) {
        boolean bl = true;
        if (!this.dropDomainEntry(l, true)) {
            return this.dropDomainEntry(l, false);
        }
        return true;
    }

    public synchronized void dumpCache() throws WdoBaseException {
        IlsUtil.Trace(9, "IlsLicenseCache", "ProductLicenseCacheEntry dump:\n" + this.pcache.toXML());
    }
}

