/*
 * Decompiled with CFR 0.152.
 */
package com.vs.ils;

import com.vs.ezlicrun.EzLicCustomLicenseInterface;
import com.vs.ezlicrun.EzLicExceptionBase;
import com.vs.ils.IlsUtil;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.StringTokenizer;

class MachineChecker
implements EzLicCustomLicenseInterface {
    private static final int _$31985 = 1;
    private static final int _$31996 = 2;
    private static final int _$32005 = 3;
    private static final int _$32013 = 4;
    private static final int _$32024 = 5;
    private static final int _$32031 = 6;
    private static final int _$32039 = 7;
    private static final String[] _$32048 = new String[]{null, "ipconfig /all", "/sbin/ifconfig -a", "lanscan", "/usr/sbin/arp -a", "netstat -v", "nvram", "dunno"};
    private static final String[] _$32054 = new String[]{null, "Physical Address", "HWaddr", "N/A", "N/A", "Hardware Address", "eaddr", "dunno"};
    private static final String[] _$32061 = new String[]{null, "-", ":", null, ":", ":", ":", "dunno"};
    private static final String[] _$32071 = new String[]{null, ":", " ", "N/A", "N/A", ":", "=", "dunno"};

    MachineChecker() {
    }

    private static int _$32078() throws EzLicExceptionBase {
        String string = System.getProperty("os.name");
        if (string.indexOf("Windows") >= 0) {
            return 1;
        }
        if (string.indexOf("Linux") >= 0) {
            return 2;
        }
        if (string.indexOf("Solaris") >= 0 || string.toLowerCase().indexOf("sunos") >= 0) {
            return 4;
        }
        if (string.toLowerCase().indexOf("hp") >= 0) {
            return 3;
        }
        if (string.toLowerCase().indexOf("aix") >= 0) {
            return 5;
        }
        if (string.toLowerCase().indexOf("irix") >= 0) {
            return 6;
        }
        EzLicExceptionBase.throwLicenseException((int)11, (String)("Unsupported OS for MAC Address Checking: " + string));
        return 0;
    }

    public int checkCustomKeyCode(String string, Object object) throws EzLicExceptionBase {
        boolean bl = false;
        int n = MachineChecker._$32078();
        if (!MachineChecker._$32120(string, _$32061[n])) {
            EzLicExceptionBase.throwLicenseException((int)1, (String)"Unrecognized machine parameter");
        }
        try {
            if (!MachineChecker._$32135(string, n)) {
                EzLicExceptionBase.throwLicenseException((int)4, (String)" Unlicensed Ethernet MAC Address");
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof EzLicExceptionBase) {
                throw (EzLicExceptionBase)throwable;
            }
            EzLicExceptionBase.throwLicenseException((int)9, (String)("Unexpected Exception: " + throwable.getClass().getName() + ", Message: " + throwable.getMessage()));
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean _$32135(String string, int n) throws Exception {
        IlsUtil.Trace(5, "IlsLicense", "checkMachineAddress: checking addr in key: " + string + " for OS: " + n);
        Process process = Runtime.getRuntime().exec(_$32048[n]);
        if (process == null) {
            throw new Exception("OS configuration error: can't run OS command '" + _$32048[n] + "'to get machine address");
        }
        BufferedReader bufferedReader = null;
        try {
            block14: {
                bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String string2 = null;
                block7: while (true) {
                    if ((string2 = bufferedReader.readLine()) == null) break block14;
                    string2 = string2.trim();
                    IlsUtil.Trace(10, "IlsLicense", "checkMachineAddress: Processing ifconfig line: " + string2);
                    switch (n) {
                        case 3: {
                            String string3;
                            StringTokenizer stringTokenizer = new StringTokenizer(string2, " \t");
                            if (stringTokenizer.hasMoreTokens()) {
                                stringTokenizer.nextToken();
                            }
                            if (!stringTokenizer.hasMoreTokens() || !(string3 = stringTokenizer.nextToken()).startsWith("0x") || !string3.equals(string)) continue block7;
                            boolean bl = true;
                            Object var9_15 = null;
                            if (bufferedReader == null) return bl;
                            bufferedReader.close();
                            return bl;
                        }
                        case 4: {
                            StringTokenizer stringTokenizer = new StringTokenizer(string2, " \t");
                            String string3 = null;
                            do {
                                string3 = stringTokenizer.nextToken();
                            } while (stringTokenizer.hasMoreTokens());
                            if (string3 == null || !MachineChecker._$32120(string3, ":") || !string3.equals(string)) continue block7;
                            boolean bl = true;
                            Object var9_16 = null;
                            if (bufferedReader == null) return bl;
                            bufferedReader.close();
                            return bl;
                        }
                        case 5: {
                            int n2 = -1;
                            while (true) {
                                if (string2 == null || (n2 = string2.indexOf(_$32054[n])) < 0) continue block7;
                                if (n2 > 0) {
                                    string2 = string2.substring(n2);
                                }
                                IlsUtil.Trace(10, "IlsLicense", "checkMachineAddress: It's a MAC addr line based on search of kwd: " + _$32054[n]);
                                if ((string2 = string2.substring(string2.indexOf(_$32071[n]) + 1)) == null) continue;
                                string2 = string2.trim();
                                IlsUtil.Trace(10, "IlsLicense", "checkMachineAddress: It's '" + string2 + "'");
                                if (string2.startsWith(string)) break;
                            }
                            boolean bl = true;
                            Object var9_17 = null;
                            if (bufferedReader == null) return bl;
                            bufferedReader.close();
                            return bl;
                        }
                    }
                    int n3 = -1;
                    n3 = string2.indexOf(_$32054[n]);
                    if (n3 < 0) continue;
                    if (n3 > 0) {
                        string2 = string2.substring(n3);
                    }
                    IlsUtil.Trace(10, "IlsLicense", "checkMachineAddress: It's a MAC addr line based on search of kwd: " + _$32054[n]);
                    if ((string2 = string2.substring(string2.indexOf(_$32071[n]) + 1)) == null) continue;
                    string2 = string2.trim();
                    IlsUtil.Trace(10, "IlsLicense", "checkMachineAddress: It's '" + string2 + "'");
                    if (string2.startsWith(string)) break;
                }
                boolean bl = true;
                Object var9_18 = null;
                if (bufferedReader == null) return bl;
                bufferedReader.close();
                return bl;
            }
            boolean bl = false;
            Object var9_19 = null;
            if (bufferedReader == null) return bl;
            bufferedReader.close();
            return bl;
        }
        catch (Throwable throwable) {
            Object var9_20 = null;
            if (bufferedReader == null) throw throwable;
            bufferedReader.close();
            throw throwable;
        }
    }

    private static boolean _$32120(String string, String string2) {
        IlsUtil.Trace(5, "IlsLicense", "checkIfMACAddr: Checking for well formed MAC addr.  mcAddr: " + string + ", toksep: " + string2);
        if (string2 == null) {
            if (!string.startsWith("0x")) {
                return false;
            }
            try {
                Long.parseLong(string.substring(2), 16);
            }
            catch (Throwable throwable) {
                boolean bl = false;
                return bl;
            }
            return true;
        }
        String string3 = string;
        int n = -1;
        int n2 = 0;
        string3 = string;
        while (n2 < 5) {
            n = string3.indexOf(string2);
            if (n <= 0) {
                IlsUtil.Trace(5, "IlsLicense", "checkIfMACAddr: Invalid MAC addr found at i: " + n2 + ", tmp: " + string3);
                return false;
            }
            ++n2;
            string3 = string3.substring(n + 1);
        }
        return true;
    }
}

