/*
 * Decompiled with CFR 0.152.
 */
package com.vs.ils;

import com.vs.ils.IlsUtil;
import com.vs.ils.ilsdb.AdminInfo;
import com.vs.ils.ilsdb.LicenseParamInfo;
import com.vs.wdo.rtl.WdoBaseException;
import java.sql.Timestamp;
import java.util.Date;

class LuwUtil {
    LuwUtil() {
    }

    public static LicenseParamInfo SetupLicenseParams(Date date, int n, long l, int n2, long l2, int n3, long l3, String string) throws WdoBaseException {
        LicenseParamInfo licenseParamInfo = new LicenseParamInfo();
        if (l > (long)0) {
            licenseParamInfo.setQuotaLimited(true);
            licenseParamInfo.setQuota(l);
            licenseParamInfo.setQuotaGrace(l2);
            licenseParamInfo.setQuotaWarningThreshold(l3);
        }
        licenseParamInfo.setTimeLimitType(date != null ? "ABST" : (n > 0 ? "RELT" : "NONE"));
        if (date != null || n > 0) {
            if (date != null) {
                licenseParamInfo.setExpDate(new Timestamp(date.getTime()));
            } else {
                licenseParamInfo.setExpDays((long)n);
            }
            licenseParamInfo.setExpGrace(n2);
            licenseParamInfo.setExpWarningThreshold(n3);
        }
        licenseParamInfo.setOptions(string);
        return licenseParamInfo;
    }

    public static AdminInfo SetupAdminInfo(Date date) throws WdoBaseException {
        AdminInfo adminInfo = new AdminInfo();
        adminInfo.setCreationDate(new Timestamp(date.getTime()));
        adminInfo.setUpdateDate(new Timestamp(date.getTime()));
        adminInfo.setUpdateTs(date.getTime());
        adminInfo.setNotes("Creation by AdminAPI");
        return adminInfo;
    }

    public static boolean SyncLicenseParams(LicenseParamInfo licenseParamInfo, LicenseParamInfo licenseParamInfo2) throws WdoBaseException {
        IlsUtil.Trace(10, "IlsAdminAPI", new String[]{"LuwUtil:SyncLicenseParams:enter.", "currParams:", licenseParamInfo.toXML(), "inParams:", licenseParamInfo2.toXML()});
        boolean bl = false;
        if (licenseParamInfo.optionsIsDefined() && licenseParamInfo2.optionsIsDefined() && !licenseParamInfo.getOptions().equals(licenseParamInfo2.getOptions()) || !licenseParamInfo.optionsIsDefined() && licenseParamInfo2.optionsIsDefined()) {
            licenseParamInfo.setOptions(licenseParamInfo2.getOptions());
            bl = true;
        }
        if (licenseParamInfo.getQuotaLimited() != licenseParamInfo2.getQuotaLimited()) {
            licenseParamInfo.setQuotaLimited(licenseParamInfo2.getQuotaLimited());
            bl = true;
        }
        if (licenseParamInfo2.getQuotaLimited()) {
            if (licenseParamInfo.getQuota() != licenseParamInfo2.getQuota()) {
                licenseParamInfo.setQuota(licenseParamInfo2.getQuota());
                bl = true;
            }
            if (licenseParamInfo.getQuotaGrace() != licenseParamInfo2.getQuotaGrace()) {
                licenseParamInfo.setQuotaGrace(licenseParamInfo2.getQuotaGrace());
                bl = true;
            }
            if (licenseParamInfo.getQuotaWarningThreshold() != licenseParamInfo2.getQuotaWarningThreshold()) {
                licenseParamInfo.setQuotaWarningThreshold(licenseParamInfo2.getQuotaWarningThreshold());
                bl = true;
            }
        } else if (bl) {
            licenseParamInfo.setQuota(-1L);
        }
        if (!licenseParamInfo.getTimeLimitType().equals(licenseParamInfo2.getTimeLimitType())) {
            licenseParamInfo.setTimeLimitType(licenseParamInfo2.getTimeLimitType());
            bl = true;
        }
        if (!licenseParamInfo2.getTimeLimitType().equals("NONE")) {
            if (licenseParamInfo2.getTimeLimitType().equals("ABST") && (!licenseParamInfo.expDateIsDefined() || licenseParamInfo.getExpDate().getTime() != licenseParamInfo2.getExpDate().getTime())) {
                licenseParamInfo.setExpDate(licenseParamInfo2.getExpDate());
                bl = true;
            }
            if (licenseParamInfo2.getTimeLimitType().equals("RELT") && licenseParamInfo.getExpDays() != licenseParamInfo2.getExpDays()) {
                licenseParamInfo.setExpDays(licenseParamInfo2.getExpDays());
                licenseParamInfo.expDateUndefine();
                bl = true;
            }
            if (licenseParamInfo.getExpGrace() != licenseParamInfo2.getExpGrace()) {
                licenseParamInfo.setExpGrace(licenseParamInfo2.getExpGrace());
                bl = true;
            }
            if (licenseParamInfo.getExpWarningThreshold() != licenseParamInfo2.getExpWarningThreshold()) {
                licenseParamInfo.setExpWarningThreshold(licenseParamInfo2.getExpWarningThreshold());
                bl = true;
            }
        } else if (bl) {
            licenseParamInfo.expDateUndefine();
            licenseParamInfo.setExpDays(-1L);
        }
        IlsUtil.Trace(10, "IlsAdminAPI", new String[]{"LuwUtil: SyncLicenseParams:exit. mods=" + bl, "Updated currParams:", licenseParamInfo.toXML()});
        return bl;
    }
}

