/*
 * Decompiled with CFR 0.152.
 */
package com.vs.ils;

import com.vs.ils.IlsException;
import com.vs.ils.IlsSystem;
import com.vs.ils.crypt.Crypt;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.StringTokenizer;

public class IlsUtil {
    public static String VersionString = "2.0.04";
    public static int TIME_PRECISION_MS = 1;
    public static int TIME_PRECISION_SEC = 2;
    public static int TIME_PRECISION_MIN = 3;
    public static int TIME_PRECISION_HR = 4;
    public static int TIME_PRECISION_DAY = 5;
    private static int _$34239 = -100;
    private static int _$34244 = -100;
    private static int _$34255 = -100;
    static long eventId;
    public static final char[] alphabet;

    public static boolean CheckDebug(int n) {
        return (_$34239 = IlsUtil._$34312("ILSDEBUG", _$34239)) >= n;
    }

    public static boolean CheckDebugSecure(int n) {
        return (_$34244 = IlsUtil._$34312("ILSDBUGH", _$34244)) >= n;
    }

    public static boolean CheckConsole(int n) {
        return (_$34255 = IlsUtil._$34312("ILSCONSOLE", _$34255)) >= n;
    }

    public static void Trace(int n, String string, String string2) {
        IlsUtil.Trace(false, n, string, new String[]{string2}, false);
    }

    public static void Trace(String string, String[] stringArray) {
        IlsUtil.Trace(false, -1, string, stringArray, false);
    }

    public static void Trace(int n, String string, String[] stringArray) {
        IlsUtil.Trace(false, n, string, stringArray, false);
    }

    public static void Trace(boolean bl, int n, String string, String string2) {
        IlsUtil.Trace(bl, n, string, new String[]{string2}, false);
    }

    public static void Trace(boolean bl, String string, String[] stringArray) {
        IlsUtil.Trace(bl, -1, string, stringArray, false);
    }

    public static void Trace(boolean bl, int n, String string, String[] stringArray) {
        IlsUtil.Trace(bl, n, string, stringArray, false);
    }

    public static synchronized void Trace(boolean bl, int n, String string, String[] stringArray, boolean bl2) {
        IlsUtil.Trace(bl, n, string, stringArray, bl2, null);
    }

    public static synchronized void Trace(boolean bl, int n, String string, String[] stringArray, boolean bl2, Throwable throwable) {
        if (n <= 0 || (bl ? IlsUtil.CheckDebugSecure(n) : IlsUtil.CheckDebug(n))) {
            Date date = new Date();
            String string2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z").format(date);
            System.out.println("#" + ++eventId + ": " + string2 + "[" + (n <= 0 ? "N/A" : String.valueOf(n)) + "]:" + (string == null ? "" : string));
            if (stringArray != null) {
                int n2 = 0;
                while (n2 < stringArray.length) {
                    if (stringArray[n2] != null) {
                        System.out.println("    " + stringArray[n2]);
                    }
                    ++n2;
                }
            }
            if (bl2) {
                if (throwable == null) {
                    throwable = new Throwable();
                }
                throwable.printStackTrace();
            }
        }
    }

    public static boolean Sleep(int n) {
        try {
            Thread.sleep(n);
            boolean bl = true;
            return bl;
        }
        catch (Throwable throwable) {
            IlsUtil.Trace(8, "IlsUtil", "Thread sleep exception.  Exception: " + throwable.getClass().getName() + ", Message: " + throwable.getMessage());
            return false;
        }
    }

    public static HashMap MakeKeyMap(String string, String string2) throws IlsException {
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = ";";
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = null;
            String string4 = null;
            String string5 = stringTokenizer.nextToken();
            int n = string5.indexOf("=");
            if (n <= 0 || n >= string5.length()) {
                IlsException.ThrowException(1000, "Malformed command: invalid syntax for keyword string: " + string);
            }
            string3 = string5.substring(0, n);
            string4 = string5.substring(n + 1);
            hashMap.put(string3, string4);
        }
        return hashMap;
    }

    public static int GetPositiveInt(String string) {
        int n = -1;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            n = -1;
        }
        return n;
    }

    public static long GetPositiveLong(String string) {
        long l = -1L;
        try {
            l = Long.parseLong(string);
        }
        catch (Exception exception) {
            l = -1L;
        }
        return l;
    }

    public static boolean IsNan(String string) {
        boolean bl = true;
        try {
            long l = Long.parseLong(string);
            bl = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public static long GetRoundedTs(long l) {
        java.sql.Date date = new java.sql.Date(l);
        String string = date.toString();
        try {
            date = java.sql.Date.valueOf(string);
        }
        catch (Exception exception) {
            long l2 = l;
            return l2;
        }
        return date.getTime();
    }

    public static long GetRoundedSecondsFromSeconds(long l, long l2) {
        long l3 = IlsUtil.GetRoundedTs(l + l2 * (long)1000);
        return (l3 - l) / (long)1000;
    }

    public static long GetRoundedSecondsFromDays(long l, long l2) {
        return IlsUtil.GetRoundedSecondsFromSeconds(l, l2 * (long)86400);
    }

    public static String[] SafeSplit(String string, String string2) {
        String[] stringArray;
        int n = string.indexOf(string2);
        if (n < 0) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = string;
            stringArray = stringArray2;
            stringArray2[1] = "";
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = string.substring(0, n);
            stringArray = stringArray3;
            stringArray3[1] = string.substring(n + string2.length());
        }
        return stringArray;
    }

    public static boolean GetBooleanFromString(String string, boolean bl) {
        boolean bl2;
        boolean bl3;
        if (string != null) {
            string = string.trim();
        }
        boolean bl4 = bl3 = string != null && !string.equals("") && (string.equals("1") || string.equalsIgnoreCase("y") || string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("true") || string.equalsIgnoreCase("t"));
        if (bl3) {
            return true;
        }
        boolean bl5 = bl2 = string != null && !string.equals("") && (string.equals("0") || string.equalsIgnoreCase("n") || string.equalsIgnoreCase("no") || string.equalsIgnoreCase("false") || string.equalsIgnoreCase("f"));
        if (bl2) {
            return false;
        }
        return !bl;
    }

    public static Date GetDate(String string, String string2) {
        Date date = null;
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
            if (simpleDateFormat != null) {
                date = simpleDateFormat.parse(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return date;
    }

    public static Date GetAcceptableDate(String string) {
        Date date = IlsUtil.GetDate(string, "yyyy-MM-dd HH:mm:ss Z");
        if (date != null) {
            return date;
        }
        date = IlsUtil.GetDate(string, "yyyy-MM-dd HH:mm:ss");
        if (date != null) {
            return date;
        }
        date = IlsUtil.GetDate(string, "yyyy-MM-dd HH:mm");
        if (date != null) {
            return date;
        }
        date = IlsUtil.GetDate(string, "yyyy-MM-dd");
        if (date != null) {
            return date;
        }
        return null;
    }

    public static Date GetCalendarDate(String string) {
        return IlsUtil.GetDate(string, "MM/dd/yyyy HH:mm:ss");
    }

    public static String GetDateStringForFilename(Date date) {
        return new SimpleDateFormat("yyMMdd-HHmmss").format(date);
    }

    public static String GetElapsedTimeString(long l, int n, boolean bl) {
        long l2 = l;
        long l3 = l2 / 86400000L;
        long l4 = (l2 %= 86400000L) / 3600000L;
        long l5 = (l2 %= 3600000L) / 60000L;
        long l6 = (l2 %= 60000L) / 1000L;
        l2 %= 1000L;
        String string = "";
        if (l3 > (long)0 && n <= TIME_PRECISION_DAY) {
            string = String.valueOf(string) + l3 + " days ";
        }
        if (l4 > (long)0 && n <= TIME_PRECISION_HR) {
            string = String.valueOf(string) + l4 + " hrs ";
        }
        if (l5 > (long)0 && n <= TIME_PRECISION_MIN) {
            string = String.valueOf(string) + l5 + " minutes ";
        }
        if (l6 > (long)0 && n <= TIME_PRECISION_SEC) {
            string = String.valueOf(string) + l6 + " seconds ";
        }
        if (n == TIME_PRECISION_MS) {
            string = String.valueOf(string) + l2 + " milliseconds ";
        }
        if (bl && (l3 != (long)0 || l4 != (long)0 || l5 != (long)0 || l6 != (long)0)) {
            string = String.valueOf(string) + "(" + l + " milliseconds) ";
        }
        return string;
    }

    public static Date GetDateFromFilename(String string) {
        Date date = null;
        try {
            date = new SimpleDateFormat("yyMMdd-HHmmss").parse(string);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return date;
    }

    public static String ToUpperStart(String string) {
        int n = string.charAt(0);
        n = (char)(n >= 97 && n <= 122 ? n + 65 - 97 : n);
        return String.valueOf(String.valueOf((char)n)) + string.substring(1);
    }

    public static String URLEncode(String string) {
        if (string == null) {
            return null;
        }
        String string2 = "internal-error";
        try {
            string2 = URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return string2;
    }

    public static String URLDecode(String string) {
        if (string == null) {
            return null;
        }
        String string2 = "internal-error";
        try {
            string2 = URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return string2;
    }

    public static String GetHostName() {
        String string = null;
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            if (inetAddress != null) {
                string = inetAddress.getHostName();
            }
            if (string == null) {
                string = "localhost";
            }
        }
        catch (Throwable throwable) {
            string = "localhost";
        }
        return string;
    }

    public static String GetEncryptedPasswd(String string, String string2) {
        String string3 = "";
        if (string != null && !string.equals("")) {
            string3 = Crypt.encode((String)"dyAuYCM/bV==", (String)string, (String)string2);
        }
        return string3;
    }

    public static String GetDecryptedPasswd(String string, String string2) {
        String string3 = "";
        if (string != null && !string.equals("")) {
            string3 = Crypt.decode((String)"dyAuYCM/bV==", (String)string, (String)string2);
        }
        return string3;
    }

    public static String GetScrambledMsg(String string) {
        String string2 = string;
        int n = string.indexOf("user=sysadmin");
        if (n > 0 && (n = string.indexOf("passwd=")) > 0) {
            string2 = String.valueOf(string.substring(0, n)) + "passwd=*******";
            string = string.substring(n);
            n = string.indexOf("&");
            string2 = String.valueOf(string2) + string.substring(n);
        }
        return string2;
    }

    private static int _$34312(String string, int n) {
        if (n == -100) {
            String string2 = IlsSystem.GetEnvvar(string);
            if (string2 != null && !string2.equals("")) {
                if (string2.charAt(0) == '\"' && string2.charAt(string2.length() - 1) == '\"') {
                    string2 = string2.substring(1, string2.length() - 2);
                }
                n = IlsUtil.GetPositiveInt(string2);
            } else {
                n = -1;
            }
        }
        return n;
    }

    public static String encodeBase64(String string) {
        return IlsUtil.encodeBase64(string.getBytes());
    }

    public static String encodeBase64(byte[] byArray) {
        int n;
        int n2;
        char[] cArray = new char[((byArray.length - 1) / 3 + 1) * 4];
        int n3 = 0;
        int n4 = 0;
        while (n4 + 3 <= byArray.length) {
            n2 = (byArray[n4++] & 0xFF) << 16;
            n2 |= (byArray[n4++] & 0xFF) << 8;
            n = ((n2 |= (byArray[n4++] & 0xFF) << 0) & 0xFC0000) >> 18;
            cArray[n3++] = alphabet[n];
            n = (n2 & 0x3F000) >> 12;
            cArray[n3++] = alphabet[n];
            n = (n2 & 0xFC0) >> 6;
            cArray[n3++] = alphabet[n];
            n = n2 & 0x3F;
            cArray[n3++] = alphabet[n];
        }
        if (byArray.length - n4 == 2) {
            n2 = (byArray[n4] & 0xFF) << 16;
            n = ((n2 |= (byArray[n4 + 1] & 0xFF) << 8) & 0xFC0000) >> 18;
            cArray[n3++] = alphabet[n];
            n = (n2 & 0x3F000) >> 12;
            cArray[n3++] = alphabet[n];
            n = (n2 & 0xFC0) >> 6;
            cArray[n3++] = alphabet[n];
            cArray[n3++] = 61;
        } else if (byArray.length - n4 == 1) {
            n2 = (byArray[n4] & 0xFF) << 16;
            n = (n2 & 0xFC0000) >> 18;
            cArray[n3++] = alphabet[n];
            n = (n2 & 0x3F000) >> 12;
            cArray[n3++] = alphabet[n];
            cArray[n3++] = 61;
            cArray[n3++] = 61;
        }
        return new String(cArray);
    }

    public static int GetMsgProtocolVsn(String string, String string2) {
        String[] stringArray = string.split(string2);
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].startsWith("protocol_vsn=")) {
                String string3 = stringArray[n].substring(stringArray[n].indexOf("=") + 1);
                IlsUtil.Trace(13, "IlsUtil", "GetMsgProtocolVsn: extracted protocol vsn " + string3 + " from cmdStr " + string);
                return IlsUtil.GetPositiveInt(string3);
            }
            ++n;
        }
        return -1;
    }

    static {
        alphabet = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    }

    public static class Semaphore {
        private int _$34271 = 1;

        public Semaphore() {
        }

        public Semaphore(int n) {
            this._$34271 = n;
        }

        public synchronized boolean wait(boolean bl) {
            if (bl) {
                return this._$34271 > 0;
            }
            try {
                if (this._$34271-- <= 0) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                boolean bl2 = false;
                return bl2;
            }
            return true;
        }

        public synchronized void signal() {
            if (++this._$34271 <= 0) {
                this.notify();
            }
        }
    }
}

