/*
 * Decompiled with CFR 0.152.
 */
package com.vs.ils;

import com.vs.ezlicrun.Crypt;
import com.vs.ils.IlsException;
import com.vs.ils.IlsUtil;
import java.util.Date;
import java.util.HashMap;

public class IlsToken {
    public static final int TOKEN_VSN = 1;
    public static final long TSDELTALIMIT = 21600000L;
    public static final long TSDELTADELTALIMIT = 3600000L;
    static final long NUSER_USERID = Long.MAX_VALUE;
    protected String tokenString;
    protected int version;
    protected long serverTs;
    protected long clientTs;
    protected long expireTs;
    protected String clientMachine;
    protected long sessionId = 1L;
    protected String serverInstance;
    protected long productId;
    protected long domainId;
    protected long userId;
    protected int authLevel;
    protected int points;
    String[] pvtkwds = new String[]{"", "vsn", "sts", "cts", "xts", "cmc", "svr", "prd", "dom", "usr", "auth", "pts", "sess", "cksm", ""};
    protected static final int VSN = 1;
    protected static final int STS = 2;
    protected static final int CTS = 3;
    protected static final int XTS = 4;
    protected static final int CMC = 5;
    protected static final int SVR = 6;
    protected static final int PRD = 7;
    protected static final int DOM = 8;
    protected static final int USR = 9;
    protected static final int AUTH = 10;
    protected static final int PTS = 11;
    protected static final int SESS = 12;
    protected static final int CKSM = 13;
    protected static final int NUMPIECES = 13;

    public IlsToken() {
    }

    public IlsToken(String string) {
        this.tokenString = string;
    }

    public IlsToken(long l, long l2, long l3, String string, long l4, String string2, long l5, long l6, long l7, int n, int n2) {
        this._$23186(l, l2, l3, string, l4, string2, l5, l6, l7, n, n2);
    }

    public static IlsToken MakeToken(String string, long l, long l2, long l3, String string2, long l4, String string3, long l5, long l6, long l7, int n, int n2) throws IlsException {
        long l8 = l - l2;
        if (l8 < (long)0) {
            l8 = -l8;
        }
        if (l8 > 21600000L) {
            IlsUtil.Trace(3, "IlsToken", "MakeToken: Delta too great.  Client ts: " + l2 + ", server ts: " + l + ", delta: " + l8);
            IlsException.ThrowException("client / server time difference too great.  delta: " + l8, 3);
        }
        if (n2 <= 0) {
            n2 = 1;
        }
        IlsToken ilsToken = new IlsToken(l, l2, l3, string2, l4, string3, l5, l6, l7, n, n2);
        ilsToken._$33899(string);
        return ilsToken;
    }

    public String getTokenString() {
        return this.tokenString;
    }

    public int getVersion() {
        return this.version;
    }

    public long getServerTs() {
        return this.serverTs;
    }

    public long getClientTs() {
        return this.clientTs;
    }

    public long getExpireTs() {
        return this.expireTs;
    }

    public String getClientMachine() {
        return this.clientMachine;
    }

    public long getSessionId() {
        return this.sessionId;
    }

    public String getServerInstance() {
        return this.serverInstance;
    }

    public long getProductId() {
        return this.productId;
    }

    public long getDomainId() {
        return this.domainId;
    }

    public long getUserId() {
        return this.userId;
    }

    public int getAuthLevel() {
        return this.authLevel;
    }

    public int getPoints() {
        return this.points;
    }

    public static IlsToken ParseToken(String string, String string2) throws IlsException {
        String string3 = null;
        IlsToken ilsToken = new IlsToken();
        ilsToken.tokenString = string;
        String string4 = Crypt.decode((String)"dyAuYCM/bV==", (String)string, (String)string2);
        IlsUtil.Trace(true, 5, "IlsToken", new String[]{"ParseToken: decoded token:\n[" + ilsToken.getTokenString() + "]\nwith service name: " + string2, "Decoded token: [" + string4 + "]"}, false);
        HashMap hashMap = IlsUtil.MakeKeyMap(string4, ":");
        if (hashMap == null) {
            IlsException.ThrowException("ParseToken could not make hashmap", 1000);
        }
        if ((string3 = (String)hashMap.get("vsn")) == null || (ilsToken.version = IlsUtil.GetPositiveInt(string3)) <= 0) {
            IlsException.ThrowException("version not found", 1);
        }
        if ((string3 = (String)hashMap.get("sts")) == null || (ilsToken.serverTs = IlsUtil.GetPositiveLong(string3)) <= (long)0) {
            IlsException.ThrowException("svr ts not found", 1);
        }
        IlsUtil.Trace(10, "IlsToken", "ParseToken: Got server ts: " + ilsToken.serverTs);
        string3 = (String)hashMap.get("cts");
        if (string3 == null || (ilsToken.clientTs = IlsUtil.GetPositiveLong(string3)) <= (long)0) {
            IlsException.ThrowException("client ts not found", 1);
        }
        IlsUtil.Trace(10, "IlsToken", "ParseToken: Got client ts: " + ilsToken.clientTs);
        string3 = (String)hashMap.get("xts");
        if (string3 == null || (ilsToken.expireTs = IlsUtil.GetPositiveLong(string3)) <= (long)0) {
            IlsException.ThrowException("expire ts not found", 1);
        }
        IlsUtil.Trace(10, "IlsToken", "ParseToken: Got expire ts: " + ilsToken.expireTs);
        string3 = (String)hashMap.get("sess");
        if (string3 == null || (ilsToken.sessionId = IlsUtil.GetPositiveLong(string3)) <= (long)0) {
            IlsException.ThrowException("invalid session id", 1);
        }
        if ((ilsToken.clientMachine = (String)hashMap.get("cmc")) == null) {
            IlsException.ThrowException("client machine not found", 1);
        }
        if ((ilsToken.serverInstance = (String)hashMap.get("svr")) == null) {
            IlsException.ThrowException("server instance not found", 1);
        }
        if (!ilsToken.serverInstance.equals(IlsUtil.GetHostName())) {
            IlsException.ThrowException("wrong server instance - expected [" + IlsUtil.GetHostName() + "], got [" + ilsToken.serverInstance + "]", 1);
        }
        if ((string3 = (String)hashMap.get("prd")) == null || (ilsToken.productId = IlsUtil.GetPositiveLong(string3)) < (long)0) {
            IlsException.ThrowException("product id not found", 1);
        }
        if ((string3 = (String)hashMap.get("dom")) == null || (ilsToken.domainId = IlsUtil.GetPositiveLong(string3)) < (long)0) {
            IlsException.ThrowException("domain id not found", 1);
        }
        if ((string3 = (String)hashMap.get("usr")) == null || (ilsToken.userId = IlsUtil.GetPositiveLong(string3)) < (long)0) {
            IlsException.ThrowException("user id not found", 1);
        }
        if ((string3 = (String)hashMap.get("auth")) == null || (ilsToken.authLevel = IlsUtil.GetPositiveInt(string3)) < 0) {
            IlsException.ThrowException("auth level not found", 1);
        }
        if ((string3 = (String)hashMap.get("pts")) == null || (ilsToken.points = IlsUtil.GetPositiveInt(string3)) < 0) {
            IlsException.ThrowException("points not found", 1);
        }
        IlsUtil.Trace(10, "IlsToken", "ParseToken: completed token parse.");
        return ilsToken;
    }

    public void validateToken(IlsToken ilsToken) throws IlsException {
        Date date;
        long l;
        long l2;
        long l3;
        if (ilsToken.clientTs < this.clientTs) {
            IlsException.ThrowException("client time travel.  token ts: " + this.clientTs + ", new ts: " + ilsToken.clientTs, 3);
        }
        if (ilsToken.version > 1) {
            IlsException.ThrowException("incompatible token version.  expected: 1, got: " + ilsToken.version, 1);
        }
        if ((l3 = this.serverTs - this.clientTs) - (l2 = (l = (date = new Date()).getTime()) - ilsToken.clientTs) > 3600000L) {
            IlsException.ThrowException("client / server time drift.  old delta: " + l3 + ", new delta: " + l2, 3);
        }
        if (!this.clientMachine.equals(ilsToken.clientMachine)) {
            IlsException.ThrowException("unexpected client machine.  expected: [" + this.clientMachine + "], got: [" + ilsToken.clientMachine + "]", 22);
        }
        if (this.sessionId != ilsToken.getSessionId()) {
            IlsException.ThrowException("unexpected client session id.  expected: " + this.sessionId + ", got: " + ilsToken.sessionId, 22);
        }
        if (this.productId != ilsToken.productId) {
            IlsException.ThrowException("unexpected product Id.  expected: " + this.productId + ", got: " + ilsToken.productId, 7);
        }
        if (this.domainId != ilsToken.domainId) {
            IlsException.ThrowException("unexpected domain Id.  expected: " + this.domainId + ", got: " + ilsToken.domainId, 8);
        }
        if (this.userId != ilsToken.userId) {
            IlsException.ThrowException("unexpected user Id.  expected: " + this.userId + ", got: " + ilsToken.userId, 9);
        }
        if (this.expireTs < l) {
            IlsException.ThrowException("token expired on " + new Date(this.expireTs) + ", right now it's: " + date, 4);
        }
    }

    private void _$23186(long l, long l2, long l3, String string, long l4, String string2, long l5, long l6, long l7, int n, int n2) {
        this.version = 1;
        this.serverTs = l;
        this.clientTs = l2;
        this.expireTs = l3;
        this.clientMachine = string;
        this.sessionId = l4;
        this.serverInstance = string2;
        this.productId = l5;
        this.domainId = l6;
        this.userId = l7;
        this.authLevel = n;
        this.points = n2;
    }

    private void _$33899(String string) {
        int[] nArray = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12};
        nArray = IlsToken._$34029(nArray, 12);
        String string2 = this._$34060(nArray, 12);
        this.tokenString = Crypt.encode((String)"dyAuYCM/bV==", (String)string2, (String)string);
        IlsUtil.Trace(true, 5, "IlsToken", new String[]{"makeTokenString: cleartext token: " + string2, "Encoding with service name: " + string, "Encoded token: " + this.tokenString}, false);
    }

    private static int[] _$34029(int[] nArray, int n) {
        int n2 = (int)(new Date().getTime() % 367L);
        int[] nArray2 = new int[n];
        int n3 = 0;
        while (n3 < n) {
            nArray2[(n3 + n2) % n] = nArray[n3];
            ++n3;
        }
        return nArray2;
    }

    private String _$34060(int[] nArray, int n) {
        if (n == 0) {
            return null;
        }
        String string = this._$34089(nArray[0]);
        int n2 = 1;
        while (n2 < n) {
            string = String.valueOf(string) + ":" + this._$34089(nArray[n2]);
            ++n2;
        }
        n2 = IlsToken.makeChecksum(string);
        IlsUtil.Trace(true, 10, "IlsToken", new String[]{"makeKey: Token checksum: " + n2}, false);
        string = String.valueOf(string) + ":cksm=" + n2;
        return string;
    }

    private String _$34089(int n) {
        switch (n) {
            case 1: {
                return "vsn=" + this.version;
            }
            case 2: {
                return "sts=" + this.serverTs;
            }
            case 3: {
                return "cts=" + this.clientTs;
            }
            case 4: {
                return "xts=" + this.expireTs;
            }
            case 5: {
                return "cmc=" + this.clientMachine;
            }
            case 12: {
                return "sess=" + this.sessionId;
            }
            case 6: {
                return "svr=" + this.serverInstance;
            }
            case 7: {
                return "prd=" + this.productId;
            }
            case 8: {
                return "dom=" + this.domainId;
            }
            case 9: {
                return "usr=" + this.userId;
            }
            case 10: {
                return "auth=" + this.authLevel;
            }
            case 11: {
                return "pts=" + this.points;
            }
        }
        return null;
    }

    static int makeChecksum(String string) {
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            n += string.charAt(n2);
            ++n2;
        }
        return n;
    }
}

