/*
 * Decompiled with CFR 0.152.
 */
package com.vs.ils;

import com.vs.ezlicgen.EzLicenseFullInfo;
import com.vs.ezlicrun.EzLicCustomLicenseInterface;
import com.vs.ezlicrun.EzLicExceptionBase;
import com.vs.ezlicrun.EzLicExceptionExceededLimits;
import com.vs.ezlicrun.EzLicExceptionExpired;
import com.vs.ezlicrun.EzLicenseInfo;
import com.vs.ils.AlerterJob;
import com.vs.ils.IlsCmdAPI;
import com.vs.ils.IlsCmdArgs;
import com.vs.ils.IlsException;
import com.vs.ils.IlsJob;
import com.vs.ils.IlsKeyCtx;
import com.vs.ils.IlsKeyHandler;
import com.vs.ils.IlsLicenseExceptionHandler;
import com.vs.ils.IlsUtil;
import com.vs.ils.client.IlsClient;
import com.vs.ils.crypt.Crypt;
import com.vs.ils.crypt.PkCrypt;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;

public class IlsLicense {
    private static final long _$30776 = 30000L;
    String licenseKey;
    String serviceName;
    String productName;
    String options;
    long userCount;
    boolean noNodelockCheck;
    EzLicenseFullInfo keyInfo;
    static boolean checkedSig;
    String spclky = Crypt.decode((String)"dyAuYCM/bV==", (String)"axHtYW==", (String)"ipsic");
    private static IlsClient _$30846;
    private static Integer _$30859;

    IlsLicense(String string, String string2, String string3, long l, String string4, boolean bl) {
        this._$23186(string, string2, string3, l, string4, bl);
    }

    IlsLicense(String string, String string2, String string3, long l, String string4) {
        this._$23186(string, string2, string3, l, string4, false);
    }

    IlsLicense(String string, String string2, String string3, long l) {
        this._$23186(string, string2, string3, l, null, false);
    }

    private void _$23186(String string, String string2, String string3, long l, String string4, boolean bl) {
        this.licenseKey = string;
        this.serviceName = string2;
        this.productName = string3;
        this.userCount = l;
        this.options = string4;
        this.noNodelockCheck = bl;
        this.keyInfo = new EzLicenseFullInfo();
    }

    public void setNoNodelockCheck(boolean bl) {
        this.noNodelockCheck = bl;
    }

    EzLicenseFullInfo getKeyInfo() {
        return this.keyInfo;
    }

    boolean checkLicense(IlsCmdArgs ilsCmdArgs) {
        return this.checkLicense(ilsCmdArgs, false);
    }

    boolean checkLicense(IlsCmdArgs ilsCmdArgs, boolean bl) {
        return this.checkLicense(ilsCmdArgs, 0L, null, bl) != null;
    }

    String[] checkLicense(IlsCmdArgs ilsCmdArgs, long l, String string, boolean bl) {
        Object object;
        Object object2;
        Object object3;
        boolean bl2;
        String string2 = null;
        this.keyInfo = new EzLicenseFullInfo();
        try {
            this.keyInfo.parseLicenseKey(this.licenseKey, "VtO7Q8WqR9Oj");
        }
        catch (Throwable throwable) {
            ilsCmdArgs.setStatusInfo(throwable instanceof EzLicExceptionBase ? (throwable instanceof EzLicExceptionExceededLimits ? 17 : 26) : 1000, "Product " + this.productName + " license error message: ", "Exception: " + throwable.getClass().getName() + "\nMessage: " + throwable.getMessage(), AlerterJob.MakeEventParams(this.productName));
            String[] stringArray = null;
            return stringArray;
        }
        String string3 = Crypt.decode((String)"dyAuYCM/bV==", (String)"QtejQ8G/WciuXr==", (String)this.spclky);
        if (!this.productName.equals(this.keyInfo.getProductName())) {
            ilsCmdArgs.setStatusInfo(26, "Key is not for product '" + this.productName + "'", null, AlerterJob.MakeEventParams(this.productName));
            return null;
        }
        if (this.keyInfo.getCustomKey() == null || !this.keyInfo.getCustomKey().equals("service=" + this.serviceName)) {
            ilsCmdArgs.setStatusInfo(26, "Product '" + this.productName + "' key is not for service '" + this.serviceName + "'", null, AlerterJob.MakeEventParams(this.productName));
            return null;
        }
        if (this.noNodelockCheck && this.keyInfo.getOptions() != null && IlsCmdAPI.GetIlsStringOption(this.keyInfo.getOptions(), "ILS:LOCK-DIR") != null && IlsCmdAPI.GetIlsStringOption(this.keyInfo.getOptions(), "ILS:LOCK-DIR").equals("IMMED")) {
            this.noNodelockCheck = false;
        }
        string2 = this.keyInfo.getEnforce() ? String.valueOf(System.getProperty("user.name")) + "@" + IlsUtil.GetHostName() : this.keyInfo.getUserHostNetName();
        if (this.keyInfo.getLicenseModelCode() != 1 || this.keyInfo.getLicenseTypeCode() != 3) {
            ilsCmdArgs.setStatusInfo(26, "Product " + this.productName + " key is not for Orion", null, AlerterJob.MakeEventParams(this.productName));
            return null;
        }
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        boolean bl3 = bl2 = this.userCount > (long)0 && this.userCount >= this.keyInfo.getUsageValue();
        if (bl) {
            l2 = 1000000L;
            l4 = 1000000L;
        } else if (this.keyInfo.getOptions() != null) {
            long l6 = IlsCmdAPI.GetIlsLongOption(this.keyInfo.getOptions(), "ILS:SOFT-USER-LIMIT");
            if (l6 >= (long)0 && this.userCount > l6) {
                ilsCmdArgs.setStatusInfo(-8, "Current user count of " + this.userCount + " for product " + this.productName + " has exceeded " + "license soft limit of " + l6 + " and is approaching the " + "hard limit of " + this.keyInfo.getUsageValue() + " users.", null, AlerterJob.MakeEventParams(this.productName));
                bl2 = true;
            } else if (this.userCount > (long)0 && this.userCount == this.keyInfo.getUsageValue()) {
                ilsCmdArgs.setStatusInfo(-8, "Current user count of " + this.userCount + " for product " + this.productName + " has reached the " + "hard limit of " + this.keyInfo.getUsageValue() + " users.", null, AlerterJob.MakeEventParams(this.productName));
            }
            long l7 = 0L;
            l7 = IlsCmdAPI.GetIlsLongOption(this.keyInfo.getOptions(), "ILS:QUOTA-GRACE");
            if (l7 > (long)0) {
                l2 = l7;
            }
            if ((l7 = IlsCmdAPI.GetIlsLongOption(this.keyInfo.getOptions(), "ILS:QUOTA-WARNING-THRESHOLD")) > (long)0) {
                l3 = l7;
            }
            if ((l7 = IlsCmdAPI.GetIlsLongOption(this.keyInfo.getOptions(), "ILS:EXP-DAYS-GRACE")) > (long)0) {
                l4 = l7;
            }
            if ((l7 = IlsCmdAPI.GetIlsLongOption(this.keyInfo.getOptions(), "ILS:EXP-DAYS-WARNING-THRESHOLD")) > (long)0) {
                l5 = l7;
            }
        }
        if (bl2) {
            String string4 = ilsCmdArgs.serviceName;
            if (string4 == null) {
                string4 = "default";
            }
            IlsUtil.Trace(9, "IlsLicense", "checkLicense: triggering user cleanup job with schedule event trigger");
            object3 = new IlsCmdArgs();
            ((IlsCmdArgs)object3).setServiceName(string4);
            IlsJob.TriggerEvent("UserCleanup", (IlsCmdArgs)object3, string4, "Schedule", null, null);
        }
        String string5 = Crypt.encode((String)"dyAuYCM/bV==", (String)"ILS", (String)this.productName);
        object3 = new EzLicenseInfo();
        IlsKeyCtx ilsKeyCtx = new IlsKeyCtx(ilsCmdArgs, string5, string2, this.serviceName, this.productName, this.noNodelockCheck, (EzLicenseInfo)object3);
        IlsUtil.Trace(true, 10, "IlsLicense", new String[]{"checkLicense: Checking key for userhost: " + string2 + ", user count: " + this.userCount}, false);
        String string6 = this.keyInfo.getAppPwd();
        if (string6 != null) {
            string6 = PkCrypt.makePublicKey((String)string6);
        }
        String string7 = null;
        int n = 0;
        try {
            string7 = object3.checkLicenseKeySecure(this.licenseKey, string, (EzLicExceptionBase)new IlsLicenseExceptionHandler(), (EzLicCustomLicenseInterface)new IlsKeyHandler(), (Object)ilsKeyCtx, (int)l5, -l, l3, (int)l4, l2, string3, this.userCount, this.productName, string6, null);
        }
        catch (EzLicExceptionExceededLimits ezLicExceptionExceededLimits) {
            ilsCmdArgs.setStatusInfo(17, "Product " + this.productName + " licensing error. " + ezLicExceptionExceededLimits.getMessage(), null, AlerterJob.MakeEventParams(this.productName));
            String[] stringArray = null;
            return stringArray;
        }
        catch (EzLicExceptionBase ezLicExceptionBase) {
            if (ezLicExceptionBase instanceof IlsLicenseExceptionHandler) {
                if (!ilsKeyCtx.success) {
                    ilsCmdArgs.setStatusInfo(26, "Product " + this.productName + ": Server runtime library or key is spoofed", null, AlerterJob.MakeEventParams(this.productName));
                    String[] stringArray = null;
                    return stringArray;
                }
                if (!this.noNodelockCheck && !object3.getUserHostNetName().equalsIgnoreCase(string2)) {
                    ilsCmdArgs.setStatusInfo(26, "Product " + this.productName + " key is not for this machine", null, AlerterJob.MakeEventParams(this.productName));
                } else {
                    object2 = (IlsLicenseExceptionHandler)ezLicExceptionBase;
                    string7 = object2.getMessage();
                    n = object2.getMessageCode();
                }
            }
            if (ezLicExceptionBase instanceof EzLicExceptionExceededLimits || ezLicExceptionBase instanceof EzLicExceptionExpired) {
                ilsCmdArgs.setStatusInfo(ezLicExceptionBase instanceof EzLicExceptionExceededLimits ? 17 : 5, "Product " + this.productName + " license error.  Message: " + ezLicExceptionBase.getMessage(), null, AlerterJob.MakeEventParams(this.productName));
                String[] stringArray = null;
                return stringArray;
            }
            IlsUtil.Trace(false, 1, "IlsLicense", null, true, ezLicExceptionBase);
            ilsCmdArgs.setStatusInfo(26, "Product " + this.productName + " license Message: " + ezLicExceptionBase.getMessage(), null, AlerterJob.MakeEventParams(this.productName));
            String[] stringArray = null;
            return stringArray;
        }
        catch (Throwable throwable) {
            IlsUtil.Trace(false, 1, "IlsLicense", null, true, throwable);
            ilsCmdArgs.setStatusInfo(1000, "Message: Exception: " + throwable.getClass().getName() + "\nMessage: " + throwable.getMessage());
            String[] stringArray = null;
            return stringArray;
        }
        if (n != 0) {
            object = "";
            if ((n & 5) != 0) {
                object2 = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss z").format(this.keyInfo.getExpirationDate());
                object = String.valueOf(object) + ":Time limited floating license key " + ((n & 1) != 0 ? "is about to expire on " : "expired on ") + (String)object2;
                ilsCmdArgs.setStatus((n & 1) != 0 ? -1 : -2);
            }
            if ((n & 0xA) != 0) {
                object = String.valueOf(object) + ":Quota limited floating license key " + ((n & 2) != 0 ? "is about to expire" : "expired and is on grace");
                ilsCmdArgs.setStatus((n & 2) != 0 ? -3 : -4);
            }
            if (!object.equals("")) {
                object = String.valueOf(object) + " for product " + this.productName;
                ilsCmdArgs.setStatusInfo(ilsCmdArgs.getStatus(), (String)object, null, AlerterJob.MakeEventParams(this.productName));
            }
        }
        object = new String[]{string7};
        return object;
    }

    long getUserLimit() {
        return this.keyInfo.getUsageValue();
    }

    static synchronized void checkEzlmSigs() throws IlsException {
        if (checkedSig) {
            return;
        }
        checkedSig = true;
    }

    Date getExpirationDate() {
        return this.keyInfo.getExpirationDate();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static String CheckoutIfNecessary(String string, String string2, String string3, long l) {
        Date date = new Date();
        Integer n = _$30859;
        synchronized (n) {
            try {
                if (_$30846 != null && _$30846.getCheckoutDate() != null && _$30846.getDuration() > (long)0 && new Date(_$30846.getCheckoutDate().getTime() + _$30846.getDuration()).after(date)) {
                    return null;
                }
                IlsClient ilsClient = new IlsClient(string, IlsUtil.GetHostName(), "ILS", string2, string3);
                if (!ilsClient.checkout(l)) {
                    return ilsClient.getResponseMsg();
                }
                _$30846 = ilsClient;
                return null;
            }
            catch (Throwable throwable) {
                Object var12_10 = null;
                throw throwable;
            }
        }
    }

    static void CheckinIfNecessary() {
        Integer n = _$30859;
        synchronized (n) {
            try {
                if (_$30846 != null) {
                    _$30846.checkin();
                    _$30846 = null;
                }
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                throw throwable;
            }
        }
    }

    static {
        _$30859 = new Integer(0);
    }

    static class KHfile {
        KHfile() {
        }

        public static synchronized String getHfileContents(String string, String string2, String string3) {
            IlsUtil.Trace(10, "IlsLicense.KHfile", "getHfileContents: getting for service '" + string + "', product '" + string2 + "', hfileDirectory '" + string3 + "'.");
            String string4 = null;
            String string5 = KHfile.makeHfileName(string, string2, string3);
            File file = new File(string5);
            if (file.exists()) {
                IlsUtil.Trace(10, "IlsLicense.KHfile", "getHfileContents: file exists.");
                BufferedReader bufferedReader = null;
                try {
                    bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
                    String string6 = bufferedReader.readLine();
                    bufferedReader.close();
                    if (string6 != null) {
                        int n = -1;
                        string6 = string6.trim();
                        IlsUtil.Trace(10, "IlsLicense.KHfile", "getHfileContents: contents before decryption: " + string6);
                        string6 = PkCrypt.decryptIls((String)string6, (String)string5);
                        IlsUtil.Trace(10, "IlsLicense.KHfile", "getHfileContents: contents after decryption: " + string6);
                        if (!string6.startsWith("system=ILS;") || (n = string6.indexOf(";")) <= 0 || string6.indexOf("nowts=") <= 0) {
                            String string7 = null;
                            return string7;
                        }
                        string6 = string6.substring(n + 1);
                        string6 = string6.substring(string6.indexOf(";") + 1);
                        string4 = string6.substring(0, string6.indexOf(";"));
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    string4 = null;
                }
            }
            IlsUtil.Trace(10, "IlsLicense.KHfile", "getHfileContents: returning contents: [" + string4 + "].");
            return string4;
        }

        public static synchronized boolean updateHfile(String string, String string2, String string3, String string4) {
            IlsUtil.Trace(10, "IlsLicense.KHfile", "updateHfile: updating contents to [" + string3 + "] for service '" + string + "', product '" + string2 + "', hfileDirectory '" + string4 + "'.");
            String string5 = KHfile.makeHfileName(string, string2, string4);
            boolean bl = false;
            try {
                File file = new File(string5);
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                PrintStream printStream = new PrintStream(fileOutputStream);
                printStream.println(PkCrypt.encryptIls((String)("system=ILS;version=1.0;" + string3 + ";nowts=0"), (String)string5));
                printStream.flush();
                printStream.close();
                bl = true;
            }
            catch (Exception exception) {
                IlsUtil.Trace(false, 10, "IlsLicense.KHfile", new String[]{"updateHfile: got exception " + exception.getClass().getName()}, true, exception);
            }
            return bl;
        }

        public static synchronized boolean dropHfile(String string, String string2, String string3) {
            String string4 = KHfile.makeHfileName(string, string2, string3);
            File file = new File(string4);
            if (file.exists()) {
                return file.delete();
            }
            return false;
        }

        public static String makeHfileName(String string, String string2, String string3) {
            if (string3 == null || string3.equals("")) {
                string3 = System.getProperty("user.dir");
            }
            String string4 = String.valueOf(string3) + System.getProperty("file.separator") + ".ils10jk" + IlsUtil.URLEncode(Crypt.encode((String)"dyAuYCM/bV==", (String)(String.valueOf(string) + "." + string2), (String)string3));
            IlsUtil.Trace(10, "IlsLicense.KHfile", "makeHfileName: made name '" + string4 + "'.");
            return string4;
        }
    }
}

