/*
 * Decompiled with CFR 0.152.
 */
package com.vs.ils;

import com.vs.ils.AuditJobEventLuw;
import com.vs.ils.IlsCmdArgs;
import com.vs.ils.IlsCmdDriver;
import com.vs.ils.IlsException;
import com.vs.ils.IlsGetJobLuw;
import com.vs.ils.IlsStartJobLuw;
import com.vs.ils.IlsUpdateJobParamsLuw;
import com.vs.ils.IlsUpdateJobStatusLuw;
import com.vs.ils.IlsUtil;
import com.vs.ils.JobScheduleTimerTask;
import com.vs.ils.ilsdb.Job;
import com.vs.wdo.rtl.WdoBaseException;
import com.vs.wdo.rtl.WdoTransaction;
import com.vs.wdo.rtl.WdoUnitOfWork;
import java.io.File;
import java.io.FilenameFilter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;

public abstract class IlsJob
extends Thread {
    public static final int PARAM_DATATYPE_INTEGER = 1;
    public static final int PARAM_DATATYPE_STRING = 2;
    public static final int PARAM_DATATYPE_DATE = 3;
    public static final String YES_RESPONSE = "Yes";
    public static final String NO_RESPONSE = "No";
    public static final String YES_NO_RESPONSE_SET = "Yes;No";
    public static final String NO_YES_RESPONSE_SET = "No;Yes";
    String jobName;
    Job theJobData;
    IlsCmdArgs cmdArgs;
    String serviceName;
    Date startTime;
    protected String triggerEvent;
    protected String[] triggerEventParams;
    protected String triggerEventData;
    long nextTime;
    IlsUtil.Semaphore enqueue = new IlsUtil.Semaphore(0);
    IlsUtil.Semaphore startEnqueue = new IlsUtil.Semaphore(0);
    static HashMap jobs = new HashMap();
    boolean stopThreadSignal;
    boolean disableThreadSignal;
    boolean jobExecuting;
    boolean dontDoAudit;
    JobScheduleTimerTask scheduleTimerTask;
    Timer timer;

    public boolean isThreadRunning() {
        return this.isAlive();
    }

    public void setStopThreadSignal(boolean bl, boolean bl2) {
        this.stopThreadSignal = bl;
        if (bl && bl2) {
            this.interrupt();
        } else if (bl) {
            this.enqueue.signal();
        }
    }

    public void setDisableThreadSignal(boolean bl) {
        this.disableThreadSignal = bl;
    }

    public boolean isJobExecuting() {
        return this.jobExecuting;
    }

    public static synchronized IlsJob GetJob(String string, IlsCmdArgs ilsCmdArgs, String string2, boolean bl) {
        ilsCmdArgs.setInTrigger(true);
        if (string2 == null || (string2 = string2.trim()).equals("")) {
            string2 = "default";
        }
        String string3 = String.valueOf(string2) + "." + string;
        try {
            IlsJob ilsJob = (IlsJob)jobs.get(string3);
            if (ilsJob == null) {
                ilsJob = IlsJob._$29194(string, null, ilsCmdArgs, string2);
                jobs.put(string3, ilsJob);
            }
            IlsJob ilsJob2 = ilsJob;
            return ilsJob2;
        }
        catch (IlsException ilsException) {
            ilsCmdArgs.setStatusInfo(1000, "Internal error: error instantiating job '" + string + "'");
            IlsUtil.Trace(false, 3, "IlsJob", new String[]{"GetJob: Can't get job.  Message: " + ilsCmdArgs.getMsg()}, true);
            IlsJob ilsJob = null;
            return ilsJob;
        }
    }

    private static synchronized void _$29205(String string, String string2) {
        if (string2 == null || (string2 = string2.trim()).equals("")) {
            string2 = "default";
        }
        String string3 = String.valueOf(string2) + "." + string;
        jobs.remove(string3);
    }

    private void _$29215() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        IlsJob._$29205(this.getJobName(), this.serviceName);
    }

    public static synchronized String[] GetJobNames() {
        String[] stringArray = new String[]{"Audit", "Backup", "Alerter", "UserCleanup", "UsageSampler"};
        return stringArray;
    }

    public static synchronized String GetJobNameList() {
        return "Audit;Backup;Alerter;UserCleanup;UsageSampler";
    }

    public static synchronized Vector GetJobList(IlsCmdArgs ilsCmdArgs, String string) {
        IlsJob ilsJob;
        if (string == null || (string = string.trim()).equals("")) {
            string = "default";
        }
        if ((ilsJob = IlsJob.GetJob("Audit", ilsCmdArgs, string, true)) == null) {
            return null;
        }
        IlsJob ilsJob2 = IlsJob.GetJob("Backup", ilsCmdArgs, string, true);
        if (ilsJob2 == null) {
            return null;
        }
        IlsJob ilsJob3 = IlsJob.GetJob("Alerter", ilsCmdArgs, string, true);
        if (ilsJob3 == null) {
            return null;
        }
        IlsJob ilsJob4 = IlsJob.GetJob("UserCleanup", ilsCmdArgs, string, true);
        if (ilsJob4 == null) {
            return null;
        }
        IlsJob ilsJob5 = IlsJob.GetJob("UsageSampler", ilsCmdArgs, string, true);
        if (ilsJob5 == null) {
            return null;
        }
        Vector<IlsJob> vector = new Vector<IlsJob>(5);
        vector.addElement(ilsJob);
        vector.addElement(ilsJob2);
        vector.addElement(ilsJob3);
        vector.addElement(ilsJob4);
        vector.addElement(ilsJob5);
        return vector;
    }

    public static Boolean[] TriggerEvents(IlsCmdArgs ilsCmdArgs, String string, String string2) {
        return IlsJob.TriggerEvents(ilsCmdArgs, string, string2, null);
    }

    public static Boolean[] TriggerEvents(IlsCmdArgs ilsCmdArgs, String string, String string2, String string3) {
        return IlsJob.TriggerEvents(ilsCmdArgs, string, string2, null, null);
    }

    public static Boolean[] TriggerEvents(IlsCmdArgs ilsCmdArgs, String string, String string2, String string3, String[] stringArray) {
        Boolean bl = IlsJob.TriggerEvent("Audit", ilsCmdArgs, string, string2, string3, stringArray);
        Boolean bl2 = IlsJob.TriggerEvent("Backup", ilsCmdArgs, string, string2, string3, stringArray);
        Boolean bl3 = IlsJob.TriggerEvent("Alerter", ilsCmdArgs, string, string2, string3, stringArray);
        Boolean bl4 = IlsJob.TriggerEvent("UserCleanup", ilsCmdArgs, string, string2, string3, stringArray);
        Boolean bl5 = IlsJob.TriggerEvent("UsageSampler", ilsCmdArgs, string, string2, string3, stringArray);
        Boolean[] booleanArray = new Boolean[]{bl, bl2, bl3, bl4, bl5};
        return booleanArray;
    }

    public static Boolean TriggerEvent(String string, IlsCmdArgs ilsCmdArgs, String string2, String string3, String string4, String[] stringArray) {
        IlsJob ilsJob;
        IlsUtil.Trace(9, "IlsJob", "TriggerEvent: enter.  Job name [" + string + "], trigger [" + string3 + "]");
        if (!IlsCmdDriver.IsServer()) {
            return new Boolean(false);
        }
        if (string2 == null || (string2 = string2.trim()).equals("")) {
            string2 = "default";
        }
        if ((ilsJob = IlsJob.GetJob(string, ilsCmdArgs, string2, true)) == null) {
            IlsUtil.Trace(9, "IlsJob", "TriggerEvent: could not successfully do GetJob");
            return null;
        }
        if (!ilsJob._$29403(string3)) {
            try {
                IlsUtil.Trace(9, "IlsJob", "TriggerEvent: could not successfully match trigger event.  Job's trigger events are: [" + ilsJob.theJobData.getEventTriggers() + "]");
                if (!ilsJob.isThreadRunning() && ilsJob.theJobData.getSchedule().equals("Every Interval") && ilsJob.theJobData.eventTriggersIsDefined() && ilsJob.theJobData.getEventTriggers().indexOf("Schedule") >= 0) {
                    IlsUtil.Trace(7, "IlsJob", "TriggerEvent: unconditionally starting scheduled job [" + string + "] because it isn't running.");
                    ilsJob.startJob(ilsCmdArgs);
                }
            }
            catch (WdoBaseException wdoBaseException) {
                // empty catch block
            }
            return new Boolean(false);
        }
        ilsJob.triggerEvent = string3;
        ilsJob.triggerEventData = string4;
        ilsJob.triggerEventParams = stringArray;
        boolean bl = ilsJob.startJob(ilsCmdArgs);
        IlsUtil.Trace(9, "IlsJob", "TriggerEvent: startJob returns: " + bl);
        return new Boolean(bl);
    }

    public synchronized boolean startJob(IlsCmdArgs ilsCmdArgs) {
        if (!IlsCmdDriver.IsServer()) {
            ilsCmdArgs.setStatusInfo(1000, "Cannot start job: not a server");
            return false;
        }
        IlsUtil.Trace(7, "IlsJob", "startJob: enter.");
        if (!this.isAlive()) {
            IlsUtil.Trace(7, "IlsJob", "startJob: not alive: starting daemon thread.");
            this.setDaemon(true);
            this.start();
            IlsUtil.Trace(7, "IlsJob", "startJob: about to wait for thread start signal.");
            if (!this.startEnqueue.wait(false)) {
                IlsUtil.Trace(3, "IlsJob", "startJob: error waiting for start semaphore.");
                ilsCmdArgs.setStatusInfo(1000, "IlsJob: error waiting for thread start signal.");
            }
            IlsUtil.Trace(7, "IlsJob", "startJob: got thread start signal.");
            try {
                if (this.theJobData.getSchedule().equals("Every Interval") && this.theJobData.getScheduleInterval() != (long)0 && this.theJobData.eventTriggersIsDefined() && this.theJobData.getEventTriggers().indexOf("Schedule") >= 0) {
                    this._$29514(ilsCmdArgs);
                }
            }
            catch (WdoBaseException wdoBaseException) {
                // empty catch block
            }
        }
        try {
            if (this.triggerEvent != null || this.theJobData.getSchedule().equals("Now")) {
                this.enqueue.signal();
            }
        }
        catch (WdoBaseException wdoBaseException) {
            // empty catch block
        }
        return true;
    }

    static String MapTriggerToTrigcode(String string) {
        if (string.equals("None")) {
            return "NONE";
        }
        if (string.equals("Schedule")) {
            return "SCHEDULE";
        }
        if (string.equals("Administration Command")) {
            return "ADMIN";
        }
        if (string.equals("Licensing Error")) {
            return "LICENSE";
        }
        if (string.equals("Licensing Warning")) {
            return "LICENSEWARN";
        }
        if (string.equals("System Error")) {
            return "SYSTEM";
        }
        if (string.equals("Configuration Error")) {
            return "CONFIG";
        }
        if (string.equals("Authorization Error")) {
            return "AUTH";
        }
        if (string.equals("General Error")) {
            return "OTHERERROR";
        }
        if (string.equals("General Warning")) {
            return "OTHERWARN";
        }
        if (string.equals("Informational Message")) {
            return "INFO";
        }
        if (string.equals("Custom Command")) {
            return "CUSTOM";
        }
        return null;
    }

    private boolean _$29514(IlsCmdArgs ilsCmdArgs) {
        try {
            long l;
            IlsUtil.Trace(7, "IlsJob", "startScheduler: enter.  Schedule start ts=" + this.theJobData.getScheduleStartTs() + ", Schedule Interval=" + this.theJobData.getScheduleInterval() + ", Next Schedule = " + this.theJobData.getNextTime());
            long l2 = l = new Date().getTime();
            if (this.theJobData.getScheduleStartTs() > l) {
                l2 = this.theJobData.getScheduleStartTs();
            }
            if (this.theJobData.getNextTime() > l) {
                l2 = this.theJobData.getNextTime();
            }
            IlsUtil.Trace(7, "IlsJob", "startScheduler: schedule to start at schedTs=" + l2 + "(" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z").format(new Date(l2)));
            this.timer = new Timer(true);
            this.scheduleTimerTask = new JobScheduleTimerTask(this);
            this.timer.schedule((TimerTask)this.scheduleTimerTask, new Date(l2), this.theJobData.getScheduleInterval() > (long)0 ? this.theJobData.getScheduleInterval() * 3600000L : -this.theJobData.getScheduleInterval() * 1000L);
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            ilsCmdArgs.setStatusInfo(1000, "Internal error: could not start job scheduler timer task for job " + this.getJobName() + ". " + "Exception: " + exception.getClass().getName() + ", Message: " + exception.getMessage());
            return false;
        }
    }

    private boolean _$29597(IlsCmdArgs ilsCmdArgs) {
        IlsUtil.Trace(7, "IlsJob", "stopScheduler: enter.  timer is " + (this.timer == null ? "" : "not ") + "null");
        this.timer.cancel();
        return true;
    }

    public static Boolean[] InitiateJobThreads(IlsCmdArgs ilsCmdArgs, String string) {
        Boolean bl = IlsJob.InitiateJobThread("Audit", ilsCmdArgs, string);
        Boolean bl2 = IlsJob.InitiateJobThread("Backup", ilsCmdArgs, string);
        Boolean bl3 = IlsJob.InitiateJobThread("Alerter", ilsCmdArgs, string);
        Boolean[] booleanArray = new Boolean[]{bl, bl2, bl3};
        return booleanArray;
    }

    public static synchronized Boolean InitiateJobThread(String string, IlsCmdArgs ilsCmdArgs, String string2) {
        IlsJob ilsJob;
        if (!IlsCmdDriver.IsServer()) {
            return null;
        }
        if (string2 == null || (string2 = string2.trim()).equals("")) {
            string2 = "default";
        }
        if ((ilsJob = IlsJob.GetJob(string, ilsCmdArgs, string2, true)) == null) {
            return null;
        }
        if (ilsJob.isThreadRunning()) {
            return new Boolean(false);
        }
        return new Boolean(ilsJob.startJob(ilsCmdArgs));
    }

    public Job getJobData() {
        return this.theJobData;
    }

    public abstract String getJobName();

    public abstract String getJobExternalName();

    public abstract ParamData[] getJobParams();

    public abstract String getJobParamsString();

    public abstract String[] getAllowedJobSchedules();

    public abstract String[] getAllowedJobEventTriggers();

    public synchronized boolean updateJobParams(ParamData[] paramDataArray, String string, Long l, Long l2, String string2) {
        return this.updateJobParams(paramDataArray, string, l, l2, string2, null, null);
    }

    public synchronized boolean updateJobParams(ParamData[] paramDataArray, String string, Long l, Long l2, String string2, Long l3, Long l4) {
        Boolean[] booleanArray;
        ParamData[] paramDataArray2 = this.getJobParams();
        if (IlsUtil.CheckDebug(7)) {
            IlsUtil.Trace(7, "IlsJob", "updateJobParams: enter.");
            ParamData.DumpParamVectorData(paramDataArray2, "Old");
            ParamData.DumpParamVectorData(paramDataArray, "New");
        }
        if ((booleanArray = this.checkJobParamUpdates(paramDataArray, paramDataArray2)) == null) {
            IlsUtil.Trace(7, "IlsJob", "updateJobParams: error during checkJobParamUpdates");
            return false;
        }
        try {
            if (!(booleanArray[booleanArray.length - 1].booleanValue() || l3 != null && l3.longValue() != this.theJobData.getNextSeq() || string2 != null && !string2.equals(this.theJobData.getEventTriggers()) || string != null && !string.equals(this.theJobData.getSchedule()) || l4 != null && l4.longValue() != this.theJobData.getNextTime() || l != null && l.longValue() != this.theJobData.getScheduleStartTs() || l2 != null && l2.longValue() != this.theJobData.getScheduleInterval())) {
                IlsUtil.Trace(7, "IlsJob", "updateJobParams: found no change - nothing to do");
                boolean bl = true;
                return bl;
            }
        }
        catch (WdoBaseException wdoBaseException) {
            boolean bl = false;
            return bl;
        }
        this.cmdArgs.setRequest("jobcmd=updateParams");
        Object[] objectArray = new Object[]{paramDataArray, booleanArray, string, l, l2, string2, l3, l4};
        boolean bl = this.processLuwCmd(new IlsUpdateJobParamsLuw(), objectArray, true);
        if (bl && (string != null || l2 != null || l4 != null || l != null) && this.scheduleTimerTask != null) {
            this._$29597(this.cmdArgs);
            if (string == null || string.equals("Every Interval")) {
                this._$29514(this.cmdArgs);
            }
        }
        return bl;
    }

    public IlsCmdArgs getCmdArgs() {
        return this.cmdArgs;
    }

    private boolean _$29824() {
        if (!this._$29830()) {
            return false;
        }
        boolean bl = this.doTheJob();
        boolean bl2 = this._$29842();
        return bl && bl2;
    }

    public void run() {
        IlsUtil.Trace(7, "IlsJob", "run(): enter.  signalling and entering loop.");
        this.startEnqueue.signal();
        boolean bl = false;
        while (true) {
            bl = false;
            Date date = new Date();
            IlsUtil.Trace(7, "IlsJob", "run(): about to wait.");
            if (!this.enqueue.wait(false)) {
                IlsUtil.Trace(7, "IlsJob", "run(): unblocked from wait w/ false return.");
                continue;
            }
            IlsUtil.Trace(7, "IlsJob", "run(): unblocked from wait.");
            if (this.stopThreadSignal || this.disableThreadSignal) {
                this.stopThreadSignal = false;
                IlsUtil.Trace(7, "IlsJob", "run(): exiting loop due to stop/disable thread signal.");
                this._$29215();
                return;
            }
            this.jobExecuting = true;
            boolean bl2 = this._$29824();
            this.jobExecuting = false;
            bl = this.isInterrupted();
        }
    }

    private boolean _$29830() {
        this.cmdArgs.setRequest("jobcmd=" + this.getJobName() + "Job");
        this.cmdArgs.setStatusInfo(-500, "Job started.");
        return this.processLuwCmd(new IlsStartJobLuw(), null, true);
    }

    private boolean _$29842() {
        if (this.cmdArgs.getStatus() == -500) {
            Date date = new Date();
            long l = (date.getTime() - this.startTime.getTime()) / (long)1000;
            this.cmdArgs.setStatusInfo(0, "Successful job execution.  Elapsed time: " + l + " seconds.");
        }
        return this.processLuwCmd(new IlsUpdateJobStatusLuw(), null, true);
    }

    protected abstract boolean updateJobSpecificParams(ParamData[] var1, Boolean[] var2);

    protected abstract boolean doTheJob();

    protected abstract boolean abortTheJob();

    private static IlsJob _$29194(String string, String string2, IlsCmdArgs ilsCmdArgs, String string3) throws IlsException {
        String string4 = string2 == null ? "com.vs.ils." + IlsUtil.ToUpperStart(string) + "Job" : String.valueOf(string2.indexOf(".") < 0 ? "com.vs.ils." : "") + string2;
        IlsJob ilsJob = null;
        try {
            ilsJob = (IlsJob)Class.forName(string4).newInstance();
        }
        catch (InstantiationException instantiationException) {
            ilsCmdArgs.setStatusInfo(1000, "Internal Error: Invalid job [" + string + "]");
        }
        catch (Throwable throwable) {
            IlsUtil.Trace(false, 5, "IlsJob", new String[]{"Unexpected exception instantiating job handler for job " + string + ".  Stack Trace: "}, true, throwable);
            IlsException.ThrowException(1000, "Internal error.  Please have your administrator contact Orion technical support with the following details: Could not instantiate job handler for job [" + string + "]" + "\nException: " + throwable.getClass().getName() + "\nMessage: " + throwable.getMessage());
        }
        ilsJob.jobName = string;
        ilsJob.cmdArgs = ilsCmdArgs;
        ilsJob.serviceName = string3;
        ilsJob.processLuwCmd(new IlsGetJobLuw(), null, false);
        if (ilsJob.cmdArgs.getStatus() > 0) {
            return null;
        }
        return ilsJob;
    }

    protected boolean processLuwCmd(WdoUnitOfWork wdoUnitOfWork, Object[] objectArray, boolean bl) {
        Object[] objectArray2 = new Object[]{this, objectArray};
        if (this.dontDoAudit) {
            bl = false;
            this.dontDoAudit = false;
        }
        String string = null;
        if (wdoUnitOfWork != null && (string = WdoTransaction.DoUnitOfWork((WdoUnitOfWork)wdoUnitOfWork, (String)this.serviceName, (int)2, (Object[])objectArray2)) != null && this.cmdArgs.getStatus() <= 0) {
            this.cmdArgs.setStatusInfo(25, string);
        }
        if (bl) {
            WdoTransaction.DoUnitOfWork((WdoUnitOfWork)new AuditJobEventLuw(), (String)this.serviceName, (int)1, (Object[])objectArray2);
        }
        return string == null;
    }

    protected Boolean[] checkJobParamUpdates(ParamData[] paramDataArray, ParamData[] paramDataArray2) {
        boolean bl = false;
        Boolean[] booleanArray = new Boolean[paramDataArray2.length + 1];
        int n = 0;
        while (n < booleanArray.length) {
            booleanArray[n] = new Boolean(false);
            ++n;
        }
        n = 0;
        while (n < paramDataArray.length) {
            ParamData paramData = paramDataArray[n];
            int n2 = 0;
            while (n2 < paramDataArray2.length) {
                ParamData paramData2 = paramDataArray2[n2];
                if (paramData.getParamName().equals(paramData2.getParamName())) {
                    if (paramData.getParamDataType() != paramData2.getParamDataType()) {
                        this.cmdArgs.setStatusInfo(1000, "Internal Error: invalid data type " + paramData.getParamDataType() + " for param '" + paramData.getParamName() + "' - expected " + paramData2.getParamDataType());
                        IlsUtil.Trace(false, 3, "IlsJob", new String[]{"checkJobParamUpdates: internal error: invalid datatype."}, true);
                        return null;
                    }
                    if (paramData.getParamValue() == null != (paramData2.getParamValue() == null) || paramData.getParamValue() != null && !paramData.getParamValue().equals(paramData2.getParamValue().trim())) {
                        IlsUtil.Trace(7, "IlsJob", "checkJobUpdateParams: changing parameter " + paramData.getParamName() + " value '" + paramData2.getParamValue() + "' to '" + paramData.getParamValue());
                        paramData2.paramValue = paramData.paramValue;
                        booleanArray[n] = new Boolean(true);
                        bl = true;
                    }
                }
                ++n2;
            }
            ++n;
        }
        booleanArray[paramDataArray2.length] = new Boolean(bl);
        return booleanArray;
    }

    protected boolean deleteOldFiles(Date date, String string, long l, FilenameFilter filenameFilter) {
        long l2 = date.getTime() - l * 86400000L;
        File file = new File(string);
        File[] fileArray = file.listFiles(filenameFilter);
        int n = 0;
        while (n < fileArray.length) {
            String string2;
            Date date2;
            int n2;
            int n3;
            String string3;
            File file2 = fileArray[n];
            String string4 = file2.getName();
            StringTokenizer stringTokenizer = new StringTokenizer(string4, "_");
            if (stringTokenizer.countTokens() >= 4 && (string3 = (string4 = string4.substring((n3 = string4.indexOf("_")) + 1)).substring(n3 + 1, n3 + (n2 = string4.indexOf("_")))).equals(this.serviceName) && (date2 = IlsUtil.GetDateFromFilename(string2 = (string4 = string4.substring(n2 + 1)).substring(0, string4.indexOf("_") - 1))) != null && date2.getTime() <= l2) {
                IlsUtil.Trace(7, "IlsJob", "deleteOldfiles: deleting file '" + string4 + "'");
                file2.delete();
            }
            ++n;
        }
        return true;
    }

    protected String makeJobFilename(Date date, String string, String string2, String string3) {
        String string4 = null;
        String string5 = this.serviceName.replace('/', '.').replace('\\', '.');
        try {
            string4 = String.valueOf(string) + System.getProperty("file.separator") + string2 + "_" + string5 + "_" + IlsUtil.GetDateStringForFilename(date) + "_" + this.theJobData.getNextSeq() + "." + string3;
        }
        catch (WdoBaseException wdoBaseException) {
            this.cmdArgs.setStatusInfo(1000, "Internal Error: IlsJob: unable to make Job Filename.  Jobdir: " + string + ", jobName: " + string2 + ", suffix: " + string3);
            IlsUtil.Trace(false, 3, "IlsJob", new String[]{"makeJobfilename: unable to make Job Filename.  Jobdir: " + string + ", jobName: " + string2 + ", suffix: " + string3}, true);
        }
        return string4;
    }

    private boolean _$29403(String string) {
        try {
            String[] stringArray = this.theJobData.getEventTriggers().split(";");
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].equals(string)) {
                    boolean bl = true;
                    return bl;
                }
                ++n;
            }
        }
        catch (WdoBaseException wdoBaseException) {
            // empty catch block
        }
        return false;
    }

    public static class ParamData
    implements Cloneable {
        String paramName;
        int paramDataType = 2;
        String paramValue;
        boolean isPasswd;
        String[] allowedValues;

        ParamData(String string, int n, String string2, boolean bl, String string3) {
            this.paramName = string;
            this.paramDataType = n;
            this.paramValue = string2;
            this.isPasswd = bl;
            this.allowedValues = string3 == null ? null : string3.split(";");
        }

        ParamData(String string, int n, String string2) {
            this.paramName = string;
            this.paramDataType = n;
            this.paramValue = string2;
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }

        public String getParamName() {
            return this.paramName;
        }

        public int getParamDataType() {
            return this.paramDataType;
        }

        public String getParamValue() {
            return this.paramValue;
        }

        public boolean getIsPasswd() {
            return this.isPasswd;
        }

        public String[] getAllowedValues() {
            return this.allowedValues;
        }

        public long getParamLongValue() {
            return this.paramDataType == 1 ? IlsUtil.GetPositiveLong(this.paramValue) : -1L;
        }

        public Date getParamDateValue() {
            return this.paramDataType == 3 ? new Date(IlsUtil.GetPositiveLong(this.paramValue)) : null;
        }

        public String getParamDateValueString() {
            return this.paramDataType == 3 ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z").format(this.getParamDateValue()) : null;
        }

        public void setParamValue(String string) {
            this.paramValue = string;
        }

        public void dumpParamData() {
            System.out.println("    Parameter name:        " + this.paramName);
            System.out.println("    Parameter data type:   " + (this.paramDataType == 3 ? "Date/time" : (this.paramDataType == 2 ? "String" : (this.paramDataType == 1 ? "Integer" : "*** Unknown (" + this.paramDataType + ") ***"))));
            System.out.println("   Parameter value:        " + (this.paramValue == null ? "*** Undefined ***" : this.paramValue));
        }

        public static void DumpParamVectorData(ParamData[] paramDataArray, String string) {
            System.out.println("Dump of " + (string != null ? String.valueOf(string) + " " : "") + "parameters:");
            int n = 0;
            while (n < paramDataArray.length) {
                System.out.println("Parameter # " + String.valueOf(n + 1) + ":");
                if (paramDataArray[n] != null) {
                    paramDataArray[n].dumpParamData();
                } else {
                    System.out.println("    <<param not defined>>");
                }
                ++n;
            }
        }
    }
}

