/*
 * Decompiled with CFR 0.152.
 */
package com.vs.ils;

import com.vs.ils.IlsException;
import com.vs.ils.IlsJob;
import com.vs.ils.IlsUtil;
import com.vs.ils.crypt.Crypt;
import com.vs.ils.crypt.PkCrypt;
import java.util.Date;
import java.util.HashMap;

public class IlsCmdArgs
implements Cloneable {
    String privateKey;
    protected String request;
    protected String response;
    protected int clientProtocolVsn = 3;
    protected String cmd;
    protected int status;
    protected String customCmd;
    protected String customCtx;
    protected String token;
    protected String machine;
    protected String product;
    protected String domain;
    protected String user;
    protected String passwd;
    protected String appCtx;
    protected String params;
    protected String options;
    protected long quota;
    protected long quotaCap;
    protected long duration;
    protected long minDuration;
    protected long maxDuration;
    protected long userExpTs;
    protected long clientTs;
    protected long sessionId;
    protected String msg;
    protected String value;
    protected int authLevel = 2;
    protected int points = 1;
    protected boolean updateOk;
    protected String enable;
    protected String checkedOut;
    protected String reportName;
    protected String reportParams;
    protected String reportResultName;
    private boolean _$26957;
    private static String _$24650 = "pkrptpttk";
    private static String _$24662 = "pcqktrzyk";
    HashMap cmdInfo;
    String serviceName;

    public IlsCmdArgs() {
        this.init();
    }

    public IlsCmdArgs(String string) {
        this.init(string);
    }

    public void init(String string) {
        this.init();
        this.request = string;
    }

    public void init(String string, int n) {
        this.init();
        this.request = string;
        this.clientProtocolVsn = n;
    }

    public void init() {
        this.request = null;
        this.response = null;
        this.cmd = null;
        this.status = 0;
        this.customCmd = null;
        this.customCtx = null;
        this.token = null;
        this.machine = null;
        this.product = null;
        this.domain = null;
        this.user = null;
        this.passwd = null;
        this.appCtx = null;
        this.params = null;
        this.options = null;
        this.quota = -999999L;
        this.quotaCap = -1L;
        this.duration = -1L;
        this.minDuration = -1L;
        this.maxDuration = -1L;
        this.userExpTs = -1L;
        this.clientTs = -1L;
        this.sessionId = 1L;
        this.msg = null;
        this.value = null;
        this.cmdInfo = null;
        this.authLevel = 2;
        this.points = 1;
        this.updateOk = false;
        this.enable = null;
        this.checkedOut = null;
        this.reportName = null;
        this.reportParams = null;
        this.reportResultName = null;
    }

    public void setServiceName(String string) {
        this.serviceName = string;
    }

    public void setInTrigger(boolean bl) {
        this._$26957 = bl;
    }

    public void setRequest(String string) {
        this.request = string;
    }

    public void setResponse(String string) {
        this.response = string;
    }

    public void setCmd(String string) {
        this.cmd = string;
    }

    public void setStatus(int n) {
        this.setStatus(n, null);
    }

    public void setStatus(int n, String[] stringArray) {
        this.status = n;
        if (!this._$26957) {
            String string = null;
            switch (n) {
                case -8: 
                case -4: 
                case -3: 
                case -2: 
                case -1: {
                    string = "Licensing Warning";
                    break;
                }
                case -9: 
                case -5: 
                case 1: 
                case 2: 
                case 3: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 18: 
                case 22: 
                case 27: 
                case 31: {
                    string = "Authorization Error";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 15: 
                case 16: 
                case 17: 
                case 26: {
                    string = "Licensing Error";
                    break;
                }
                case -7: 
                case 24: 
                case 25: 
                case 28: 
                case 101: 
                case 102: {
                    string = "Configuration Error";
                    break;
                }
                case 1000: 
                case 1001: 
                case 1002: {
                    string = "System Error";
                    break;
                }
                default: {
                    if (n > 0) {
                        string = "General Error";
                        break;
                    }
                    if (n <= -100) {
                        string = "Informational Message";
                        break;
                    }
                    if (n >= 0) break;
                    string = "General Warning";
                }
            }
            if (string != null) {
                String string2 = null;
                if (this.msg != null) {
                    string2 = "Message:\n" + this.msg;
                    if (this.value != null) {
                        string2 = String.valueOf(string2) + "\nValue:\n" + this.value;
                    }
                }
                IlsCmdArgs ilsCmdArgs = new IlsCmdArgs();
                ilsCmdArgs.setServiceName(this.serviceName);
                this._$26957 = true;
                ilsCmdArgs._$26957 = true;
                IlsJob.TriggerEvents(ilsCmdArgs, this.serviceName, string, string2, stringArray);
                this._$26957 = false;
            }
        }
    }

    public void setStatus(String string) throws IlsException {
        if (string != null) {
            this.status = IlsUtil.GetPositiveInt(string);
        }
    }

    public void setCustomCmd(String string) {
        this.customCmd = string;
    }

    public void setCustomCtx(String string) {
        this.customCtx = string;
    }

    public void setToken(String string) {
        this.token = string;
    }

    public void setMachine(String string) {
        this.machine = string;
    }

    public void setProduct(String string) {
        this.product = string;
    }

    public void setDomain(String string) {
        this.domain = string;
    }

    public void setUser(String string) {
        this.user = string;
    }

    public void setPasswd(String string) {
        this.passwd = string;
    }

    public void setAppCtx(String string) {
        this.appCtx = string;
    }

    public void setParams(String string) {
        this.params = string;
    }

    public void setOptions(String string) {
        this.options = string;
    }

    public void setQuota(long l) {
        this.quota = l;
    }

    public void setQuota(String string) throws IlsException {
        if (string != null) {
            try {
                this.quota = Long.parseLong(string);
            }
            catch (Throwable throwable) {
                throw new IlsException(23, "Invalid quota value: [" + string + "]");
            }
        }
    }

    public void setQuotaCap(String string) throws IlsException {
        if (string != null) {
            try {
                this.quotaCap = Long.parseLong(string);
            }
            catch (Throwable throwable) {
                throw new IlsException(23, "Invalid quota cap value: [" + string + "]");
            }
        }
    }

    public void setQuotaCap(long l) {
        this.quotaCap = l;
    }

    public void setUpdateOk(boolean bl) {
        this.updateOk = bl;
    }

    public void setEnable(String string) throws IlsException {
        if (string == null) {
            this.enable = null;
        } else if (string.equals("1") || string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes")) {
            this.enable = "Yes";
        } else if (string.equals("0") || string.equalsIgnoreCase("false") || string.equalsIgnoreCase("no")) {
            this.enable = "No";
        } else {
            throw new IlsException(23, "Invalid enable value: [" + string + "]");
        }
    }

    public void setCheckedOut(String string) throws IlsException {
        if (string == null) {
            this.checkedOut = null;
        } else if (string.equals("1") || string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes")) {
            this.checkedOut = "Yes";
        } else if (string.equals("0") || string.equalsIgnoreCase("false") || string.equalsIgnoreCase("no")) {
            this.checkedOut = "No";
        } else {
            throw new IlsException(23, "Invalid checkedOut value: [" + string + "]");
        }
    }

    public void setReportName(String string) {
        this.reportName = string;
    }

    public void setReportParams(String string) {
        this.reportParams = string;
    }

    public void setReportResultName(String string) {
        this.reportResultName = string;
    }

    public void setSessionId(long l) {
        this.sessionId = l;
    }

    public void setSessionId(String string) throws IlsException {
        if (string != null) {
            this.sessionId = IlsUtil.GetPositiveLong(string);
            if (this.sessionId <= (long)0) {
                throw new IlsException(23, "Invalid session Id value: [" + string + "]");
            }
        }
    }

    public void setAuthLevel(String string) throws IlsException {
        if (string != null) {
            this.authLevel = IlsUtil.GetPositiveInt(string);
            if (this.authLevel <= 0) {
                throw new IlsException(23, "Invalid authorization level value: [" + string + "]");
            }
        }
    }

    public void setPoints(String string) throws IlsException {
        if (string != null) {
            this.points = IlsUtil.GetPositiveInt(string);
            if (this.points <= 0) {
                throw new IlsException(23, "Invalid points value: [" + string + "]");
            }
        }
    }

    public void setDuration(long l) {
        this.duration = l;
    }

    public void setDuration(String string) throws IlsException {
        if (string != null) {
            this.duration = IlsUtil.GetPositiveLong(string);
            if (this.duration <= (long)0) {
                throw new IlsException(23, "Invalid duration value: [" + string + "]");
            }
        }
    }

    public void setMinDuration(long l) {
        this.minDuration = l;
    }

    public void setMaxDuration(long l) {
        this.maxDuration = l;
    }

    public void setUserExpTs(long l) {
        this.userExpTs = l;
    }

    public void setUserExpTs(String string) throws IlsException {
        if (string != null) {
            this.userExpTs = IlsUtil.GetPositiveLong(string);
            if (this.userExpTs > (long)0) {
                this.userExpTs *= (long)1000;
            }
        }
    }

    public void setClientTs(long l) {
        this.clientTs = l;
    }

    public void setClientTs(String string) throws IlsException {
        if (string != null) {
            if (string.equals("ticktock")) {
                this.clientTs = new Date().getTime();
            } else {
                this.clientTs = IlsUtil.GetPositiveLong(string);
                if (this.clientTs <= (long)0) {
                    throw new IlsException(23, "Invalid clock value: [" + string + "]");
                }
                this.clientTs *= (long)1000;
            }
        }
    }

    public void setMsg(String string) {
        this.msg = string;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public int setStatusInfo(int n, String string, String string2) {
        return this.setStatusInfo(n, string, string2, null);
    }

    public int setStatusInfo(int n, String string, String string2, String[] stringArray) {
        if (n > 0) {
            IlsUtil.Trace(false, 5, "IlsCmdArgs", new String[]{"Set status info: status = " + n + ", msg = " + string + ".\nCall stack:"}, true);
        } else if (n < 0) {
            IlsUtil.Trace(false, 8, "IlsCmdArgs", new String[]{"Set status info: status = " + n + ", msg = " + string + ".\nCall stack:"}, true);
        }
        if (string != null) {
            this.setMsg(string);
        }
        if (string2 != null) {
            this.setValue(string2);
        }
        this.setStatus(n, stringArray);
        return n;
    }

    public int setStatusInfo(int n, String string) {
        return this.setStatusInfo(n, string, null);
    }

    public void setCmdInfo(HashMap hashMap) {
        this.cmdInfo = hashMap;
    }

    public String getRequest() {
        return this.request;
    }

    public String getResponse() {
        return this.response;
    }

    public String getCmd() {
        return this.cmd;
    }

    public int getStatus() {
        return this.status;
    }

    public String getCustomCmd() {
        return this.customCmd;
    }

    public String getCustomCtx() {
        return this.customCtx;
    }

    public String getToken() {
        return this.token;
    }

    public String getMachine() {
        return this.machine;
    }

    public String getProduct() {
        return this.product;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getUser() {
        return this.user;
    }

    public String getPasswd() {
        return this.passwd;
    }

    public String getEncryptedPasswd() {
        return IlsUtil.GetEncryptedPasswd(this.passwd, this.user);
    }

    public String getAppCtx() {
        return this.appCtx;
    }

    public String getParams() {
        return this.params;
    }

    public String getOptions() {
        return this.options;
    }

    public long getQuota() {
        return this.quota;
    }

    public long getQuotaCap() {
        return this.quotaCap;
    }

    public long getSessionId() {
        return this.sessionId;
    }

    public long getDuration() {
        return this.duration;
    }

    public long getMinDuration() {
        return this.minDuration;
    }

    public long getMaxDuration() {
        return this.maxDuration;
    }

    public long getUserExpTs() {
        return this.userExpTs;
    }

    public long getClientTs() {
        return this.clientTs;
    }

    public int getAuthLevel() {
        return this.authLevel;
    }

    public int getPoints() {
        return this.points;
    }

    public boolean getUpdateOk() {
        return this.updateOk;
    }

    public String getEnable() {
        return this.enable;
    }

    public String getCheckedOut() {
        return this.checkedOut;
    }

    public String getReportName() {
        return this.reportName;
    }

    public String getReportParams() {
        return this.reportParams;
    }

    public String getReportResultName() {
        return this.reportResultName;
    }

    public String getMsg() {
        return this.msg;
    }

    public String getValue() {
        return this.value;
    }

    public HashMap getCmdInfo() {
        return this.cmdInfo;
    }

    public void makeCmdArgs(HashMap hashMap, String string) throws IlsException {
        this.privateKey = string;
        this.setCmd((String)hashMap.get("cmd"));
        this.setParams(IlsCmdArgs._$27537((String)hashMap.get("params")));
        this.setStatus((String)hashMap.get("status"));
        this.setOptions(IlsCmdArgs._$27537((String)hashMap.get("options")));
        this.setCustomCmd((String)hashMap.get("customcmd"));
        this.setCustomCtx(IlsCmdArgs._$27537((String)hashMap.get("customctx")));
        this.setToken(IlsCmdArgs._$27537((String)hashMap.get("token")));
        this.setMachine(IlsCmdArgs._$27537((String)hashMap.get("machine")));
        this.setProduct(IlsCmdArgs._$27537((String)hashMap.get("product")));
        this.setDomain(IlsCmdArgs._$27537((String)hashMap.get("domain")));
        this.setUser(IlsCmdArgs._$27537((String)hashMap.get("user")));
        this.setPasswd(IlsCmdArgs._$27537((String)hashMap.get("passwd")));
        this.setAppCtx(IlsCmdArgs._$27537((String)hashMap.get("appctx")));
        this.setSessionId((String)hashMap.get("session"));
        this.setQuota((String)hashMap.get("quota"));
        this.setQuotaCap((String)hashMap.get("quota_cap"));
        this.setUserExpTs((String)hashMap.get("userexpts"));
        this.setDuration((String)hashMap.get("ttl"));
        this.setPoints((String)hashMap.get("points"));
        this.setUpdateOk(hashMap.get("updateok") != null);
        this.setEnable((String)hashMap.get("enable"));
        this.setCheckedOut((String)hashMap.get("checkedout"));
        this.setReportName(IlsCmdArgs._$27537((String)hashMap.get("reportname")));
        this.setReportParams(IlsCmdArgs._$27537((String)hashMap.get("reportparams")));
        this.setReportResultName(IlsCmdArgs._$27537((String)hashMap.get("reportresultname")));
        this.setMsg(IlsCmdArgs._$27537((String)hashMap.get("msg")));
        this.setValue(IlsCmdArgs._$27537((String)hashMap.get("value")));
        this.setClientTs((String)hashMap.get("clock"));
        this.setCmdInfo(hashMap);
    }

    public String makeCmdResponse() {
        return this.makeCmdResponse(true);
    }

    public String makeCmdResponse(boolean bl) {
        if (this.response != null && !bl) {
            return this.response;
        }
        String string = "protocol_vsn=4|";
        string = String.valueOf(string) + "status=" + this.getStatus();
        if (this.getMsg() != null) {
            string = String.valueOf(string) + "|msg=" + IlsUtil.URLEncode(this.getMsg());
        }
        if (this.getValue() != null) {
            string = String.valueOf(string) + "|value=" + IlsUtil.URLEncode(this.getValue());
        }
        if (this.getStatus() <= 0) {
            if (this.getOptions() != null) {
                string = String.valueOf(string) + "|options=" + IlsUtil.URLEncode(this.getOptions());
            }
            if (this.getParams() != null) {
                string = String.valueOf(string) + "|params=" + IlsUtil.URLEncode(this.getParams());
            }
            if (this.getToken() != null) {
                string = String.valueOf(string) + "|token=" + IlsUtil.URLEncode(this.getToken());
            }
            if (this.getAppCtx() != null) {
                string = String.valueOf(string) + "|appctx=" + IlsUtil.URLEncode(this.getAppCtx());
            }
            if (this.getCustomCtx() != null) {
                string = String.valueOf(string) + "|customctx=" + IlsUtil.URLEncode(this.getCustomCtx());
            }
            if (this.getQuota() >= (long)0) {
                string = String.valueOf(string) + "|quota=" + this.getQuota();
            }
            if (this.getQuotaCap() >= (long)0) {
                string = String.valueOf(string) + "|quota_cap=" + this.getQuotaCap();
            }
            if (this.getDuration() >= (long)0) {
                string = String.valueOf(string) + "|ttl=" + this.getDuration();
            }
            if (this.getMinDuration() >= (long)0) {
                string = String.valueOf(string) + "|ttl_min=" + this.getMinDuration();
            }
            if (this.getMaxDuration() >= (long)0) {
                string = String.valueOf(string) + "|ttl_max=" + this.getMaxDuration();
            }
        } else if (this.getStatus() == 13) {
            if (this.getMachine() != null) {
                string = String.valueOf(string) + "|machine=" + IlsUtil.URLEncode(this.getMachine());
            }
            string = String.valueOf(string) + "|session=" + this.getSessionId();
        }
        if (this.getUserExpTs() >= (long)0) {
            string = String.valueOf(string) + "|userexpts=" + this.getUserExpTs() / (long)1000;
        }
        if (this.clientProtocolVsn >= 4) {
            string = String.valueOf(string) + "|clock=" + String.valueOf(new Date().getTime() / (long)1000);
        }
        if (bl && this.privateKey != null) {
            IlsUtil.Trace(5, "IlsCmdArgs", "makeCmdResponse: Response string before encryption:\n" + string);
            string = "envelope=" + PkCrypt.encryptWithPrivateKey((String)Crypt.encode((String)"dyAuYCM/bV==", (String)_$24662, (String)_$24650), (String)string, (String)this.privateKey);
        }
        this.response = "system=ILS|" + string;
        return this.response;
    }

    private static String _$27537(String string) {
        return IlsUtil.URLDecode(string);
    }
}

