/*
 * Decompiled with CFR 0.152.
 */
package com.vs.ils;

import com.vs.ils.AlerterJob;
import com.vs.ils.AuditCmdEventLuw;
import com.vs.ils.CheckProductLuw;
import com.vs.ils.DomainLicenseCacheEntry;
import com.vs.ils.DumDumCmd;
import com.vs.ils.IlsCmdArgs;
import com.vs.ils.IlsCustomCheckoutHandler;
import com.vs.ils.IlsException;
import com.vs.ils.IlsJob;
import com.vs.ils.IlsLicense;
import com.vs.ils.IlsLicenseCache;
import com.vs.ils.IlsToken;
import com.vs.ils.IlsUtil;
import com.vs.ils.crypt.Crypt;
import com.vs.ils.crypt.PkCrypt;
import com.vs.ils.ilsdb.AdminInfo;
import com.vs.ils.ilsdb.CheckoutInfo;
import com.vs.ils.ilsdb.Domain;
import com.vs.ils.ilsdb.HostAccessControl;
import com.vs.ils.ilsdb.LicenseParamInfo;
import com.vs.ils.ilsdb.Product;
import com.vs.ils.ilsdb.User;
import com.vs.wdo.rtl.WdoBaseException;
import com.vs.wdo.rtl.WdoObjectChangedOrDeletedException;
import com.vs.wdo.rtl.WdoTransaction;
import com.vs.wdo.rtl.WdoUnitOfWork;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.StringTokenizer;

public abstract class IlsCmdAPI {
    protected static final int LAST_NO_APP_PWD_PROTOCOL_VERSION = 2;
    protected IlsCmdArgs cmdArgs;
    protected HashMap cmdInfo;
    protected String serviceName = "default";
    protected IlsToken token;
    protected boolean doAudit;
    protected boolean hosted;
    protected boolean posth_act;
    private static final int _$23947 = 0;
    private static final int _$23962 = 1;
    private static final int _$23972 = 2;
    private static final int _$23982 = 3;
    private static final int _$23992 = 4;
    private static final int _$24002 = 5;
    private static final int _$24012 = 6;
    private static final int _$24022 = 7;
    private static final int _$24032 = 8;
    private static final int _$24045 = 100;
    static final String SYSOPTION_PREFIX = "ILS:";
    static final String SYSOPTION_SOFTUSERLIMIT = "ILS:SOFT-USER-LIMIT";
    static final String SYSOPTION_QUOTAGRACE = "ILS:QUOTA-GRACE";
    static final String SYSOPTION_QUOTAWARNTHRESHOLD = "ILS:QUOTA-WARNING-THRESHOLD";
    static final String SYSOPTION_EXPGRACE = "ILS:EXP-DAYS-GRACE";
    static final String SYSOPTION_EXPWARNTHRESHOLD = "ILS:EXP-DAYS-WARNING-THRESHOLD";
    static final String SYSOPTION_DURATIONFLOOR = "ILS:DURATION-FLOOR";
    static final String SYSOPTION_DURATIONCEILING = "ILS:DURATION-CEILING";
    static final String SYSOPTION_CANCELCHECKOUT_PRIV = "ILS:CANCEL-CHECKOUT-PRIV";
    static final String SYSOPTION_AUDIT = "ILS:AUDIT";
    static final String SYSOPTION_KEY_SHELF_LIFE = "ILS:KEY-SHELF-LIFE-HRS";
    static final String SYSOPTION_MACHINE_IP = "ILS:MACHINE-ADDR-IP";
    static final String SYSOPTION_MACHINE_MAC = "ILS:MACHINE-ADDR-MAC";
    static final String SYSOPTION_MACHINE_FP = "ILS:MACHINE-FINGERPRINT";
    static final String SYSOPTION_LOCK_DIR = "ILS:LOCK-DIR";
    static final String SYSOPTION_NORESTORE = "ILS:INHIBIT-DB-RESTORE";
    static final String SYSOPTION_MANDATORY_PWD = "ILS:MANDATORY-PASSWORD";
    static final String SYSOPTION_SYSOPT = "ILS:SYSOPT";
    static final String SYSOPT_HOSTED = "ILS:HOSTED";
    static final String SYSOPT_POSTH_ACT = "ILS:ENABLE_POSTHUMOUS_ACTIVATION";
    static final String SYSOPTION_CANCELCHECKOUT_PRIV_SYS = "SYSADMIN";
    static final String SYSOPTION_CANCELCHECKOUT_PRIV_PROD = "PRODADMIN";
    static final String SYSOPTION_CANCELCHECKOUT_PRIV_DOM = "DOMADMIN";
    static final String SYSOPTION_CANCELCHECKOUT_PRIV_NONE = "NONE";
    static final String SYSOPTION_DIRLOCK_NONE = "NO";
    static final String SYSOPTION_DIRLOCK_NONE_BAD = "NONE";
    static final String SYSOPTION_DIRLOCK_DEFER = "DEFER";
    static final String SYSOPTION_DIRLOCK_IMMED = "IMMED";
    static final String SYSOPTION_NORESTORE_INHIBIT1 = "1";
    static final String SYSOPTION_NORESTORE_INHIBIT2 = "T";
    static final String SYSOPTION_NORESTORE_INHIBIT3 = "Y";
    static final String SYSOPTION_NORESTORE_INHIBIT4 = "TRUE";
    static final String SYSOPTION_NORESTORE_INHIBIT5 = "YES";
    static final int DEFAULT_KEY_SHELF_LIFE = 168;
    private static String _$24650 = "pkrptpttk";
    private static String _$24662 = "pcqktrzyk";

    IlsCmdArgs getCmdArgs() {
        return this.cmdArgs;
    }

    String getServiceName() {
        return this.serviceName;
    }

    IlsToken getToken() {
        return this.token;
    }

    public static IlsCmdAPI MakeIlsCmd(String string) throws IlsException {
        if (!string.startsWith("system=ILS")) {
            IlsException.ThrowException(23, "Invalid protocol");
        }
        string = string.substring(string.indexOf("&") + 1);
        String string2 = null;
        String string3 = null;
        int n = 0;
        boolean bl = true;
        String string4 = null;
        IlsCmdAPI ilsCmdAPI = null;
        IlsCmdArgs ilsCmdArgs = new IlsCmdArgs(string);
        HashMap hashMap = null;
        try {
            boolean bl2;
            String string5;
            hashMap = IlsUtil.MakeKeyMap(string, "&");
            string2 = (String)hashMap.get("protocol_vsn");
            try {
                n = Integer.parseInt(string2);
            }
            catch (Throwable throwable) {
                IlsException.ThrowException(23, "Malformed protocol version: [" + string2 + "]");
            }
            if (n > 4) {
                IlsException.ThrowException(23, "Incompatible protocol version: [" + string2 + "]");
            }
            ilsCmdArgs.clientProtocolVsn = n;
            String string6 = IlsUtil.URLDecode((String)hashMap.get("product"));
            String string7 = null;
            String string8 = null;
            ilsCmdArgs.setProduct(string6);
            string3 = (String)hashMap.get("service");
            if (string3 != null) {
                string3 = IlsUtil.URLDecode(string3);
            }
            ilsCmdArgs.setServiceName(string3);
            ilsCmdAPI = new DumDumCmd();
            ilsCmdAPI.setArgs(ilsCmdArgs);
            ilsCmdAPI.cmdInfo = hashMap;
            if (string3 != null && !string3.trim().equals("")) {
                ilsCmdAPI.serviceName = string3.trim();
            }
            IlsCmdArgs ilsCmdArgs2 = new IlsCmdArgs();
            IlsJob.TriggerEvents(ilsCmdArgs2, string3, "User Command");
            if (!string6.equals("system")) {
                Object[] objectArray = new Object[]{ilsCmdAPI, null, null};
                string5 = WdoTransaction.DoUnitOfWork((WdoUnitOfWork)new CheckProductLuw(), (String)string3, (int)2, (Object[])objectArray);
                if (string5 != null) {
                    if (ilsCmdArgs.getStatus() <= 0) {
                        ilsCmdArgs.setStatusInfo(25, "Product " + string6 + " configuration error / warning.  Please contact your administrator with the following details: " + string5, null, AlerterJob.MakeEventParams(string6));
                    }
                    if (ilsCmdArgs.getStatus() > 0) {
                        DumDumCmd dumDumCmd = ilsCmdAPI;
                        return dumDumCmd;
                    }
                }
                string7 = (String)objectArray[1];
                string8 = (String)objectArray[2];
                bl = ilsCmdAPI.doAudit;
            }
            boolean bl3 = bl2 = string7 == null || string7.equals("");
            if (string7 == null || n <= 2) {
                string7 = string6;
            }
            if ((string5 = (String)hashMap.get("envelope")) != null) {
                String[] stringArray = PkCrypt.makeKeyPair((String)Crypt.encode((String)"dyAuYCM/bV==", (String)_$24662, (String)_$24650), (String)string7);
                string4 = stringArray[1];
                string = PkCrypt.decryptWithPrivateKey((String)Crypt.encode((String)"dyAuYCM/bV==", (String)_$24662, (String)_$24650), (String)IlsUtil.URLDecode(string5), (String)string4);
                IlsUtil.Trace(true, 7, "IlsCmdAPI", new String[]{"Decrypted request:[" + string + "]"}, false);
                string = String.valueOf(string) + "&product=" + string6;
                hashMap = IlsUtil.MakeKeyMap(string, "&");
                ilsCmdArgs.setRequest(string);
            } else if (!bl2 && ((String)hashMap.get("cmd")).equals("checkout")) {
                Object object;
                boolean bl4 = IlsUtil.GetBooleanFromString(IlsCmdAPI.GetIlsStringOption(string8, SYSOPTION_MANDATORY_PWD), true);
                if (bl4) {
                    object = (String)hashMap.get("domain");
                    if (object != null && ((String)object).equals("system")) {
                        bl4 = false;
                    } else {
                        String string9 = (String)hashMap.get("user");
                        if (string9 != null && string9.startsWith("useradmin")) {
                            bl4 = false;
                        }
                    }
                }
                IlsUtil.Trace(7, "IlsCmdAPI", "MakeIlsCmd: checking for mandatory passwd.  Product options=" + string8 + ", mand=" + bl4 + ", isClear=" + bl2);
                if (string8 != null && bl4) {
                    ilsCmdArgs.setStatusInfo(23, "Product '" + string6 + "' requires use of an application password public key by the client.", null, AlerterJob.MakeEventParams(string6));
                    object = ilsCmdAPI;
                    return object;
                }
            }
            string2 = (String)hashMap.get("cmd");
            String string10 = "com.vs.ils." + IlsUtil.ToUpperStart(string2) + "Cmd";
            ilsCmdAPI = (IlsCmdAPI)Class.forName(string10).newInstance();
            ilsCmdAPI.setArgs(ilsCmdArgs);
            ilsCmdArgs.makeCmdArgs(hashMap, string4);
            ilsCmdAPI.cmdInfo = hashMap;
            if (ilsCmdArgs.getDomain() != null && ilsCmdArgs.getDomain().equals("system") && ilsCmdArgs.getCustomCtx() != null && ilsCmdArgs.getCustomCtx().equals("noaudit") || ilsCmdArgs.getParams() != null && ilsCmdArgs.getParams().equals("ils:noaudit")) {
                ilsCmdAPI.doAudit = false;
                bl = false;
            }
            if (!IlsLicense.checkedSig) {
                IlsLicense.checkEzlmSigs();
            }
            if (ilsCmdAPI.hosted = IlsCmdAPI.CheckHosted(string8, string7)) {
                ilsCmdAPI.posth_act = IlsCmdAPI.CheckPosthumousActivation(string8, string7);
            }
            ilsCmdAPI.doAudit = bl;
        }
        catch (IlsException ilsException) {
            if (ilsCmdArgs.getStatus() <= 0) {
                ilsCmdArgs.setStatusInfo(1000, "Internal error.  Please have your administrator contact Orion technical support with the following details: " + ilsException.getMessage());
            }
        }
        catch (InstantiationException instantiationException) {
            ilsCmdArgs.setStatusInfo(23, "Protocol Error: Invalid command [" + string2 + "]");
        }
        catch (Throwable throwable) {
            IlsUtil.Trace(false, 5, "IlsCmdAPI", new String[]{"Unexpected exception instantiating cmd handler for cmd " + string2 + ".  Stack Trace: "}, true, throwable);
            IlsException.ThrowException(1000, "Internal error.  Please have your administrator contact Orion technical support with the following details: Could not instantiate command handler for command [" + string2 + "]" + "\nException: " + throwable.getClass().getName() + "\nMessage: " + throwable.getMessage());
        }
        if (string3 != null && !string3.trim().equals("")) {
            ilsCmdAPI.serviceName = string3.trim();
        }
        return ilsCmdAPI;
    }

    public void setArgs(IlsCmdArgs ilsCmdArgs) {
        this.cmdArgs = ilsCmdArgs;
    }

    public abstract boolean processCmd();

    boolean processLuwCmd(WdoUnitOfWork wdoUnitOfWork) {
        Object[] objectArray = new Object[]{this};
        String string = null;
        if (wdoUnitOfWork != null && (string = WdoTransaction.DoUnitOfWork((WdoUnitOfWork)wdoUnitOfWork, (String)this.serviceName, (int)1, (Object[])objectArray)) != null && this.cmdArgs.getStatus() <= 0) {
            this.cmdArgs.setStatusInfo(25, string);
        }
        if (this.doAudit) {
            WdoTransaction.DoUnitOfWork((WdoUnitOfWork)new AuditCmdEventLuw(), (String)this.serviceName, (int)1, (Object[])objectArray);
        }
        return string == null;
    }

    public String makeCmdResponse() {
        return this.cmdArgs.makeCmdResponse();
    }

    IlsToken parseToken() throws WdoBaseException {
        return this.parseToken(false);
    }

    IlsToken parseToken(boolean bl) throws WdoBaseException {
        IlsToken ilsToken = null;
        try {
            ilsToken = IlsToken.ParseToken(this.cmdArgs.getToken(), this.serviceName);
        }
        catch (IlsException ilsException) {
            this.cmdArgs.setStatusInfo(ilsException.getCode(), ilsException.getMessage());
            WdoBaseException.ThrowProxyWdoException((int)12);
        }
        this.cmdArgs.setMachine(ilsToken.getClientMachine());
        if (ilsToken.getProductId() > (long)0) {
            this.cmdArgs.setProduct(Product.GetProduct((long)ilsToken.getProductId()).getName());
        }
        if (!bl && ilsToken.getDomainId() > (long)0) {
            this.cmdArgs.setDomain(Domain.GetDomain((long)ilsToken.getDomainId()).getName());
        }
        this.cmdArgs.setSessionId(ilsToken.getSessionId());
        if (!bl) {
            long l = ilsToken.getUserId();
            String string = null;
            if (l != (long)0) {
                try {
                    string = User.GetUser((long)ilsToken.getUserId()).getName();
                }
                catch (WdoObjectChangedOrDeletedException wdoObjectChangedOrDeletedException) {
                    // empty catch block
                }
            }
            this.cmdArgs.setUser(string);
        }
        this.token = ilsToken;
        return ilsToken;
    }

    void checkToken(Product product, Domain domain, User user, IlsToken ilsToken, Date date, boolean bl) throws WdoBaseException {
        CheckoutInfo checkoutInfo = user.getCheckoutInfo();
        if (!checkoutInfo.getCheckedOut()) {
            if (this.cmdArgs.getStatus() <= 0) {
                this.cmdArgs.setStatusInfo(14, checkoutInfo.lastChkInTsIsDefined() ? "The authentication token was already checked in on " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z").format(new Date(checkoutInfo.getLastChkInTs())) : "The authentication token was never checked out", null, AlerterJob.MakeEventParams(product.getName(), domain.getName(), user.getName()));
            }
        } else if (!checkoutInfo.getLastChkMachineX().equals(this.cmdArgs.getMachine()) || checkoutInfo.getLastChkSessId() != this.cmdArgs.getSessionId()) {
            if (this.cmdArgs.getStatus() <= 0) {
                this.cmdArgs.setStatusInfo(22, "The authentication token was checked out by a different machine / session. Machine: " + checkoutInfo.getLastChkMachineX() + ", Session Id: " + checkoutInfo.getLastChkSessId(), null, AlerterJob.MakeEventParams(product.getName(), domain.getName(), user.getName()));
            }
        } else if (!ilsToken.getTokenString().trim().equals(user.getToken().trim())) {
            if (this.cmdArgs.getStatus() <= 0) {
                this.cmdArgs.setStatusInfo(1, "Invalid server session.  Root cause: unexpected authentication token.", ilsToken.getTokenString(), AlerterJob.MakeEventParams(product.getName(), domain.getName(), user.getName()));
            }
        } else if (ilsToken.getExpireTs() < date.getTime()) {
            IlsUtil.Trace(10, "IlsCmdAPI", "checktoken:found expired.  expireTs=" + ilsToken.getExpireTs() + ", nowTs=" + date.getTime());
            if (this.cmdArgs.getStatus() <= 0 && bl) {
                this.cmdArgs.setStatusInfo(bl ? 4 : -5, "Late Checkin.  Root cause: authentication token expired on " + new Date(ilsToken.getExpireTs()) + ", current date/time is " + date + ".", ilsToken.getTokenString(), AlerterJob.MakeEventParams(product.getName(), domain.getName(), user.getName()));
            }
        }
        if (this.cmdArgs.getStatus() > 0) {
            WdoBaseException.ThrowProxyWdoException((int)12);
        }
    }

    void checkHostAccess(String string, String string2, String string3) throws WdoBaseException {
        boolean bl;
        String string4 = this.makeQualifiedMachineName(string, string2, string3);
        boolean bl2 = bl = HostAccessControl.CheckAccessDeny2((String)this.cmdArgs.getMachine(), (String)string4) > 0;
        if (!bl) {
            boolean bl3 = string4.equals(this.cmdArgs.getMachine()) ? false : HostAccessControl.CheckAccessAllow((String)string4) == 0;
            boolean bl4 = HostAccessControl.CheckAccessAllow((String)this.cmdArgs.getMachine()) == 0;
            boolean bl5 = bl = bl4 && !bl3;
        }
        if (bl) {
            this.cmdArgs.setStatusInfo(18, "Access is denied to requests from machine: " + this.cmdArgs.getMachine());
            WdoBaseException.ThrowProxyWdoException((int)12);
        }
    }

    String makeQualifiedMachineName(String string, String string2, String string3) {
        if (string == null || string2 == null) {
            return this.cmdArgs.getMachine();
        }
        return String.valueOf(string) + ":" + string2 + ":" + (string3 == null ? "anon" : string3) + ":" + this.cmdArgs.getMachine();
    }

    void checkValidCheckin(Date date, Product product, Domain domain, User user, boolean bl) throws WdoBaseException {
        CheckoutInfo checkoutInfo = user.getCheckoutInfo();
        long l = (date.getTime() - checkoutInfo.getLastChkOutTs()) / (long)1000;
        IlsUtil.Trace(10, "IlsCmdAPI.checkValidCheckin", new String[]{"hosted: " + this.hosted, "posthumous activation: " + this.posth_act, "actualChkoutDuration is " + l});
        long l2 = -1L;
        long l3 = -1L;
        if (product.optionsIsDefined()) {
            l2 = IlsCmdAPI.GetIlsLongOption(product.getOptions(), SYSOPTION_DURATIONFLOOR);
            l3 = IlsCmdAPI.GetIlsLongOption(product.getOptions(), SYSOPTION_DURATIONCEILING);
            IlsUtil.Trace(10, "IlsCmdAPI.checkValidCheckin", new String[]{"minChkoutDuration is " + l2, "maxChkoutDuration is " + l3});
        }
        if (this.hosted || l2 < domain.getMinCheckoutDurationSec()) {
            l2 = domain.getMinCheckoutDurationSec();
        }
        if (this.hosted || l3 > (long)0 && l3 > domain.getMaxCheckoutDurationSec()) {
            l3 = domain.getMaxCheckoutDurationSec();
        }
        IlsUtil.Trace(10, "IlsCmdAPI.checkValidCheckin", new String[]{"adj minChkoutDuration is " + l2, "adj maxChkoutDuration is " + l3});
        if (!bl) {
            long l4 = l2;
            if (l2 > user.getCheckoutDurationSec()) {
                l4 = user.getCheckoutDurationSec();
            }
            if (l4 > l) {
                if (this.cmdArgs.getStatus() <= 0) {
                    this.cmdArgs.setStatusInfo(15, "Attempted premature checkin by user " + user.getName() + " from machine '" + checkoutInfo.getLastChkMachine() + "' for product " + product.getName() + " domain " + domain.getName() + " has failed and the authentication token is still checked out.  Checkin is allowed only after a minimum duration of " + l2 + " seconds after the first checkout.", null, AlerterJob.MakeEventParams(product.getName(), domain.getName(), user.getName()));
                }
                WdoBaseException.ThrowProxyWdoException((int)12);
            }
            if (l3 > (long)0 && l3 < l && this.cmdArgs.getStatus() == 0) {
                this.cmdArgs.setStatusInfo(-5, "Late checkin by user " + user.getName() + " from machine '" + checkoutInfo.getLastChkMachine() + " for product " + product.getName() + " domain " + domain.getName() + ".  Checkin is required to occur before a maximum duration of " + l3 + " seconds after checkout.", null, AlerterJob.MakeEventParams(product.getName(), domain.getName(), user.getName()));
            }
        }
    }

    void verifyProduct(Product product) throws WdoBaseException {
        String string;
        boolean bl;
        if (product.getName().equals("system")) {
            return;
        }
        if (!product.kcookyIsDefined()) {
            this.cmdArgs.setStatusInfo(26, "Invalid license configuration in database for product " + product.getName() + ".  Likely explanation: security attack on license server.", null, AlerterJob.MakeEventParams(product.getName()));
            WdoBaseException.ThrowProxyWdoException((int)12);
        }
        String string2 = product.optionsIsDefined() ? product.getOptions() : null;
        String string3 = IlsCmdAPI.GetIlsStringOption(string2, SYSOPTION_NORESTORE);
        boolean bl2 = bl = string3 != null && (string3.equalsIgnoreCase(SYSOPTION_NORESTORE_INHIBIT1) || string3.equalsIgnoreCase(SYSOPTION_NORESTORE_INHIBIT2) || string3.equalsIgnoreCase(SYSOPTION_NORESTORE_INHIBIT3) || string3.equalsIgnoreCase(SYSOPTION_NORESTORE_INHIBIT4) || string3.equalsIgnoreCase(SYSOPTION_NORESTORE_INHIBIT5));
        if (bl && ((string = IlsLicense.KHfile.getHfileContents(this.serviceName, product.getName(), null)) == null || !string.equals(product.getKcooky()))) {
            IlsUtil.Trace(10, "IlsCmdAPI:verifyProduct", "kooky mismatch.  file contents: [" + string + "], prod kooky: [" + product.getKcooky() + "]");
            this.cmdArgs.setStatusInfo(26, "Invalid license configuration in database  for product " + product.getName() + " - database is a backup, and backups are not allowed for this product.  Please reinstall your product floating license key in order to continue.", null, AlerterJob.MakeEventParams(product.getName()));
            WdoBaseException.ThrowProxyWdoException((int)12);
        }
        if ((string = IlsCmdAPI.GetIlsStringOption(string2, SYSOPTION_LOCK_DIR)) == null || string.equals("")) {
            string = SYSOPTION_DIRLOCK_DEFER;
        }
        if (!string.equals(SYSOPTION_DIRLOCK_NONE) && !string.equals("NONE")) {
            String string4 = null;
            if (!product.getInited()) {
                if (string.equals(SYSOPTION_DIRLOCK_IMMED)) {
                    string4 = "The database has been tampered with.";
                } else {
                    product.setInited(true);
                    product.setCurd(System.getProperty("user.dir"));
                }
            } else {
                boolean bl3 = System.getProperty("os.name").startsWith("Windows");
                String string5 = System.getProperty("user.dir");
                String string6 = product.getCurd();
                if (!(bl3 ? string5.equalsIgnoreCase(string6) : string5.equals(string6))) {
                    string4 = "The database and / or product installation is not in its original location.";
                }
            }
            if (string4 != null) {
                this.cmdArgs.setStatusInfo(26, "License configuration error  for product " + product.getName() + ".  Root cause: " + string4, null, AlerterJob.MakeEventParams(product.getName()));
                WdoBaseException.ThrowProxyWdoException((int)12);
            }
        }
        if (!product.getEnabled()) {
            this.cmdArgs.setStatusInfo(10, "Product '" + product.getName() + "' is not enabled", null, AlerterJob.MakeEventParams(product.getName()));
            WdoBaseException.ThrowProxyWdoException((int)12);
        }
    }

    Domain getVerifyDomain(Product product, long l) throws WdoBaseException {
        Domain domain = Domain.GetDomain((long)l);
        if (!domain.getEnabled()) {
            this.cmdArgs.setStatusInfo(11, "Domain '" + domain.getName() + "' for product '" + product.getName() + "' is not enabled", null, AlerterJob.MakeEventParams(product.getName(), domain.getName()));
            WdoBaseException.ThrowProxyWdoException((int)12);
        }
        return domain;
    }

    User getVerifyUser(Product product, Domain domain, long l) throws WdoBaseException {
        User user = User.GetUser((long)l);
        if (!user.getEnabled()) {
            IlsUtil.Trace(5, "IlsCmdAPI", new String[]{"getVerifyUser: Got disabled user.  XML dump:", user.toXML()});
            this.cmdArgs.setStatusInfo(12, "User '" + user.getName() + "'  for product '" + product.getName() + " domain '" + domain.getName() + "' is not enabled", null, AlerterJob.MakeEventParams(product.getName(), domain.getName(), user.getName()));
            WdoBaseException.ThrowProxyWdoException((int)12);
        }
        return user;
    }

    Product checkGetProduct() throws WdoBaseException {
        long l = Product.FindByName((String)this.cmdArgs.getProduct(), (boolean)true);
        if (l == (long)0) {
            this.cmdArgs.setStatusInfo(7, "Product '" + this.cmdArgs.getProduct() + "' not found", null, AlerterJob.MakeEventParams(this.cmdArgs.getProduct()));
            WdoBaseException.ThrowProxyWdoException((int)12);
        }
        Product product = Product.GetProduct((long)l);
        this.verifyProduct(product);
        return product;
    }

    Product checkGetProductById() throws WdoBaseException {
        Product product = null;
        long l = this.getToken().getProductId();
        try {
            product = Product.GetProductX((long)l, (boolean)true);
            String string = product.getName();
        }
        catch (WdoObjectChangedOrDeletedException wdoObjectChangedOrDeletedException) {
            this.cmdArgs.setStatusInfo(7, "Product '" + this.cmdArgs.getProduct() + "' not found", null, AlerterJob.MakeEventParams(this.cmdArgs.getProduct()));
            WdoBaseException.ThrowProxyWdoException((int)12);
        }
        this.verifyProduct(product);
        return product;
    }

    Domain checkGetDomain(Product product) throws WdoBaseException {
        long l = Domain.FindByNameX((String)this.cmdArgs.getProduct(), (String)this.cmdArgs.getDomain(), (boolean)true);
        if (l == (long)0) {
            this.cmdArgs.setStatusInfo(8, "Domain '" + this.cmdArgs.getDomain() + "' not found for product '" + this.cmdArgs.getProduct() + "'", null, AlerterJob.MakeEventParams(product.getName(), this.cmdArgs.getDomain()));
            WdoBaseException.ThrowProxyWdoException((int)12);
        }
        return this.getVerifyDomain(product, l);
    }

    Domain checkGetDomainById(Product product) throws WdoBaseException {
        Domain domain = null;
        long l = this.getToken().getDomainId();
        try {
            domain = Domain.GetDomainX((long)l, (boolean)true);
            domain = this.getVerifyDomain(product, l);
        }
        catch (WdoObjectChangedOrDeletedException wdoObjectChangedOrDeletedException) {
            this.cmdArgs.setStatusInfo(8, "Domain '" + this.cmdArgs.getDomain() + "' not found for product '" + this.cmdArgs.getProduct() + "'", null, AlerterJob.MakeEventParams(product.getName(), this.cmdArgs.getDomain()));
            WdoBaseException.ThrowProxyWdoException((int)12);
        }
        return domain;
    }

    User checkGetIUser(Product product, Domain domain) throws WdoBaseException {
        long l = 0L;
        long l2 = 0L;
        User user = null;
        try {
            l = new Date().getTime();
            long l3 = 0L;
            if (this.cmdArgs.getUser() == null || (l3 = User.FindByNameX((String)this.cmdArgs.getProduct(), (String)this.cmdArgs.getDomain(), (String)this.cmdArgs.getUser(), (String)IlsUtil.GetEncryptedPasswd(this.cmdArgs.getPasswd(), this.cmdArgs.getUser()), (boolean)true)) == (long)0) {
                this.cmdArgs.setStatusInfo(9, String.valueOf(this.cmdArgs.getUser() == null ? "User name not specified, valid and authorized" : "User name '" + this.cmdArgs.getUser() + "' not found") + " for domain '" + this.cmdArgs.getDomain() + "', product '" + this.cmdArgs.getProduct() + "'", null, AlerterJob.MakeEventParams(product.getName(), domain.getName(), this.cmdArgs.getUser()));
                WdoBaseException.ThrowProxyWdoException((int)12);
            }
            l2 = new Date().getTime();
            IlsUtil.Trace(7, "IlsCmdAPI", "checkGetIUser: time to find iuser by name (ms): " + String.valueOf(l2 - l));
            user = this.getVerifyUser(product, domain, l3);
            l2 = new Date().getTime();
            IlsUtil.Trace(7, "IlsCmdAPI", "checkGetIUser: time to find iuser by name and getverifyuser (ms): " + String.valueOf(l2 - l));
        }
        catch (WdoObjectChangedOrDeletedException wdoObjectChangedOrDeletedException) {
            this.cmdArgs.setStatusInfo(9, "User name '" + this.cmdArgs.getUser() + "' not found for domain '" + this.cmdArgs.getDomain() + "', product '" + this.cmdArgs.getProduct() + "'", null, AlerterJob.MakeEventParams(product.getName(), domain.getName(), this.cmdArgs.getUser()));
            WdoBaseException.ThrowProxyWdoException((int)12);
        }
        return user;
    }

    User checkGetIUserById(Product product, Domain domain, Date date, boolean bl) throws WdoBaseException {
        User user;
        block10: {
            long l = 0L;
            long l2 = 0L;
            boolean bl2 = domain.getLicenseModel().equals("IUSER");
            user = null;
            long l3 = this.getToken().getUserId();
            try {
                l = new Date().getTime();
                user = User.GetUserForUpdate((long)l3);
                String string = user.getName();
                l2 = new Date().getTime();
                IlsUtil.Trace(7, "IlsCmdAPI", "checkGetIUserById: time to get user for update (ms): " + String.valueOf(l2 - l));
                if (!bl2 && string != null && string.startsWith("useradmin")) {
                    bl2 = true;
                }
                user = this.getVerifyUser(product, domain, l3);
                l2 = new Date().getTime();
                IlsUtil.Trace(7, "IlsCmdAPI", "checkGetIUserById: time to check/get iuser and getverifyuser (ms): " + String.valueOf(l2 - l));
                if (bl2 && !IlsCmdAPI.CheckUserCheckedOut(date, user)) {
                    IlsUtil.Trace(7, "IlsCmdAPI", "checkGetIUserById: found user not checked out.");
                    String string2 = "User name '" + this.cmdArgs.getUser() + "' has either already been checked in or its checkout has expired or was cancelled.";
                    int n = bl ? 14 : -5;
                    this.cmdArgs.setStatusInfo(n, string2, null, AlerterJob.MakeEventParams(product.getName(), domain.getName(), user.getName()));
                    if (user.getCheckoutInfo().getCheckedOut() && !bl) {
                        user.getCheckoutInfo().setCheckedOut(false);
                        user.setIsDirty(true);
                        IlsUtil.Trace(9, "IlsCmdAPI", "CheckGetIuserById: adjusting named-user checkout watermark down by 1 due to late-checkin scenario");
                        DomainLicenseCacheEntry domainLicenseCacheEntry = IlsLicenseCache.getDomainCacheEntry(date, product, domain);
                        if (bl2) {
                            domainLicenseCacheEntry.adjustCheckoutWatermark(date, domain, -1, true);
                        } else {
                            domainLicenseCacheEntry.adjustWatermark(date, domain, -user.getPoints(), true);
                        }
                    }
                    if (bl) {
                        WdoBaseException.ThrowProxyWdoException((int)12);
                    }
                    user = null;
                }
            }
            catch (WdoObjectChangedOrDeletedException wdoObjectChangedOrDeletedException) {
                user = null;
                String string = null;
                int n = 0;
                if (bl2) {
                    string = "User no longer exists for domain '" + this.cmdArgs.getDomain() + "', product '" + this.cmdArgs.getProduct() + "'";
                    n = 9;
                } else {
                    string = "Checkout was cancelled for anonymous user on domain '" + this.cmdArgs.getDomain() + "', product '" + this.cmdArgs.getProduct() + "'";
                    n = -9;
                }
                this.cmdArgs.setStatusInfo(n, string, null, AlerterJob.MakeEventParams(product.getName(), domain.getName()));
                if (!bl2) break block10;
                WdoBaseException.ThrowProxyWdoException((int)12);
            }
        }
        return user;
    }

    void checkExpiredUser(Date date, IlsLicense ilsLicense, Product product, Domain domain, User user) throws WdoBaseException {
        long l;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        long l2 = date.getTime();
        long l3 = -1L;
        long l4 = -1L;
        LicenseParamInfo licenseParamInfo = user.getLicenseParams();
        if (!this.posth_act && (ilsLicense.getKeyInfo().getLicenseModeBitmap() & 1) != 0) {
            bl = true;
            l = IlsCmdAPI.GetIlsLongOption(ilsLicense.getKeyInfo().getOptions(), SYSOPTION_EXPGRACE);
            long l5 = IlsCmdAPI.GetIlsLongOption(ilsLicense.getKeyInfo().getOptions(), SYSOPTION_EXPWARNTHRESHOLD);
            l3 = ilsLicense.getKeyInfo().getExpirationDate().getTime();
            l4 = l3 + (l <= (long)0 ? 0L : l * (long)86400000);
            if (l2 > l3) {
                bl2 = true;
                bl3 = l2 > l4;
            } else {
                boolean bl5 = bl4 = l2 >= l3 - (l5 <= (long)0 ? 0L : l5 * (long)86400000);
            }
        }
        if (!bl3 && !domain.getLicenseParams().getTimeLimitType().equals("NONE")) {
            bl = true;
            if (!domain.getLicenseParams().expDateIsDefined()) {
                l = l2 + domain.getLicenseParams().getExpDays() * (long)86400000;
                if (l > l3 && l3 > (long)0) {
                    l = l3;
                }
                domain.getLicenseParams().setExpDate(new Timestamp(l));
                domain.setIsDirty(true);
            }
            if (l3 <= (long)0 || l3 > domain.getLicenseParams().getExpDate().getTime()) {
                l3 = domain.getLicenseParams().getExpDate().getTime();
            }
            if (l4 <= (long)0 || l4 > l3 + (long)(domain.getLicenseParams().getExpGrace() * 86400000)) {
                l4 = l3 + (long)(domain.getLicenseParams().getExpGrace() * 86400000);
            }
            if (l2 > l3 && l3 > (long)0) {
                bl2 = true;
                bl3 = l2 > l4;
            } else {
                boolean bl6 = bl4 = l3 > (long)0 && l2 >= l3 - (long)(domain.getLicenseParams().getExpWarningThreshold() * 86400000);
            }
        }
        if (!bl3 && !user.getLicenseParams().getTimeLimitType().equals("NONE")) {
            bl = true;
            if (!user.getLicenseParams().expDateIsDefined()) {
                l = l2 + user.getLicenseParams().getExpDays() * (long)86400000;
                if (l > l3 && l3 > (long)0) {
                    l = l3;
                }
                user.getLicenseParams().setExpDate(new Timestamp(l));
                user.setIsDirty(true);
            }
            if (l3 <= (long)0 || l3 > user.getLicenseParams().getExpDate().getTime()) {
                l3 = user.getLicenseParams().getExpDate().getTime();
            }
            if (l4 <= (long)0 || l4 > l3 + (long)(user.getLicenseParams().getExpGrace() * 86400000)) {
                l4 = l3 + (long)(user.getLicenseParams().getExpGrace() * 86400000);
            }
            if (l2 > l3 && l3 > (long)0) {
                bl2 = true;
                bl3 = l2 > l4;
            } else {
                boolean bl7 = bl4 = l3 > (long)0 && l2 >= l3 - (long)(user.getLicenseParams().getExpWarningThreshold() * 86400000);
            }
        }
        if (bl) {
            if (bl3 || bl2) {
                this.cmdArgs.setStatusInfo(bl3 ? 5 : -2, "User license for user '" + user.getName() + "' for product '" + product.getName() + "' domain '" + domain.getName() + "'" + " expired on " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z").format(new Date(l3)) + (bl3 ? "" : " and is on a grace period through " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z").format(new Date(l4))), null, AlerterJob.MakeEventParams(product.getName(), domain.getName(), user.getName()));
                if (bl3) {
                    WdoBaseException.ThrowProxyWdoException((int)12);
                }
            } else if (bl4) {
                this.cmdArgs.setStatusInfo(-1, "User license for user '" + user.getName() + "' for product '" + product.getName() + "' domain '" + domain.getName() + "' expires on " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z").format(new Date(l3)), null, AlerterJob.MakeEventParams(product.getName(), domain.getName(), user.getName()));
            }
            this.cmdArgs.setUserExpTs(l3);
        }
    }

    void checkExpiredQuotaUser(Date date, long l, IlsLicense ilsLicense, Product product, Domain domain, User user, boolean bl, IlsCmdArgs ilsCmdArgs) throws WdoBaseException {
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        long l2 = 0L;
        long l3 = 0L;
        LicenseParamInfo licenseParamInfo = user.getLicenseParams();
        if (bl) {
            IlsUtil.Trace(7, "IlsCmdAPI", new String[]{"checkExpiredQuotaUser: enter for update.", "addQuota=" + l, "prod-used-quota=" + product.getUsedQuota(), "dom-used-quota=" + domain.getCurrQuotaUsageLevel(), "user-used-quota=" + user.getCurrQuotaUsageLevel()});
        }
        if ((ilsLicense.getKeyInfo().getLicenseModeBitmap() & 2) != 0) {
            bl2 = true;
            long l4 = IlsCmdAPI.GetIlsLongOption(ilsLicense.getKeyInfo().getOptions(), SYSOPTION_QUOTAGRACE);
            long l5 = IlsCmdAPI.GetIlsLongOption(ilsLicense.getKeyInfo().getOptions(), SYSOPTION_QUOTAWARNTHRESHOLD);
            l2 = ilsLicense.getKeyInfo().getQuotaValue();
            l3 = l2 + (l4 <= (long)0 ? 0L : l4);
            IlsUtil.Trace(7, "IlsCmdAPI", new String[]{"checkExpiredQuotaUser: update=" + bl + ", addQuota=" + l + ", quotaCap=" + l2 + ",", "absQuotaCap=" + l3 + ", quotaGrace=" + l4 + ", quotaWarnThreshold=" + l5 + ", prod-used-quota=" + product.getUsedQuota()});
            if (product.getUsedQuota() + l > l2) {
                bl3 = true;
                bl4 = product.getUsedQuota() + l > l3;
            } else {
                boolean bl6 = bl5 = product.getUsedQuota() + l >= l2 - (l5 <= (long)0 ? 0L : l5);
            }
        }
        if (!bl4 && bl) {
            product.setUsedQuota(product.getUsedQuota() + l);
        }
        if (!bl4 && domain.getLicenseParams().getQuotaLimited()) {
            bl2 = true;
            if (l2 <= (long)0 || l2 > domain.getLicenseParams().getQuota()) {
                l2 = domain.getLicenseParams().getQuota();
            }
            if (l3 <= (long)0 || l3 > l2 + domain.getLicenseParams().getQuotaGrace()) {
                l3 = l2 + domain.getLicenseParams().getQuotaGrace();
            }
            if (domain.getCurrQuotaUsageLevel() + l > l2) {
                bl3 = true;
                bl4 = domain.getCurrQuotaUsageLevel() + l - l2 > domain.getLicenseParams().getQuotaGrace();
            } else {
                boolean bl7 = bl5 = domain.getCurrQuotaUsageLevel() + l >= l2 - domain.getLicenseParams().getQuotaWarningThreshold();
            }
        }
        if (bl && !bl4) {
            domain.setCurrQuotaUsageLevel(domain.getCurrQuotaUsageLevel() + l);
        }
        if (!bl4 && user.getLicenseParams().getQuotaLimited()) {
            bl2 = true;
            if (l2 <= (long)0 || l2 > user.getLicenseParams().getQuota()) {
                l2 = user.getLicenseParams().getQuota();
            }
            if (l3 <= (long)0 || l3 > l2 + user.getLicenseParams().getQuotaGrace()) {
                l3 = l2 + user.getLicenseParams().getQuotaGrace();
            }
            if (user.getCurrQuotaUsageLevel() + l > l2) {
                bl3 = true;
                bl4 = user.getCurrQuotaUsageLevel() + l - l2 > user.getLicenseParams().getQuotaGrace();
            } else {
                boolean bl8 = bl5 = user.getCurrQuotaUsageLevel() + l >= l2 - user.getLicenseParams().getQuotaWarningThreshold();
            }
        }
        if (bl && !bl4) {
            user.setCurrQuotaUsageLevel(user.getCurrQuotaUsageLevel() + l);
        }
        if (bl2) {
            if (bl4 || bl3) {
                ilsCmdArgs.setStatusInfo(bl4 ? 6 : -4, "User " + user.getName() + " license quota consumption of " + l + " for domain " + domain.getName() + " (product " + product.getName() + ")" + " causes the assigned / capped quota of " + l2 + " to be exceeded" + (bl4 ? "" : " and is on a grace quota up to " + l3), null, AlerterJob.MakeEventParams(product.getName(), domain.getName(), user.getName()));
                if (bl4) {
                    WdoBaseException.ThrowProxyWdoException((int)12);
                }
                if (l > (long)0) {
                    AdminInfo adminInfo = user.getAdminInfo();
                    adminInfo.setUpdateDate(new Timestamp(date.getTime()));
                }
            } else if (bl5) {
                ilsCmdArgs.setStatusInfo(-3, "User " + user.getName() + " is approaching assigned / capped quota of " + l2 + " for domain " + domain.getName() + " (product " + product.getName() + ")" + " - balance quota available: " + (l2 - l), null, AlerterJob.MakeEventParams(product.getName(), domain.getName(), user.getName()));
            }
            ilsCmdArgs.setQuotaCap(l2);
        }
        if (bl) {
            IlsUtil.Trace(7, "IlsCmdAPI", "checkExpiredQuotaUser: exit for update.  doWarning=" + bl5 + ", exceeded=" + bl3 + ", prod-used-quota=" + product.getUsedQuota() + ",dom-used-quota=" + domain.getCurrQuotaUsageLevel() + ", user-used-quota=" + user.getCurrQuotaUsageLevel());
        }
    }

    long calcCheckoutDuration(Date date, IlsLicense ilsLicense, Domain domain, User user) throws WdoBaseException {
        long l = this.cmdArgs.getDuration();
        long l2 = domain.getMinCheckoutDurationSec();
        long l3 = domain.getMaxCheckoutDurationSec();
        long l4 = -1L;
        CheckoutInfo checkoutInfo = user != null ? user.getCheckoutInfo() : new CheckoutInfo();
        IlsUtil.Trace(10, "IlsCmdAPI", "calcCheckoutDuration: enter.  duration=" + l + ", durationLow=" + l2 + ", durationHi=" + l3 + ", checkedOut: " + checkoutInfo.getCheckedOut() + ", last checked out: " + (checkoutInfo.getCheckedOut() ? String.valueOf(checkoutInfo.getLastChkOutTs()) : "N/A") + ", now: " + date.getTime() + "(" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z").format(date) + ")" + ", elapsed duration between time of last checkout and now: " + (checkoutInfo.getCheckedOut() ? String.valueOf((date.getTime() - checkoutInfo.getLastChkOutTs()) / (long)1000) : "N/A"));
        if (checkoutInfo.getCheckedOut() && checkoutInfo.getLastChkOutTs() > (long)0 && date.getTime() - checkoutInfo.getLastChkOutTs() < user.getCheckoutDurationSec() * 1000L) {
            l4 = (checkoutInfo.getLastChkOutTs() + user.getCheckoutDurationSec() * 1000L - date.getTime()) / 1000L;
            IlsUtil.Trace(10, "IlsCmdAPI", "calcCheckoutDuration: is checked out.  balanceDuration=" + l4);
        }
        if (l2 > (long)0 && l4 > (long)0 && l4 < l2) {
            IlsUtil.Trace(10, "IlsCmdAPI", "calcCheckoutDuration: setting durationLow " + l2 + " to balanceDuration " + l4 + " due to condition durationLow > 0 && balanceDuration > 0 && balanceDuration < durationLow");
            l2 = l4;
        }
        if (l2 > (long)0 && l < l2) {
            IlsUtil.Trace(10, "IlsCmdAPI", "calcCheckoutDuration: adjusting duration " + l + " to durationLow " + l2 + " due to durationLow > 0 && duration < durationLow");
            l = l2;
        }
        if (l3 > (long)0 && l4 > (long)0 && l4 < l3) {
            IlsUtil.Trace(10, "IlsCmdAPI", "calcCheckoutDuration: adjusting durationHi " + l3 + " to balanceDuration " + l4 + " due to durationHi > 0 && balanceDuration > 0 && balanceDuration < durationHi");
            l3 = l4;
        }
        if (l3 > (long)0 && l > l3) {
            IlsUtil.Trace(10, "IlsCmdAPI", "calcCheckoutDuration: adjusting duration " + l + " to durationHi " + l3 + " due to durationHi > 0 && duration > durationHi");
            l = l3;
        }
        IlsUtil.Trace(10, "IlsCmdAPI", "calcCheckoutDuration: duration after duration lo/hi/balance adjustment=" + l);
        if (ilsLicense != null) {
            long l5 = 0L;
            Date date2 = ilsLicense.getKeyInfo().getExpirationDate();
            if (date2 != null && !this.hosted && (l5 = (date2.getTime() - date.getTime()) / (long)1000) >= (long)0 && l5 < l) {
                IlsUtil.Trace(10, "IlsCmdAPI", "calcCheckoutDuration: product time-limited-license adjustment: adjusting duration " + l + " to keyDurationCap " + l5 + " due to keyDurationCap < duration. Product key expiration date = " + date2);
                l = l5;
            }
            if (!this.hosted) {
                if (!domain.getLicenseParams().getTimeLimitType().equals("NONE") && domain.getLicenseParams().expDateIsDefined()) {
                    l5 = (domain.getLicenseParams().getExpDate().getTime() - date.getTime()) / (long)1000;
                    if (l5 >= (long)0 && l5 < l) {
                        IlsUtil.Trace(10, "IlsCmdAPI", "calcCheckoutDuration: domain time-limited-license adjustment: adjusting duration " + l + " to keyDurationCap " + l5 + " due to keyDurationCap < duration. Domain key expiration date = " + domain.getLicenseParams().getExpDate());
                        l = l5;
                    }
                } else if (domain.getLicenseParams().getTimeLimitType().equals("RELT") && (l5 = IlsUtil.GetRoundedSecondsFromDays(date.getTime(), domain.getLicenseParams().getExpDays())) >= (long)0 && l5 < l) {
                    IlsUtil.Trace(10, "IlsCmdAPI", "calcCheckoutDuration: domain relative-time-limited-license adjustment: adjusting duration " + l + " to keyDurationCap " + l5 + " due to keyDurationCap < duration. Domain key relative expiration days = " + domain.getLicenseParams().getExpDays());
                    l = l5;
                }
            }
            if (user != null) {
                if (!user.getLicenseParams().getTimeLimitType().equals("NONE") && user.getLicenseParams().expDateIsDefined()) {
                    l5 = (user.getLicenseParams().getExpDate().getTime() - date.getTime()) / (long)1000;
                    IlsUtil.Trace(11, "IlsCmdAPI", "calcCheckoutDuration: keyDurationCap based on curr exp date: " + l5);
                    if (l5 >= (long)0 && l5 < l) {
                        IlsUtil.Trace(10, "IlsCmdAPI", "calcCheckoutDuration: user time-limited-license adjustment: adjusting duration " + l + " to keyDurationCap " + l5 + " due to keyDurationCap < duration. User key expiration date = " + user.getLicenseParams().getExpDate());
                        l = l5;
                    }
                } else if (user.getLicenseParams().getTimeLimitType().equals("RELT")) {
                    l5 = IlsUtil.GetRoundedSecondsFromDays(date.getTime(), user.getLicenseParams().getExpDays());
                    IlsUtil.Trace(11, "IlsCmdAPI", "calcCheckoutDuration: keyDurationCap based on curr exp days: " + l5);
                    if (l5 >= (long)0 && l5 < l) {
                        IlsUtil.Trace(10, "IlsCmdAPI", "calcCheckoutDuration: user relative-time-limited-license adjustment: adjusting duration " + l + " to keyDurationCap " + l5 + " due to keyDurationCap < duration. User key relative expiration days = " + user.getLicenseParams().getExpDays());
                        l = l5;
                    }
                } else {
                    IlsUtil.Trace(11, "IlsCmdAPI", "calcCheckoutDuration: no key duration capping for user due to no exp date and time limit type = " + user.getLicenseParams().getTimeLimitType());
                }
            }
        }
        IlsUtil.Trace(10, "IlsCmdAPI", "calcCheckoutDuration: final duration after adjustment with product key = " + l);
        this.cmdArgs.setDuration(l);
        return l;
    }

    void doCustomCheckoutHandler(String string, String string2, String string3) throws WdoBaseException {
        IlsCustomCheckoutHandler ilsCustomCheckoutHandler = null;
        try {
            ilsCustomCheckoutHandler = (IlsCustomCheckoutHandler)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            this.cmdArgs.setStatusInfo(24, "Custom handler configuration error: unable to instantiate custom checkout handler '" + string + "'");
            WdoBaseException.ThrowProxyWdoException((int)12);
        }
        if (!ilsCustomCheckoutHandler.processCheckout(this.cmdArgs, string3, string2)) {
            WdoBaseException.ThrowProxyWdoException((int)12);
        }
    }

    static String GetIlsStringOption(String string, String string2) {
        if (string == null || string.equals("")) {
            return null;
        }
        String string3 = null;
        HashMap hashMap = null;
        try {
            hashMap = IlsUtil.MakeKeyMap(string, ";");
            string3 = (String)hashMap.get(string2);
        }
        catch (IlsException ilsException) {
            // empty catch block
        }
        return string3;
    }

    static long GetIlsLongOption(String string, String string2) {
        String string3 = IlsCmdAPI.GetIlsStringOption(string, string2);
        return string3 == null ? -1L : IlsUtil.GetPositiveLong(string3);
    }

    static String DecodePvtEncryptedString(String string, String string2) {
        String string3 = PkCrypt.makePublicKey((String)string2);
        return PkCrypt.decryptWithPublicKey((String)string, (String)string3);
    }

    static String GetIlsEncodedStringOption(String string, String string2, String string3) {
        String string4 = IlsCmdAPI.GetIlsStringOption(string, SYSOPTION_SYSOPT);
        if (string4 == null || string4.trim().equals("")) {
            return null;
        }
        return IlsCmdAPI.GetIlsStringOption(IlsCmdAPI.DecodePvtEncryptedString(string4, string3), string2);
    }

    static long GetIlsEncodedLongOption(String string, String string2, String string3) {
        String string4 = IlsCmdAPI.GetIlsStringOption(string, SYSOPTION_SYSOPT);
        if (string4 == null || string4.trim().equals("")) {
            return -1L;
        }
        return IlsCmdAPI.GetIlsLongOption(IlsCmdAPI.DecodePvtEncryptedString(string4, string3), string2);
    }

    static boolean CheckHosted(String string, IlsLicense ilsLicense) {
        if (ilsLicense == null || ilsLicense.getKeyInfo() == null) {
            return false;
        }
        String string2 = ilsLicense.getKeyInfo().getOptions();
        String string3 = ilsLicense.getKeyInfo().getAppPwd();
        if (string3 == null) {
            string3 = string;
        }
        return IlsCmdAPI.CheckHosted(string2, string3);
    }

    static boolean CheckPosthumousActivation(String string, IlsLicense ilsLicense) {
        if (ilsLicense == null || ilsLicense.getKeyInfo() == null) {
            return false;
        }
        String string2 = ilsLicense.getKeyInfo().getOptions();
        String string3 = ilsLicense.getKeyInfo().getAppPwd();
        if (string3 == null) {
            string3 = string;
        }
        return IlsCmdAPI.CheckPosthumousActivation(string2, string3);
    }

    static boolean CheckHosted(String string, String string2) {
        IlsUtil.Trace(7, "IlsCmdAPI", "CheckHosted: productOptions: '" + string + "', appPwd: '" + string2);
        if (string == null) {
            return false;
        }
        String string3 = IlsCmdAPI.GetIlsEncodedStringOption(string, SYSOPT_HOSTED, string2);
        boolean bl = string3 != null && (string3.equals(SYSOPTION_NORESTORE_INHIBIT1) || string3.equalsIgnoreCase("true") || string3.equalsIgnoreCase("t") || string3.equalsIgnoreCase("y") || string3.equalsIgnoreCase("yes"));
        IlsUtil.Trace(7, "IlsCmdAPI", "CheckHosted: found hosted = " + bl);
        return bl;
    }

    static boolean CheckPosthumousActivation(String string, String string2) {
        IlsUtil.Trace(7, "IlsCmdAPI", "CheckPosthumousActivation: productOptions: '" + string + "', appPwd: '" + string2);
        if (string == null) {
            return false;
        }
        String string3 = IlsCmdAPI.GetIlsEncodedStringOption(string, SYSOPT_POSTH_ACT, string2);
        boolean bl = string3 != null && (string3.equals(SYSOPTION_NORESTORE_INHIBIT1) || string3.equalsIgnoreCase("true") || string3.equalsIgnoreCase("t") || string3.equalsIgnoreCase("y") || string3.equalsIgnoreCase("yes"));
        IlsUtil.Trace(7, "IlsCmdAPI", "CheckPosthumousActivation: found posth-activation = " + bl);
        return bl;
    }

    void checkOptions(IlsLicense ilsLicense, Product product, Domain domain, User user) throws WdoBaseException {
        String string;
        String string2 = this.cmdArgs.getOptions();
        boolean bl = false;
        IlsUtil.Trace(10, "IlsCmdAPI", "checkOptions: inOptions:" + string2 + ":");
        this.cmdArgs.setOptions(null);
        if (user != null && ilsLicense.getKeyInfo().getCreatorUsername().equals(user.getName())) {
            IlsUtil.Trace(10, "IlsCmdAPI", "checkOptions: user is the key creator w/ unrestricted privileges ");
            bl = true;
        }
        if (!product.optionsIsDefined()) {
            if (string2 == null || string2.equals("")) {
                IlsUtil.Trace(10, "IlsCmdAPI", "checkOptions: product has no options defined and none requested - nothing to do");
                return;
            }
            this.cmdArgs.setStatusInfo(27, "Invalid options specification: no options available for selected product", null, AlerterJob.MakeEventParams(product.getName(), domain.getName(), user.getName()));
            WdoBaseException.ThrowProxyWdoException((int)12);
        }
        String string3 = user == null ? "*" : (user.getLicenseParams().optionsIsDefined() && !user.getLicenseParams().getOptions().equals("") ? user.getLicenseParams().getOptions() : "*");
        String string4 = domain.getLicenseParams().optionsIsDefined() && !domain.getLicenseParams().getOptions().equals("") ? domain.getLicenseParams().getOptions() : "*";
        String string5 = product.optionsIsDefined() && !product.getOptions().equals("") ? product.getOptions() : "*";
        String string6 = product == null ? null : product.getName();
        String string7 = string6 == null || domain == null ? null : domain.getName();
        String string8 = string = string7 == null || user == null ? null : user.getName();
        if (!IlsCmdAPI.verifyAndMakeOptionSubset(string6, string7, string, this.cmdArgs, string4, string5, bl, this.hosted)) {
            WdoBaseException.ThrowProxyWdoException((int)12);
        }
        if (!IlsCmdAPI.verifyAndMakeOptionSubset(string6, string7, string, this.cmdArgs, string3, this.cmdArgs.getOptions(), bl, this.hosted)) {
            WdoBaseException.ThrowProxyWdoException((int)12);
        }
        if (!IlsCmdAPI.verifyAndMakeOptionSubset(string6, string7, string, this.cmdArgs, string2, this.cmdArgs.getOptions(), bl, false, true)) {
            WdoBaseException.ThrowProxyWdoException((int)12);
        }
    }

    static boolean verifyAndMakeOptionSubset(String string, String string2, String string3, IlsCmdArgs ilsCmdArgs, String string4, String string5, boolean bl) {
        return IlsCmdAPI.verifyAndMakeOptionSubset(string, string2, string3, ilsCmdArgs, string4, string5, bl, false);
    }

    static boolean verifyAndMakeOptionSubset(String string, String string2, String string3, IlsCmdArgs ilsCmdArgs, String string4, String string5, boolean bl, boolean bl2) {
        return IlsCmdAPI.verifyAndMakeOptionSubset(string, string2, string3, ilsCmdArgs, string4, string5, bl, bl2, false);
    }

    static boolean verifyAndMakeOptionSubset(String string, String string2, String string3, IlsCmdArgs ilsCmdArgs, String string4, String string5, boolean bl, boolean bl2, boolean bl3) {
        if (string5 == null) {
            string5 = "";
        }
        if (string4 == null) {
            string4 = "";
        }
        HashMap hashMap = null;
        IlsUtil.Trace(10, "IlsCmdAPI", "verifyAndMakeOptionSubset: srcOptions:" + string5 + ", inOptions:" + string4 + ":");
        if (string4.equals(" ")) {
            ilsCmdArgs.setOptions(string4);
            return true;
        }
        try {
            hashMap = IlsUtil.MakeKeyMap(string5, ";");
        }
        catch (Throwable throwable) {
            ilsCmdArgs.setStatusInfo(25, "Configuration error: malformed options specification: '" + string5 + "'", null, AlerterJob.MakeEventParams(string, string2, string3));
            boolean bl4 = false;
            return bl4;
        }
        if (string4.equals("*")) {
            IlsUtil.Trace(10, "IlsCmdAPI", "verifyAndMakeOptionSubset: asking for all - using all srcOptions");
            if (!bl) {
                if (bl3) {
                    hashMap.remove(SYSOPTION_SOFTUSERLIMIT);
                }
                hashMap.remove(SYSOPTION_QUOTAGRACE);
                hashMap.remove(SYSOPTION_QUOTAWARNTHRESHOLD);
                hashMap.remove(SYSOPTION_EXPGRACE);
                hashMap.remove(SYSOPTION_EXPWARNTHRESHOLD);
                hashMap.remove(SYSOPTION_DURATIONFLOOR);
                hashMap.remove(SYSOPTION_DURATIONCEILING);
                hashMap.remove(SYSOPTION_CANCELCHECKOUT_PRIV);
                hashMap.remove(SYSOPTION_AUDIT);
                hashMap.remove(SYSOPTION_KEY_SHELF_LIFE);
                hashMap.remove(SYSOPTION_MACHINE_IP);
                hashMap.remove(SYSOPTION_MACHINE_MAC);
                hashMap.remove(SYSOPTION_MACHINE_FP);
                hashMap.remove(SYSOPTION_LOCK_DIR);
                hashMap.remove(SYSOPTION_NORESTORE);
                hashMap.remove(SYSOPTION_MANDATORY_PWD);
                hashMap.remove(SYSOPTION_SYSOPT);
            }
            string4 = string5;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string4, ";");
        String string6 = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string7 = stringTokenizer.nextToken();
            IlsUtil.Trace(10, "IlsCmdAPI", "verifyAndMakeOptionSubset: processing kwdval=" + string7 + ":");
            String string8 = null;
            String string9 = null;
            long l = 0L;
            long l2 = 0L;
            int n = 0;
            int n2 = -1;
            n2 = string7.indexOf("=");
            if (n2 > 0 && n2 > 1 && ">!<".indexOf(String.valueOf(string7.charAt(n2 - 1))) < 0 && n2 < string7.length() - 1 && "><".indexOf(String.valueOf(string7.charAt(n2 + 1))) < 0) {
                string8 = string7.substring(0, n2);
                string9 = string7.substring(n2 + 1);
                n = 1;
            }
            if (n == 0) {
                n2 = string7.indexOf(">=");
                if (n2 > 0 || (n2 = string7.indexOf("=>")) > 0) {
                    string8 = string7.substring(0, n2);
                    string9 = string7.substring(n2 + 2);
                    n = 5;
                } else {
                    n2 = string7.indexOf("<=");
                    if (n2 > 0 || (n2 = string7.indexOf("=<")) > 0) {
                        string8 = string7.substring(0, n2);
                        string9 = string7.substring(n2 + 2);
                        n = 2;
                    } else {
                        n2 = string7.indexOf("<>");
                        if (n2 > 0 || (n2 = string7.indexOf("!=")) > 0) {
                            string8 = string7.substring(0, n2);
                            string9 = string7.substring(n2 + 2);
                            n = 4;
                        } else {
                            n2 = string7.indexOf("==");
                            if (n2 > 0) {
                                string8 = string7.substring(0, n2);
                                string9 = string7.substring(n2 + 2);
                                n = 1;
                            } else {
                                n2 = string7.indexOf(">");
                                if (n2 > 0) {
                                    string8 = string7.substring(0, n2);
                                    string9 = string7.substring(n2 + 1);
                                    n = 6;
                                } else {
                                    n2 = string7.indexOf("<");
                                    if (n2 > 0) {
                                        string8 = string7.substring(0, n2);
                                        string9 = string7.substring(n2 + 1);
                                        n = 3;
                                    } else {
                                        n2 = string7.indexOf(" in ");
                                        if (n2 > 0) {
                                            string8 = string7.substring(0, n2);
                                            string9 = string7.substring(n2 + 4);
                                            n = 7;
                                        } else {
                                            n2 = string7.indexOf(" not in ");
                                            if (n2 > 0) {
                                                string8 = string7.substring(0, n2);
                                                string9 = string7.substring(n2 + 8);
                                                n = 8;
                                            } else {
                                                string8 = string7;
                                                string9 = null;
                                                n = 100;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            string8 = string8.trim();
            if (string9 != null) {
                string9 = string9.trim();
            }
            if (string8.startsWith(SYSOPTION_PREFIX) && !bl && (bl3 || !string8.equals(SYSOPTION_SOFTUSERLIMIT))) {
                IlsUtil.Trace(10, "IlsCmdAPI", "verifyAndMakeOptionSubset: tossing kwd " + string8 + " due to system kwd and not superuser");
                continue;
            }
            String string10 = (String)hashMap.get(string8);
            if (bl2 && n == 1) {
                string10 = string9;
                hashMap.put(string8, string9);
            } else if (string10 == null) {
                ilsCmdArgs.setStatusInfo(27, "Invalid options specification: option keyword '" + string8 + "' is not defined", null, AlerterJob.MakeEventParams(string, string2, string3));
                return false;
            }
            IlsUtil.Trace(10, "IlsCmdAPI", "verifyAndMakeOptionSubset: kwd=" + string8 + ",val=" + string9 + ",srcval=" + string10);
            switch (n) {
                case 2: 
                case 3: 
                case 5: 
                case 6: {
                    try {
                        l = Long.parseLong(string9);
                        l2 = Long.parseLong(string10);
                        break;
                    }
                    catch (Throwable throwable) {
                        ilsCmdArgs.setStatusInfo(23, "Invalid options syntax: " + ilsCmdArgs.getOptions(), null, AlerterJob.MakeEventParams(string, string2, string3));
                        boolean bl5 = false;
                        return bl5;
                    }
                }
            }
            switch (n) {
                case 7: {
                    if (string10.indexOf(string9) < 0) {
                        ilsCmdArgs.setStatusInfo(27, "Invalid options specification: option keyword '" + string8 + "' fails containment test", null, AlerterJob.MakeEventParams(string, string2, string3));
                        return false;
                    }
                    string6 = IlsCmdAPI._$26659(string6, string8, hashMap);
                    break;
                }
                case 8: {
                    if (string10.indexOf(string9) >= 0) {
                        ilsCmdArgs.setStatusInfo(27, "Invalid options specification: option keyword '" + string8 + "' fails negative containment test", null, AlerterJob.MakeEventParams(string, string2, string3));
                        return false;
                    }
                    string6 = IlsCmdAPI._$26659(string6, string8, hashMap);
                    break;
                }
                case 1: {
                    if (!string9.equalsIgnoreCase(string10)) {
                        ilsCmdArgs.setStatusInfo(27, "Invalid options specification: option keyword '" + string8 + "' does not match defined value", null, AlerterJob.MakeEventParams(string, string2, string3));
                        return false;
                    }
                    string6 = IlsCmdAPI._$26659(string6, string8, hashMap);
                    break;
                }
                case 4: {
                    if (string9.equalsIgnoreCase(string10)) {
                        ilsCmdArgs.setStatusInfo(27, "Invalid options specification: option keyword '" + string8 + "' fails inequality test", null, AlerterJob.MakeEventParams(string, string2, string3));
                        return false;
                    }
                    string6 = IlsCmdAPI._$26659(string6, string8, hashMap);
                    break;
                }
                case 3: {
                    if (l2 >= l) {
                        ilsCmdArgs.setStatusInfo(27, "Invalid options specification: option keyword '" + string8 + "' fails '<' test", null, AlerterJob.MakeEventParams(string, string2, string3));
                        return false;
                    }
                    string6 = IlsCmdAPI._$26659(string6, string8, hashMap);
                    break;
                }
                case 2: {
                    if (l2 > l) {
                        ilsCmdArgs.setStatusInfo(27, "Invalid options specification: option keyword '" + string8 + "' fails '<=' test", null, AlerterJob.MakeEventParams(string, string2, string3));
                        return false;
                    }
                    string6 = IlsCmdAPI._$26659(string6, string8, hashMap);
                    break;
                }
                case 5: {
                    if (l2 < l) {
                        ilsCmdArgs.setStatusInfo(27, "Invalid options specification: option keyword '" + string8 + "' fails '>=' test", null, AlerterJob.MakeEventParams(string, string2, string3));
                        return false;
                    }
                    string6 = IlsCmdAPI._$26659(string6, string8, hashMap);
                    break;
                }
                case 6: {
                    if (l2 <= l) {
                        ilsCmdArgs.setStatusInfo(27, "Invalid options specification: option keyword '" + string8 + "' fails '>' test", null, AlerterJob.MakeEventParams(string, string2, string3));
                        return false;
                    }
                    string6 = IlsCmdAPI._$26659(string6, string8, hashMap);
                    break;
                }
                case 100: {
                    string6 = IlsCmdAPI._$26659(string6, string8, hashMap);
                }
            }
        }
        IlsUtil.Trace(10, "IlsCmdAPI", "verifyAndMakeOptionSubset: setting cmd arg options to: " + string6);
        ilsCmdArgs.setOptions(string6);
        return true;
    }

    private static String _$26659(String string, String string2, HashMap hashMap) {
        string = string == null ? "" : String.valueOf(string) + ";";
        string = String.valueOf(string) + string2 + "=" + (String)hashMap.get(string2);
        return string;
    }

    static int getCancelAuthLevel(String string) {
        int n = 4;
        String string2 = IlsCmdAPI.GetIlsStringOption(string, SYSOPTION_CANCELCHECKOUT_PRIV);
        if (string2 != null) {
            if (string2.equals("NONE")) {
                n = 5;
            } else if (string2.equals(SYSOPTION_CANCELCHECKOUT_PRIV_PROD)) {
                n = 3;
            } else if (string2.equals(SYSOPTION_CANCELCHECKOUT_PRIV_DOM)) {
                n = 2;
            } else if (string2.equals(SYSOPTION_CANCELCHECKOUT_PRIV_SYS)) {
                n = 4;
            }
        }
        return n;
    }

    static boolean CheckUserCheckedOut(Date date, User user) throws WdoBaseException {
        CheckoutInfo checkoutInfo = user.getCheckoutInfo();
        if (checkoutInfo.getCheckedOut() && date.getTime() <= checkoutInfo.getLastChkOutTs() + user.getCheckoutDurationSec() * 1000L) {
            IlsUtil.Trace(10, "IlsCmdAPI", "CheckUserCheckedOut: true.  Username: " + user.getName() + ", nowTs: " + date.getTime() + ", checkoutTs: " + checkoutInfo.getLastChkOutTs() + ", last checkout duration: " + user.getCheckoutDurationSec());
            return true;
        }
        return false;
    }

    static boolean CheckUserCheckedOutAndDead(Date date, User user) throws WdoBaseException {
        CheckoutInfo checkoutInfo = user.getCheckoutInfo();
        if (checkoutInfo.getCheckedOut() && date.getTime() > checkoutInfo.getLastChkOutTs() + user.getCheckoutDurationSec() * 1000L) {
            IlsUtil.Trace(10, "IlsCmdAPI", "CheckUserCheckedOutAndDead: true.  Username: " + user.getName() + ", nowTs: " + date.getTime() + ", checkoutTs: " + checkoutInfo.getLastChkOutTs() + ", last checkout duration: " + user.getCheckoutDurationSec());
            return true;
        }
        return false;
    }
}

