/*
 * Decompiled with CFR 0.152.
 */
package com.vs.ils;

import com.vs.ils.IlsAdminAPI;
import com.vs.ils.IlsCmdArgs;
import com.vs.ils.IlsException;
import com.vs.ils.IlsUtil;
import com.vs.ils.ilsdb.LicenseParamInfo;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IlsAdminDataManager {
    static /* synthetic */ Class class$com$vs$ils$IlsAdminDataManager$AllStats;
    static /* synthetic */ Class class$org$w3c$dom$Element;
    static /* synthetic */ Class class$com$vs$ils$IlsAdminAPI;

    static /* synthetic */ Class class$(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static AllStats MakeStats() {
        AllStats allStats = new AllStats();
        return allStats;
    }

    public static boolean DropHostAccessControlData(String string, String string2, String string3, IlsCmdArgs ilsCmdArgs) {
        ilsCmdArgs.setRequest("admincmd=dropHostAccessControl&name=" + string3);
        IlsAdminAPI ilsAdminAPI = new IlsAdminAPI(string, string2, ilsCmdArgs);
        return ilsAdminAPI.dropHostAccessControl(string3);
    }

    public static boolean DropProductData(String string, String string2, String string3, IlsCmdArgs ilsCmdArgs) {
        ilsCmdArgs.setRequest("admincmd=dropProduct&name=" + string3);
        IlsAdminAPI ilsAdminAPI = new IlsAdminAPI(string, string2, ilsCmdArgs);
        return ilsAdminAPI.dropProduct(string3);
    }

    public static boolean DropDomainData(String string, String string2, String string3, String string4, IlsCmdArgs ilsCmdArgs) {
        ilsCmdArgs.setRequest("admincmd=dropDomain&product=" + string3 + "&name=" + string4);
        IlsAdminAPI ilsAdminAPI = new IlsAdminAPI(string, string2, ilsCmdArgs);
        return ilsAdminAPI.dropDomain(string3, string4);
    }

    public static boolean DropIUserData(String string, String string2, String string3, String string4, String string5, IlsCmdArgs ilsCmdArgs) {
        ilsCmdArgs.setRequest("admincmd=dropUser&product=" + string3 + "&domain=" + string4 + "&name=" + string5);
        IlsAdminAPI ilsAdminAPI = new IlsAdminAPI(string, string2, ilsCmdArgs);
        return ilsAdminAPI.dropIUser(string3, string4, string5);
    }

    public static boolean DropObject(String string, String string2, String string3, long l, IlsCmdArgs ilsCmdArgs) {
        ilsCmdArgs.setRequest("admincmd=dropObject&objId=" + l);
        IlsAdminAPI ilsAdminAPI = new IlsAdminAPI(string, string2, ilsCmdArgs);
        return ilsAdminAPI.dropObject(string3, l);
    }

    public static Object GetObject(String string, String string2, String string3, long l, IlsCmdArgs ilsCmdArgs) {
        ilsCmdArgs.setRequest("admincmd=getObject&objId=" + l);
        IlsAdminAPI ilsAdminAPI = new IlsAdminAPI(string, string2, ilsCmdArgs);
        return ilsAdminAPI.getObject(string3, l);
    }

    public static String GetXmlData(String string, String string2, int n, IlsCmdArgs ilsCmdArgs) {
        IlsAdminAPI ilsAdminAPI = new IlsAdminAPI(string, string2, ilsCmdArgs);
        return ilsAdminAPI.getXmlData(n);
    }

    public static Vector GetVectorData(String string, String string2, String string3, IlsCmdArgs ilsCmdArgs) {
        IlsAdminAPI ilsAdminAPI = new IlsAdminAPI(string, string2, ilsCmdArgs);
        return ilsAdminAPI.getEntityVectorData(string3);
    }

    public static boolean LoadXmlData(String string, String string2, InputStream inputStream, AllStats allStats, IlsCmdArgs ilsCmdArgs) {
        boolean bl = true;
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = documentBuilder.parse(inputStream);
            Element element = document.getDocumentElement();
            if (string == null || string.equals("")) {
                string = element.getAttribute("service");
            }
            if (string == null || string.equals("")) {
                string = "default";
            }
            IlsAdminAPI ilsAdminAPI = new IlsAdminAPI(string, string2, ilsCmdArgs);
            bl = IlsAdminDataManager.ProcessElement(ilsAdminAPI, element, allStats);
            if (ilsCmdArgs != ilsAdminAPI.getCmdArgs()) {
                ilsCmdArgs.setStatus(ilsAdminAPI.getCmdArgs().getStatus());
                if (ilsAdminAPI.getCmdArgs().getMsg() != null) {
                    ilsCmdArgs.setMsg(ilsAdminAPI.getCmdArgs().getMsg());
                }
                if (ilsAdminAPI.getCmdArgs().getValue() != null) {
                    ilsCmdArgs.setValue(ilsAdminAPI.getCmdArgs().getValue());
                }
            }
            IlsUtil.Trace(1, "IlsAdminDataManager", "LoadXmlData: return from ProcessElement.  ret=" + bl + ", cmd args status = " + ilsCmdArgs.getStatus());
        }
        catch (Throwable throwable) {
            IlsUtil.Trace(false, 1, "IlsAdminDataManager", new String[]{"LoadXmlData: exception name: " + throwable.getClass().getName() + ", message: " + throwable.getMessage()}, true);
            boolean bl2 = throwable instanceof IllegalAccessException || throwable instanceof InstantiationException || throwable instanceof NoSuchMethodException || throwable instanceof ClassNotFoundException;
            ilsCmdArgs.setStatusInfo(bl2 ? 1000 : 100, String.valueOf(bl2 ? "Internal Error.  Details:" : "Malformed document.  Details:") + "\nException class: " + throwable.getClass().getName() + "\nMessage: " + throwable.getMessage());
            bl = false;
        }
        return bl;
    }

    public static boolean ProcessElement(IlsAdminAPI ilsAdminAPI, Element element, AllStats allStats) throws Throwable {
        Object object;
        Object object2;
        IlsUtil.Trace(5, "IlsAdminDataManager", "ProcessElement: enter.  cmdargs status=" + ilsAdminAPI.getCmdArgs().getStatus());
        boolean bl = false;
        ilsAdminAPI.getCmdArgs().init();
        String string = element.getTagName();
        String string2 = "com.vs.ils." + IlsUtil.ToUpperStart(string) + "NodeProcessor";
        IlsUtil.Trace(5, "IlsAdminDataManager", "ProcessElement: processing command class " + string2);
        try {
            object2 = Class.forName(string2);
            Object obj = ((Class)object2).newInstance();
            object = ((Class)object2).getMethod("processNode", class$com$vs$ils$IlsAdminAPI == null ? (class$com$vs$ils$IlsAdminAPI = IlsAdminDataManager.class$("com.vs.ils.IlsAdminAPI")) : class$com$vs$ils$IlsAdminAPI, class$org$w3c$dom$Element == null ? (class$org$w3c$dom$Element = IlsAdminDataManager.class$("org.w3c.dom.Element")) : class$org$w3c$dom$Element, class$com$vs$ils$IlsAdminDataManager$AllStats == null ? (class$com$vs$ils$IlsAdminDataManager$AllStats = IlsAdminDataManager.class$("com.vs.ils.IlsAdminDataManager$AllStats")) : class$com$vs$ils$IlsAdminDataManager$AllStats);
            Object[] objectArray = new Object[]{ilsAdminAPI, element, allStats};
            Object object3 = ((Method)object).invoke(obj, objectArray);
            if (!(object3 instanceof Boolean)) {
                IlsException.ThrowException(1000, "Unexpected return type '" + object3.getClass().getName() + "' from metadata processor for node '" + string + "'");
            }
            bl = (Boolean)object3;
            IlsUtil.Trace(5, "IlsAdminDataManager", "ProcessElement for class '" + string2 + "': got boolean return value: " + bl + ", cmdargs status: " + ilsAdminAPI.getCmdArgs().getStatus());
        }
        catch (Exception exception) {
            Throwable throwable = null;
            throwable = exception instanceof InvocationTargetException ? ((InvocationTargetException)exception).getTargetException() : exception;
            throw throwable;
        }
        if (bl) {
            object2 = element.getChildNodes();
            IlsUtil.Trace(5, "IlsAdminDataManager", "ProcessElement: processing " + object2.getLength() + " children for command class " + string2);
            int n = 0;
            while (n < object2.getLength() && bl) {
                object = object2.item(n);
                if (object instanceof Element) {
                    bl = IlsAdminDataManager.ProcessElement(ilsAdminAPI, (Element)object, allStats);
                }
                ++n;
            }
        }
        IlsUtil.Trace(5, "IlsAdminDataManager", "returning from ProcessElement for class '" + string2 + "', boolean return value: " + bl + ", cmdargs status: " + ilsAdminAPI.getCmdArgs().getStatus());
        return bl;
    }

    static LicenseParamInfo getLicenseParams(IlsAdminAPI ilsAdminAPI, Element element, Stats stats) {
        LicenseParamInfo licenseParamInfo = new LicenseParamInfo();
        try {
            Object object;
            boolean bl;
            Comparable<Long> comparable;
            if (IlsAdminDataManager.getAttribute(element, "quota") != null) {
                Long l;
                licenseParamInfo.setQuotaLimited(true);
                comparable = IlsAdminDataManager.getLongAttribute(ilsAdminAPI, element, "quota", stats);
                if (comparable == null) {
                    LicenseParamInfo licenseParamInfo2 = null;
                    return licenseParamInfo2;
                }
                licenseParamInfo.setQuota(((Long)comparable).longValue());
                if (IlsAdminDataManager.getAttribute(element, "quota-grace") != null) {
                    l = IlsAdminDataManager.getLongAttribute(ilsAdminAPI, element, "quota-grace", stats);
                    if (l == null) {
                        LicenseParamInfo licenseParamInfo3 = null;
                        return licenseParamInfo3;
                    }
                    licenseParamInfo.setQuotaGrace(l.longValue());
                }
                if (IlsAdminDataManager.getAttribute(element, "quota-warn-threshold") != null) {
                    l = IlsAdminDataManager.getLongAttribute(ilsAdminAPI, element, "quota-warn-threshold", stats);
                    if (l == null) {
                        LicenseParamInfo licenseParamInfo4 = null;
                        return licenseParamInfo4;
                    }
                    licenseParamInfo.setQuotaWarningThreshold(l.longValue());
                }
            }
            comparable = null;
            boolean bl2 = IlsAdminDataManager.getAttribute(element, "exp-date") != null;
            boolean bl3 = bl = IlsAdminDataManager.getAttribute(element, "exp-days") != null;
            if (bl2 && bl) {
                ilsAdminAPI.getCmdArgs().setStatusInfo(100, "Time limited license can't be both absolute and relative.  Tag: " + element.getTagName());
                LicenseParamInfo licenseParamInfo5 = null;
                return licenseParamInfo5;
            }
            licenseParamInfo.setTimeLimitType(bl2 ? "ABST" : (bl ? "RELT" : "NONE"));
            if (bl2) {
                comparable = IlsAdminDataManager.getDateAttribute(ilsAdminAPI, element, "exp-date", "yyyy-MM-dd", stats);
                if (comparable == null) {
                    LicenseParamInfo licenseParamInfo6 = null;
                    return licenseParamInfo6;
                }
                licenseParamInfo.setExpDate(new Timestamp(((Date)comparable).getTime()));
            } else if (bl) {
                object = IlsAdminDataManager.getLongAttribute(ilsAdminAPI, element, "exp-days", stats);
                if (object == null) {
                    LicenseParamInfo licenseParamInfo7 = null;
                    return licenseParamInfo7;
                }
                IlsUtil.Trace(5, "IlsAdminDataManager", "getLicenseParams: got expdays=" + String.valueOf(((Long)object).intValue()));
                licenseParamInfo.setExpDays((long)((Long)object).intValue());
            }
            if ((bl2 || bl) && IlsAdminDataManager.getAttribute(element, "exp-grace") != null) {
                object = IlsAdminDataManager.getLongAttribute(ilsAdminAPI, element, "exp-grace", stats);
                if (object == null) {
                    LicenseParamInfo licenseParamInfo8 = null;
                    return licenseParamInfo8;
                }
                licenseParamInfo.setExpGrace(((Long)object).intValue());
                Long l = IlsAdminDataManager.getLongAttribute(ilsAdminAPI, element, "exp-warn-threshold", stats);
                if (l == null) {
                    LicenseParamInfo licenseParamInfo9 = null;
                    return licenseParamInfo9;
                }
                licenseParamInfo.setExpWarningThreshold(l.intValue());
            }
            if ((object = IlsAdminDataManager.getOptionalStringAttribute(ilsAdminAPI, element, "options", stats)) != null) {
                licenseParamInfo.setOptions((String)object);
            }
        }
        catch (Throwable throwable) {
            ilsAdminAPI.getCmdArgs().setStatusInfo(1000, "Unexpected exception.  Exception class: " + throwable.getClass().getName() + ",\nMessage: " + throwable.getMessage());
            LicenseParamInfo licenseParamInfo10 = null;
            return licenseParamInfo10;
        }
        return licenseParamInfo;
    }

    static String getAttribute(Element element, String string) {
        String string2 = element.getAttribute(string);
        IlsUtil.Trace(10, "IlsAdminDataManager", "getAttribute: attr '" + string + "'=" + string2);
        if (string2 != null) {
            string2 = string2.trim();
        }
        if (string2 != null && string2.equals("")) {
            string2 = null;
        }
        return string2;
    }

    static String getOptionalStringAttribute(IlsAdminAPI ilsAdminAPI, Element element, String string, Stats stats) {
        if (IlsAdminDataManager.getAttribute(element, string) == null) {
            return null;
        }
        return IlsAdminDataManager.getStringAttribute(ilsAdminAPI, element, string, stats);
    }

    static String getStringAttribute(IlsAdminAPI ilsAdminAPI, Element element, String string, Stats stats) {
        String string2 = IlsAdminDataManager.getAttribute(element, string);
        if (stats != null && (string2 == null || string2.equals(""))) {
            ilsAdminAPI.getCmdArgs().setStatusInfo(100, "Missing or empty attribute '" + string + "' for tag '" + element.getTagName() + "'");
            ++stats.rejected;
            return null;
        }
        return string2;
    }

    static String getOptionalStringEnumAttribute(IlsAdminAPI ilsAdminAPI, Element element, String string, String[] stringArray, Stats stats) {
        if (IlsAdminDataManager.getAttribute(element, string) == null) {
            return null;
        }
        return IlsAdminDataManager.getStringEnumAttribute(ilsAdminAPI, element, string, stringArray, stats);
    }

    static String getStringEnumAttribute(IlsAdminAPI ilsAdminAPI, Element element, String string, String[] stringArray, Stats stats) {
        String string2 = IlsAdminDataManager.getAttribute(element, string);
        if (stats != null && (string2 == null || string2.equals(""))) {
            ilsAdminAPI.getCmdArgs().setStatusInfo(100, "Missing or empty attribute '" + string + "' for tag '" + element.getTagName() + "'");
            ++stats.rejected;
            return null;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (string2.equals(stringArray[n])) {
                return string2;
            }
            ++n;
        }
        ilsAdminAPI.getCmdArgs().setStatusInfo(100, "Invalid enumeration value '" + string2 + "' of attribute '" + string + "' for tag '" + element.getTagName() + "'");
        ++stats.rejected;
        return string2;
    }

    static Date getOptionalDateAttribute(IlsAdminAPI ilsAdminAPI, Element element, String string, String string2, Stats stats) {
        if (IlsAdminDataManager.getAttribute(element, string) == null) {
            return null;
        }
        return IlsAdminDataManager.getDateAttribute(ilsAdminAPI, element, string, string2, stats);
    }

    static Date getDateAttribute(IlsAdminAPI ilsAdminAPI, Element element, String string, String string2, Stats stats) {
        String string3 = IlsAdminDataManager.getAttribute(element, string);
        if (stats != null && (string3 == null || string3.equals(""))) {
            ilsAdminAPI.getCmdArgs().setStatusInfo(100, "Missing or empty attribute '" + string + "' for tag '" + element.getTagName() + "'");
            ++stats.rejected;
            return null;
        }
        Date date = null;
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
            if (simpleDateFormat == null) {
                throw new Exception("bzzt");
            }
            date = simpleDateFormat.parse(string3);
        }
        catch (Exception exception) {
            ilsAdminAPI.getCmdArgs().setStatusInfo(100, "Invalid date format value '" + string3 + "' of attribute '" + string + "' for tag '" + element.getTagName() + "'");
            ++stats.rejected;
        }
        return date;
    }

    static Boolean getOptionalBooleanAttribute(IlsAdminAPI ilsAdminAPI, Element element, String string, Stats stats) {
        if (IlsAdminDataManager.getAttribute(element, string) == null) {
            return null;
        }
        return IlsAdminDataManager.getBooleanAttribute(ilsAdminAPI, element, string, stats);
    }

    static Boolean getBooleanAttribute(IlsAdminAPI ilsAdminAPI, Element element, String string, Stats stats) {
        String string2 = IlsAdminDataManager.getAttribute(element, string);
        if (stats != null && (string2 == null || !string2.equals("0") && !string2.equals("1"))) {
            ilsAdminAPI.getCmdArgs().setStatusInfo(100, "Missing or invalid attribute '" + string + "' for tag '" + element.getTagName() + "'");
            ++stats.rejected;
            return null;
        }
        return new Boolean(string2.equals("1") ? "true" : "false");
    }

    static Long getOptionalLongAttribute(IlsAdminAPI ilsAdminAPI, Element element, String string, Stats stats) {
        if (IlsAdminDataManager.getAttribute(element, string) == null) {
            return null;
        }
        return IlsAdminDataManager.getLongAttribute(ilsAdminAPI, element, string, stats);
    }

    static Long getLongAttribute(IlsAdminAPI ilsAdminAPI, Element element, String string, Stats stats) {
        String string2 = IlsAdminDataManager.getAttribute(element, string);
        IlsUtil.Trace(11, "IlsAdminDataManager", "getLongAttribute: attr '" + string + "'=" + string2);
        if (stats != null && (string2 == null || string2.equals(""))) {
            ilsAdminAPI.getCmdArgs().setStatusInfo(100, "Missing or empty attribute '" + string + "' for tag '" + element.getTagName() + "'");
            ++stats.rejected;
            return null;
        }
        Long l = null;
        try {
            long l2 = Long.parseLong(string2);
            l = new Long(l2);
        }
        catch (Exception exception) {
            ilsAdminAPI.getCmdArgs().setStatusInfo(100, "Invalid integer value '" + string2 + "' of attribute '" + string + "' for tag '" + element.getTagName() + "'");
            ++stats.rejected;
        }
        return l;
    }

    static String getTextNode(Element element, boolean bl) throws Exception {
        String string = null;
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node.getNodeType() == 3) {
                if (string == null) {
                    string = "";
                } else if (bl) {
                    string = String.valueOf(string) + "\n";
                }
                string = String.valueOf(string) + node.getNodeValue();
            }
            ++n;
        }
        return string;
    }

    public static class AllStats {
        public Stats hostStats = new Stats();
        public Stats productStats = new Stats();
        public Stats domainStats = new Stats();
        public Stats userStats = new Stats();
    }

    public static class Stats {
        public int processed;
        public int added;
        public int updated;
        public int dup;
        public int rejected;

        public boolean updateStats(IlsAdminAPI ilsAdminAPI) {
            IlsUtil.Trace(5, "IlsAdminDataManager", "updateStats: stat code is " + ilsAdminAPI.getCmdArgs().getStatus());
            switch (ilsAdminAPI.getCmdArgs().getStatus()) {
                case -102: {
                    ++this.dup;
                    break;
                }
                case -100: {
                    ++this.updated;
                    break;
                }
                case 0: {
                    ++this.added;
                    break;
                }
                default: {
                    if (ilsAdminAPI.getCmdArgs().getStatus() <= 0) break;
                    ++this.rejected;
                    return false;
                }
            }
            return true;
        }
    }
}

