/*
 * Decompiled with CFR 0.152.
 */
package com.vs.ils;

import com.vs.ils.AddAuditTrailLuw;
import com.vs.ils.AddDomainLuw;
import com.vs.ils.AddHostAccessControlLuw;
import com.vs.ils.AddProductLuw;
import com.vs.ils.AddUserLuw;
import com.vs.ils.AlerterJob;
import com.vs.ils.BackupJob;
import com.vs.ils.CopyAuditEntriesLuw;
import com.vs.ils.CopyDomainsLuw;
import com.vs.ils.CopyHostAccessRulesLuw;
import com.vs.ils.CopyProductsLuw;
import com.vs.ils.CopyUsersLuw;
import com.vs.ils.DropAuditTrailLuw;
import com.vs.ils.DropDomainLuw;
import com.vs.ils.DropHostAccessControlLuw;
import com.vs.ils.DropObjectLuw;
import com.vs.ils.DropProductLuw;
import com.vs.ils.DropUserLuw;
import com.vs.ils.DropUserXLuw;
import com.vs.ils.ExecMethodLuw;
import com.vs.ils.GetObjectLuw;
import com.vs.ils.IlsCmdAPI;
import com.vs.ils.IlsCmdArgs;
import com.vs.ils.IlsException;
import com.vs.ils.IlsJob;
import com.vs.ils.IlsLicense;
import com.vs.ils.IlsToken;
import com.vs.ils.IlsUtil;
import com.vs.ils.ListDataLuw;
import com.vs.ils.ListEntityDataLuw;
import com.vs.ils.PropagateLimitsToDomainsLuw;
import com.vs.ils.PropagateLimitsToUsersLuw;
import com.vs.ils.admin.IlsAdminPublicAPI;
import com.vs.ils.ilsdb.AuditTrail;
import com.vs.ils.ilsdb.CheckoutInfo;
import com.vs.ils.ilsdb.Domain;
import com.vs.ils.ilsdb.HostAccessControl;
import com.vs.ils.ilsdb.LicenseParamInfo;
import com.vs.ils.ilsdb.Product;
import com.vs.ils.ilsdb.User;
import com.vs.wdo.rtl.WdoBaseException;
import com.vs.wdo.rtl.WdoTransaction;
import com.vs.wdo.rtl.WdoUnitOfWork;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;

public class IlsAdminAPI {
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$HashMap;
    public static final int ILS_ADMIN_LICENSE_PROPAGATE_NONE = 0;
    public static final int ILS_ADMIN_LICENSE_PROPAGATE_DOMAIN = 1;
    public static final int ILS_ADMIN_LICENSE_PROPAGATE_USER = 2;
    public static final String ILS_ADMIN_ENTITY_HOSTACCESS = "HostAccessControl";
    public static final String ILS_ADMIN_ENTITY_PRODUCT = "Product";
    public static final String ILS_ADMIN_ENTITY_DOMAIN = "Domain";
    public static final String ILS_ADMIN_ENTITY_USER = "User";
    static final int ILS_ADMIN_ACTION_QUERY = 1;
    static final int ILS_ADMIN_ACTION_INSERT = 2;
    static final int ILS_ADMIN_ACTION_UPDATE = 3;
    static final int ILS_ADMIN_ACTION_DELETE = 4;
    static final int ILS_TLTYPE_NONE = 1;
    static final int ILS_TLTYPE_ABST = 2;
    static final int ILS_TLTYPE_RELT_INERT = 3;
    static final int ILS_TLTYPE_RELT_ACTIVE = 4;
    static final int ILS_ADMIN_LICENSE_PROPAGATE_PAGESIZE = 500;
    private IlsCmdArgs _$2794;
    protected String serviceName = "default";
    String tokenString;
    IlsToken token;
    int entityCode;
    int actionCode;
    String entityName;
    Object[] dispatchArgs;
    long itemsProcessed;
    boolean doAudit = true;

    static /* synthetic */ Class class$(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public IlsAdminAPI(String string, String string2) {
        if (string != null && !string.trim().equals("")) {
            this.serviceName = string.trim();
        }
        this._$2794 = new IlsCmdArgs();
        this._$2794.setServiceName(string);
        this.tokenString = string2;
    }

    public IlsAdminAPI(String string, String string2, IlsCmdArgs ilsCmdArgs) {
        if (string != null && !string.trim().equals("")) {
            this.serviceName = string.trim();
        }
        this._$2794 = ilsCmdArgs;
        this.tokenString = string2;
    }

    public static IlsAdminAPI MakeAdminCmd(String string) throws IlsException {
        if (!string.startsWith("system=ILS")) {
            IlsException.ThrowException(23, "Invalid protocol");
        }
        string = string.substring(string.indexOf("&") + 1);
        String string2 = null;
        String string3 = null;
        int n = 0;
        IlsAdminAPI ilsAdminAPI = null;
        IlsCmdArgs ilsCmdArgs = new IlsCmdArgs(string);
        HashMap hashMap = null;
        try {
            hashMap = IlsUtil.MakeKeyMap(string, "&");
            ilsCmdArgs.setCmdInfo(hashMap);
            string3 = (String)hashMap.get("service");
            ilsCmdArgs.setServiceName(string3);
            string2 = (String)hashMap.get("protocol_vsn");
            ilsAdminAPI = new IlsAdminAPI(string3, null, ilsCmdArgs);
            try {
                n = Integer.parseInt(string2);
            }
            catch (Throwable throwable) {
                IlsException.ThrowException(23, "Malformed protocol version: [" + string2 + "]");
            }
            if (n > 4) {
                IlsException.ThrowException(23, "Incompatible protocol version: [" + string2 + "]");
            }
            if ((string2 = (String)hashMap.get("admincmd")) == null) {
                IlsException.ThrowException(23, "no command found in input string");
            }
            ilsCmdArgs.setCmd(string2);
            if (string2.startsWith("get")) {
                string2 = string2.substring(3);
                ilsAdminAPI.actionCode = 1;
            } else if (string2.startsWith("add")) {
                string2 = string2.substring(3);
                ilsAdminAPI.actionCode = 2;
            } else if (string2.startsWith("update")) {
                string2 = string2.substring(6);
                ilsAdminAPI.actionCode = 3;
            } else if (string2.startsWith("drop")) {
                string2 = string2.substring(4);
                ilsAdminAPI.actionCode = 4;
            } else {
                IlsException.ThrowException(23, "unrecognized admin command: " + string2);
            }
            if (!(string2.equals(ILS_ADMIN_ENTITY_HOSTACCESS) || string2.equals(ILS_ADMIN_ENTITY_PRODUCT) || string2.equals(ILS_ADMIN_ENTITY_DOMAIN))) {
                IlsException.ThrowException(23, "unrecognized admin command: " + string2);
            }
            ilsAdminAPI.entityName = string2;
            if (ilsAdminAPI.actionCode != 1) {
                Object[] objectArray;
                String string4 = "make" + (ilsAdminAPI.actionCode == 4 ? "Drop" : "Add") + string2 + "DispatchArgs";
                Method method = ilsAdminAPI.getClass().getMethod(string4, class$java$util$HashMap == null ? (class$java$util$HashMap = IlsAdminAPI.class$("java.util.HashMap")) : class$java$util$HashMap);
                Object object = method.invoke((Object)ilsAdminAPI, objectArray = new Object[]{hashMap});
                boolean bl = (Boolean)object;
                if (!bl) {
                    IlsAdminAPI ilsAdminAPI2 = null;
                    return ilsAdminAPI2;
                }
            }
        }
        catch (IlsException ilsException) {
            throw ilsException;
        }
        catch (Throwable throwable) {
            IlsException.ThrowException(1000, "Could not instantiate Admin API for command [" + string2 + "]" + "\nException: " + throwable.getClass().getName() + "\nMessage: " + throwable.getMessage());
        }
        if (string3 != null && !string3.trim().equals("")) {
            ilsAdminAPI.serviceName = string3.trim();
        }
        return ilsAdminAPI;
    }

    public IlsCmdArgs getCmdArgs() {
        return this._$2794;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public long getItemsProcessed() {
        return this.itemsProcessed;
    }

    public boolean dispatchAdminCmd() {
        if (this.actionCode == 1) {
            this._$2794.setMsg(this.getEntityXmlData(this.entityName, 3));
            return this._$2794.getMsg() != null && this._$2794.getStatus() <= 0;
        }
        String string = this.actionCode == 4 ? "drop" : "add";
        string = IlsUtil.ToUpperStart(string);
        WdoUnitOfWork wdoUnitOfWork = null;
        try {
            Class<?> clazz = Class.forName("com.vs.ils." + string + this.entityName + "Luw");
            wdoUnitOfWork = (WdoUnitOfWork)clazz.newInstance();
        }
        catch (Throwable throwable) {
            this._$2794.setStatusInfo(1000, "Internal error.  Please have your administrator contact Agilis with the following information: Could not instantiate admin Luw.\nException: " + throwable.getClass().getName() + "\nMessage: " + throwable.getMessage());
            boolean bl = false;
            return bl;
        }
        return this.processLuwCmd(wdoUnitOfWork, this.dispatchArgs, true);
    }

    void parseToken(int n) throws WdoBaseException {
        this.token = null;
        User user = null;
        if (this.tokenString == null) {
            this._$2794.setStatusInfo(18, "Unauthorized access for internal administrative function.");
            WdoBaseException.ThrowProxyWdoException((int)12);
        }
        try {
            this.token = IlsToken.ParseToken(this.tokenString, this.serviceName);
        }
        catch (IlsException ilsException) {
            this._$2794.setStatusInfo(ilsException.getCode(), ilsException.getMessage());
            WdoBaseException.ThrowProxyWdoException((int)12);
        }
        IlsUtil.Trace(11, "IlsAdminAPI", "ParseToken: parsed token.  Setting cmdargs from token.");
        IlsUtil.Trace(11, "IlsAdminAPI", "ParseToken: Setting machine from token.");
        this._$2794.setMachine(this.token.getClientMachine());
        IlsUtil.Trace(11, "IlsAdminAPI", "ParseToken: Setting session id from token.");
        this._$2794.setSessionId(this.token.getSessionId());
        if (this.token.getAuthLevel() == 5) {
            IlsUtil.Trace(11, "IlsAdminAPI", "ParseToken: Setting system product/domain/user.");
            this._$2794.setProduct("system");
            this._$2794.setDomain("system");
            this._$2794.setUser("system");
        } else {
            IlsUtil.Trace(11, "IlsAdminAPI", "ParseToken: Setting product from token+cache.");
            long l = this.token.getProductId();
            IlsUtil.Trace(11, "IlsAdminAPI", "ParseToken: token product id is: " + l);
            Product product = Product.GetProduct((long)l);
            IlsUtil.Trace(11, "IlsAdminAPI", "ParseToken: got product and it is " + (product == null ? "" : "not") + " null.");
            String string = product.getName();
            IlsUtil.Trace(11, "IlsAdminAPI", "ParseToken: product name is: " + string);
            this._$2794.setProduct(string);
            IlsUtil.Trace(11, "IlsAdminAPI", "ParseToken: Setting domain from token.");
            Domain domain = Domain.GetDomain((long)this.token.getDomainId());
            if (domain.getAuthlevel() < n) {
                this._$2794.setStatusInfo(31, "Insufficient authorization level for administrative function.Required: " + IlsAdminAPI.getAuthLevelDescr(n) + ", found " + IlsAdminAPI.getAuthLevelDescr(domain.getAuthlevel()) + " in domain " + domain.getName() + " for product " + string, null, AlerterJob.MakeEventParams(string, domain.getName()));
                WdoBaseException.ThrowProxyWdoException((int)12);
            }
            this._$2794.setDomain(domain.getName());
            IlsUtil.Trace(11, "IlsAdminAPI", "ParseToken: Setting user from token.");
            long l2 = this.token.getUserId();
            user = User.GetUser((long)l2);
            this._$2794.setUser(user.getName());
            IlsUtil.Trace(11, "IlsAdminAPI", "ParseToken: completed setting info from token.");
        }
        IlsUtil.Trace(11, "IlsAdminAPI", "ParseToken: done.");
    }

    void checkToken() throws WdoBaseException {
        String string;
        IlsUtil.Trace(11, "IlsAdminAPI", "checkToken: enter.");
        long l = new Date().getTime();
        User user = User.GetUser((long)this.token.getUserId());
        CheckoutInfo checkoutInfo = user.getCheckoutInfo();
        String string2 = this.token.getProductId() > (long)0 ? Product.GetProduct((long)this.token.getProductId()).getName() : null;
        String string3 = string2 != null && this.token.getDomainId() > (long)0 ? Domain.GetDomain((long)this.token.getDomainId()).getName() : null;
        String string4 = string = string3 != null ? user.getName() : null;
        if (!checkoutInfo.getCheckedOut()) {
            this._$2794.setStatusInfo(14, checkoutInfo.lastChkInTsIsDefined() ? "User was already checked in on " + new Date(checkoutInfo.getLastChkInTs()) : "User was never checked out", null, AlerterJob.MakeEventParams(string2, string3, string));
            WdoBaseException.ThrowProxyWdoException((int)12);
        } else if (!checkoutInfo.getLastChkMachineX().equals(this._$2794.getMachine()) || checkoutInfo.getLastChkSessId() != this._$2794.getSessionId()) {
            this._$2794.setStatusInfo(22, "User was checked out by a different machine / session. Machine: " + checkoutInfo.getLastChkMachineX() + ", Session Id: " + checkoutInfo.getLastChkSessId(), null, AlerterJob.MakeEventParams(string2, string3, string));
            WdoBaseException.ThrowProxyWdoException((int)12);
        } else if (!this.token.getTokenString().trim().equals(user.getToken().trim())) {
            IlsUtil.Trace(10, "IlsAdminAPI", "checkToken: token mismatch.  user:[" + user.getToken().trim() + "], string in token:[" + this.token.getTokenString() + "]");
            this._$2794.setStatusInfo(1, "Invalid server session.  Root cause: unexpected authentication token.", this.token.getTokenString(), AlerterJob.MakeEventParams(string2, string3));
        } else if (this.token.getExpireTs() < l) {
            IlsUtil.Trace(10, "IlsAdminAPI", "checkToken:found expired.  expireTs=" + this.token.getExpireTs() + ", nowTs=" + l);
            this._$2794.setStatusInfo(4, "Logon expired on " + new Date(this.token.getExpireTs()) + ", current date/time is " + new Date(l), null, AlerterJob.MakeEventParams(string2, string3, string));
            WdoBaseException.ThrowProxyWdoException((int)12);
        }
        IlsUtil.Trace(10, "IlsAdminAPI", "checkToken: done.");
    }

    int checkAuthorization(int n) throws WdoBaseException {
        this.parseToken(n);
        if (this.token.getAuthLevel() < 5) {
            this.checkToken();
        }
        return this.token.getAuthLevel();
    }

    static int GetReportAuthLevel(String string) {
        if (string.indexOf(ILS_ADMIN_ENTITY_PRODUCT) > 0) {
            return 4;
        }
        if (string.indexOf(ILS_ADMIN_ENTITY_DOMAIN) > 0) {
            return 3;
        }
        if (string.indexOf(ILS_ADMIN_ENTITY_USER) > 0) {
            return 2;
        }
        return 1;
    }

    public boolean addHostAccessControl(String string, String string2, boolean bl, String string3) {
        Object[] objectArray = new Object[]{string, string2, bl ? "1" : "0", string3};
        this._$2794.setCmd("AddHostAccessControl");
        this._$2794.setRequest("name=" + string);
        return this.processLuwCmd(new AddHostAccessControlLuw(), objectArray, true);
    }

    public boolean dropHostAccessControl(String string) {
        Object[] objectArray = new Object[]{string};
        this._$2794.setCmd("DropHostAccessControl");
        this._$2794.setRequest("name=" + string);
        return this.processLuwCmd(new DropHostAccessControlLuw(), objectArray, true);
    }

    public boolean addProduct(String string, String string2, String string3, boolean bl, int n, String string4, String string5) {
        return this.addProduct(string, string2, string3, bl, n, string4, string5, 0, 0, 0);
    }

    public boolean addProduct(String string, String string2, String string3, boolean bl, int n, String string4, String string5, int n2, int n3, int n4) {
        if (string4 == null) {
            string4 = "";
        }
        this._$2794.setCmd("AddProduct");
        this._$2794.setRequest("product=" + string);
        boolean bl2 = string.equals("system");
        IlsLicense ilsLicense = null;
        if (!bl2 && string3 != null) {
            ilsLicense = new IlsLicense(string3, this.serviceName, string, 0L, null, true);
            if (!ilsLicense.checkLicense(this._$2794)) {
                return false;
            }
            if (!ilsLicense.getKeyInfo().getProductName().equals(string)) {
                this._$2794.setStatusInfo(7, "Name of product being added: " + string + " doesn't match the name in the license key");
                return false;
            }
            string4 = ilsLicense.getKeyInfo().getOptions();
            if (string4 == null) {
                string4 = "";
            }
            n = (int)ilsLicense.getKeyInfo().getUsageValue();
        }
        boolean bl3 = n2 >= 1 || n3 >= 1 || n4 >= 1;
        Object[] objectArray = new Object[11];
        objectArray[0] = string;
        objectArray[1] = string2 == null ? string : string2;
        objectArray[2] = string3;
        Object object = objectArray[3] = ilsLicense != null ? ilsLicense.getKeyInfo().getOptions() : string4;
        objectArray[4] = new Integer(bl2 ? 1 : (ilsLicense == null ? -1 : (int)ilsLicense.getKeyInfo().getUsageValue()));
        objectArray[5] = string5;
        objectArray[6] = bl ? "1" : "0";
        objectArray[7] = ilsLicense;
        objectArray[8] = new Integer(this.token.getAuthLevel());
        objectArray[9] = null;
        objectArray[10] = null;
        boolean bl4 = this.processLuwCmd(new AddProductLuw(), objectArray, true);
        if (bl4) {
            if (bl3) {
                Product product = (Product)objectArray[9];
                boolean bl5 = (Boolean)objectArray[10];
                bl4 = this.propagateDomains(product, bl5, n2, n3, n4);
            }
            if (bl4) {
                Product.RemoveNameCacheEntry((String)this.getServiceName(), (String)string);
            }
        }
        return bl4;
    }

    public boolean dropProduct(String string) {
        Object[] objectArray = new Object[]{string};
        this._$2794.setCmd("DropProduct");
        this._$2794.setRequest("product=" + string);
        boolean bl = this.processLuwCmd(new DropProductLuw(), objectArray, true);
        if (bl) {
            Product.RemoveNameCacheEntry((String)this.getServiceName(), (String)string);
        }
        return bl;
    }

    public boolean addDomain(String string, String string2, String string3, LicenseParamInfo licenseParamInfo, Long l, Long l2, Long l3, Long l4, String string4, String string5) {
        return this.addDomain(string, string2, string3, licenseParamInfo, l, l2, l3, l4, string4, string5, false, false, false);
    }

    public boolean addDomain(String string, String string2, String string3, LicenseParamInfo licenseParamInfo, Long l, Long l2, Long l3, Long l4, String string4, String string5, boolean bl, boolean bl2, boolean bl3) {
        return this.addDomain(string, string2, string3, licenseParamInfo, l, l2, l3, l4, null, string4, string5, bl, bl2, bl3);
    }

    public boolean addDomain(String string, String string2, String string3, LicenseParamInfo licenseParamInfo, Long l, Long l2, Long l3, Long l4, Long l5, String string4, String string5, boolean bl, boolean bl2, boolean bl3) {
        IlsUtil.Trace(7, "IlsAdminAPI", "addDomain: enter.  Product=" + string + ", domain=" + string2 + ", authlevel=" + l);
        Object[] objectArray = new Object[]{string, string2, string3, licenseParamInfo, l, l2, l3, l4, l5, string4, string5, new Integer(this.token.getAuthLevel()), null, null};
        this._$2794.setCmd("AddDomain");
        this._$2794.setRequest("product=" + string + "&domain=" + string2);
        boolean bl4 = this.processLuwCmd(new AddDomainLuw(), objectArray, true);
        if (bl4) {
            if (bl || bl2 || bl3) {
                Domain domain = (Domain)objectArray[12];
                boolean bl5 = (Boolean)objectArray[13];
                bl4 = this.propagateUsers(domain, bl5, bl, bl2, bl3);
            }
            Domain.RemoveNameCacheEntry((String)this.getServiceName(), (String)string, (String)string2);
        }
        return bl4;
    }

    public boolean dropDomain(String string, String string2) {
        Object[] objectArray = new Object[]{string, string2};
        this._$2794.setCmd("DropDomain");
        this._$2794.setRequest("product=" + string + "&domain=" + string2);
        boolean bl = this.processLuwCmd(new DropDomainLuw(), objectArray, true);
        if (bl) {
            Domain.RemoveNameCacheEntry((String)this.getServiceName(), (String)string, (String)string2);
        }
        return bl;
    }

    public boolean addIUser(String string, String string2, String string3, String string4, String string5, LicenseParamInfo licenseParamInfo, String string6, Long l, String string7, String string8) {
        return this.addIUserX(string, string2, string3, string4, string5, null, licenseParamInfo, string6, l, string7, string8);
    }

    public boolean addIUserX(String string, String string2, String string3, String string4, String string5, String string6, LicenseParamInfo licenseParamInfo, String string7, Long l, String string8, String string9) {
        Object[] objectArray = new Object[]{string, string2, string3, string4, string5, string6, licenseParamInfo, string7, l, string8, string9, new Integer(this.token.getAuthLevel())};
        this._$2794.setCmd("AddUser");
        this._$2794.setRequest("product=" + string + "&domain=" + string2 + "&user=" + string3);
        return this.processLuwCmd(new AddUserLuw(), objectArray, true);
    }

    public boolean dropIUser(String string, String string2, String string3) {
        Object[] objectArray = new Object[]{string, string2, string3};
        this._$2794.setCmd("DropUser");
        this._$2794.setRequest("product=" + string + "&domain=" + string2 + "&user=" + string3);
        return this.processLuwCmd(new DropUserLuw(), objectArray, true);
    }

    public boolean dropUserX(long l, long l2, long l3) {
        Object[] objectArray = new Object[]{new Long(l), new Long(l2), new Long(l3), new Integer(this.token.getAuthLevel())};
        this._$2794.setCmd("DropUser");
        this._$2794.setRequest("productId=" + l3 + "&domainId=" + l2 + "&userId=" + l);
        return this.processLuwCmd(new DropUserXLuw(), objectArray, true);
    }

    public boolean dropObject(String string, long l) {
        Object[] objectArray = new Object[]{string, new Long(l), null};
        return this.processLuwCmd(new DropObjectLuw(), objectArray, true);
    }

    public long dropAuditTrail(long l, String string, String string2, String string3, String string4, String string5, String string6, int n, int n2, int n3) {
        Object[] objectArray = new Object[]{new Long(l), string, string2, string3, string4, string5, string6, new Integer(n), new Integer(n2), new Integer(n3), null};
        this._$2794.setCmd("DropAuditTrail");
        if (this.processLuwCmd(new DropAuditTrailLuw(), objectArray, false)) {
            return (Long)objectArray[10];
        }
        return -1L;
    }

    public String getXmlData(int n) {
        Object[] objectArray = new Object[2];
        objectArray[0] = new Integer(n);
        if (!this.processLuwCmd(new ListDataLuw(), objectArray, false)) {
            return null;
        }
        return (String)objectArray[1];
    }

    public String getEntityXmlData(String string, int n) {
        Object[] objectArray = new Object[4];
        objectArray[0] = string;
        objectArray[1] = new Integer(n);
        objectArray[2] = new Integer(1);
        if (!this.processLuwCmd(new ListEntityDataLuw(), objectArray, false)) {
            return null;
        }
        return (String)objectArray[3];
    }

    public Vector getEntityVectorData(String string) {
        Object[] objectArray = new Object[4];
        objectArray[0] = string;
        objectArray[1] = new Integer(0);
        objectArray[2] = new Integer(0);
        if (!this.processLuwCmd(new ListEntityDataLuw(), objectArray, false)) {
            return null;
        }
        return (Vector)objectArray[3];
    }

    public Object execAdminMethod(int n, String string, Object object, String string2, Class[] classArray, Object[] objectArray, boolean bl, int n2, boolean bl2, String string3) {
        return this.execAdminMethod(n, string, object, string2, classArray, objectArray, bl, n2, bl2, string3, 0L);
    }

    public Object execAdminMethod(int n, String string, Object object, String string2, Class[] classArray, Object[] objectArray, boolean bl, int n2, boolean bl2, String string3, long l) {
        Object[] objectArray2;
        long l2 = 0L;
        IlsUtil.Trace(5, "IlsAdminAPI", "execAdminMethod enter.  objName: " + string + ", methodName: " + string2 + ", isVectorQuery: " + bl + ", level: " + n2 + ", doAudit: " + bl2 + ", cmdName: " + string3 + ", productId: " + l);
        if (bl2) {
            objectArray2 = "objName: " + string + ", methodName: " + string2 + ", cmdName: " + string3;
            IlsCmdArgs ilsCmdArgs = new IlsCmdArgs();
            IlsJob.TriggerEvents(ilsCmdArgs, this.serviceName, "Administration Command", (String)objectArray2, null);
            BackupJob backupJob = (BackupJob)IlsJob.GetJob("Backup", ilsCmdArgs, this.serviceName, false);
            long l3 = 0L;
            if (backupJob != null && (l3 = backupJob.checkBackupInProgress()) > (long)0) {
                l2 = new Date().getTime();
                ilsCmdArgs.setStatusInfo(1004, "A backup is currently in progress and has been running for " + IlsUtil.GetElapsedTimeString(l2 - l3, IlsUtil.TIME_PRECISION_HR, false));
                return null;
            }
        }
        l2 = new Date().getTime();
        this._$2794 = new IlsCmdArgs();
        this._$2794.setServiceName(this.serviceName);
        this._$2794.setCmd(string3 == null ? String.valueOf(string) + "." + string2 : string3);
        if (!(this.tokenString != null || string.equals(ILS_ADMIN_ENTITY_PRODUCT) && object == null && string2.equals("GetList") && n >= 5)) {
            this._$2794.setStatusInfo(18, "Unauthorized access for internal administrative function.");
            return null;
        }
        IlsUtil.Trace(10, "IlsAdminAPI", "execAdminMethod done token verification, executing LUW...");
        objectArray2 = new Object[]{string, object, string2, classArray, objectArray, bl ? "1" : "0", new Integer(n2), new Integer(2), new Long(l), new Integer(n), null};
        if (!this.processLuwCmd(new ExecMethodLuw(), objectArray2, bl2)) {
            return null;
        }
        long l4 = new Date().getTime();
        IlsUtil.Trace(5, "IlsAdminAPI", "execAdminMethod done LUW execution.  Elapsed time (ms): " + String.valueOf(l4 - l2));
        return objectArray2[10];
    }

    public String getErrorMsg(String string) {
        String string2 = String.valueOf(this._$2794.getMsg()) + " " + (this._$2794.getValue() == null ? "" : this._$2794.getValue()) + "(" + (string == null ? "" : String.valueOf(string) + " ") + "Error: Status code: " + this._$2794.getStatus() + ")";
        return string2;
    }

    public boolean propagateDomains(Product product, boolean bl, int n, int n2, int n3) {
        Vector vector;
        boolean bl2 = false;
        boolean bl3 = n >= 2 || n2 >= 2 || n3 >= 2;
        Object[] objectArray = new Object[8];
        objectArray[0] = product;
        objectArray[1] = new Long(500L);
        objectArray[3] = new Boolean(n >= 1);
        objectArray[4] = new Boolean(n2 >= 1);
        objectArray[5] = new Boolean(n3 >= 1);
        objectArray[6] = new Boolean(bl);
        long l = 0L;
        do {
            objectArray[2] = new Long(l);
            bl2 = this.processLuwCmd(new PropagateLimitsToDomainsLuw(), objectArray, false);
            if (!bl2) {
                return false;
            }
            vector = (Vector)objectArray[7];
            try {
                l = ((Domain)vector.elementAt(vector.size() - 1)).getDomainId();
            }
            catch (WdoBaseException wdoBaseException) {
                l = 999999999L;
            }
            if (!bl3) continue;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Domain domain = (Domain)enumeration.nextElement();
                bl2 = this.propagateUsers(domain, bl, n >= 2, n2 >= 2, n3 >= 2);
                if (bl2) continue;
                return false;
            }
        } while (vector.size() >= 500);
        return true;
    }

    public boolean propagateUsers(Domain domain, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        boolean bl5 = false;
        Object[] objectArray = new Object[8];
        objectArray[0] = domain;
        objectArray[1] = new Long(500L);
        objectArray[3] = new Boolean(bl2);
        objectArray[4] = new Boolean(bl3);
        objectArray[5] = new Boolean(bl4);
        objectArray[6] = new Boolean(bl);
        long l = 0L;
        while (true) {
            objectArray[2] = new Long(l);
            bl5 = this.processLuwCmd(new PropagateLimitsToUsersLuw(), objectArray, false);
            if (!bl5) {
                return false;
            }
            Vector vector = (Vector)objectArray[7];
            if (vector.size() < 500) break;
            try {
                l = ((User)vector.elementAt(vector.size() - 1)).getUserId();
            }
            catch (WdoBaseException wdoBaseException) {
                l = 999999999L;
            }
        }
        return true;
    }

    public boolean copyAuditEntries(IlsAdminAPI ilsAdminAPI, String string, int n, boolean bl) throws WdoBaseException {
        block7: {
            Vector vector;
            IlsUtil.Trace(5, "IlsAdminAPI", "copyAuditEntries: enter.");
            IlsCopyState ilsCopyState = IlsCopyState.GetCopyState(ilsAdminAPI.serviceName, this.serviceName, ilsAdminAPI._$2794, this._$2794);
            if (ilsCopyState == null) {
                return false;
            }
            if (ilsCopyState.state > 1) {
                ilsAdminAPI._$2794.setStatusInfo(1000, "Internal error: copyAuditEntries expected state COPY_STATE_DOAUDITS, got " + ilsCopyState.state);
                return false;
            }
            ilsCopyState.state = 1;
            ilsCopyState.saveCopyState();
            boolean bl2 = false;
            if (n <= 0) {
                n = 250;
            }
            Object[] objectArray = new Object[2];
            do {
                IlsUtil.Trace(5, "IlsAdminAPI", "copyAuditEntries: getting next set of entries based on last id = " + ilsCopyState.lastAuditId + "." + " Current value for auditsAdded = " + ilsCopyState.auditsAdded + ".");
                objectArray[1] = null;
                int n2 = 1;
                int n3 = 5;
                vector = (Vector)ilsAdminAPI.execAdminMethod(4, "AuditTrail", null, "FindEntriesXScrollByIdAscNoSort", new Class[]{Integer.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, class$java$lang$String == null ? IlsAdminAPI.class$("java.lang.String") : class$java$lang$String, class$java$lang$String == null ? IlsAdminAPI.class$("java.lang.String") : class$java$lang$String, class$java$lang$String == null ? IlsAdminAPI.class$("java.lang.String") : class$java$lang$String, class$java$lang$String == null ? IlsAdminAPI.class$("java.lang.String") : class$java$lang$String, class$java$lang$String == null ? IlsAdminAPI.class$("java.lang.String") : class$java$lang$String, class$java$lang$String == null ? IlsAdminAPI.class$("java.lang.String") : class$java$lang$String, Integer.TYPE, Integer.TYPE, Integer.TYPE, class$java$lang$String == null ? IlsAdminAPI.class$("java.lang.String") : class$java$lang$String, class$java$lang$String == null ? IlsAdminAPI.class$("java.lang.String") : class$java$lang$String}, new Object[]{new Integer(n), new Long(ilsCopyState.lastAuditId), new Long(0L), new Long(Long.MAX_VALUE), "%", "%", "%", "%", "%", "%", new Integer(n2), new Integer(4), new Integer(n3), "%", "%"}, true, 0, false, null);
                if (vector == null) {
                    return false;
                }
                if (bl) {
                    System.out.print(".");
                }
                if (vector.size() <= 0) continue;
                ilsCopyState.lastAuditId = ((AuditTrail)vector.elementAt(vector.size() - 1)).getAuditTrailId();
                objectArray[0] = vector;
                bl2 = this.processLuwCmd(new CopyAuditEntriesLuw(), objectArray, false);
                IlsUtil.Trace(5, "IlsAdminAPI", "copyAuditEntries: input count=" + vector.size() + ", new lastId = " + ilsCopyState.lastAuditId + "copy ret: " + bl2);
                if (!bl2) {
                    return false;
                }
                ilsCopyState.auditsAdded += (long)vector.size();
                ilsCopyState.saveCopyState();
            } while (vector.size() >= n);
            ilsCopyState.state = 2;
            ilsCopyState.saveCopyState();
            if (!bl) break block7;
            System.out.println("");
        }
        return true;
    }

    public boolean copyHostAccessRules(IlsAdminAPI ilsAdminAPI, String string, String string2, int n, boolean bl) throws WdoBaseException {
        block8: {
            Vector vector;
            IlsUtil.Trace(5, "IlsAdminAPI", "copyHostAccessRules: enter. rule name pattern = " + string2);
            IlsCopyState ilsCopyState = IlsCopyState.GetCopyState(ilsAdminAPI.serviceName, this.serviceName, ilsAdminAPI._$2794, this._$2794);
            if (ilsCopyState == null) {
                return false;
            }
            if (ilsCopyState.state != 2) {
                ilsAdminAPI._$2794.setStatusInfo(1000, "Internal error: copyHostAccessRules expected state COPY_STATE_DOHOSTS, got " + ilsCopyState.state);
                return false;
            }
            boolean bl2 = false;
            if (n <= 0) {
                n = 250;
            }
            if (string2 == null) {
                string2 = "%";
            }
            Object[] objectArray = new Object[4];
            do {
                objectArray[1] = new Long(ilsCopyState.hostrulesAdded);
                objectArray[2] = new Long(ilsCopyState.hostrulesUpdated);
                objectArray[3] = null;
                IlsUtil.Trace(5, "IlsAdminAPI", "copyHostAccessEntries: getting next set of entries based on last id = " + ilsCopyState.lastHostRuleId + "." + " Current value for hostrulesAdded = " + ilsCopyState.hostrulesAdded + ", hostrulesUpdated = " + ilsCopyState.hostrulesUpdated);
                IlsAdminPublicAPI.Result result = IlsAdminPublicAPI.findMatchingHostAccessControlRules((String)ilsAdminAPI.serviceName, (String)string, (boolean)false, (int)n, (long)ilsCopyState.lastHostRuleId, (String)string2, (String)"%", (String)"%");
                if (result.getStatusCode() > 0) {
                    ilsAdminAPI._$2794.setStatusInfo(result.getStatusCode(), result.getStatusMsg());
                    return false;
                }
                vector = (Vector)result.getResultData();
                if (bl) {
                    System.out.print(".");
                }
                if (vector.size() <= 0) continue;
                ilsCopyState.lastHostRuleId = ((HostAccessControl)vector.elementAt(vector.size() - 1)).getHostAccessControlId();
                objectArray[0] = vector;
                bl2 = this.processLuwCmd(new CopyHostAccessRulesLuw(), objectArray, false);
                IlsUtil.Trace(5, "IlsAdminAPI", "copyHostaccessEntries: input count=" + vector.size() + ", new lastId = " + ilsCopyState.lastHostRuleId + "copy ret: " + bl2);
                if (!bl2) {
                    return false;
                }
                Vector vector2 = (Vector)objectArray[3];
                ilsCopyState.hostrulesAdded += ((Long)objectArray[1]).longValue();
                ilsCopyState.hostrulesUpdated += ((Long)objectArray[2]).longValue();
                ilsCopyState.saveCopyState();
            } while (vector.size() >= n);
            ilsCopyState.state = 3;
            ilsCopyState.saveCopyState();
            if (!bl) break block8;
            System.out.println("");
        }
        return true;
    }

    public boolean copyProducts(IlsAdminAPI ilsAdminAPI, String string, String string2, String string3, String string4, int n, boolean bl) throws WdoBaseException {
        block12: {
            Vector vector;
            IlsUtil.Trace(5, "IlsAdminAPI", "copyProducts: enter. product name pattern = " + string2 + ", domain name pattern = " + string3 + ", username pattern = " + string4);
            IlsCopyState ilsCopyState = IlsCopyState.GetCopyState(ilsAdminAPI.serviceName, this.serviceName, ilsAdminAPI._$2794, this._$2794);
            if (ilsCopyState == null) {
                return false;
            }
            if (ilsCopyState.state != 3) {
                ilsAdminAPI._$2794.setStatusInfo(1000, "Internal error: copyProducts expected state COPY_STATE_DOPRODUCTS, got " + ilsCopyState.state);
                return false;
            }
            boolean bl2 = false;
            if (n <= 0) {
                n = 250;
            }
            if (string2 == null) {
                string2 = "%";
            }
            if (string3 == null) {
                string3 = "%";
            }
            if (string4 == null) {
                string4 = "%";
            }
            Object[] objectArray = new Object[4];
            do {
                objectArray[1] = new Long(ilsCopyState.productsAdded);
                objectArray[2] = new Long(ilsCopyState.productsUpdated);
                objectArray[3] = null;
                IlsUtil.Trace(5, "IlsAdminAPI", "copyProducts: doing findMatchingProducts with last product id = " + ilsCopyState.lastProductId);
                IlsAdminPublicAPI.Result result = IlsAdminPublicAPI.findMatchingProducts((String)ilsAdminAPI.serviceName, (String)string, (boolean)false, (int)n, (long)ilsCopyState.lastProductId, (String)string2, (String)"%");
                if (result.getStatusCode() > 0) {
                    ilsAdminAPI._$2794.setStatusInfo(result.getStatusCode(), result.getStatusMsg());
                    return false;
                }
                vector = (Vector)result.getResultData();
                if (bl) {
                    System.out.print(".");
                }
                if (vector.size() <= 0) continue;
                objectArray[0] = vector;
                bl2 = this.processLuwCmd(new CopyProductsLuw(), objectArray, false);
                IlsUtil.Trace(5, "IlsAdminAPI", "copyProducts: input count=" + vector.size() + ", new lastId = " + ilsCopyState.lastProductId + "copy ret: " + bl2);
                if (!bl2) {
                    return false;
                }
                Vector vector2 = (Vector)objectArray[3];
                ilsCopyState.productsAdded += ((Long)objectArray[1]).longValue();
                ilsCopyState.productsUpdated += ((Long)objectArray[2]).longValue();
                Enumeration enumeration = vector2.elements();
                Enumeration enumeration2 = vector.elements();
                while (enumeration.hasMoreElements()) {
                    Product product = (Product)enumeration.nextElement();
                    if (product.getName().equals("system")) continue;
                    if (!this.copyDomains(ilsAdminAPI, string, product, string3, string4, n, bl)) {
                        return false;
                    }
                    Product product2 = (Product)enumeration2.nextElement();
                    ilsCopyState.lastProductId = product2.getProductId();
                    ilsCopyState.saveCopyState();
                    IlsUtil.Trace(5, "IlsAdminAPI", "copyProducts: new lastId after copyDomains = " + ilsCopyState.lastProductId);
                }
            } while (vector.size() >= n);
            ilsCopyState.state = 4;
            ilsCopyState.saveCopyState();
            if (!bl) break block12;
            System.out.println("");
        }
        return true;
    }

    public boolean copyDomains(IlsAdminAPI ilsAdminAPI, String string, Product product, String string2, String string3, int n, boolean bl) throws WdoBaseException {
        block9: {
            Vector vector;
            IlsUtil.Trace(5, "IlsAdminAPI", "copyDomains: enter. product name = " + product.getName() + ", domain name pattern = " + string2 + ", username pattern = " + string3);
            IlsCopyState ilsCopyState = IlsCopyState.GetCopyState(ilsAdminAPI.serviceName, this.serviceName, ilsAdminAPI._$2794, this._$2794);
            if (ilsCopyState == null) {
                return false;
            }
            if (ilsCopyState.state != 3) {
                ilsAdminAPI._$2794.setStatusInfo(1000, "Internal error: copyDomains expected state COPY_STATE_DOPRODUCTS, got " + ilsCopyState.state);
                return false;
            }
            boolean bl2 = false;
            if (n <= 0) {
                n = 250;
            }
            Object[] objectArray = new Object[5];
            objectArray[0] = product;
            do {
                IlsUtil.Trace(5, "IlsAdminAPI", "copyDomains: about to find matching domains.  Input parameters:\n\tproduct name = " + product.getName() + "\n\tlast domain id = " + ilsCopyState.lastDomainId + "\n\tname pattern = " + string2);
                objectArray[2] = new Long(ilsCopyState.domainsAdded);
                objectArray[3] = new Long(ilsCopyState.domainsUpdated);
                objectArray[4] = null;
                IlsAdminPublicAPI.Result result = IlsAdminPublicAPI.findMatchingDomains((String)ilsAdminAPI.serviceName, (String)string, (boolean)false, (int)n, (long)ilsCopyState.lastDomainId, (String)product.getName(), (String)string2, (boolean)true, (boolean)true, (String)"%");
                if (result.getStatusCode() > 0) {
                    ilsAdminAPI._$2794.setStatusInfo(result.getStatusCode(), result.getStatusMsg());
                    return false;
                }
                vector = (Vector)result.getResultData();
                if (bl) {
                    System.out.print("+");
                }
                if (vector.size() <= 0) continue;
                objectArray[1] = vector;
                bl2 = this.processLuwCmd(new CopyDomainsLuw(), objectArray, false);
                IlsUtil.Trace(5, "IlsAdminAPI", "copyDomains: input count=" + vector.size() + ", new lastDomainId = " + ilsCopyState.lastDomainId + "copy ret: " + bl2);
                if (!bl2) {
                    return false;
                }
                Vector vector2 = (Vector)objectArray[4];
                ilsCopyState.domainsAdded += ((Long)objectArray[2]).longValue();
                ilsCopyState.domainsUpdated += ((Long)objectArray[3]).longValue();
                Enumeration enumeration = vector2.elements();
                Enumeration enumeration2 = vector.elements();
                while (enumeration.hasMoreElements()) {
                    Domain domain = (Domain)enumeration.nextElement();
                    if (!this.copyUsers(ilsAdminAPI, string, product, domain, string3, n, bl)) {
                        return false;
                    }
                    Domain domain2 = (Domain)enumeration2.nextElement();
                    ilsCopyState.lastDomainId = domain2.getDomainId();
                    IlsUtil.Trace(5, "IlsAdminAPI", "copyDomains: did copyUsers, new lastDomainId = " + ilsCopyState.lastDomainId);
                    ilsCopyState.saveCopyState();
                }
            } while (vector.size() >= n);
            if (!bl) break block9;
            System.out.println("");
        }
        return true;
    }

    public boolean copyUsers(IlsAdminAPI ilsAdminAPI, String string, Product product, Domain domain, String string2, int n, boolean bl) throws WdoBaseException {
        Vector vector;
        IlsUtil.Trace(5, "IlsAdminAPI", "copyUsers: enter. product name = " + product.getName() + ", domain name = " + domain.getName() + ", username pattern = " + string2);
        IlsCopyState ilsCopyState = IlsCopyState.GetCopyState(ilsAdminAPI.serviceName, this.serviceName, ilsAdminAPI._$2794, this._$2794);
        if (ilsCopyState == null) {
            IlsUtil.Trace(3, "IlsAdminAPI", "copyUsers: failed to get copyState");
            return false;
        }
        if (ilsCopyState.state != 3) {
            ilsAdminAPI._$2794.setStatusInfo(1000, "Internal error: copyUsers expected state COPY_STATE_DOPRODUCTS, got " + ilsCopyState.state);
            IlsUtil.Trace(3, "IlsAdminAPI", "copyUsers: bad state for copyState");
            return false;
        }
        boolean bl2 = false;
        if (n <= 0) {
            n = 250;
        }
        Object[] objectArray = new Object[6];
        objectArray[0] = product;
        objectArray[1] = domain;
        do {
            IlsUtil.Trace(5, "IlsAdminAPI", "copyUsers: about to find matching users.  Input parameters and state:\n\tlastUserId=" + ilsCopyState.lastUserId + "\n\tproduct name pattern = [" + product.getName() + "]" + "\n\tdomain name pattern = [" + domain.getName() + "]" + "\n\tuser name pattern = [" + string2 + "]" + "\n\tusers added so far = " + ilsCopyState.usersAdded + "\n\tusers updated so far = " + ilsCopyState.usersUpdated);
            objectArray[3] = new Long(ilsCopyState.usersAdded);
            objectArray[4] = new Long(ilsCopyState.usersUpdated);
            objectArray[5] = null;
            IlsAdminPublicAPI.Result result = IlsAdminPublicAPI.findMatchingUsers((String)ilsAdminAPI.serviceName, (String)string, (boolean)false, (int)n, (long)ilsCopyState.lastUserId, (String)product.getName(), (String)domain.getName(), (String)string2, (String)"%", (String)"%", (boolean)false);
            if (result.getStatusCode() > 0) {
                IlsUtil.Trace(3, "IlsAdminAPI", "copyUsers: failed to find matching users");
                ilsAdminAPI._$2794.setStatusInfo(result.getStatusCode(), result.getStatusMsg());
                return false;
            }
            vector = (Vector)result.getResultData();
            if (bl) {
                System.out.print("#");
            }
            if (vector.size() > 0) {
                ilsCopyState.lastUserId = ((User)vector.elementAt(vector.size() - 1)).getUserId();
                objectArray[2] = vector;
                bl2 = this.processLuwCmd(new CopyUsersLuw(), objectArray, false);
                IlsUtil.Trace(5, "IlsAdminAPI", "copyUsers: input count=" + vector.size() + ", new lastUserId = " + ilsCopyState.lastUserId + ", copy ret: " + bl2);
                if (!bl2) {
                    return false;
                }
                Vector vector2 = (Vector)objectArray[5];
                ilsCopyState.usersAdded = (Long)objectArray[3];
                ilsCopyState.usersUpdated = (Long)objectArray[4];
                ilsCopyState.saveCopyState();
                IlsUtil.Trace(5, "IlsAdminAPI", "copUsers: new values for usersAdded = " + ilsCopyState.usersAdded + ", usersUpdated = " + ilsCopyState.usersUpdated);
                continue;
            }
            IlsUtil.Trace(5, "IlsAdminAPI", "copyUsers: vector size to process is 0");
        } while (vector.size() >= n);
        ilsCopyState.lastUserId = 0L;
        ilsCopyState.saveCopyState();
        return true;
    }

    void checkNoAudit(Product product) throws WdoBaseException {
        if (product.optionsIsDefined()) {
            String string = product.getOptions();
            if ((string = IlsCmdAPI.GetIlsStringOption(string, "ILS:AUDIT")) != null && string.equals("0")) {
                this.doAudit = false;
            }
        }
    }

    public Object execPersistentMethod(String string, Object object, String string2, Class[] classArray, Object[] objectArray, boolean bl, int n) {
        if (!bl) {
            this._$2794.setCmd(String.valueOf(string) + "." + string2);
        }
        Object[] objectArray2 = new Object[]{string, object, string2, classArray, objectArray, bl ? "1" : "0", new Integer(n), null};
        if (!this.processLuwCmd(new ExecMethodLuw(), objectArray2, !bl)) {
            return null;
        }
        return objectArray2[7];
    }

    public Object getObject(String string, long l) {
        Object[] objectArray = new Object[]{string, new Long(l), null};
        Object object = null;
        if (this.processLuwCmd(new GetObjectLuw(), objectArray, false)) {
            object = objectArray[2];
        }
        return object;
    }

    public boolean processLuwCmd(WdoUnitOfWork wdoUnitOfWork, Object object, boolean bl) {
        Object[] objectArray = new Object[]{this, object};
        String string = WdoTransaction.DoUnitOfWork((WdoUnitOfWork)wdoUnitOfWork, (String)this.serviceName, (int)2, (Object[])objectArray);
        if (IlsUtil.CheckDebug(10)) {
            if (bl) {
                System.out.println("ProcessLuwCmd invoked in audit mode.  Stack trace:");
                new Throwable().printStackTrace();
            }
            if (string != null) {
                System.out.println("Admin API processLuwCmd: unit of work returned error string: " + string);
                System.out.println("Cmd arg status code was: " + this._$2794.getStatus());
            }
        }
        if (string != null && this._$2794.getStatus() <= 0) {
            this._$2794.setStatusInfo(25, string);
        }
        if (bl && this.doAudit && this._$2794.getCmd() != null) {
            if (IlsUtil.CheckDebug(10)) {
                System.out.println("ProcessLuwCmd: recording audit trail entry.");
            }
            WdoTransaction.DoUnitOfWork((WdoUnitOfWork)new AddAuditTrailLuw(), (String)this.serviceName, (int)1, (Object[])objectArray);
            this.doAudit = false;
        }
        return this._$2794.getStatus() <= 0;
    }

    boolean makeAddHostAccessControlDispatchArgs(HashMap hashMap) {
        this.dispatchArgs = new Object[3];
        this.dispatchArgs[0] = (String)hashMap.get("name");
        this.dispatchArgs[1] = (String)hashMap.get("pattern");
        this.dispatchArgs[2] = (String)hashMap.get("allow");
        if (this.dispatchArgs[0] == null || this.dispatchArgs[1] == null || this.dispatchArgs[2] == null) {
            this._$2794.setStatusInfo(100, "All parameters must be specified for adding or updating a host access control entry: name, pattern, allow/deny");
            return false;
        }
        return true;
    }

    boolean makeDropHostAccessControlDispatchArgs(HashMap hashMap) {
        this.dispatchArgs = new Object[1];
        this.dispatchArgs[0] = (String)hashMap.get("name");
        if (this.dispatchArgs[0] == null) {
            this._$2794.setStatusInfo(100, "Name pattern must be specified for dropping host access control entries");
            return false;
        }
        return true;
    }

    boolean makeAddProductDispatchArgs(HashMap hashMap) {
        String string = (String)hashMap.get("name");
        String string2 = (String)hashMap.get("title");
        if (string2 == null || string2.equals("")) {
            string2 = string;
        }
        String string3 = (String)hashMap.get("key");
        if (string == null || string3 == null) {
            this._$2794.setStatusInfo(100, "Product name and key must be specified for adding or updating a product entry");
            return false;
        }
        IlsLicense ilsLicense = new IlsLicense(string3, this.serviceName, string, 0L, null, true);
        if (!ilsLicense.checkLicense(this._$2794)) {
            return false;
        }
        if (!ilsLicense.getKeyInfo().getProductName().equals(string)) {
            this._$2794.setStatusInfo(7, "Name of product being added / updated: " + string + " doesn't match the name in the license key");
            return false;
        }
        this.dispatchArgs = new Object[5];
        this.dispatchArgs[0] = string;
        this.dispatchArgs[1] = string2;
        this.dispatchArgs[2] = string3;
        this.dispatchArgs[3] = ilsLicense.getKeyInfo().getOptions();
        this.dispatchArgs[4] = new Integer((int)ilsLicense.getKeyInfo().getUsageValue());
        return true;
    }

    boolean makeDropProductDispatchArgs(HashMap hashMap) {
        this.dispatchArgs = new Object[1];
        this.dispatchArgs[0] = (String)hashMap.get("name");
        if (this.dispatchArgs[0] == null) {
            this._$2794.setStatusInfo(100, "Product name pattern must be specified for dropping products");
            return false;
        }
        return true;
    }

    boolean makeAddDomainDispatchArgs(HashMap hashMap) {
        LicenseParamInfo licenseParamInfo = null;
        this.dispatchArgs = new Object[4];
        this.dispatchArgs[0] = (String)hashMap.get("product");
        this.dispatchArgs[1] = (String)hashMap.get("name");
        this.dispatchArgs[2] = (String)hashMap.get("model");
        if (this.dispatchArgs[0] == null || this.dispatchArgs[1] == null || this.dispatchArgs[2] == null) {
            this._$2794.setStatusInfo(100, "Parameters must be specified for adding / updating a domain entry: product name, domain name, license model");
            return false;
        }
        licenseParamInfo = this.makeLicenseParams(hashMap);
        if (licenseParamInfo == null) {
            return false;
        }
        this.dispatchArgs[3] = licenseParamInfo;
        return true;
    }

    boolean makeDropDomainDispatchArgs(HashMap hashMap) {
        this.dispatchArgs = new Object[2];
        this.dispatchArgs[0] = (String)hashMap.get("product");
        this.dispatchArgs[1] = (String)hashMap.get("name");
        if (this.dispatchArgs[0] == null || this.dispatchArgs[1] == null) {
            this._$2794.setStatusInfo(100, "Product and domain name patterns must be specified for dropping domain entries");
            return false;
        }
        return true;
    }

    boolean makeAddUserDispatchArgs(HashMap hashMap) {
        String string = (String)hashMap.get("product");
        String string2 = (String)hashMap.get("domain");
        String string3 = (String)hashMap.get("name");
        String string4 = (String)hashMap.get("passwd");
        LicenseParamInfo licenseParamInfo = null;
        this.dispatchArgs = new Object[5];
        this.dispatchArgs[0] = string;
        this.dispatchArgs[1] = string2;
        this.dispatchArgs[2] = string3;
        this.dispatchArgs[3] = string4;
        if (this.dispatchArgs[0] == null || this.dispatchArgs[1] == null || this.dispatchArgs[2] == null) {
            this._$2794.setStatusInfo(100, "Parameters must be specified for adding / updating a user entry: product name, domain name, user name");
            return false;
        }
        licenseParamInfo = this.makeLicenseParams(hashMap);
        if (licenseParamInfo == null) {
            return false;
        }
        this.dispatchArgs[4] = licenseParamInfo;
        return true;
    }

    boolean makeDropUserDispatchArgs(HashMap hashMap) {
        this.dispatchArgs = new Object[2];
        this.dispatchArgs[0] = (String)hashMap.get("product");
        this.dispatchArgs[1] = (String)hashMap.get("domain");
        this.dispatchArgs[2] = (String)hashMap.get("name");
        if (this.dispatchArgs[0] == null || this.dispatchArgs[1] == null || this.dispatchArgs[2] == null) {
            this._$2794.setStatusInfo(100, "Product, domain and user name patterns must be specified for dropping user entries");
            return false;
        }
        return true;
    }

    long getValidatedProductQuotaLimit(Product product) throws WdoBaseException {
        return product.getQuotaLimited() ? product.getQuota() : -1L;
    }

    long getValidatedProductExpTs(Product product) throws WdoBaseException {
        return product.getTimeLimited() ? product.getExpTs() : -1L;
    }

    long getValidatedDomainQuotaLimit(Product product, Domain domain) throws WdoBaseException {
        long l;
        long l2 = this.getValidatedProductQuotaLimit(product);
        long l3 = l = domain.getLicenseParams().getQuotaLimited() ? domain.getLicenseParams().getQuota() : -1L;
        if (l2 > (long)0 && (l <= (long)0 || l > l2)) {
            l = l2;
        }
        return l;
    }

    long getValidatedDomainExpTs(Product product, Domain domain) throws WdoBaseException {
        long l;
        long l2 = this.getValidatedProductExpTs(product);
        if (l2 <= (long)0 && (domain.getLicenseParams().getTimeLimitType().equals("NONE") || !domain.getLicenseParams().expDateIsDefined())) {
            return -1L;
        }
        long l3 = domain.getLicenseParams().getTimeLimitType().equals("NONE") ? -1L : (l = domain.getLicenseParams().expDateIsDefined() ? domain.getLicenseParams().getExpDate().getTime() : -1L);
        if (l2 > (long)0 && (l <= (long)0 || l > l2 && l - l2 >= (long)86400000)) {
            l = l2;
        }
        return l;
    }

    public static LicenseParamInfo makeLicenseParams(long l, long l2, long l3, String string, long l4, long l5, long l6, String string2) {
        LicenseParamInfo licenseParamInfo = new LicenseParamInfo();
        try {
            if (l > (long)0) {
                licenseParamInfo.setQuotaLimited(true);
            }
            licenseParamInfo.setQuota(l);
            licenseParamInfo.setQuotaWarningThreshold(l3);
            licenseParamInfo.setQuotaGrace(l2);
            licenseParamInfo.setTimeLimitType(string);
            if (string.equals("RELT")) {
                licenseParamInfo.setExpDays(l4);
            } else if (string.equals("ABST")) {
                licenseParamInfo.setExpDate(new Timestamp(new Date().getTime() + l4 * (long)86400 * (long)1000));
            }
            licenseParamInfo.setExpGrace((int)l5);
            licenseParamInfo.setExpWarningThreshold((int)l6);
            licenseParamInfo.setOptions(string2 == null ? "" : (string2.equals("") ? " " : string2));
        }
        catch (Throwable throwable) {
            IlsUtil.Trace(false, 5, "IlsAdminAPI", new String[]{"makeLicenseParams: caught exception.  Name: " + throwable.getClass().getName() + ", message: " + throwable.getMessage()}, true, throwable);
            licenseParamInfo = null;
        }
        return licenseParamInfo;
    }

    LicenseParamInfo makeLicenseParams(HashMap hashMap) {
        LicenseParamInfo licenseParamInfo = new LicenseParamInfo();
        try {
            boolean bl;
            String string = null;
            long l = -1L;
            string = (String)hashMap.get("quota");
            if (string != null) {
                licenseParamInfo.setQuotaLimited(true);
                l = this.getPositiveLong(string, "quota");
                if (l <= (long)0) {
                    LicenseParamInfo licenseParamInfo2 = null;
                    return licenseParamInfo2;
                }
                licenseParamInfo.setQuota(l);
                string = (String)hashMap.get("quota-grace");
                if (string != null) {
                    l = this.getPositiveLong(string, "quota-grace");
                    if (l < (long)0) {
                        LicenseParamInfo licenseParamInfo3 = null;
                        return licenseParamInfo3;
                    }
                    licenseParamInfo.setQuotaGrace(l);
                }
                if ((string = (String)hashMap.get("quota-warn-threshold")) != null) {
                    l = this.getPositiveLong(string, "quota-warn-threshold");
                    if (l < (long)0) {
                        LicenseParamInfo licenseParamInfo4 = null;
                        return licenseParamInfo4;
                    }
                    licenseParamInfo.setQuotaWarningThreshold(l);
                }
            }
            Date date = null;
            boolean bl2 = hashMap.get("exp-date") != null;
            boolean bl3 = bl = hashMap.get("exp-days") != null;
            if (bl2 && bl) {
                this._$2794.setStatusInfo(100, "Time limited license can't be both absolute and relative");
                LicenseParamInfo licenseParamInfo5 = null;
                return licenseParamInfo5;
            }
            licenseParamInfo.setTimeLimitType(bl2 ? "ABST" : (bl ? "RELT" : "NONE"));
            if (bl2) {
                date = IlsUtil.GetDate((String)hashMap.get("exp-date"), "yyyy-MM-dd");
                if (date == null) {
                    this._$2794.setStatusInfo(100, "Invalid date format value '" + (String)hashMap.get("exp-date") + "' specified for expiration date - expected format yyyy-mm-dd.");
                    LicenseParamInfo licenseParamInfo6 = null;
                    return licenseParamInfo6;
                }
                licenseParamInfo.setExpDate(new Timestamp(date.getTime()));
            } else if (bl && (string = (String)hashMap.get("exp-days")) != null) {
                l = this.getPositiveLong(string, "exp-days");
                if (l <= (long)0) {
                    LicenseParamInfo licenseParamInfo7 = null;
                    return licenseParamInfo7;
                }
                licenseParamInfo.setExpDays(l);
            }
            if (bl2 || bl) {
                string = (String)hashMap.get("exp-grace");
                if (string != null) {
                    l = this.getPositiveLong(string, "exp-grace");
                    if (l < (long)0) {
                        LicenseParamInfo licenseParamInfo8 = null;
                        return licenseParamInfo8;
                    }
                    licenseParamInfo.setExpGrace((int)l);
                }
                if ((string = (String)hashMap.get("exp-warn-threshold")) != null) {
                    l = this.getPositiveLong(string, "exp-warn-threshold");
                    if (l < (long)0) {
                        LicenseParamInfo licenseParamInfo9 = null;
                        return licenseParamInfo9;
                    }
                    licenseParamInfo.setExpWarningThreshold((int)l);
                }
            }
        }
        catch (Throwable throwable) {
            this._$2794.setStatusInfo(1000, "Unexpected exception while assembling license params.\nException: " + throwable.getClass().getName() + "\nMessage: " + throwable.getMessage());
            LicenseParamInfo licenseParamInfo10 = null;
            return licenseParamInfo10;
        }
        return licenseParamInfo;
    }

    long getPositiveLong(String string, String string2) {
        long l = IlsUtil.GetPositiveLong(string);
        if (l <= (long)0) {
            this._$2794.setStatusInfo(100, "Invalid numeric value '" + string + "' for attribute '" + string2 + "'");
        }
        return l;
    }

    static String getAuthLevelDescr(int n) {
        switch (n) {
            case 1: {
                return "PUBLIC";
            }
            case 2: {
                return "USER ADMINISTRATOR";
            }
            case 3: {
                return "PRODUCT ADMINISTRATOR";
            }
            case 4: {
                return "SERVICE SYSTEM ADMINISTRATOR";
            }
            case 5: {
                return "AGILIS-INTERNAL";
            }
        }
        return "***UNKNOWN (please report bug) ***";
    }

    static boolean doPropagate(LicenseParamInfo licenseParamInfo, long l, long l2, long l3, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) throws WdoBaseException {
        IlsUtil.Trace(8, "IlsAdminAPI", "doPropagate: enter.  License Params:\n" + licenseParamInfo.toXML() + ", newExpTs=" + l + ", newExpDays=" + l2 + ", newQuota=" + l3 + ", newOptions=" + string + ", propExpiration=" + bl2 + ", propQuota=" + bl3 + ", propOptions=" + bl4 + ", inhibitSys=" + bl5 + ", hosted=" + bl);
        boolean bl6 = false;
        if (bl2 && !licenseParamInfo.getTimeLimitType().equals("NONE")) {
            licenseParamInfo.setTimeLimitType("NONE");
            licenseParamInfo.expDateUndefine();
            licenseParamInfo.setExpDays(-1L);
            bl6 = true;
        }
        if (bl3) {
            if (l3 < (long)0) {
                if (licenseParamInfo.getQuotaLimited()) {
                    licenseParamInfo.setQuotaLimited(false);
                    IlsUtil.Trace(10, "IlsAdminAPI", "doPropagate: converting quota limit to no-quota-limit");
                    bl6 = true;
                }
            } else if (!licenseParamInfo.getQuotaLimited()) {
                licenseParamInfo.setQuotaLimited(true);
                licenseParamInfo.setQuota(l3);
                IlsUtil.Trace(10, "IlsAdminAPI", "doPropagate: converting non-quota limit to quota-limit of " + l3);
                bl6 = true;
            } else if (licenseParamInfo.getQuota() != l3) {
                IlsUtil.Trace(10, "IlsAdminAPI", "doPropagate: adjusting quota limit from " + licenseParamInfo.getQuota() + " to " + l3);
                licenseParamInfo.setQuota(l3);
                bl6 = true;
            }
        }
        if (bl4) {
            String string2;
            boolean bl7 = false;
            if (string == null) {
                string = "";
            }
            String string3 = string2 = licenseParamInfo.optionsIsDefined() ? licenseParamInfo.getOptions() : "";
            if (!string2.equals(string)) {
                String[] stringArray = string.split(";");
                String string4 = null;
                int n = 0;
                while (n < stringArray.length) {
                    String[] stringArray2 = stringArray[n].split("=");
                    if (!stringArray2[0].startsWith("ILS:") || !bl5 && stringArray2[0].equals("ILS:SOFT-USER-LIMIT")) {
                        string4 = string4 == null ? "" : String.valueOf(string4) + ";";
                        string4 = String.valueOf(string4) + stringArray2[0] + "=" + stringArray2[1];
                    }
                    ++n;
                }
                IlsUtil.Trace(10, "IlsAdminAPI", "doPropagate: adjusting options from old value:\n'" + string2 + "'\nto new value:\n" + string4 + "\n(input options:\n" + string + ")");
                licenseParamInfo.setOptions(string4);
                bl6 = true;
            }
        }
        return bl6;
    }

    public static class IlsCopyState
    implements Cloneable {
        public static final int COPY_STATE_INITIAL = 0;
        public static final int COPY_STATE_DOAUDITS = 1;
        public static final int COPY_STATE_DOHOSTS = 2;
        public static final int COPY_STATE_DOPRODUCTS = 3;
        public static final int COPY_STATE_ALLDONE = 4;
        long createTs;
        long updateTs;
        long productsAdded;
        long productsUpdated;
        long domainsAdded;
        long domainsUpdated;
        long usersAdded;
        long usersUpdated;
        long hostrulesAdded;
        long hostrulesUpdated;
        long auditsAdded;
        long lastProductId;
        long lastDomainId;
        long lastUserId;
        long lastHostRuleId;
        long lastAuditId;
        int state;
        String srcService;
        String destService;
        IlsCmdArgs srcCmdArgs;
        IlsCmdArgs destCmdArgs;
        Properties props;
        static IlsCopyState currCopyState;

        public Object clone() {
            try {
                Object object = super.clone();
                return object;
            }
            catch (Throwable throwable) {
                return null;
            }
        }

        IlsCopyState(String string, String string2, IlsCmdArgs ilsCmdArgs, IlsCmdArgs ilsCmdArgs2) {
            this.srcService = string;
            this.destService = string2;
            this.srcCmdArgs = ilsCmdArgs;
            this.destCmdArgs = ilsCmdArgs2;
        }

        public static synchronized IlsCopyState GetCopyState(String string, String string2, IlsCmdArgs ilsCmdArgs, IlsCmdArgs ilsCmdArgs2) {
            return IlsCopyState.GetCopyState(string, string2, ilsCmdArgs, ilsCmdArgs2, true);
        }

        /*
         * Loose catch block
         */
        public static synchronized IlsCopyState GetCopyState(String string, String string2, IlsCmdArgs ilsCmdArgs, IlsCmdArgs ilsCmdArgs2, boolean bl) {
            IlsCopyState ilsCopyState;
            block35: {
                Object object2222;
                block32: {
                    String string3;
                    block34: {
                        if (currCopyState != null) {
                            return currCopyState;
                        }
                        ilsCopyState = new IlsCopyState(string, string2, ilsCmdArgs, ilsCmdArgs2);
                        ilsCopyState.props = new Properties();
                        string3 = IlsCopyState._$14268(string, string2);
                        File file = new File(string3);
                        if (file.exists()) break block34;
                        if (!bl) {
                            return null;
                        }
                        try {
                            file.createNewFile();
                        }
                        catch (IOException iOException) {
                            ilsCmdArgs2.setStatusInfo(1002, "Could not create property file '" + string3 + "'.  Exception: " + iOException.getClass().getName() + ", Message: " + iOException.getMessage());
                            IlsCopyState ilsCopyState2 = null;
                            return ilsCopyState2;
                        }
                        Date date = new Date();
                        ilsCopyState.createTs = date.getTime();
                        ilsCopyState.updateTs = date.getTime();
                        ilsCopyState.saveCopyState();
                        break block35;
                    }
                    FileInputStream fileInputStream = null;
                    fileInputStream = new FileInputStream(string3);
                    ilsCopyState.props.load(fileInputStream);
                    Object var12_13 = null;
                    try {
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                        break block32;
                    }
                    catch (Throwable object2222) {}
                    break block32;
                    {
                        catch (Exception exception) {
                            ilsCmdArgs2.setStatusInfo(1002, "Could not load property file.  Exception: " + exception.getClass().getName() + ", Message: " + exception.getMessage());
                            IlsCopyState ilsCopyState3 = null;
                            Object var12_14 = null;
                            try {
                                if (fileInputStream != null) {
                                    fileInputStream.close();
                                }
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            return ilsCopyState3;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var12_15 = null;
                        try {
                            if (fileInputStream != null) {
                                fileInputStream.close();
                            }
                        }
                        catch (Throwable throwable2) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
                object2222 = null;
                object2222 = ilsCopyState.props.getProperty("createTs");
                if (object2222 != null) {
                    ilsCopyState.createTs = IlsUtil.GetPositiveLong((String)object2222);
                }
                if ((object2222 = ilsCopyState.props.getProperty("updateTs")) != null) {
                    ilsCopyState.updateTs = IlsUtil.GetPositiveLong((String)object2222);
                }
                if ((object2222 = ilsCopyState.props.getProperty("productsAdded")) != null) {
                    ilsCopyState.productsAdded = IlsUtil.GetPositiveLong((String)object2222);
                }
                if ((object2222 = ilsCopyState.props.getProperty("productsUpdated")) != null) {
                    ilsCopyState.productsUpdated = IlsUtil.GetPositiveLong((String)object2222);
                }
                if ((object2222 = ilsCopyState.props.getProperty("domainsAdded")) != null) {
                    ilsCopyState.domainsAdded = IlsUtil.GetPositiveLong((String)object2222);
                }
                if ((object2222 = ilsCopyState.props.getProperty("domainsUpdated")) != null) {
                    ilsCopyState.domainsUpdated = IlsUtil.GetPositiveLong((String)object2222);
                }
                if ((object2222 = ilsCopyState.props.getProperty("usersAdded")) != null) {
                    ilsCopyState.usersAdded = IlsUtil.GetPositiveLong((String)object2222);
                }
                if ((object2222 = ilsCopyState.props.getProperty("usersUpdated")) != null) {
                    ilsCopyState.usersUpdated = IlsUtil.GetPositiveLong((String)object2222);
                }
                if ((object2222 = ilsCopyState.props.getProperty("hostrulesAdded")) != null) {
                    ilsCopyState.hostrulesAdded = IlsUtil.GetPositiveLong((String)object2222);
                }
                if ((object2222 = ilsCopyState.props.getProperty("hostrulesUpdated")) != null) {
                    ilsCopyState.hostrulesUpdated = IlsUtil.GetPositiveLong((String)object2222);
                }
                if ((object2222 = ilsCopyState.props.getProperty("auditsAdded")) != null) {
                    ilsCopyState.auditsAdded = IlsUtil.GetPositiveLong((String)object2222);
                }
                if ((object2222 = ilsCopyState.props.getProperty("lastProductId")) != null) {
                    ilsCopyState.lastProductId = IlsUtil.GetPositiveLong((String)object2222);
                }
                if ((object2222 = ilsCopyState.props.getProperty("lastDomainId")) != null) {
                    ilsCopyState.lastDomainId = IlsUtil.GetPositiveLong((String)object2222);
                }
                if ((object2222 = ilsCopyState.props.getProperty("lastUserId")) != null) {
                    ilsCopyState.lastUserId = IlsUtil.GetPositiveLong((String)object2222);
                }
                if ((object2222 = ilsCopyState.props.getProperty("lastHostRuleId")) != null) {
                    ilsCopyState.lastHostRuleId = IlsUtil.GetPositiveLong((String)object2222);
                }
                if ((object2222 = ilsCopyState.props.getProperty("lastAuditId")) != null) {
                    ilsCopyState.lastAuditId = IlsUtil.GetPositiveLong((String)object2222);
                }
                if ((object2222 = ilsCopyState.props.getProperty("state")) != null) {
                    ilsCopyState.state = (int)IlsUtil.GetPositiveLong((String)object2222);
                }
            }
            currCopyState = ilsCopyState;
            return ilsCopyState;
        }

        /*
         * Loose catch block
         */
        public boolean saveCopyState() {
            block13: {
                if (currCopyState != this && currCopyState != null) {
                    this.srcCmdArgs.setStatusInfo(1000, "Internal error: invalid / mismatched copy state");
                    return false;
                }
                if (currCopyState == null) {
                    currCopyState = this;
                }
                Date date = new Date();
                this.updateTs = date.getTime();
                this.props.setProperty("createTs", String.valueOf(this.createTs));
                this.props.setProperty("updateTs", String.valueOf(this.updateTs));
                this.props.setProperty("productsAdded", String.valueOf(this.productsAdded));
                this.props.setProperty("productsUpdated", String.valueOf(this.productsUpdated));
                this.props.setProperty("domainsAdded", String.valueOf(this.domainsAdded));
                this.props.setProperty("domainsUpdated", String.valueOf(this.domainsUpdated));
                this.props.setProperty("usersAdded", String.valueOf(this.usersAdded));
                this.props.setProperty("usersUpdated", String.valueOf(this.usersUpdated));
                this.props.setProperty("hostrulesAdded", String.valueOf(this.hostrulesAdded));
                this.props.setProperty("hostrulesUpdated", String.valueOf(this.hostrulesUpdated));
                this.props.setProperty("auditsAdded", String.valueOf(this.auditsAdded));
                this.props.setProperty("lastProductId", String.valueOf(this.lastProductId));
                this.props.setProperty("lastDomainId", String.valueOf(this.lastDomainId));
                this.props.setProperty("lastUserId", String.valueOf(this.lastUserId));
                this.props.setProperty("lastHostRuleId", String.valueOf(this.lastHostRuleId));
                this.props.setProperty("lastAuditId", String.valueOf(this.lastAuditId));
                this.props.setProperty("state", String.valueOf(this.state));
                String string = IlsCopyState._$14268(this.srcService, this.destService);
                FileOutputStream fileOutputStream = null;
                fileOutputStream = new FileOutputStream(string);
                this.props.store(fileOutputStream, "Orion Db Migration State " + this.srcService + "->" + this.destService + "\n" + "Created " + new SimpleDateFormat("yyyy-MM-dd HH:MM:ss z").format(new Date(this.createTs)) + "\n" + "Modified " + new SimpleDateFormat("yyyy-MM-dd HH:MM:ss z").format(new Date(this.updateTs)));
                fileOutputStream.flush();
                Object var7_4 = null;
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                    break block13;
                }
                catch (Throwable throwable) {}
                break block13;
                {
                    catch (Exception exception) {
                        this.destCmdArgs.setStatusInfo(1002, "Could not save property file.  Exception: " + exception.getClass().getName() + ", Message: " + exception.getMessage());
                        boolean bl = false;
                        Object var7_5 = null;
                        try {
                            if (fileOutputStream != null) {
                                fileOutputStream.close();
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        return bl;
                    }
                }
                catch (Throwable throwable) {
                    Object var7_6 = null;
                    try {
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            return true;
        }

        public static boolean CloseCopyState() {
            return IlsCopyState.CloseCopyState(false);
        }

        public static boolean CloseCopyState(boolean bl) {
            String string;
            String string2;
            File file;
            IlsCopyState.currCopyState.state = 4;
            currCopyState.saveCopyState();
            if (bl && !(file = new File(string2 = IlsCopyState._$14268(IlsCopyState.currCopyState.srcService, IlsCopyState.currCopyState.destService))).renameTo(new File(string = String.valueOf(string2) + "." + new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss").format(new Date())))) {
                IlsUtil.Trace(3, "IlsAdminAPI", "CloseCopyState: could not rename file '" + string2 + "' to '" + string + "'");
                IlsCopyState.currCopyState.destCmdArgs.setStatusInfo(1002, "could not rename file '" + string2 + "' to '" + string + "'");
                return false;
            }
            currCopyState = null;
            return true;
        }

        public static void DropCopyState() {
            String string = IlsCopyState._$14268(IlsCopyState.currCopyState.srcService, IlsCopyState.currCopyState.destService);
            File file = new File(string);
            file.delete();
            currCopyState = null;
        }

        public long getProductsAdded() {
            return this.productsAdded;
        }

        public long getProductsUpdated() {
            return this.productsUpdated;
        }

        public long getDomainsAdded() {
            return this.domainsAdded;
        }

        public long getDomainsUpdated() {
            return this.domainsUpdated;
        }

        public long getUsersAdded() {
            return this.usersAdded;
        }

        public long getUsersUpdated() {
            return this.usersUpdated;
        }

        public long getHostrulesAdded() {
            return this.hostrulesAdded;
        }

        public long getHostrulesUpdated() {
            return this.hostrulesUpdated;
        }

        public long getAuditsAdded() {
            return this.auditsAdded;
        }

        public int getState() {
            return this.state;
        }

        public long getCreateTs() {
            return this.createTs;
        }

        private static String _$14268(String string, String string2) {
            String string3 = string.replace('/', '.').replace('\\', '.');
            String string4 = string2.replace('/', '.').replace('\\', '.');
            return String.valueOf(System.getProperty("user.home")) + System.getProperty("file.separator") + "ilsmig_" + string3 + "_" + string4 + ".ini";
        }
    }
}

