/*
 * Decompiled with CFR 0.152.
 */
package com.vs.ils;

import com.vs.ils.AlerterJob;
import com.vs.ils.IlsCmdAPI;
import com.vs.ils.IlsCmdArgs;
import com.vs.ils.IlsException;
import com.vs.ils.IlsReportHandler;
import com.vs.ils.IlsToken;
import com.vs.ils.IlsUtil;
import com.vs.ils.ilsdb.Domain;
import com.vs.ils.ilsdb.Product;
import com.vs.wdo.rtl.WdoBaseException;
import com.vs.wdo.rtl.WdoUnitOfWork;
import java.util.Date;

class ExecreportLuw
implements WdoUnitOfWork {
    ExecreportLuw() {
    }

    public void doIt(int n, Object[] objectArray) throws WdoBaseException {
        Domain domain;
        IlsCmdAPI ilsCmdAPI = (IlsCmdAPI)objectArray[0];
        IlsCmdArgs ilsCmdArgs = ilsCmdAPI.getCmdArgs();
        Date date = new Date();
        String string = ilsCmdArgs.getProduct();
        String string2 = ilsCmdArgs.getDomain();
        String string3 = ilsCmdArgs.getReportName();
        String string4 = ilsCmdArgs.getReportParams();
        String string5 = ilsCmdArgs.getReportResultName();
        IlsToken ilsToken = ilsCmdAPI.parseToken(true);
        ilsCmdArgs.setToken(null);
        IlsUtil.Trace(10, "ExecreportCmd", "ExecreportLuw: domain name after parseToken: " + ilsCmdArgs.getDomain());
        int n2 = string.equalsIgnoreCase("system") ? 4 : (string2 == null || string2.equalsIgnoreCase("system") ? 3 : 2);
        Product product = ilsCmdAPI.checkGetProduct();
        long l = product.getProductId();
        IlsUtil.Trace(10, "ExecreportCmd", "ExecreportLuw: domain name just before checkgetdomain: " + ilsCmdArgs.getDomain());
        Domain domain2 = domain = string2 == null ? null : ilsCmdAPI.checkGetDomain(product);
        if (ilsToken.getAuthLevel() < n2) {
            ilsCmdArgs.setStatusInfo(31, "You do not have sufficient privileges to perform this operation", null, AlerterJob.MakeEventParams(product.getName(), string2));
            WdoBaseException.ThrowProxyWdoException((int)12);
        }
        if (domain != null && ilsToken.getAuthLevel() == 2 && domain.getDomainId() != ilsToken.getDomainId()) {
            ilsCmdArgs.setStatusInfo(31, "Insufficient privileges to perform reports on domain '" + string2 + "'.  Your domain administration privileges are limited to your assigned domain '" + Domain.GetDomain((long)ilsToken.getDomainId()).getName(), null, AlerterJob.MakeEventParams(product.getName(), string2));
            WdoBaseException.ThrowProxyWdoException((int)12);
        }
        IlsReportHandler ilsReportHandler = null;
        try {
            ilsReportHandler = (IlsReportHandler)Class.forName("com.vs.ils." + IlsUtil.ToUpperStart(string3) + "Report").newInstance();
            ilsCmdArgs.setParams(ilsReportHandler.processReport(ilsCmdArgs, string3, string4, string5, product, domain));
        }
        catch (InstantiationException instantiationException) {
            ilsCmdArgs.setStatusInfo(35, "Report '" + string3 + "' is not supported or is not valid with the specified parameters");
        }
        catch (IlsException ilsException) {
        }
        catch (Throwable throwable) {
            IlsUtil.Trace(false, 5, "ExecreportCmd", new String[]{"Unexpected exception instantiating report handler for report " + string3 + ".  Stack Trace: "}, true, throwable);
            ilsCmdArgs.setStatusInfo(1000, "Internal error.  Please have your administrator contact Orion technical support with the following details: Could not instantiate report handler for report [" + string3 + "]" + "\nException: " + throwable.getClass().getName() + "\nMessage: " + throwable.getMessage());
        }
        if (ilsCmdArgs.getStatus() > 0) {
            WdoBaseException.ThrowProxyWdoException((int)12);
        }
    }
}

