/*
 * Decompiled with CFR 0.152.
 */
package com.vs.ils;

import com.vs.ils.AlerterJob;
import com.vs.ils.DomainLicenseCacheEntry;
import com.vs.ils.IlsAdminAPI;
import com.vs.ils.IlsCmdAPI;
import com.vs.ils.IlsCmdArgs;
import com.vs.ils.IlsLicenseCache;
import com.vs.ils.UserCleanupJob;
import com.vs.ils.ilsdb.Domain;
import com.vs.ils.ilsdb.Product;
import com.vs.ils.ilsdb.User;
import com.vs.wdo.rtl.WdoBaseException;
import com.vs.wdo.rtl.WdoUnitOfWork;
import java.util.Date;

class DropUserXLuw
implements WdoUnitOfWork {
    DropUserXLuw() {
    }

    public void doIt(int n, Object[] objectArray) throws WdoBaseException {
        IlsAdminAPI ilsAdminAPI = (IlsAdminAPI)objectArray[0];
        IlsCmdArgs ilsCmdArgs = ilsAdminAPI.getCmdArgs();
        Object[] objectArray2 = (Object[])objectArray[1];
        long l = (Long)objectArray2[0];
        long l2 = (Long)objectArray2[1];
        long l3 = (Long)objectArray2[2];
        int n2 = (Integer)objectArray2[3];
        Date date = new Date();
        if (!UserCleanupJob.DoingUserCleanup(ilsCmdArgs)) {
            WdoBaseException.ThrowProxyWdoException((int)12);
        }
        try {
            User user = User.GetUser((long)l);
            String string = user.getName();
            ilsAdminAPI.checkAuthorization(string != null && string.startsWith("useradmin") ? 3 : 2);
            Product product = Product.GetProduct((long)l3);
            Domain domain = Domain.GetDomain((long)l2);
            boolean bl = IlsCmdAPI.CheckUserCheckedOut(date, user);
            boolean bl2 = IlsCmdAPI.CheckUserCheckedOutAndDead(date, user);
            int n3 = -user.getPoints();
            boolean bl3 = product.getName().equals("system");
            boolean bl4 = domain.getName().equals("system");
            boolean bl5 = domain.getLicenseModel().equals("NUSER");
            boolean bl6 = bl5 && string.equals("useradmin");
            boolean bl7 = bl3 || bl4 || bl6;
            ilsAdminAPI.checkNoAudit(product);
            User.Drop((long)l);
            if (bl || bl2) {
                if (bl) {
                    int n4;
                    int n5 = bl3 ? n2 : (n4 = IlsCmdAPI.getCancelAuthLevel(product.optionsIsDefined() ? product.getOptions() : null));
                    if (n2 < n4) {
                        ilsCmdArgs.setStatusInfo(18, "Insufficient privilege level for dropping a checked-out user", null, AlerterJob.MakeEventParams(product.getName(), domain.getName(), string));
                        WdoBaseException.ThrowProxyWdoException((int)12);
                    }
                }
                if (!bl7) {
                    DomainLicenseCacheEntry domainLicenseCacheEntry = IlsLicenseCache.getDomainCacheEntry(date, product, domain);
                    if (bl5) {
                        domainLicenseCacheEntry.adjustWatermark(date, domain, n3, true);
                    } else {
                        if (bl) {
                            domainLicenseCacheEntry.adjustCheckoutWatermark(date, domain, n3, true);
                        }
                        domainLicenseCacheEntry.adjustWatermark(date, domain, -1, true);
                    }
                }
            } else if (!bl5 && !bl7) {
                DomainLicenseCacheEntry domainLicenseCacheEntry = IlsLicenseCache.getDomainCacheEntry(date, product, domain);
                domainLicenseCacheEntry.adjustWatermark(date, domain, -1, true);
            }
            Object var28_26 = null;
        }
        catch (Throwable throwable) {
            Object var28_27 = null;
            UserCleanupJob.DoneUserCleanup();
            throw throwable;
        }
        UserCleanupJob.DoneUserCleanup();
    }
}

