/*
 * Decompiled with CFR 0.152.
 */
package com.vs.ils;

import com.vs.ils.AlerterJob;
import com.vs.ils.IlsAdminAPI;
import com.vs.ils.IlsCmdArgs;
import com.vs.ils.IlsLicenseCache;
import com.vs.ils.IlsUtil;
import com.vs.ils.ProductLicenseCacheEntry;
import com.vs.ils.ilsdb.Domain;
import com.vs.ils.ilsdb.Product;
import com.vs.ils.ilsdb.User;
import com.vs.wdo.rtl.WdoBaseException;
import com.vs.wdo.rtl.WdoUnitOfWork;
import java.util.Date;

class DropDomainLuw
implements WdoUnitOfWork {
    DropDomainLuw() {
    }

    public void doIt(int n, Object[] objectArray) throws WdoBaseException {
        IlsAdminAPI ilsAdminAPI = (IlsAdminAPI)objectArray[0];
        IlsCmdArgs ilsCmdArgs = ilsAdminAPI.getCmdArgs();
        Object[] objectArray2 = (Object[])objectArray[1];
        String string = (String)objectArray2[0];
        String string2 = (String)objectArray2[1];
        ilsAdminAPI.checkAuthorization(3);
        IlsUtil.Trace(5, "IlsAdminAPI", "DropDomainLuw: dropping for product name pattern: " + string + ", domain name pattern: " + string2);
        long l = Product.FindAnyByName((String)string);
        if (l == (long)0) {
            IlsUtil.Trace(5, "IlsAdminAPI", "DropDomainLuw: product: '" + string + "' not found!");
            ilsCmdArgs.setStatusInfo(102, "Product '" + string + "' has disappeared", null, AlerterJob.MakeEventParams(string, string2));
            return;
        }
        Product product = Product.GetProduct((long)l);
        ilsAdminAPI.checkNoAudit(product);
        long l2 = Domain.FindByName((String)string, (String)string2);
        long l3 = User.DropMatching((String)string, (String)string2, (String)"%");
        IlsUtil.Trace(5, "IlsAdminAPI", "DropDomainLuw: dropped " + l3 + " users");
        long l4 = Domain.DropMatching((String)string, (String)string2);
        ilsCmdArgs.setStatusInfo(-101, "Number of domains dropped: ", String.valueOf(l4), AlerterJob.MakeEventParams(string, string2));
        if (l2 > (long)0) {
            boolean bl = Domain.GetDomain((long)l2).getName().equals("system");
            Domain.Drop((long)l2);
            if (!bl) {
                ProductLicenseCacheEntry productLicenseCacheEntry = IlsLicenseCache.getProductCacheEntry(new Date(), product);
                productLicenseCacheEntry.dropDomainEntry(l2);
            }
        }
    }
}

