/*
 * Decompiled with CFR 0.152.
 */
package com.vs.ils;

import com.vs.ils.AlerterJob;
import com.vs.ils.IlsCmdAPI;
import com.vs.ils.IlsCmdArgs;
import com.vs.ils.IlsJob;
import com.vs.ils.IlsUtil;
import com.vs.ils.ProductLicenseCacheEntry;
import com.vs.ils.ilsdb.AggInfo;
import com.vs.ils.ilsdb.DomLicPCache;
import com.vs.ils.ilsdb.Domain;
import com.vs.ils.ilsdb.Product;
import com.vs.wdo.rtl.WdoBaseException;
import java.util.Date;

class DomainLicenseCacheEntry {
    Date lastRefreshTime;
    boolean anonDomain;
    DomLicPCache pcache;
    ProductLicenseCacheEntry prodCache;

    public static synchronized DomainLicenseCacheEntry DomainLicenseCacheFactory(Date date, ProductLicenseCacheEntry productLicenseCacheEntry, Domain domain) throws WdoBaseException {
        DomLicPCache domLicPCache = DomLicPCache.Load((long)domain.getDomainId(), (long)date.getTime());
        DomainLicenseCacheEntry domainLicenseCacheEntry = new DomainLicenseCacheEntry(date, productLicenseCacheEntry, domain, domLicPCache);
        if (domainLicenseCacheEntry.getLicenseLimit() == (long)0) {
            domainLicenseCacheEntry.refresh(date, domain);
        }
        return domainLicenseCacheEntry;
    }

    public void refresh(Date date, Domain domain) throws WdoBaseException {
        long l = 0L;
        while ((l = this.anonDomain ? domain.cleanupDeadCheckoutUsers(date.getTime()) : domain.cleanupDeadCheckoutNamedUsers(date.getTime())) > (long)0) {
        }
        this.pcache.setDomainName(domain.getName());
        this.pcache.setLicenseLimit((long)domain.getUserLimit());
        Date date2 = new Date();
        AggInfo aggInfo = domain.getCheckoutUserCounts(date.getTime());
        Date date3 = new Date();
        IlsUtil.Trace(7, "DomLicenseCacheEntry", "refresh: time to getCheckoutUserCounts: " + String.valueOf(date3.getTime() - date2.getTime()) + ".");
        long l2 = aggInfo.getWeightedCount();
        long l3 = aggInfo.getActualCount();
        if (this.anonDomain) {
            this.pcache.setHighWatermark(l2);
            this.pcache.setCheckoutHiWatermark(this.pcache.getHighWatermark());
            this.pcache.setCheckoutActualHiWatermark(l3);
        } else {
            date2 = date3;
            this.pcache.setHighWatermark((long)domain.getTotalUserCount());
            date3 = new Date();
            IlsUtil.Trace(7, "DomainLicenseCacheEntry", "refresh: time to getTotalUserCount: " + String.valueOf(date3.getTime() - date2.getTime()) + ".");
            this.pcache.setCheckoutHiWatermark(l2);
            this.pcache.setCheckoutActualHiWatermark(l3);
            this.pcache.setDisabledUserHiWatermark((long)domain.getUserCount(true, false));
        }
        if (this.pcache.getCheckoutHiWatermark() > this.pcache.getPeakUsageSample()) {
            this.pcache.setPeakUsageSample(this.pcache.getCheckoutHiWatermark());
        }
        this.lastRefreshTime = date;
    }

    public DomainLicenseCacheEntry(Date date, ProductLicenseCacheEntry productLicenseCacheEntry, Domain domain, DomLicPCache domLicPCache) throws WdoBaseException {
        this.prodCache = productLicenseCacheEntry;
        this.pcache = domLicPCache;
        this.anonDomain = domain.getLicenseModel().equals("NUSER");
    }

    public synchronized boolean checkLimit(Date date, IlsCmdArgs ilsCmdArgs, Product product, Domain domain, int n, long l) throws WdoBaseException {
        return this.checkLimit(date, ilsCmdArgs, product, domain, n, l, 0);
    }

    public synchronized boolean checkLimit(Date date, IlsCmdArgs ilsCmdArgs, Product product, Domain domain, int n, long l, int n2) throws WdoBaseException {
        if (this.pcache.getLicenseLimit() != l) {
            this.pcache.setLicenseLimit(l);
        }
        long l2 = this.pcache.getHighWatermark() + (long)n - (long)n2;
        boolean bl = true;
        if (l2 <= l) {
            long l3;
            long l4;
            long l5 = product.optionsIsDefined() ? IlsCmdAPI.GetIlsLongOption(product.getOptions(), "ILS:SOFT-USER-LIMIT") : -1L;
            long l6 = l4 = domain.getLicenseParams().optionsIsDefined() ? IlsCmdAPI.GetIlsLongOption(domain.getLicenseParams().getOptions(), "ILS:SOFT-USER-LIMIT") : -1L;
            long l7 = l5 < (long)0 ? l4 : (l4 < (long)0 ? l5 : (l3 = l5 < l4 ? l5 : l4));
            if (l3 >= (long)0 && l2 > l3) {
                ilsCmdArgs.setStatusInfo(-8, "Current weighted user count of " + l2 + " for domain " + domain.getName() + " (product " + product.getName() + ")" + " has exceeded " + "license soft limit of " + l3 + " and is approaching the " + "hard limit of " + l + " weighted users.", null, AlerterJob.MakeEventParams(product.getName(), domain.getName()));
            } else if (l2 == l) {
                ilsCmdArgs.setStatusInfo(-8, "Current weighted user count of " + l2 + " for domain " + domain.getName() + " (product " + product.getName() + ")" + " has reached the " + "hard limit of " + l + " weighted users.", null, AlerterJob.MakeEventParams(product.getName(), domain.getName()));
            } else {
                bl = false;
            }
        }
        if (l2 > (long)0 && bl) {
            String string = ilsCmdArgs.serviceName;
            if (string == null) {
                string = "default";
            }
            IlsCmdArgs ilsCmdArgs2 = new IlsCmdArgs();
            ilsCmdArgs2.setServiceName(string);
            IlsUtil.Trace(9, "IlsLicenseCache", "checkLimit: triggering user cleanup job with schedule event trigger");
            IlsJob.TriggerEvent("UserCleanup", ilsCmdArgs2, string, "Schedule", null, null);
        }
        return l2 <= l;
    }

    public long getCurrLimit() throws WdoBaseException {
        return this.pcache.getHighWatermark();
    }

    public synchronized void setLicenseLimit(long l) throws WdoBaseException {
        if (l >= (long)0) {
            this.pcache.setLicenseLimit(l);
        }
    }

    public synchronized long getLicenseLimit() throws WdoBaseException {
        return this.pcache.getLicenseLimit();
    }

    public synchronized void adjustWatermark(Date date, Domain domain, int n, boolean bl) throws WdoBaseException {
        this.adjustWatermark2(date, domain, n, n > 0 ? 1 : (n < 0 ? -1 : 0), bl);
    }

    public synchronized void adjustWatermark2(Date date, Domain domain, int n, int n2, boolean bl) throws WdoBaseException {
        this.adjustWatermark2(date, domain, n, n2);
        if (bl) {
            this.prodCache.adjustWatermark2(date, Product.GetProduct((long)this.prodCache.pcache.getProductId()), n, n2, domain.getLicenseModel().equals("NUSER"));
        }
    }

    public synchronized void adjustWatermark(Date date, Domain domain, int n) throws WdoBaseException {
        if (n == 0) {
            return;
        }
        if (this.pcache.getHighWatermark() + (long)n >= (long)0) {
            this.pcache.setHighWatermark(this.pcache.getHighWatermark() + (long)n);
        }
        if (this.anonDomain && n != 0) {
            this.adjustCheckoutWatermark(date, domain, n);
        }
    }

    public synchronized void adjustWatermark2(Date date, Domain domain, int n, int n2) throws WdoBaseException {
        if (n == 0 || n2 == 0) {
            return;
        }
        if (this.pcache.getHighWatermark() + (long)n >= (long)0) {
            this.pcache.setHighWatermark(this.pcache.getHighWatermark() + (long)n);
        }
        if (this.anonDomain) {
            this.adjustCheckoutWatermark2(date, domain, n, n2);
        }
    }

    public void adjustCheckoutWatermark(Date date, Domain domain, int n, boolean bl) throws WdoBaseException {
        this.adjustCheckoutWatermark2(date, domain, n, n > 0 ? 1 : (n < 0 ? -1 : 0), bl);
    }

    public synchronized void adjustCheckoutWatermark2(Date date, Domain domain, int n, int n2, boolean bl) throws WdoBaseException {
        this.adjustCheckoutWatermark2(date, domain, n, n2);
        if (bl) {
            this.prodCache.adjustCheckoutWatermark2(date, Product.GetProduct((long)this.prodCache.pcache.getProductId()), n, n2);
        }
    }

    public void adjustCheckoutWatermark(Date date, Domain domain, int n) throws WdoBaseException {
        this.adjustCheckoutWatermark2(date, domain, n, n > 0 ? 1 : (n < 0 ? -1 : 0));
    }

    public void adjustCheckoutWatermark2(Date date, Domain domain, int n, int n2) throws WdoBaseException {
        if (n == 0 || n2 == 0) {
            return;
        }
        if (this.pcache.getCheckoutHiWatermark() + (long)n >= (long)0) {
            this.pcache.setCheckoutHiWatermark(this.pcache.getCheckoutHiWatermark() + (long)n);
        }
        if (this.pcache.getCheckoutActualHiWatermark() + (long)n2 >= (long)0) {
            this.pcache.setCheckoutActualHiWatermark(this.pcache.getCheckoutActualHiWatermark() + (long)n2);
        }
        if (this.pcache.getPeakUsageSample() < this.pcache.getCheckoutHiWatermark() && this.pcache.getCheckoutHiWatermark() >= (long)0) {
            this.pcache.setPeakUsageSample(this.pcache.getCheckoutHiWatermark());
        }
    }

    public synchronized void adjustDisabledUserWatermark(boolean bl, boolean bl2) throws WdoBaseException {
        this.adjustDisabledUserWatermark(bl);
        if (bl2) {
            this.prodCache.adjustDisabledUserWatermark(bl);
        }
    }

    public synchronized void adjustDisabledUserWatermark(boolean bl) throws WdoBaseException {
        long l = this.pcache.getDisabledUserHiWatermark();
        l = bl ? ++l : --l;
        if (l >= (long)0) {
            this.pcache.setDisabledUserHiWatermark(l);
        }
    }

    public int getPeakUsageSample() throws WdoBaseException {
        long l = this.pcache.getPeakUsageSample();
        if (this.pcache.getCheckoutHiWatermark() >= (long)0) {
            this.pcache.setPeakUsageSample(this.pcache.getCheckoutHiWatermark());
        }
        return (int)l;
    }

    public synchronized void dumpCache() throws WdoBaseException {
        IlsUtil.Trace(9, "IlsLicenseCache", "DomainLicenseCacheEntry dump:\n" + this.pcache.toXML());
    }
}

