/*
 * Decompiled with CFR 0.152.
 */
package com.vs.ils;

import com.vs.ils.AlerterJob;
import com.vs.ils.DomainLicenseCacheEntry;
import com.vs.ils.IlsCmdAPI;
import com.vs.ils.IlsCmdArgs;
import com.vs.ils.IlsLicenseCache;
import com.vs.ils.IlsToken;
import com.vs.ils.IlsUtil;
import com.vs.ils.UserCleanupJob;
import com.vs.ils.ilsdb.Domain;
import com.vs.ils.ilsdb.Product;
import com.vs.ils.ilsdb.User;
import com.vs.wdo.rtl.WdoBaseException;
import com.vs.wdo.rtl.WdoUnitOfWork;
import java.util.Date;

class DeregisterLuw
implements WdoUnitOfWork {
    DeregisterLuw() {
    }

    public void doIt(int n, Object[] objectArray) throws WdoBaseException {
        IlsCmdAPI ilsCmdAPI = (IlsCmdAPI)objectArray[0];
        IlsCmdArgs ilsCmdArgs = ilsCmdAPI.getCmdArgs();
        Date date = new Date();
        String string = ilsCmdArgs.getUser();
        String string2 = IlsUtil.GetEncryptedPasswd(ilsCmdArgs.getPasswd(), ilsCmdArgs.getUser());
        Object var8_8 = null;
        Object var9_9 = null;
        long l = 0L;
        IlsUtil.Trace(10, "DeregisterCmd:DeregisterLuw", "Enter.");
        IlsToken ilsToken = ilsCmdAPI.parseToken(true);
        ilsCmdArgs.setToken(null);
        Product product = ilsCmdAPI.checkGetProduct();
        long l2 = product.getProductId();
        Domain domain = ilsCmdAPI.checkGetDomain(product);
        long l3 = domain.getDomainId();
        if (ilsToken.getAuthLevel() < 2 || ilsToken.getAuthLevel() == 2 && string.startsWith("useradmin")) {
            ilsCmdArgs.setStatusInfo(31, "Deregistering a public named user requires user administration privileges at a minimum.  If the named user to be deregistered is a user administrator, product administration privileges are required at a minimum.", null, AlerterJob.MakeEventParams(product.getName(), domain.getName()));
            WdoBaseException.ThrowProxyWdoException((int)12);
        }
        if (ilsToken.getAuthLevel() == 2 && l3 != ilsToken.getDomainId()) {
            ilsCmdArgs.setStatusInfo(31, "Insufficient privileges to perform user deregistration on domain '" + domain.getName() + "'.  Your domain administration privileges are limited to your assigned domain '" + Domain.GetDomain((long)ilsToken.getDomainId()).getName(), null, AlerterJob.MakeEventParams(product.getName(), domain.getName()));
            WdoBaseException.ThrowProxyWdoException((int)12);
        }
        boolean bl = domain.getLicenseModel().equals("IUSER");
        boolean bl2 = string.startsWith("useradmin");
        if (!bl && !bl2) {
            ilsCmdArgs.setStatusInfo(19, "Users can only be registered to a named-user type of domain.  Domain: " + domain.getName(), null, AlerterJob.MakeEventParams(product.getName(), domain.getName()));
            WdoBaseException.ThrowProxyWdoException((int)12);
        }
        if (!UserCleanupJob.DoingUserCleanup(ilsCmdArgs)) {
            WdoBaseException.ThrowProxyWdoException((int)12);
        }
        try {
            User user = null;
            l = User.FindByNameXNoAuth((String)product.getName(), (String)domain.getName(), (String)string, (boolean)true);
            if (l == (long)0) {
                IlsUtil.Trace(5, "DeregisterCmd:DeregisterLuw", "Cannot find user '" + string + "'to drop");
                ilsCmdArgs.setStatusInfo(-103, "User to be deregistered does not exist", null, AlerterJob.MakeEventParams(product.getName(), domain.getName()));
            } else {
                user = User.GetUser((long)l);
                String string3 = product.optionsIsDefined() ? product.getOptions() : "";
                int n2 = IlsCmdAPI.getCancelAuthLevel(string3);
                if (user.getEnabled() && IlsCmdAPI.CheckUserCheckedOut(date, user) && ilsToken.getAuthLevel() < n2) {
                    ilsCmdArgs.setStatusInfo(18, "Insufficient privilege level for de-registering a checked-out user", null, AlerterJob.MakeEventParams(product.getName(), domain.getName()));
                    WdoBaseException.ThrowProxyWdoException((int)12);
                }
                IlsUtil.Trace(5, "DeregisterCmd:DeregisterLuw", "Dropping user '" + string + "', userid " + l);
                boolean bl3 = user.getCheckoutInfo().getCheckedOut();
                User.Drop((long)l);
                if (bl || !bl2) {
                    DomainLicenseCacheEntry domainLicenseCacheEntry = IlsLicenseCache.getDomainCacheEntry(date, product, domain);
                    if (bl3) {
                        domainLicenseCacheEntry.adjustCheckoutWatermark(date, domain, -1, true);
                    }
                    domainLicenseCacheEntry.adjustWatermark(date, domain, -1, true);
                }
            }
            Object var27_23 = null;
        }
        catch (Throwable throwable) {
            Object var27_24 = null;
            UserCleanupJob.DoneUserCleanup();
            throw throwable;
        }
        UserCleanupJob.DoneUserCleanup();
    }
}

