/*
 * Decompiled with CFR 0.152.
 */
package com.vs.ils;

import com.vs.ils.AddDomainLuw;
import com.vs.ils.IlsAdminAPI;
import com.vs.ils.IlsCmdAPI;
import com.vs.ils.IlsCmdArgs;
import com.vs.ils.IlsLicense;
import com.vs.ils.IlsUtil;
import com.vs.ils.ilsdb.LicenseParamInfo;
import com.vs.ils.ilsdb.Product;
import com.vs.wdo.rtl.WdoBaseException;
import com.vs.wdo.rtl.WdoDuplicateObjectException;
import com.vs.wdo.rtl.WdoUnitOfWork;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

class CopyProductsLuw
implements WdoUnitOfWork {
    CopyProductsLuw() {
    }

    public void doIt(int n, Object[] objectArray) throws WdoBaseException {
        IlsAdminAPI ilsAdminAPI = (IlsAdminAPI)objectArray[0];
        IlsCmdArgs ilsCmdArgs = ilsAdminAPI.getCmdArgs();
        Object[] objectArray2 = (Object[])objectArray[1];
        Vector vector = (Vector)objectArray2[0];
        Vector<Product> vector2 = new Vector<Product>(vector.size());
        long l = (Long)objectArray2[1];
        long l2 = (Long)objectArray2[2];
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Product product = (Product)enumeration.nextElement();
            IlsUtil.Trace(8, "IlsAdminAPI", "CopyProductsLuw: copying product " + product.getName() + ", id " + product.getProductId());
            Product product2 = null;
            boolean bl = true;
            while (true) {
                try {
                    IlsCmdArgs ilsCmdArgs2;
                    product.productIdUndefine();
                    product.setProductId(0L);
                    long l3 = Product.Create((Product)product);
                    product2 = Product.GetProduct((long)l3);
                    vector2.addElement(product2);
                    if (bl) {
                        ++l;
                    } else {
                        ++l2;
                    }
                    product2.setInited(false);
                    product2.setCurd("");
                    LicenseParamInfo licenseParamInfo = new LicenseParamInfo();
                    if (product2.getTimeLimited()) {
                        licenseParamInfo.setTimeLimitType("ABST");
                        licenseParamInfo.setExpDate(new Timestamp(product2.getExpTs()));
                    }
                    if (product2.getQuotaLimited()) {
                        licenseParamInfo.setQuotaLimited(true);
                        licenseParamInfo.setQuota(product2.getQuota());
                    }
                    boolean bl2 = false;
                    boolean bl3 = false;
                    IlsLicense ilsLicense = new IlsLicense(product.getLicenseKey(), ilsAdminAPI.serviceName, product.getName(), 0L, null, true);
                    if (ilsLicense.checkLicense(ilsCmdArgs2 = new IlsCmdArgs(), 0L, null, true) != null) {
                        bl2 = IlsCmdAPI.CheckHosted(product.getName(), ilsLicense);
                        bl3 = IlsCmdAPI.CheckPosthumousActivation(product.getName(), ilsLicense);
                    }
                    if (bl2 && (product2.getTimeLimited() || product2.getQuotaLimited())) {
                        if (product2.getTimeLimited()) {
                            licenseParamInfo.setExpGrace(bl3 ? 10000 : 30);
                        }
                        if (product2.getQuotaLimited()) {
                            licenseParamInfo.setQuotaGrace((long)(bl3 ? 1000000000 : 1000));
                        }
                    }
                    long l4 = AddDomainLuw.AddDomain(ilsCmdArgs, new Date(product2.getAdminInfo().getCreationDate().getTime()), "system", "IUSER", product2, licenseParamInfo, 3L, product2.getUserLimit(), 0L, -1L, true, "Created internally.");
                }
                catch (WdoDuplicateObjectException wdoDuplicateObjectException) {
                    Product.DropMatching((String)product.getName());
                    bl = false;
                    continue;
                }
                break;
            }
            IlsUtil.Trace(10, "IlsAdminAPI", "CopyProductsLuw: add/update product: " + product2.toXML());
        }
        objectArray2[1] = new Long(l);
        objectArray2[2] = new Long(l2);
        objectArray2[3] = vector2;
    }
}

