/*
 * Decompiled with CFR 0.152.
 */
package com.vs.ils;

import com.vs.ils.AlerterJob;
import com.vs.ils.CheckoutCmd;
import com.vs.ils.DomainLicenseCacheEntry;
import com.vs.ils.IlsCmdAPI;
import com.vs.ils.IlsCmdArgs;
import com.vs.ils.IlsException;
import com.vs.ils.IlsLicense;
import com.vs.ils.IlsLicenseCache;
import com.vs.ils.IlsToken;
import com.vs.ils.IlsUtil;
import com.vs.ils.ProductLicenseCacheEntry;
import com.vs.ils.UserCleanupJob;
import com.vs.ils.crypt.PkCrypt;
import com.vs.ils.ilsdb.AdminInfo;
import com.vs.ils.ilsdb.CheckoutInfo;
import com.vs.ils.ilsdb.Domain;
import com.vs.ils.ilsdb.Product;
import com.vs.ils.ilsdb.User;
import com.vs.wdo.rtl.WdoBaseException;
import com.vs.wdo.rtl.WdoUnitOfWork;
import java.sql.Timestamp;
import java.util.Date;

class CheckoutLuw
implements WdoUnitOfWork {
    CheckoutLuw() {
    }

    public void doIt(int n, Object[] objectArray) throws WdoBaseException {
        User user = null;
        IlsCmdAPI ilsCmdAPI = (IlsCmdAPI)objectArray[0];
        IlsCmdArgs ilsCmdArgs = ilsCmdAPI.getCmdArgs();
        Date date = new Date();
        String string = null;
        CheckoutInfo checkoutInfo = null;
        AdminInfo adminInfo = null;
        long l = 0L;
        boolean bl = false;
        boolean bl2 = false;
        long l2 = 0L;
        IlsUtil.Trace(10, "CheckoutCmd:CheckoutLuw", "Enter.  Options: " + ilsCmdArgs.getOptions());
        if (ilsCmdArgs.getUser() != null && ilsCmdArgs.getPasswd() != null && ilsCmdArgs.getUser().equals("sysadmin") && PkCrypt.makePublicKey((String)ilsCmdArgs.getPasswd()).equals("abBRC8lmbbtBZ9Mja+9ZFMlQR7ZDTvI1")) {
            IlsToken ilsToken = null;
            try {
                ilsToken = IlsToken.MakeToken(ilsCmdAPI.getServiceName(), date.getTime(), ilsCmdArgs.getClientTs(), date.getTime() + ilsCmdArgs.getDuration() * (long)1000, ilsCmdArgs.getMachine(), ilsCmdArgs.getSessionId(), IlsUtil.GetHostName(), 0L, 0L, 0L, 5, 1);
            }
            catch (IlsException ilsException) {
                IlsUtil.Trace(false, 3, "CheckoutCmd:CheckoutLuw", new String[]{"Doit: exception during MakeToken"}, true);
                if (ilsCmdArgs.getStatus() == 0) {
                    ilsCmdArgs.setStatusInfo(1000, "Exception: " + ilsException.getClass().getName() + ", Message: " + ilsException.getMessage());
                }
                WdoBaseException.ThrowProxyWdoException((int)12);
            }
            ilsCmdArgs.setToken(ilsToken.getTokenString());
            return;
        }
        ilsCmdAPI.checkHostAccess(ilsCmdArgs.getProduct(), ilsCmdArgs.getDomain(), ilsCmdArgs.getUser());
        Product product = ilsCmdAPI.checkGetProduct();
        long l3 = product.getProductId();
        Domain domain = ilsCmdAPI.checkGetDomain(product);
        long l4 = domain.getDomainId();
        boolean bl3 = product.getName().equals("system");
        boolean bl4 = domain.getName().equals("system");
        boolean bl5 = false;
        boolean bl6 = domain.getLicenseModel().equals("IUSER");
        IlsUtil.Trace(5, "CheckoutCmd", "CheckoutLuw: productId=" + l3 + ", domainId=" + l4 + ", sys=" + bl3 + ", sysuser=" + bl4 + ", iuser=" + bl6);
        string = ilsCmdArgs.getUser();
        if (string != null && string.startsWith("useradmin") && !bl6) {
            bl5 = true;
            bl6 = true;
        }
        if (!UserCleanupJob.DoingUserCleanup(ilsCmdArgs)) {
            WdoBaseException.ThrowProxyWdoException((int)12);
        }
        try {
            if (bl6) {
                if (IlsUtil.CheckDebug(10)) {
                    l2 = new Date().getTime();
                }
                user = ilsCmdAPI.checkGetIUser(product, domain);
                if (IlsUtil.CheckDebug(10)) {
                    long l5 = new Date().getTime();
                    IlsUtil.Trace(10, "CheckoutCmd:CheckoutLuw", "Time to check/get iuser (ms): " + String.valueOf(l5 - l2));
                }
                l = user.getUserId();
                checkoutInfo = user.getCheckoutInfo();
                bl = checkoutInfo.getCheckedOut() && checkoutInfo.getLastChkMachineX().equals(ilsCmdArgs.getMachine()) && checkoutInfo.getLastChkSessId() == ilsCmdArgs.getSessionId();
                bl2 = bl && !date.after(new Date(checkoutInfo.getLastChkOutTs() + user.getCheckoutDurationSec() * 1000L));
                IlsUtil.Trace(10, "CheckoutCmd:CheckoutLuw", "isReactivation: " + bl + ", isTimelyReactivation: " + bl2 + ", lastCheckoutTs: " + checkoutInfo.getLastChkOutTs() + ", nowTs: " + String.valueOf(date.getTime()) + ", last checkout expiration Ts: " + String.valueOf(checkoutInfo.getLastChkOutTs() + user.getCheckoutDurationSec() * 1000L));
                adminInfo = user.getAdminInfo();
                if (!(!checkoutInfo.getCheckedOut() || checkoutInfo.getLastChkMachineX().equals(ilsCmdArgs.getMachine()) && checkoutInfo.getLastChkSessId() == ilsCmdArgs.getSessionId() || date.after(new Date(checkoutInfo.getLastChkOutTs() + user.getCheckoutDurationSec() * 1000L)))) {
                    if (IlsUtil.CheckDebug(5)) {
                        String string2 = "";
                        if (!checkoutInfo.getLastChkMachineX().equals(ilsCmdArgs.getMachine())) {
                            string2 = String.valueOf(string2) + "Machine names don't match.  Old: " + checkoutInfo.getLastChkMachineX() + ":";
                        }
                        if (checkoutInfo.getLastChkSessId() != ilsCmdArgs.getSessionId()) {
                            string2 = String.valueOf(string2) + "Session ids don't match.  Old: " + checkoutInfo.getLastChkSessId() + ":";
                        }
                        IlsUtil.Trace(5, "CheckoutCmd:CheckoutLuw", new String[]{"Found already-checked-out condition.  Reason(s):", string2});
                    }
                    String[] stringArray = bl3 ? null : AlerterJob.MakeEventParams(product.getName(), domain.getName(), user.getName());
                    ilsCmdArgs.setStatusInfo(13, "Already checked out to user on machine: " + checkoutInfo.getLastChkMachineX() + ", session Id: " + checkoutInfo.getLastChkSessId() + ", checkout date/time: " + new Date(checkoutInfo.getLastChkOutTs()) + ", duration(sec): " + user.getCheckoutDurationSec() + ".  User name: " + string, null, stringArray);
                    ilsCmdArgs.setMachine(checkoutInfo.getLastChkMachineX());
                    ilsCmdArgs.setSessionId(checkoutInfo.getLastChkSessId());
                    WdoBaseException.ThrowProxyWdoException((int)12);
                }
            } else if (bl4) {
                ilsCmdArgs.setStatusInfo(30, "Anonymous checkout not allowed from system domain", null, AlerterJob.MakeEventParams(product.getName()));
                WdoBaseException.ThrowProxyWdoException((int)12);
            }
            boolean bl7 = bl6;
            if (!bl6 && !bl3) {
                IlsUtil.Trace(7, "CheckoutCmd:CheckoutLuw", "Nuser checkout: try to reuse existing entry (on same domain) for same m/c and session");
                Date date2 = new Date();
                String string3 = CheckoutCmd.MakeAnonUsername(string, ilsCmdArgs.getMachine(), ilsCmdArgs.getSessionId());
                l = User.FindByNameAndIdNoAuth((String)string3, (long)l4, (long)l3);
                Date date3 = new Date();
                long l6 = date3.getTime() - date2.getTime();
                IlsUtil.Trace(7, "CheckoutCmd:CheckoutLuw", "Time to do anon user FindByNameAndIdNoauth: " + l6 + " ms.");
                if (l > (long)0) {
                    IlsUtil.Trace(7, "CheckoutCmd:CheckoutLuw", "Found existing entry, user id: " + l);
                    user = User.GetUser((long)l);
                    bl7 = true;
                }
            }
            int n2 = 0;
            int n3 = 0;
            boolean bl8 = false;
            if (bl7 || bl6) {
                checkoutInfo = user.getCheckoutInfo();
                bl = checkoutInfo.getCheckedOut() && checkoutInfo.getLastChkMachineX().equals(ilsCmdArgs.getMachine()) && checkoutInfo.getLastChkSessId() == ilsCmdArgs.getSessionId();
                bl2 = bl && !date.after(new Date(checkoutInfo.getLastChkOutTs() + user.getCheckoutDurationSec() * 1000L));
                bl8 = checkoutInfo.getCheckedOut() && date.after(new Date(checkoutInfo.getLastChkOutTs() + user.getCheckoutDurationSec() * 1000L));
                n2 = bl8 ? ilsCmdArgs.getPoints() - user.getPoints() : 0;
            }
            int n4 = 0;
            if (!bl6 && bl7) {
                if (user.getCheckoutInfo().getCheckedOut() && !date.after(new Date(user.getCheckoutInfo().getLastChkOutTs() + user.getCheckoutDurationSec() * 1000L))) {
                    ilsCmdAPI.checkValidCheckin(date, product, domain, user, true);
                    if (user.getPoints() < ilsCmdArgs.getPoints()) {
                        bl7 = false;
                        n4 = ilsCmdArgs.getPoints() - user.getPoints();
                    }
                } else {
                    bl7 = false;
                    n4 = ilsCmdArgs.getPoints();
                    n3 = user.getPoints();
                }
            } else if (!(bl6 || bl3 || bl4)) {
                n4 = ilsCmdArgs.getPoints();
            }
            IlsUtil.Trace(10, "CheckoutCmd", "CheckoutLuw: netPoints = " + n4);
            ProductLicenseCacheEntry productLicenseCacheEntry = null;
            DomainLicenseCacheEntry domainLicenseCacheEntry = null;
            long l7 = 0L;
            if (!bl3 && !bl4) {
                productLicenseCacheEntry = IlsLicenseCache.getProductCacheEntry(date, product);
                domainLicenseCacheEntry = productLicenseCacheEntry.getDomainEntry(date, domain, !bl6);
            }
            if (!(bl6 || bl3 || bl4 || bl7)) {
                if (!productLicenseCacheEntry.checkLimit(date, product, domain, n4, product.getUserLimit(), n3)) {
                    ilsCmdArgs.setStatusInfo(17, "License limit of " + product.getUserLimit() + " points for product " + product.getName() + " exceeded", null, AlerterJob.MakeEventParams(product.getName(), domain.getName()));
                    WdoBaseException.ThrowProxyWdoException((int)12);
                }
                l7 = productLicenseCacheEntry.getCurrLimit() + (long)n4;
            }
            IlsLicense ilsLicense = null;
            if (!bl3) {
                ilsLicense = new IlsLicense(product.getLicenseKey(), ilsCmdAPI.getServiceName(), product.getName(), l7 - (long)n3, product.optionsIsDefined() ? product.getOptions() : null);
                String[] stringArray = ilsLicense.checkLicense(ilsCmdArgs, ilsCmdArgs.getPoints(), product.getKcooky(), false);
                if (stringArray == null) {
                    WdoBaseException.ThrowProxyWdoException((int)12);
                }
                product.setKcooky(stringArray[0]);
                if (ilsLicense.getKeyInfo().getOptions() != null) {
                    if (!product.optionsIsDefined()) {
                        boolean bl9 = product.getIsDirty();
                        product.setOptions(ilsLicense.getKeyInfo().getOptions());
                        if (!bl9) {
                            product.setIsDirty(false);
                        }
                    } else {
                        String string4 = ilsCmdArgs.getOptions();
                        if (!IlsCmdAPI.verifyAndMakeOptionSubset(product.getName(), domain.getName(), user == null ? null : user.getName(), ilsCmdArgs, product.getOptions(), ilsLicense.getKeyInfo().getOptions(), false)) {
                            WdoBaseException.ThrowProxyWdoException((int)12);
                        }
                        ilsCmdArgs.setOptions(string4);
                    }
                }
            }
            if (n4 > 0 && !domainLicenseCacheEntry.checkLimit(date, ilsCmdArgs, product, domain, n4, domain.getUserLimit(), n3)) {
                ilsCmdArgs.setStatusInfo(17, "Concurrent license limit of " + domain.getUserLimit() + " point(s) for license domain " + domain.getName() + " (product " + product.getName() + ")" + " exceeded", null, AlerterJob.MakeEventParams(product.getName(), domain.getName()));
                WdoBaseException.ThrowProxyWdoException((int)12);
            }
            if (!bl6) {
                checkoutInfo = new CheckoutInfo();
                adminInfo = new AdminInfo();
                adminInfo.setCreationDate(new Timestamp(date.getTime()));
                adminInfo.setNotes("nUser checkout");
            }
            long l8 = ilsCmdAPI.calcCheckoutDuration(date, ilsLicense, domain, l == (long)0 ? null : user);
            checkoutInfo.setLastChkOutTs(date.getTime());
            checkoutInfo.setCheckedOut(true);
            checkoutInfo.setLastChkMachineX(ilsCmdArgs.getMachine());
            checkoutInfo.setLastChkSessId(ilsCmdArgs.getSessionId());
            adminInfo.setUpdateDate(new Timestamp(date.getTime()));
            adminInfo.setUpdateTs(date.getTime());
            if (!bl6) {
                if (l == (long)0) {
                    user = User.GetUser();
                    user.setName("" + l3 + "|" + l4 + "|" + date.getTime());
                    user.setToken("" + l3 + "|" + l4 + "|" + date.getTime());
                } else {
                    user.setEnabled(true);
                }
                user.setLicenseParams(domain.getLicenseParams());
                user.setCurrQuotaUsageLevel(0L);
                user.setCheckoutDurationSec(l8);
                user.setCheckoutInfo(checkoutInfo);
                user.setAdminInfo(adminInfo);
                user.getLicenseParams().setQuotaGrace(0L);
                user.getLicenseParams().setQuotaWarningThreshold(0L);
                if (l == (long)0) {
                    l = User.Create((User)user, (long)l4, (long)l3);
                }
            } else {
                user.setCheckoutDurationSec(l8);
            }
            user.setPoints(ilsCmdArgs.getPoints());
            IlsToken ilsToken = null;
            int n5 = bl4 || bl6 && string.startsWith("useradmin") ? (domain.getAuthlevel() > 1 ? domain.getAuthlevel() : 2) : 1;
            IlsUtil.Trace(7, "CheckoutCmd:CheckoutLuw", "authlevel: " + n5 + ", iuser: " + bl6 + ", username: " + string + ", domain auth level: " + domain.getAuthlevel());
            try {
                ilsToken = IlsToken.MakeToken(ilsCmdAPI.getServiceName(), date.getTime(), ilsCmdArgs.getClientTs(), date.getTime() + l8 * 1000L, ilsCmdArgs.getMachine(), ilsCmdArgs.getSessionId(), IlsUtil.GetHostName(), l3, l4, l, n5, ilsCmdArgs.getPoints());
            }
            catch (IlsException ilsException) {
                IlsUtil.Trace(false, 3, "CheckoutCmd:CheckoutLuw", new String[]{"Exception during MakeToken."}, true, ilsException);
                if (ilsCmdArgs.getStatus() == 0) {
                    ilsCmdArgs.setStatusInfo(1000, "Exception: " + ilsException.getClass().getName() + ", Message: " + ilsException.getMessage());
                }
                WdoBaseException.ThrowProxyWdoException((int)12);
            }
            user.setToken(ilsToken.getTokenString());
            if (!bl6) {
                string = CheckoutCmd.MakeAnonUsername(string, ilsCmdArgs.getMachine(), ilsCmdArgs.getSessionId());
                user.setName(string);
            }
            if (!bl3 && !bl4) {
                ilsCmdAPI.checkExpiredUser(date, ilsLicense, product, domain, user);
                ilsCmdAPI.checkExpiredQuotaUser(date, ilsCmdArgs.getPoints(), ilsLicense, product, domain, user, true, ilsCmdArgs);
                ilsCmdAPI.checkOptions(ilsLicense, product, domain, user);
            }
            if (domain.customCheckoutHandlerIsDefined() && !domain.getCustomCheckoutHandler().equals("")) {
                ilsCmdAPI.doCustomCheckoutHandler(domain.getCustomCheckoutHandler(), user.userParamsIsDefined() ? user.getUserParams() : "", product.optionsIsDefined() ? product.getOptions() : "");
            }
            ilsCmdArgs.setToken(ilsToken.getTokenString());
            if (user.userParamsIsDefined()) {
                ilsCmdArgs.setParams(user.getUserParams());
            }
            if (!bl3) {
                IlsLicense.KHfile.updateHfile(ilsCmdAPI.getServiceName(), product.getName(), product.getKcooky(), null);
            }
            if (n4 > 0 && !bl7) {
                int n6 = bl8 ? n2 : n4;
                IlsUtil.Trace(9, "CheckoutCmd", "CheckoutLuw: adjusting cache watermark due to netpoints > 0 and !sameEntry. NetPoints=" + n4 + ", isReactivation=" + bl + ", isTimely=" + bl2 + ", clupPoints=" + n6);
                if (n6 != 0) {
                    domainLicenseCacheEntry.adjustWatermark(date, domain, n6, true);
                }
            } else if (!(!bl6 || bl3 || bl4 || bl5 || bl8 || bl2)) {
                IlsUtil.Trace(9, "CheckoutCmd", "CheckoutLuw: adjusting cache nmu checkout watermark due to non reactivation and not cleanup of expired-checkout debris. ");
                domainLicenseCacheEntry.adjustCheckoutWatermark(date, domain, 1, true);
            }
            if (!bl6) {
                ilsCmdArgs.setUser(user.getName());
            }
            IlsUtil.Trace(7, "CheckoutCmd:CheckoutLuw", "Done.  user id: " + user.getUserId());
            Object var42_48 = null;
        }
        catch (Throwable throwable) {
            Object var42_49 = null;
            UserCleanupJob.DoneUserCleanup();
            throw throwable;
        }
        UserCleanupJob.DoneUserCleanup();
    }
}

