/*
 * Decompiled with CFR 0.152.
 */
package com.vs.ils;

import com.vs.ils.DomainLicenseCacheEntry;
import com.vs.ils.IlsCmdAPI;
import com.vs.ils.IlsCmdArgs;
import com.vs.ils.IlsLicenseCache;
import com.vs.ils.IlsToken;
import com.vs.ils.IlsUtil;
import com.vs.ils.UserCleanupJob;
import com.vs.ils.ilsdb.AdminInfo;
import com.vs.ils.ilsdb.CheckoutInfo;
import com.vs.ils.ilsdb.Domain;
import com.vs.ils.ilsdb.Product;
import com.vs.ils.ilsdb.User;
import com.vs.wdo.rtl.WdoBaseException;
import com.vs.wdo.rtl.WdoUnitOfWork;
import java.util.Date;

class CheckinLuw
implements WdoUnitOfWork {
    CheckinLuw() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doIt(int n, Object[] objectArray) throws WdoBaseException {
        block10: {
            block9: {
                IlsCmdAPI ilsCmdAPI = (IlsCmdAPI)objectArray[0];
                IlsCmdArgs ilsCmdArgs = ilsCmdAPI.getCmdArgs();
                Date date = new Date();
                IlsToken ilsToken = ilsCmdAPI.parseToken();
                if (ilsToken.getAuthLevel() == 5) {
                    return;
                }
                Product product = ilsCmdAPI.checkGetProduct();
                long l = product.getProductId();
                Domain domain = ilsCmdAPI.checkGetDomainById(product);
                long l2 = domain.getDomainId();
                if (!UserCleanupJob.DoingUserCleanup(ilsCmdArgs)) {
                    WdoBaseException.ThrowProxyWdoException((int)12);
                }
                try {
                    boolean bl;
                    User user = ilsCmdAPI.checkGetIUserById(product, domain, date, false);
                    if (user == null) {
                        Object var23_12 = null;
                        break block9;
                    }
                    boolean bl2 = product.getName().equals("system");
                    boolean bl3 = domain.getName().equals("system");
                    ilsCmdAPI.checkToken(product, domain, user, ilsToken, date, false);
                    ilsCmdAPI.checkValidCheckin(date, product, domain, user, false);
                    boolean bl4 = domain.getLicenseModel().equals("IUSER");
                    boolean bl5 = user.getName().startsWith("useradmin");
                    boolean bl6 = bl = bl4 || bl5;
                    if (bl) {
                        CheckoutInfo checkoutInfo = user.getCheckoutInfo();
                        AdminInfo adminInfo = user.getAdminInfo();
                        checkoutInfo.setCheckedOut(false);
                        checkoutInfo.setLastChkInTs(date.getTime());
                        user.setPoints(1);
                        if (ilsCmdArgs.getParams() != null) {
                            user.setUserParams(ilsCmdArgs.getParams());
                        }
                        user.setIsDirty(true);
                        if (!(bl2 || bl3 || !bl4 && bl5)) {
                            IlsUtil.Trace(9, "CheckinCmd", "CheckinLuw: adjusting named-user checkout watermark down by 1");
                            DomainLicenseCacheEntry domainLicenseCacheEntry = IlsLicenseCache.getDomainCacheEntry(date, product, domain);
                            domainLicenseCacheEntry.adjustCheckoutWatermark(date, domain, -1, true);
                        }
                    } else {
                        int n2 = -user.getPoints();
                        User.Drop((long)user.getUserId());
                        DomainLicenseCacheEntry domainLicenseCacheEntry = IlsLicenseCache.getDomainCacheEntry(date, product, domain);
                        domainLicenseCacheEntry.adjustWatermark(date, domain, n2, true);
                    }
                    ilsCmdArgs.setToken(null);
                    break block10;
                }
                catch (Throwable throwable) {
                    Object var23_14 = null;
                    UserCleanupJob.DoneUserCleanup();
                    throw throwable;
                }
            }
            UserCleanupJob.DoneUserCleanup();
            return;
        }
        Object var23_13 = null;
        UserCleanupJob.DoneUserCleanup();
    }
}

