/*
 * Decompiled with CFR 0.152.
 */
package com.vs.ils;

import com.vs.ils.IlsCmdAPI;
import com.vs.ils.IlsCmdArgs;
import com.vs.ils.IlsLicense;
import com.vs.ils.IlsUtil;
import com.vs.ils.ilsdb.Product;
import com.vs.wdo.rtl.WdoBaseException;
import com.vs.wdo.rtl.WdoUnitOfWork;
import java.util.Date;

class CheckProductLuw
implements WdoUnitOfWork {
    CheckProductLuw() {
    }

    public void doIt(int n, Object[] objectArray) throws WdoBaseException {
        Date date = new Date();
        try {
            objectArray[1] = null;
            IlsCmdAPI ilsCmdAPI = (IlsCmdAPI)objectArray[0];
            IlsCmdArgs ilsCmdArgs = ilsCmdAPI.getCmdArgs();
            Product product = ilsCmdAPI.checkGetProduct();
            String string = product == null || !product.optionsIsDefined() ? null : product.getOptions();
            objectArray[2] = string;
            String string2 = IlsCmdAPI.GetIlsStringOption(string, "ILS:AUDIT");
            boolean bl = ilsCmdAPI.doAudit = string2 == null || !string2.equals("0");
            if (!product.getName().equals("system")) {
                IlsLicense ilsLicense = new IlsLicense(product.getLicenseKey(), ilsCmdAPI.getServiceName(), product.getName(), 0L, null);
                if (!ilsLicense.checkLicense(ilsCmdArgs, true)) {
                    WdoBaseException.ThrowProxyWdoException((int)12);
                }
                if ((long)product.getUserLimit() != ilsLicense.getKeyInfo().getUsageValue()) {
                    product.setUserLimit((int)ilsLicense.getKeyInfo().getUsageValue());
                }
                objectArray[1] = ilsLicense.getKeyInfo().getAppPwd();
            }
        }
        catch (Throwable throwable) {
            IlsUtil.Trace(false, 5, "IlsCmdAPI", new String[]{"Error in CheckProductLuw.  Stack trace:"}, true);
            if (throwable instanceof WdoBaseException) {
                throw (WdoBaseException)throwable;
            }
            String string = null;
            string = "CheckProductLuw: caught throwable.  Name: " + throwable.getClass().getName() + ", Message: " + throwable.getMessage();
            IlsUtil.Trace(5, "IlsCmdAPI", string);
            WdoBaseException.ThrowProxyWdoException((int)5, (String)string);
        }
    }
}

