/*
 * Decompiled with CFR 0.152.
 */
package com.vs.ils;

import com.vs.ils.BackupFilenameFilter;
import com.vs.ils.IlsException;
import com.vs.ils.IlsJob;
import com.vs.ils.IlsUtil;
import com.vs.wdo.rtl.ConnectionPool;
import com.vs.wdo.rtl.WdoBaseException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class BackupJob
extends IlsJob {
    static final String BACKUP_JOB_NAME = "Backup";
    static final String BACKUP_JOB_EXTERNAL_NAME = "Backup Manager";
    static final String BACKUP_POLICY_PARAM_NAME = "Backup Policy";
    static final String BACKUP_RETENTION_PARAM_NAME = "Backup Retention Period";
    static final String BACKUP_DIRECTORY_PARAM_NAME = "Backup Directory";
    static final String BACKUP_PURGE_AUDIT_PARAM_NAME = "Purge Audit Trail After Backup";
    static final String BACKUP_POLICY_LAZY = "Lazy";
    static final String BACKUP_POLICY_EAGER = "Eager";
    static final String BACKUP_POLICY_RESPONSE_SET = "Lazy;Eager";
    static final long BACKUP_DEFAULT_RETENTION_DAYS = 30L;
    static final String BACKUP_DEFAULT_DIRECTORY = "database_backups";
    static final String BACKUP_DEFAULT_PURGE_AUDIT = "Yes";
    private long _$1762;

    public synchronized long checkBackupInProgress() {
        return this._$1762;
    }

    public String getJobName() {
        return BACKUP_JOB_NAME;
    }

    public String getJobExternalName() {
        return BACKUP_JOB_EXTERNAL_NAME;
    }

    public IlsJob.ParamData[] getJobParams() {
        IlsJob.ParamData[] paramDataArray = new IlsJob.ParamData[4];
        try {
            paramDataArray[0] = new IlsJob.ParamData(BACKUP_POLICY_PARAM_NAME, 2, this.theJobData.param1IsDefined() ? this.theJobData.getParam1() : BACKUP_POLICY_LAZY, false, BACKUP_POLICY_RESPONSE_SET);
            paramDataArray[1] = new IlsJob.ParamData(BACKUP_RETENTION_PARAM_NAME, 1, this.theJobData.param2IsDefined() ? this.theJobData.getParam2() : String.valueOf(30L), false, null);
            paramDataArray[2] = new IlsJob.ParamData(BACKUP_DIRECTORY_PARAM_NAME, 2, this.theJobData.param3IsDefined() ? this.theJobData.getParam3() : BACKUP_DEFAULT_DIRECTORY, false, null);
            paramDataArray[3] = new IlsJob.ParamData(BACKUP_PURGE_AUDIT_PARAM_NAME, 2, this.theJobData.param4IsDefined() ? this.theJobData.getParam4() : BACKUP_DEFAULT_PURGE_AUDIT, false, "No;Yes");
        }
        catch (WdoBaseException wdoBaseException) {
            paramDataArray = null;
        }
        return paramDataArray;
    }

    public String getJobParamsString() {
        String string = null;
        try {
            string = "Backup Policy=" + (this.theJobData.param1IsDefined() ? this.theJobData.getParam1() : BACKUP_POLICY_LAZY) + "&" + BACKUP_RETENTION_PARAM_NAME + "=" + (this.theJobData.param2IsDefined() ? this.theJobData.getParam2() : String.valueOf(30L)) + "&" + BACKUP_DIRECTORY_PARAM_NAME + "=" + (this.theJobData.param3IsDefined() ? this.theJobData.getParam3() : BACKUP_DEFAULT_DIRECTORY) + "&" + BACKUP_PURGE_AUDIT_PARAM_NAME + "=" + (this.theJobData.param4IsDefined() ? this.theJobData.getParam4() : BACKUP_DEFAULT_PURGE_AUDIT);
        }
        catch (WdoBaseException wdoBaseException) {
            string = null;
        }
        return string;
    }

    public String[] getAllowedJobSchedules() {
        String[] stringArray = new String[]{"Never", "Now", "Every Interval"};
        return stringArray;
    }

    public String[] getAllowedJobEventTriggers() {
        String[] stringArray = new String[]{"None", "Schedule", "Administration Command"};
        return stringArray;
    }

    protected boolean updateJobSpecificParams(IlsJob.ParamData[] paramDataArray, Boolean[] booleanArray) {
        try {
            if (booleanArray[0].booleanValue()) {
                this.theJobData.setParam1(paramDataArray[0].paramValue);
            }
            if (booleanArray[1].booleanValue()) {
                this.theJobData.setParam2(paramDataArray[1].paramValue);
            }
            if (booleanArray[2].booleanValue()) {
                this.theJobData.setParam3(paramDataArray[2].paramValue);
            }
            if (booleanArray[3].booleanValue()) {
                this.theJobData.setParam4(paramDataArray[3].paramValue);
            }
        }
        catch (WdoBaseException wdoBaseException) {
            boolean bl = false;
            return bl;
        }
        return true;
    }

    protected boolean doTheJob() {
        Date date = new Date();
        IlsJob.ParamData[] paramDataArray = this.getJobParams();
        boolean bl = this._$8855(date, paramDataArray[2].paramValue);
        boolean bl2 = true;
        boolean bl3 = true;
        if (bl) {
            IlsJob ilsJob;
            bl2 = this._$8877(date, paramDataArray);
            if (paramDataArray[3].paramValue != null && paramDataArray[3].paramValue.equalsIgnoreCase(BACKUP_DEFAULT_PURGE_AUDIT) && (ilsJob = IlsJob.GetJob("Audit", this.cmdArgs, this.serviceName, true)) != null) {
                ilsJob.startJob(this.cmdArgs);
            }
        }
        return bl && bl2 && bl3;
    }

    protected boolean abortTheJob() {
        System.out.println("!!!PRETEND-BACKUP-ABORT!!!!");
        return true;
    }

    private boolean _$8917(Date date, String string) {
        File file = new File(string);
        return file.lastModified() == (long)0 || file.lastModified() > date.getTime();
    }

    private boolean _$8952(String string) {
        File file = new File(String.valueOf(string) + ".new");
        return file.exists();
    }

    private boolean _$8877(Date date, IlsJob.ParamData[] paramDataArray) {
        long l = IlsUtil.GetPositiveLong(paramDataArray[1].paramValue);
        return this.deleteOldFiles(date, paramDataArray[2].paramValue, l, new BackupFilenameFilter());
    }

    private String _$9020() {
        ConnectionPool connectionPool = null;
        try {
            connectionPool = new ConnectionPool(this.serviceName, 2);
        }
        catch (WdoBaseException wdoBaseException) {
            this.cmdArgs.setStatusInfo(25, "Invalid service '" + this.serviceName + "'");
            String string = null;
            return string;
        }
        ConnectionPool.ConnectionInfo connectionInfo = connectionPool.getConnectionInfo();
        if (!connectionInfo.checkIfInprocessHsqldb()) {
            this.cmdArgs.setStatusInfo(25, "Service '" + this.serviceName + "' is not an in-process embedded database service. " + "Automatic backup management is only available for in-process embedded database services. " + "For other configurations, please refer to the respective database administration guide.");
            return null;
        }
        return connectionInfo.getInprocessDbpath();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean _$8855(Date var1_1, String var2_2) {
        IlsUtil.Trace(7, "BackupJob", "backupFiles: enter.  Backup dir = " + var2_2);
        var3_3 = var1_1;
        var4_4 = new File(var2_2);
        if (!var4_4.exists() && !var4_4.mkdir()) {
            this.cmdArgs.setStatusInfo(25, "Unable to create backup directory '" + var4_4.getAbsolutePath() + "'");
            return false;
        }
        var5_5 = this.makeJobFilename(var1_1, var2_2, "Backup", "zip");
        IlsUtil.Trace(7, "BackupJob", "backupFiles: made backup file name: " + var5_5);
        if (var5_5 == null) {
            return false;
        }
        var6_6 = this._$9020();
        if (var6_6 == null) {
            return false;
        }
        var7_7 = null;
        var8_8 = null;
        var9_9 = null;
        var10_10 = 0;
        while (true) {
            block34: {
                block37: {
                    block32: {
                        block30: {
                            block31: {
                                if (var10_10 >= 12) {
                                    return false;
                                }
                                try {
                                    try {
                                        var7_7 = new File(var5_5);
                                        var8_8 = new FileOutputStream(var7_7);
                                        var9_9 = new ZipOutputStream(var8_8);
                                        if (!this._$9230(var1_1, var9_9, var6_6, "script") || !this._$9230(var1_1, var9_9, var6_6, "properties")) {
                                            this.cmdArgs.setStatusInfo(25, "Backup configuration error: service '" + this.serviceName + "' is missing one or more mandatory files.");
                                            var11_12 = false;
                                            var15_16 = null;
                                            if (var9_9 == null) break block30;
                                            break block31;
                                        }
                                        this._$9230(var1_1, var9_9, var6_6, "data");
                                        this._$9230(var1_1, var9_9, var6_6, "backup");
                                        var9_9.close();
                                        var8_8.close();
                                        var1_1 = new Date();
                                        var11_13 = (var1_1.getTime() - var3_3.getTime()) / (long)1000;
                                        this.cmdArgs.setStatusInfo(0, "Backup successful after " + var10_10 + " retries. Backup file size: " + String.valueOf(var7_7.length() / (long)1000) + " Kbytes.  Elapsed time: " + var11_13 + " seconds.");
                                        var13_18 = true;
                                        break block32;
                                    }
                                    catch (IOException var11_14) {
                                        this.cmdArgs.setStatusInfo(1002, "OS Error occurred while performing backup.  Details: Exception: " + var11_14.getClass().getName() + ", Message: " + var11_14.getMessage());
                                        this._$9244(var5_5);
                                        var15_16 = null;
                                        if (var9_9 != null) {
                                            try {
                                                var9_9.close();
                                            }
                                            catch (Throwable var16_17) {
                                                // empty catch block
                                            }
                                        }
                                        if (var8_8 != null) {
                                            try {
                                                var8_8.close();
                                            }
                                            catch (Throwable var16_17) {}
                                        }
                                        break block34;
                                    }
                                    catch (IlsException var11_15) {
                                        block35: {
                                            this.cmdArgs.setStatusInfo(25, "Backup configuration error: service '" + this.serviceName + "' files have been modified while backup was in progress. " + "Details: " + var11_15.getMessage());
                                            this._$9244(var5_5);
                                            var15_16 = null;
                                            if (var9_9 != null) {
                                                ** try [egrp 2[TRYBLOCK] [3 : 534->542)] { 
lbl77:
                                                // 1 sources

                                                var9_9.close();
                                                break block35;
lbl79:
                                                // 1 sources

                                                catch (Throwable var16_17) {
                                                    // empty catch block
                                                }
                                            }
                                        }
                                        if (var8_8 != null) {
                                            try {}
                                            catch (Throwable var16_17) {}
                                            var8_8.close();
                                        }
                                        break block34;
                                    }
                                }
                                catch (Throwable var14_19) {
                                    block36: {
                                        var15_16 = null;
                                        if (var9_9 != null) {
                                            ** try [egrp 2[TRYBLOCK] [3 : 534->542)] { 
lbl93:
                                            // 1 sources

                                            var9_9.close();
                                            break block36;
lbl95:
                                            // 1 sources

                                            catch (Throwable var16_17) {
                                                // empty catch block
                                            }
                                        }
                                    }
                                    if (var8_8 == null) throw var14_19;
                                    ** try [egrp 3[TRYBLOCK] [4 : 550->558)] { 
lbl100:
                                    // 1 sources

                                    var8_8.close();
                                    throw var14_19;
lbl102:
                                    // 1 sources

                                    catch (Throwable var16_17) {
                                        // empty catch block
                                    }
                                    throw var14_19;
                                }
                            }
                            ** try [egrp 2[TRYBLOCK] [3 : 534->542)] { 
lbl107:
                            // 1 sources

                            var9_9.close();
                            break block30;
lbl109:
                            // 1 sources

                            catch (Throwable var16_17) {
                                // empty catch block
                            }
                        }
                        if (var8_8 == null) return var11_12;
                        ** try [egrp 3[TRYBLOCK] [4 : 550->558)] { 
lbl114:
                        // 1 sources

                        var8_8.close();
                        return var11_12;
lbl116:
                        // 1 sources

                        catch (Throwable var16_17) {
                            // empty catch block
                        }
                        return var11_12;
                    }
                    var15_16 = null;
                    if (var9_9 != null) {
                        ** try [egrp 2[TRYBLOCK] [3 : 534->542)] { 
lbl123:
                        // 1 sources

                        var9_9.close();
                        break block37;
lbl125:
                        // 1 sources

                        catch (Throwable var16_17) {
                            // empty catch block
                        }
                    }
                }
                if (var8_8 == null) return var13_18;
                ** try [egrp 3[TRYBLOCK] [4 : 550->558)] { 
lbl130:
                // 1 sources

                var8_8.close();
                return var13_18;
lbl132:
                // 1 sources

                catch (Throwable var16_17) {
                    // empty catch block
                }
                return var13_18;
            }
            if (!IlsUtil.Sleep(10000)) {
                IlsUtil.Trace(7, "BackupJob", "backupFiles: exiting retry loop due to interruption.");
                this.cmdArgs.setStatusInfo(-501, "Backup job was interrupted");
                return false;
            }
            var1_1 = new Date();
            ++var10_10;
        }
    }

    private boolean _$9230(Date date, ZipOutputStream zipOutputStream, String string, String string2) throws IlsException, IOException {
        String string3 = String.valueOf(string) + "." + string2;
        IlsUtil.Trace(7, "BackupJob", "backupOneFile: enter.  baseFilename = " + string + ", extension = " + string2);
        File file = new File(string3);
        if (!file.exists()) {
            return false;
        }
        ZipEntry zipEntry = new ZipEntry(string3);
        zipOutputStream.putNextEntry(zipEntry);
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            byte[] byArray = new byte[1024];
            int n = 0;
            while ((n = fileInputStream.read(byArray)) > 0) {
                if (this._$8917(date, string3)) {
                    IlsException.ThrowException(25, "Database file '" + string3 + "' detected modified since beginning of backup.  Aborting backup.");
                }
                if (this._$8952(string3)) {
                    IlsException.ThrowException(1004, "Database initiated a checkpoint after backup commenced.  Aborting backup.");
                }
                zipOutputStream.write(byArray, 0, n);
            }
            zipOutputStream.flush();
            Object var12_11 = null;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            fileInputStream.close();
            zipOutputStream.closeEntry();
            throw throwable;
        }
        fileInputStream.close();
        zipOutputStream.closeEntry();
        return true;
    }

    private boolean _$9244(String string) {
        boolean bl = new File(string).delete();
        return bl;
    }
}

