/*
 * Decompiled with CFR 0.152.
 */
package com.vs.ils;

import com.vs.ils.IlsCmdArgs;
import com.vs.ils.IlsJob;
import com.vs.ils.IlsUtil;
import com.vs.ils.ilsdb.AuditTrail;
import com.vs.wdo.rtl.WdoBaseException;
import com.vs.wdo.rtl.WdoUnitOfWork;
import java.sql.Timestamp;
import java.util.Date;

class AuditJobEventLuw
implements WdoUnitOfWork {
    AuditJobEventLuw() {
    }

    public void doIt(int n, Object[] objectArray) throws WdoBaseException {
        Date date = new Date();
        IlsJob ilsJob = (IlsJob)objectArray[0];
        IlsCmdArgs ilsCmdArgs = ilsJob.getCmdArgs();
        IlsUtil.Trace(10, "IlsJob", "AuditJobEventLuw: enter.  Service: " + ilsJob.serviceName);
        AuditTrail auditTrail = AuditTrail.GetAuditTrail();
        auditTrail.setEventDate(new Timestamp(date.getTime()));
        auditTrail.setEventTs(date.getTime());
        auditTrail.setSource("INT");
        auditTrail.setCategory("SYS");
        int n2 = ilsCmdArgs.getStatus();
        int n3 = 1;
        if (n2 > 0) {
            n3 = n2 >= 500 ? 4 : 3;
        } else if (n2 < 0 && n2 > -100) {
            n3 = 2;
        }
        boolean bl = false;
        if (n2 != 0) {
            IlsUtil.Trace(10, "IlsJob", "AuditJobEventLuw: non-0 status, and msg is: '" + ilsCmdArgs.getMsg() + "'");
            bl = true;
        }
        auditTrail.setUserName("sysadmin");
        auditTrail.setDomainName("system");
        auditTrail.setProductName("system");
        auditTrail.setMachineName("N/A");
        auditTrail.setSeverity(n3);
        auditTrail.setViewAuthLevel(4);
        auditTrail.setViewDetailLevel(3);
        auditTrail.setCmd(String.valueOf(ilsJob.getJobName()) + "Job");
        auditTrail.setEventStatusCode(n2);
        String string = String.valueOf(ilsCmdArgs.getRequest()) + "&" + ilsJob.getJobParamsString();
        auditTrail.setRequestMsg(string);
        ilsCmdArgs.setResponse(null);
        String string2 = ilsCmdArgs.makeCmdResponse(false);
        if (string2 == null) {
            string2 = "";
        }
        auditTrail.setResponseMsg(string2);
        if (bl) {
            IlsUtil.Trace(10, "IlsJob", "AuditJobEventLuw: non-0 status, and msg after setting audit trail entries and before setting msg is: '" + ilsCmdArgs.getMsg() + "'");
        }
        if (ilsCmdArgs.getMsg() != null) {
            auditTrail.setEventStatusMsg(String.valueOf(ilsCmdArgs.getMsg()) + (ilsCmdArgs.getValue() != null ? ilsCmdArgs.getValue() : ""));
        }
        if (bl) {
            IlsUtil.Trace(10, "IlsJob", "AuditJobEventLuw: non-0 status, and msg in audit trail entry is: '" + auditTrail.getEventStatusMsg() + "'");
        }
        IlsUtil.Trace(10, "IlsJob", "AuditJobEventLuw: creating entry in db.  Service: " + ilsJob.serviceName);
        AuditTrail.Create((AuditTrail)auditTrail);
        IlsUtil.Trace(10, "IlsJob", "AuditJobEventLuw: done.  Service: " + ilsJob.serviceName);
    }
}

