/*
 * Decompiled with CFR 0.152.
 */
package com.vs.ils;

import com.vs.ils.AuditArchiveFilenameFilter;
import com.vs.ils.AuditPurgeJobEventLuw;
import com.vs.ils.IlsJob;
import com.vs.ils.IlsUtil;
import com.vs.wdo.rtl.WdoBaseException;
import java.io.File;
import java.util.Date;

public class AuditJob
extends IlsJob {
    static final String AUDIT_JOB_NAME = "Audit";
    static final String AUDIT_JOB_EXTERNAL_NAME = "Audit Trail Cleaner";
    static final String AUDIT_RETENTION_PARAM_NAME = "Audit Retention Period";
    static final String AUDIT_ARCHIVE_RETENTION_PARAM_NAME = "Audit Archive Retention Period";
    static final String AUDIT_ARCHIVE_DIRECTORY_PARAM_NAME = "Audit Archive Directory";
    static final String AUDIT_ARCHIVE_PURGED_PARAM_NAME = "Archive Purged Audit Trail Entries";
    static final String AUDIT_ARCHIVE_FORMAT_PARAM_NAME = "Archive File Format";
    static final long AUDIT_DEFAULT_RETENTION_DAYS = 30L;
    static final long AUDIT_ARCHIVE_DEFAULT_RETENTION_DAYS = 30L;
    static final String AUDIT_ARCHIVE_DEFAULT_DIRECTORY = "audit_archives";
    static final String AUDIT_DEFAULT_ARCHIVE_PURGED = "Yes";
    public static final String AUDIT_ARCHIVE_FORMAT_CSV = "csv";
    public static final String AUDIT_ARCHIVE_FORMAT_TAB = "tab";
    public static final String AUDIT_ARCHIVE_FORMAT_XML = "xml";
    static final String AUDIT_DEFAULT_ARCHIVE_FORMAT = "xml";
    private static final int _$7182 = 1000;

    public String getJobName() {
        return AUDIT_JOB_NAME;
    }

    public String getJobExternalName() {
        return AUDIT_JOB_EXTERNAL_NAME;
    }

    public IlsJob.ParamData[] getJobParams() {
        IlsJob.ParamData[] paramDataArray = new IlsJob.ParamData[5];
        try {
            paramDataArray[0] = new IlsJob.ParamData(AUDIT_RETENTION_PARAM_NAME, 1, this.theJobData.param1IsDefined() ? this.theJobData.getParam1() : String.valueOf(30L), false, null);
            paramDataArray[1] = new IlsJob.ParamData(AUDIT_ARCHIVE_RETENTION_PARAM_NAME, 1, this.theJobData.param2IsDefined() ? this.theJobData.getParam2() : String.valueOf(30L), false, null);
            paramDataArray[2] = new IlsJob.ParamData(AUDIT_ARCHIVE_DIRECTORY_PARAM_NAME, 2, this.theJobData.param3IsDefined() ? this.theJobData.getParam3() : AUDIT_ARCHIVE_DEFAULT_DIRECTORY, false, null);
            paramDataArray[3] = new IlsJob.ParamData(AUDIT_ARCHIVE_PURGED_PARAM_NAME, 2, this.theJobData.param4IsDefined() ? this.theJobData.getParam4() : AUDIT_DEFAULT_ARCHIVE_PURGED, false, "Yes;No");
            String string = "xml;csv;tab";
            paramDataArray[4] = new IlsJob.ParamData(AUDIT_ARCHIVE_FORMAT_PARAM_NAME, 2, this.theJobData.param5IsDefined() ? this.theJobData.getParam5() : "xml", false, string);
        }
        catch (WdoBaseException wdoBaseException) {
            paramDataArray = null;
        }
        return paramDataArray;
    }

    public String getJobParamsString() {
        String string = null;
        try {
            string = "Audit Retention Period=" + (this.theJobData.param1IsDefined() ? this.theJobData.getParam1() : String.valueOf(30L)) + "&" + AUDIT_ARCHIVE_RETENTION_PARAM_NAME + "=" + (this.theJobData.param2IsDefined() ? this.theJobData.getParam2() : String.valueOf(30L)) + "&" + AUDIT_ARCHIVE_DIRECTORY_PARAM_NAME + "=" + (this.theJobData.param3IsDefined() ? this.theJobData.getParam3() : AUDIT_ARCHIVE_DEFAULT_DIRECTORY) + "&" + AUDIT_ARCHIVE_PURGED_PARAM_NAME + "=" + (this.theJobData.param4IsDefined() ? this.theJobData.getParam4() : AUDIT_DEFAULT_ARCHIVE_PURGED) + "&" + AUDIT_ARCHIVE_FORMAT_PARAM_NAME + "=" + (this.theJobData.param5IsDefined() ? this.theJobData.getParam5() : "xml");
        }
        catch (WdoBaseException wdoBaseException) {
            string = null;
        }
        return string;
    }

    public String[] getAllowedJobSchedules() {
        String[] stringArray = new String[]{"Never", "Now", "Every Interval"};
        return stringArray;
    }

    public String[] getAllowedJobEventTriggers() {
        String[] stringArray = new String[]{"None", "Schedule"};
        return stringArray;
    }

    protected boolean updateJobSpecificParams(IlsJob.ParamData[] paramDataArray, Boolean[] booleanArray) {
        try {
            if (booleanArray[0].booleanValue()) {
                this.theJobData.setParam1(paramDataArray[0].paramValue);
            }
            if (booleanArray[1].booleanValue()) {
                this.theJobData.setParam2(paramDataArray[1].paramValue);
            }
            if (booleanArray[2].booleanValue()) {
                this.theJobData.setParam3(paramDataArray[2].paramValue);
            }
            if (booleanArray[3].booleanValue()) {
                this.theJobData.setParam4(paramDataArray[3].paramValue);
            }
            if (booleanArray[4].booleanValue()) {
                this.theJobData.setParam5(paramDataArray[4].paramValue);
            }
        }
        catch (WdoBaseException wdoBaseException) {
            boolean bl = false;
            return bl;
        }
        return true;
    }

    protected boolean doTheJob() {
        try {
            Date date = new Date();
            IlsJob.ParamData[] paramDataArray = this.getJobParams();
            boolean bl = this._$7233(date, paramDataArray);
            if (bl && IlsUtil.GetBooleanFromString(paramDataArray[3].paramValue, true)) {
                bl = this._$7270(date, paramDataArray);
            }
            boolean bl2 = bl;
            return bl2;
        }
        catch (WdoBaseException wdoBaseException) {
            this.cmdArgs.setStatusInfo(1000, "AuditJob got unexpected Wdo exception. Exception: " + ((Object)((Object)wdoBaseException)).getClass().getName() + ", Message: " + wdoBaseException.getMessage());
            return false;
        }
    }

    protected boolean abortTheJob() {
        System.out.println("!!!PRETEND-AUDIT-ABORT!!!!");
        return true;
    }

    private boolean _$7233(Date date, IlsJob.ParamData[] paramDataArray) throws WdoBaseException {
        block6: {
            Object object;
            long l = IlsUtil.GetPositiveLong(paramDataArray[0].paramValue);
            long l2 = date.getTime() - l * 86400000L;
            boolean bl = IlsUtil.GetBooleanFromString(paramDataArray[3].paramValue, true);
            IlsUtil.Trace(7, "AuditJob", "archiveAndPurge: enter.  Retention days=" + l + ", doArchive=" + bl);
            String string = null;
            String string2 = null;
            long l3 = 0L;
            if (bl) {
                string = paramDataArray[2].paramValue;
                object = new File(string);
                if (!((File)object).exists() && !((File)object).mkdir()) {
                    this.cmdArgs.setStatusInfo(25, "Unable to create audit archive directory '" + ((File)object).getAbsolutePath() + "'");
                    return false;
                }
                string2 = paramDataArray[4].paramValue;
                l3 = this.theJobData.getNextSeq();
            }
            Object object2 = object = bl ? this.makeJobFilename(date, string, AUDIT_JOB_NAME, string2) : "";
            if (object == null) {
                return false;
            }
            long l4 = 0L;
            do {
                String string3 = "jobcmd=" + this.getJobName() + "Job";
                if (bl) {
                    string3 = String.valueOf(string3) + "&archivefile=" + (String)object;
                }
                this.cmdArgs.setRequest(string3);
                Object[] objectArray = new Object[]{new Integer(1000), new Long(l2), object, string2, new Long(l4), null};
                if (!this.processLuwCmd(new AuditPurgeJobEventLuw(), objectArray, false)) {
                    return false;
                }
                long l5 = (Long)objectArray[5];
                l4 += l5;
                if (l5 < (long)1000) break block6;
            } while (IlsUtil.Sleep(1000));
            IlsUtil.Trace(7, "Audit Job", "archiveAndPurge: exiting audit / purge loop due to interruption.");
            this.cmdArgs.setStatusInfo(-501, "Audit cleaner job was interrupted");
            return false;
        }
        return true;
    }

    private boolean _$7270(Date date, IlsJob.ParamData[] paramDataArray) {
        long l = IlsUtil.GetPositiveLong(paramDataArray[0].paramValue);
        IlsUtil.Trace(7, "AuditJob", "deleteOldArchives: enter.  Retention days=" + l);
        return this.deleteOldFiles(date, paramDataArray[2].paramValue, l, new AuditArchiveFilenameFilter());
    }
}

