/*
 * Decompiled with CFR 0.152.
 */
package com.vs.ils;

import com.vs.ils.CheckoutCmd;
import com.vs.ils.IlsCmdAPI;
import com.vs.ils.IlsCmdArgs;
import com.vs.ils.IlsUtil;
import com.vs.ils.ilsdb.AuditTrail;
import com.vs.wdo.rtl.WdoBaseException;
import com.vs.wdo.rtl.WdoUnitOfWork;
import java.sql.Timestamp;
import java.util.Date;

class AuditCmdEventLuw
implements WdoUnitOfWork {
    AuditCmdEventLuw() {
    }

    public void doIt(int n, Object[] objectArray) throws WdoBaseException {
        Date date = new Date();
        IlsCmdAPI ilsCmdAPI = (IlsCmdAPI)objectArray[0];
        IlsCmdArgs ilsCmdArgs = ilsCmdAPI.getCmdArgs();
        IlsUtil.Trace(10, "IlsCmdAPI", "AuditCmdEventLuw: enter.  Service: " + ilsCmdAPI.getServiceName());
        AuditTrail auditTrail = AuditTrail.GetAuditTrail();
        auditTrail.setEventDate(new Timestamp(date.getTime()));
        auditTrail.setEventTs(date.getTime());
        auditTrail.setSource("CLI");
        auditTrail.setCategory("CMD");
        int n2 = ilsCmdArgs.getStatus();
        int n3 = 1;
        if (n2 > 0) {
            n3 = n2 >= 500 ? 4 : 3;
        } else if (n2 < 0 && n2 > -100) {
            n3 = 2;
        }
        boolean bl = false;
        if (n2 != 0) {
            IlsUtil.Trace(10, "IlsCmdAPI", "AuditCmdEventLuw: non-0 status, and msg is: '" + ilsCmdArgs.getMsg() + "'");
            bl = true;
        }
        String string = ilsCmdArgs.getMachine() == null || ilsCmdArgs.getMachine().equals("") ? "unknown" : ilsCmdArgs.getMachine();
        auditTrail.setUserName(CheckoutCmd.MakeAnonUsername(ilsCmdArgs.getUser(), string, 0L));
        auditTrail.setDomainName(ilsCmdArgs.getDomain() == null || ilsCmdArgs.getDomain().equals("") ? "default" : ilsCmdArgs.getDomain());
        auditTrail.setProductName(ilsCmdArgs.getProduct() == null || ilsCmdArgs.getProduct().equals("") ? "system" : ilsCmdArgs.getProduct());
        auditTrail.setMachineName(string);
        auditTrail.setSeverity(n3);
        auditTrail.setViewAuthLevel(2);
        auditTrail.setViewDetailLevel(3);
        auditTrail.setCmd(ilsCmdArgs.getCmd());
        auditTrail.setEventStatusCode(n2);
        String string2 = ilsCmdArgs.getRequest();
        if (string2 == null) {
            string2 = "";
        }
        auditTrail.setRequestMsg(IlsUtil.URLDecode(IlsUtil.GetScrambledMsg(string2).replace('&', '|')));
        String string3 = ilsCmdArgs.makeCmdResponse(false);
        if (string3 == null) {
            string3 = "";
        }
        auditTrail.setResponseMsg(IlsUtil.URLDecode(string3));
        if (bl) {
            IlsUtil.Trace(10, "IlsCmdAPI", "AuditCmdEventLuw: non-0 status, and msg after setting audit trail entries and before setting msg is: '" + ilsCmdArgs.getMsg() + "'");
        }
        if (ilsCmdArgs.getMsg() != null) {
            auditTrail.setEventStatusMsg(String.valueOf(ilsCmdArgs.getMsg()) + (ilsCmdArgs.getValue() != null ? ilsCmdArgs.getValue() : ""));
        }
        if (bl) {
            IlsUtil.Trace(10, "IlsCmdAPI", "AuditCmdEventLuw: non-0 status, and msg in audit trail entry is: '" + auditTrail.getEventStatusMsg() + "'");
        }
        IlsUtil.Trace(10, "IlsCmdAPI", "AuditCmdEventLuw: creating entry in db.  Service: " + ilsCmdAPI.getServiceName());
        AuditTrail.Create((AuditTrail)auditTrail);
        IlsUtil.Trace(10, "IlsCmdAPI", "AuditCmdEventLuw: done.  Service: " + ilsCmdAPI.getServiceName());
    }
}

