/*
 * Decompiled with CFR 0.152.
 */
package com.vs.ils;

import com.sun.mail.smtp.SMTPAddressFailedException;
import com.sun.mail.smtp.SMTPAddressSucceededException;
import com.sun.mail.smtp.SMTPSendFailedException;
import com.sun.mail.smtp.SMTPTransport;
import com.vs.ils.IlsEventHandler;
import com.vs.ils.IlsJob;
import com.vs.ils.IlsUtil;
import com.vs.ils.RoutingTableEntry;
import com.vs.wdo.rtl.WdoBaseException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class AlerterJob
extends IlsJob {
    static final String ALERTER_JOB_NAME = "Alerter";
    static final String ALERTER_JOB_EXTERNAL_NAME = "Event Alerter";
    static final String SMTP_ADDRESS_PARAM_NAME = "SMTP Server";
    static final String SMTP_AUTHENT_USERNAME_PARAM_NAME = "SMTP Server Username";
    static final String SMTP_AUTHENT_PASSWD_PARAM_NAME = "SMTP Server Password";
    static final String SMTP_PORT_PARAM_NAME = "SMTP Port Number";
    static final String SMTP_ALTPORT_PARAM_NAME = "SMTP Alternate Port";
    static final String ADMIN_EMAIL_PARAM_NAME = "Email Routing Specification";
    static final int DEFAULT_SMTP_PORT = 25;
    static final int DEFAULT_SMTP_ALTPORT = 587;
    static final String DEFAULT_SMTP_SERVER = "localhost";
    static final String syshandlers = "[IlsNullMsgEventHandler][IlsTerseMsgEventHandler][IlsVerboseMsgEventHandler]";
    private long _$1762;
    private String _$1780;

    public static String[] MakeEventParams(String string, String string2, String string3) {
        boolean bl = string == null || string.equals("system");
        boolean bl2 = string != null && (string2 == null || string2.equals("system"));
        boolean bl3 = string != null && string2 != null && (string3 == null || string3.startsWith("useradmin"));
        String[] stringArray = null;
        if (!bl) {
            int n = bl2 ? 1 : (bl3 ? 2 : 3);
            stringArray = new String[n];
            stringArray[0] = string;
            if (!bl2) {
                stringArray[1] = string2;
                if (!bl3) {
                    stringArray[2] = string3;
                }
            }
        }
        return stringArray;
    }

    public static String[] MakeEventParams(String string, String string2) {
        return AlerterJob.MakeEventParams(string, string2, null);
    }

    public static String[] MakeEventParams(String string) {
        return AlerterJob.MakeEventParams(string, null, null);
    }

    public synchronized long checkBackupInProgress() {
        return this._$1762;
    }

    public String getJobName() {
        return ALERTER_JOB_NAME;
    }

    public String getJobExternalName() {
        return ALERTER_JOB_EXTERNAL_NAME;
    }

    public IlsJob.ParamData[] getJobParams() {
        IlsJob.ParamData[] paramDataArray = new IlsJob.ParamData[6];
        try {
            paramDataArray[0] = new IlsJob.ParamData(SMTP_ADDRESS_PARAM_NAME, 2, this.theJobData.param1IsDefined() ? this.theJobData.getParam1() : DEFAULT_SMTP_SERVER, false, null);
            paramDataArray[1] = new IlsJob.ParamData(SMTP_AUTHENT_USERNAME_PARAM_NAME, 2, this.theJobData.param2IsDefined() ? this.theJobData.getParam2() : "", false, null);
            paramDataArray[2] = new IlsJob.ParamData(SMTP_AUTHENT_PASSWD_PARAM_NAME, 2, this.theJobData.param3IsDefined() ? this.theJobData.getParam3() : "", true, null);
            paramDataArray[3] = new IlsJob.ParamData(SMTP_PORT_PARAM_NAME, 1, this.theJobData.param4IsDefined() ? this.theJobData.getParam4() : String.valueOf(25), false, null);
            paramDataArray[4] = new IlsJob.ParamData(SMTP_ALTPORT_PARAM_NAME, 1, this.theJobData.param5IsDefined() ? this.theJobData.getParam5() : String.valueOf(587), false, null);
            paramDataArray[5] = new IlsJob.ParamData(ADMIN_EMAIL_PARAM_NAME, 2, this.theJobData.param6IsDefined() ? this.theJobData.getParam6() : "", false, null);
        }
        catch (WdoBaseException wdoBaseException) {
            paramDataArray = null;
        }
        return paramDataArray;
    }

    public String getJobParamsString() {
        String string = null;
        try {
            string = "SMTP Server=" + (this.theJobData.param1IsDefined() ? this.theJobData.getParam1() : DEFAULT_SMTP_SERVER) + "&" + SMTP_AUTHENT_USERNAME_PARAM_NAME + "=" + (this.theJobData.param2IsDefined() ? this.theJobData.getParam2() : "") + "&" + SMTP_AUTHENT_PASSWD_PARAM_NAME + "=" + (this.theJobData.param3IsDefined() ? this.theJobData.getParam3() : "") + "&" + SMTP_PORT_PARAM_NAME + "=" + (this.theJobData.param4IsDefined() ? this.theJobData.getParam4() : String.valueOf(25)) + "&" + SMTP_PORT_PARAM_NAME + "=" + (this.theJobData.param5IsDefined() ? this.theJobData.getParam5() : String.valueOf(587)) + "&" + ADMIN_EMAIL_PARAM_NAME + "=" + (this.theJobData.param6IsDefined() ? this.theJobData.getParam6() : "");
        }
        catch (WdoBaseException wdoBaseException) {
            string = null;
        }
        return string;
    }

    public String[] getAllowedJobSchedules() {
        String[] stringArray = new String[]{"Never", "Now", "Every Interval"};
        return stringArray;
    }

    public String[] getAllowedJobEventTriggers() {
        String[] stringArray = new String[]{"None", "Schedule", "Administration Command", "Licensing Error", "Licensing Warning", "System Error", "Configuration Error", "Authorization Error", "General Error", "General Warning", "Informational Message", "Custom Command"};
        return stringArray;
    }

    protected boolean updateJobSpecificParams(IlsJob.ParamData[] paramDataArray, Boolean[] booleanArray) {
        try {
            if (booleanArray[0].booleanValue()) {
                this.theJobData.setParam1(paramDataArray[0].paramValue);
            }
            if (booleanArray[1].booleanValue()) {
                this.theJobData.setParam2(paramDataArray[1].paramValue);
            }
            if (booleanArray[2].booleanValue()) {
                this.theJobData.setParam3(paramDataArray[2].paramValue);
            }
            if (booleanArray[3].booleanValue()) {
                this.theJobData.setParam4(paramDataArray[3].paramValue);
            }
            if (booleanArray[4].booleanValue()) {
                this.theJobData.setParam5(paramDataArray[4].paramValue);
            }
            if (booleanArray[5].booleanValue()) {
                this.theJobData.setParam6(paramDataArray[5].paramValue);
            }
        }
        catch (WdoBaseException wdoBaseException) {
            boolean bl = false;
            return bl;
        }
        return true;
    }

    protected boolean doTheJob() {
        String[] stringArray;
        Vector vector;
        Date date = new Date();
        IlsJob.ParamData[] paramDataArray = this.getJobParams();
        IlsUtil.Trace(9, "AlerterJob", "doTheJob: enter.\nRouting table spec: " + (paramDataArray[5].paramValue == null ? "none" : "[" + paramDataArray[5].paramValue + "]"));
        if (paramDataArray[5].paramValue == null || this.triggerEvent == null) {
            return true;
        }
        this._$1780 = IlsJob.MapTriggerToTrigcode(this.triggerEvent);
        if (this._$1780 == null) {
            IlsUtil.Trace(1, "AlerterJob", "doTheJob: could not resolve job code '" + this.triggerEvent + "'");
            this.cmdArgs.setStatusInfo(1000, "AlerterJob: could not resolve job code '" + this.triggerEvent + "'");
            return false;
        }
        String[] stringArray2 = this._$2855(date, this.triggerEventParams);
        IlsUtil.Trace(9, "AlerterJob", "doTheJob:\n\nEmail header: " + stringArray2[0] + "\nEmail body:\n" + stringArray2[1]);
        String string = null;
        String string2 = null;
        String string3 = null;
        if (this.checkValidEmailAddr(paramDataArray[5].paramValue)) {
            string3 = paramDataArray[5].paramValue;
        } else {
            vector = new Vector();
            stringArray = new Hashtable();
            String[] stringArray3 = this._$2975(vector, (Hashtable)stringArray, paramDataArray[5].paramValue, 0);
            if (stringArray3 != null) {
                string = stringArray3[0];
                string2 = stringArray3[1];
            }
            string3 = this._$2992(this.triggerEventParams, vector);
        }
        if (string3 == null) {
            return true;
        }
        if (string == null) {
            string = "orionsysadmin@noreply.com";
        }
        IlsUtil.Trace(9, "AlerterJob", "doTheJob:\nEmail list:\n" + string3 + "\nEmail header:\n" + stringArray2[0] + "\nEmail text:\n" + stringArray2[1] + "\nfromAddr: " + string + "\nhandlerName: " + string2);
        if (string2 != null) {
            if (syshandlers.indexOf("[" + string2 + "]") >= 0) {
                string2 = "com.vs.ils." + string2;
            }
            vector = null;
            try {
                vector = (IlsEventHandler)Class.forName(string2).newInstance();
                stringArray = vector.handleEvent(this.serviceName, string, string3, this.triggerEvent, this._$1780, this.triggerEventParams, this.triggerEventData, stringArray2[0], stringArray2[1], string3);
                if (stringArray == null) {
                    boolean bl = true;
                    return bl;
                }
                string = stringArray[0];
                stringArray2[0] = stringArray[1];
                stringArray2[1] = stringArray[2];
                string3 = stringArray[3];
                IlsUtil.Trace(9, "AlerterJob", "doTheJob after handler processing:\nEmail list:\n" + string3 + "\nEmail header:\n" + stringArray2[0] + "\nEmail text:\n" + stringArray2[1] + "\nfromAddr: " + string);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (!IlsUtil.CheckDebug(3) && string3 != null) {
            int n = IlsUtil.GetPositiveInt(paramDataArray[3].paramValue);
            int n2 = IlsUtil.GetPositiveInt(paramDataArray[4].paramValue);
            boolean bl = this._$3153(date, paramDataArray[0].paramValue, paramDataArray[1].paramValue, paramDataArray[2].paramValue, n, stringArray2[0], stringArray2[1], string, string3);
            if (!bl && n2 > 0) {
                bl = this._$3153(date, paramDataArray[0].paramValue, paramDataArray[1].paramValue, paramDataArray[2].paramValue, n2, stringArray2[0], stringArray2[1], string, string3);
            }
            return bl;
        }
        return true;
    }

    protected boolean abortTheJob() {
        System.out.println("!!!PRETEND-ALERTER-ABORT!!!!");
        return true;
    }

    private String[] _$2975(Vector vector, Hashtable hashtable, String string, int n) {
        String string2 = null;
        String string3 = null;
        String[] stringArray = string.split(",");
        IlsUtil.Trace(9, "AlerterJob", "makeRoutingTable: split routing table [" + string + "] to " + stringArray.length + " entries");
        int n2 = 0;
        while (n2 < stringArray.length) {
            IlsUtil.Trace(9, "AlerterJob", "makeRoutingTable: processing entry [" + stringArray[n2] + "]:");
            String[] stringArray2 = stringArray[n2].split("=");
            if (stringArray2.length != 2) {
                IlsUtil.Trace(7, "AlerterJob", "makeRoutingTable: bad entry [" + stringArray[n2] + "]: too many equality operators");
            } else {
                String[] stringArray3 = stringArray2[0].split("::");
                if (stringArray3.length > 2) {
                    IlsUtil.Trace(7, "AlerterJob", "makeRoutingTable: bad entry [" + stringArray[n2] + "]: too many event-qualifier separators");
                } else {
                    String string4;
                    String string5 = string4 = stringArray3.length > 1 ? stringArray3[0] : null;
                    if (string4 != null && !this._$3294(string4, this._$1780)) {
                        IlsUtil.Trace(9, "AlerterJob", "makeRoutingTable: entry [" + stringArray[n2] + "] disqualified - does not match event type [" + this._$1780 + "]");
                    } else {
                        String string6 = stringArray3.length > 1 ? stringArray3[1] : stringArray3[0];
                        int n3 = RoutingTableEntry.GetRoutingEntryType(string6);
                        IlsUtil.Trace(9, "AlerterJob", "makeRoutingTable: entry is of type: " + n3);
                        if (n3 == 0) {
                            IlsUtil.Trace(7, "AlerterJob", "makeRoutingTable: bad entry [" + stringArray[n2] + "]: unrecognized entry type [" + string6 + "]");
                        } else {
                            switch (n3) {
                                case 2: {
                                    IlsUtil.Trace(9, "AlerterJob", "makeRoutingTable: processing sys entry: adding to table");
                                    vector.addElement(new RoutingTableEntry("sys", stringArray2[1]));
                                    break;
                                }
                                case 100: {
                                    IlsUtil.Trace(9, "AlerterJob", "makeRoutingTable: processing from-addr entry: setting from-addr to " + stringArray2[1]);
                                    string2 = stringArray2[1];
                                    break;
                                }
                                case 101: {
                                    IlsUtil.Trace(9, "AlerterJob", "makeRoutingTable: processing handler entry: setting handler to " + stringArray2[1]);
                                    string3 = stringArray2[1];
                                    break;
                                }
                                case 1: {
                                    IlsUtil.Trace(9, "AlerterJob", "makeRoutingTable: processing file entry");
                                    if (hashtable.containsKey(stringArray2[1])) break;
                                    hashtable.put(stringArray2[1], new Integer(n));
                                    String string7 = this.readFileEntries(stringArray2[1]);
                                    if (string7 == null) {
                                        IlsUtil.Trace(7, "AlerterJob", "makeRoutingTable: bad entry [" + stringArray[n2] + "]: could not read file entries");
                                        break;
                                    }
                                    String[] stringArray4 = this._$2975(vector, hashtable, string7, n + 1);
                                    if (stringArray4 == null) break;
                                    if (stringArray4[0] != null) {
                                        string2 = stringArray4[0];
                                    }
                                    if (stringArray4[1] == null) break;
                                    string3 = stringArray4[1];
                                    break;
                                }
                                case 3: 
                                case 4: 
                                case 5: {
                                    IlsUtil.Trace(9, "AlerterJob", "makeRoutingTable: processing prod / dom / user entry: adding to table");
                                    vector.addElement(new RoutingTableEntry(string6, stringArray2[1]));
                                }
                            }
                        }
                    }
                }
            }
            ++n2;
        }
        return new String[]{string2, string3};
    }

    /*
     * Unable to fully structure code
     */
    String readFileEntries(String var1_1) {
        block12: {
            var2_2 = new File(var1_1);
            if (!var2_2.exists()) {
                return null;
            }
            var3_3 = null;
            var4_4 = null;
            var4_4 = new BufferedReader(new InputStreamReader(new FileInputStream(var2_2)));
            var5_5 = null;
            var6_7 = 1;
            if (true) ** GOTO lbl17
            do {
                ++var6_7;
                if (!(var5_5 = var5_5.trim()).startsWith("#") && !var5_5.equals("")) {
                    var3_3 = var3_3 == null ? "" : String.valueOf(var3_3) + ",";
                    var3_3 = String.valueOf(var3_3) + var5_5;
                }
lbl17:
                // 4 sources

                var5_5 = var4_4.readLine();
                if (var5_5 == null) break;
            } while (var6_7 < 100);
            var8_8 = null;
            try {
                var4_4.close();
            }
            catch (Exception var9_11) {}
            break block12;
            {
                catch (IOException var5_6) {
                    var3_3 = null;
                    var8_9 = null;
                    try {
                        var4_4.close();
                    }
                    catch (Exception var9_12) {}
                }
            }
            catch (Throwable var7_14) {
                var8_10 = null;
                try {
                    var4_4.close();
                }
                catch (Exception var9_13) {
                    // empty catch block
                }
                throw var7_14;
            }
        }
        return var3_3;
    }

    boolean checkValidEmailAddr(String string) {
        if (string.indexOf("=") >= 0 || string.indexOf(":") >= 0 || string.indexOf(";") >= 0 || string.indexOf("+") >= 0 || string.indexOf(",") >= 0) {
            IlsUtil.Trace(9, "AlerterJob", "checkValidEmailAddr: not valid email addr: found one of =:;+, chars");
            return false;
        }
        String[] stringArray = string.split("@");
        if (stringArray.length != 2) {
            IlsUtil.Trace(9, "AlerterJob", "checkValidEmailAddr: not valid email addr: didn't find '@'");
            return false;
        }
        String string2 = stringArray[1];
        if ((stringArray = string2.split("[.]")).length < 2) {
            IlsUtil.Trace(9, "AlerterJob", "checkValidEmailAddr: not valid email addr: didn't find '.' in domain name spec [" + string2 + "] - got # of parts = " + String.valueOf(stringArray.length));
        }
        return stringArray.length >= 2;
    }

    private String _$2992(String[] stringArray, Vector vector) {
        if (vector == null) {
            return null;
        }
        IlsUtil.Trace(9, "AlerterJob", "makeEmailList: enter.  Routing table # of elements = " + vector.size());
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string = null;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            RoutingTableEntry routingTableEntry = (RoutingTableEntry)enumeration.nextElement();
            IlsUtil.Trace(9, "AlerterJob", "makeEmailList: processing entry with formal params: [" + routingTableEntry.formalParams[0] + "...], email addresses: [" + routingTableEntry.emailAddrs[0] + "...]");
            if (!this._$3823(stringArray, routingTableEntry.formalParams)) continue;
            int n = 0;
            while (n < routingTableEntry.emailAddrs.length) {
                if (!hashtable.containsKey(routingTableEntry.emailAddrs[n])) {
                    if (!this.checkValidEmailAddr(routingTableEntry.emailAddrs[n])) {
                        IlsUtil.Trace(9, "AlerterJob", "makeEmailList: tossing invalid email address [" + routingTableEntry.emailAddrs[n] + "]");
                    } else {
                        hashtable.put(routingTableEntry.emailAddrs[n], "x");
                        string = string == null ? "" : String.valueOf(string) + ",";
                        IlsUtil.Trace(9, "AlerterJob", "makeEmailList: adding email address [" + routingTableEntry.emailAddrs[n]);
                        string = String.valueOf(string) + routingTableEntry.emailAddrs[n];
                    }
                }
                ++n;
            }
        }
        return string;
    }

    private boolean _$3823(String[] stringArray, String[] stringArray2) {
        boolean bl = stringArray2 != null && stringArray2.length == 1 && (stringArray2[0].equals("sys") || stringArray2[0].equals("system") || stringArray2[0].equals("sysadmin"));
        IlsUtil.Trace(9, "AlerterJob", "matchEntry: isSys=" + bl);
        if (bl) {
            return true;
        }
        if (stringArray == null || stringArray.length == 0) {
            IlsUtil.Trace(9, "AlerterJob", "matchEntry: mismatch due to not sys and no actual pars");
            return false;
        }
        if (stringArray2.length > stringArray.length) {
            IlsUtil.Trace(9, "AlerterJob", "matchEntry: false match due to formal pars length " + stringArray2.length + "being greater than actual pars length " + stringArray.length);
            return false;
        }
        try {
            int n = 0;
            while (n < stringArray2.length) {
                if (!stringArray[n].matches(stringArray2[n])) {
                    IlsUtil.Trace(9, "AlerterJob", "matchEntry: false match due to actual par " + stringArray[n] + "not pattern-matching formal par " + stringArray2[n]);
                    boolean bl2 = false;
                    return bl2;
                }
                ++n;
            }
        }
        catch (Throwable throwable) {
            boolean bl3 = false;
            return bl3;
        }
        return true;
    }

    private String _$3863(String[] stringArray, boolean bl) {
        String string = bl ? "=" : ":  ";
        String string2 = bl ? "," : "\n";
        String string3 = "";
        if (stringArray == null) {
            string3 = "Event Type" + string + "System-level Event";
        } else {
            string3 = stringArray.length == 1 ? "Product" : (stringArray.length == 2 ? "Domain" : "User");
            string3 = String.valueOf(string3) + "-level Event" + string2;
            if (!bl) {
                string = ":     ";
            }
            string3 = String.valueOf(string3) + "Product" + string + stringArray[0];
            if (stringArray.length > 1) {
                if (!bl) {
                    string = ":      ";
                }
                string3 = String.valueOf(string3) + string2 + "Domain" + string + stringArray[1];
            }
            if (stringArray.length > 2) {
                if (!bl) {
                    string = ":        ";
                }
                string3 = String.valueOf(string3) + string2 + "User" + string + stringArray[2];
            }
            if (!bl) {
                string = ":  ";
            }
            string3 = "Event Type" + string + string3;
        }
        return string3;
    }

    private String[] _$2855(Date date, String[] stringArray) {
        String string = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z").format(date);
        String[] stringArray2 = new String[]{"Orion License Server Alert: " + this.triggerEvent, "\nSystem Parameters\n-----------------\nService:     " + this.serviceName + "\nHost:        " + IlsUtil.GetHostName() + "\nDate:        " + string + "\n\nEvent Parameters" + "\n----------------\n" + "Event:       " + this.triggerEvent + "\n" + this._$3863(stringArray, false) + "\n" + (this.triggerEventData == null || this.triggerEventData.equals("") ? "<<no data>>" : this.triggerEventData)};
        return stringArray2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean _$3153(Date date, String string, String string2, String string3, int n, String string4, String string5, String string6, String string7) {
        String string8;
        Exception exception3;
        block10: {
            block9: {
                Exception exception2;
                MessagingException messagingException;
                this.cmdArgs.setStatusInfo(0, "");
                try {
                    Properties properties = System.getProperties();
                    properties.put("mail.smtp.host", string);
                    properties.put("mail.smtp.auth", string2 != null ? "true" : "false");
                    Session session = Session.getInstance((Properties)properties, null);
                    MimeMessage mimeMessage = new MimeMessage(session);
                    mimeMessage.setFrom((Address)new InternetAddress(string6.trim()));
                    mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)string7.trim()));
                    mimeMessage.setSubject(string4);
                    mimeMessage.setText(string5);
                    mimeMessage.setHeader("X-Mailer", "smtpsend");
                    mimeMessage.setSentDate(date);
                    InternetAddress[] internetAddressArray = new InternetAddress[]{new InternetAddress(string6)};
                    mimeMessage.setReplyTo((Address[])internetAddressArray);
                    SMTPTransport sMTPTransport = (SMTPTransport)session.getTransport("smtp");
                    try {
                        sMTPTransport.connect(string, n, string2, string3);
                        sMTPTransport.sendMessage((Message)mimeMessage, mimeMessage.getAllRecipients());
                        Object var16_22 = null;
                    }
                    catch (Throwable throwable) {
                        Object var16_23 = null;
                        sMTPTransport.close();
                        throw throwable;
                    }
                    sMTPTransport.close();
                    return true;
                }
                catch (Exception exception3) {
                    string8 = "";
                    if (!(exception3 instanceof SendFailedException)) break block9;
                    messagingException = (MessagingException)exception3;
                    if (messagingException instanceof SMTPSendFailedException) {
                        SMTPSendFailedException sMTPSendFailedException = (SMTPSendFailedException)messagingException;
                        string8 = "SMTP SEND failed:";
                        string8 = String.valueOf(string8) + "  Command: " + sMTPSendFailedException.getCommand();
                        string8 = String.valueOf(string8) + "  RetCode: " + sMTPSendFailedException.getReturnCode();
                        string8 = String.valueOf(string8) + "  Response: " + sMTPSendFailedException.getMessage();
                    }
                    string8 = String.valueOf(string8) + "Send failed: " + messagingException.toString();
                }
                while ((exception2 = messagingException.getNextException()) != null && exception2 instanceof MessagingException) {
                    SMTPAddressFailedException sMTPAddressFailedException;
                    messagingException = (MessagingException)exception2;
                    if (messagingException instanceof SMTPAddressFailedException) {
                        sMTPAddressFailedException = (SMTPAddressFailedException)messagingException;
                        string8 = String.valueOf(string8) + " ADDRESS failed: ";
                        string8 = String.valueOf(string8) + "  Address: " + sMTPAddressFailedException.getAddress();
                        string8 = String.valueOf(string8) + "  Command: " + sMTPAddressFailedException.getCommand();
                        string8 = String.valueOf(string8) + "  RetCode: " + sMTPAddressFailedException.getReturnCode();
                        string8 = String.valueOf(string8) + "  Response: " + sMTPAddressFailedException.getMessage();
                        continue;
                    }
                    if (!(messagingException instanceof SMTPAddressSucceededException)) continue;
                    string8 = String.valueOf(string8) + " ADDRESS succeeded: ";
                    sMTPAddressFailedException = (SMTPAddressSucceededException)messagingException;
                    string8 = String.valueOf(string8) + "  Address: " + sMTPAddressFailedException.getAddress();
                    string8 = String.valueOf(string8) + "  Command: " + sMTPAddressFailedException.getCommand();
                    string8 = String.valueOf(string8) + "  RetCode: " + sMTPAddressFailedException.getReturnCode();
                    string8 = String.valueOf(string8) + "  Response: " + sMTPAddressFailedException.getMessage();
                }
                break block10;
            }
            if (exception3 instanceof AddressException) {
                string8 = "Exception: " + exception3.getClass().getName() + ", Message: " + exception3.getMessage();
                string8 = String.valueOf(string8) + ", Ref=" + ((AddressException)exception3).getRef() + ", Pos=" + ((AddressException)exception3).getPos();
            } else {
                string8 = "Exception: " + exception3.getClass().getName() + ", Message: " + exception3.getMessage();
            }
        }
        IlsUtil.Trace(false, 3, "AlerterJob", new String[]{"sendEmailAlert: internal error sending email.  Details:", string8}, true, exception3);
        this.cmdArgs.setStatusInfo(25, "Internal error: unable to send mail.  Details: " + string8);
        return false;
    }

    private static String _$4533(String string) {
        if (string == null) {
            return null;
        }
        if (string.equals("Schedule")) {
            return "SCHEDULE";
        }
        if (string.equals("User Command")) {
            return "COMMAND";
        }
        if (string.equals("Administration Command")) {
            return "ADMIN";
        }
        if (string.equals("Licensing Error")) {
            return "LICENSE";
        }
        if (string.equals("Licensing Warning")) {
            return "LICENSEWARN";
        }
        if (string.equals("System Error")) {
            return "SYSTEM";
        }
        if (string.equals("Configuration Error")) {
            return "CONFIG";
        }
        if (string.equals("Authorization Error")) {
            return "AUTH";
        }
        if (string.equals("General Error")) {
            return "OTHERERROR";
        }
        if (string.equals("General Warning")) {
            return "OTHERWARN";
        }
        if (string.equals("Informational Message")) {
            return "INFO";
        }
        if (string.equals("Custom Command")) {
            return "CUSTOM";
        }
        return null;
    }

    private boolean _$3294(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        if (string == null || (string = string.trim()).equals("")) {
            return true;
        }
        String[] stringArray = string.split("[+]");
        if (stringArray == null) {
            return true;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equalsIgnoreCase(string2)) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

