/*
 * Decompiled with CFR 0.152.
 */
package com.vs.ils;

import com.vs.ils.AlerterJob;
import com.vs.ils.DomainLicenseCacheEntry;
import com.vs.ils.IlsAdminAPI;
import com.vs.ils.IlsCmdAPI;
import com.vs.ils.IlsCmdArgs;
import com.vs.ils.IlsLicense;
import com.vs.ils.IlsLicenseCache;
import com.vs.ils.IlsUtil;
import com.vs.ils.LuwUtil;
import com.vs.ils.ProductLicenseCacheEntry;
import com.vs.ils.UserCleanupJob;
import com.vs.ils.ilsdb.Domain;
import com.vs.ils.ilsdb.LicenseParamInfo;
import com.vs.ils.ilsdb.Product;
import com.vs.ils.ilsdb.User;
import com.vs.wdo.rtl.WdoBaseException;
import com.vs.wdo.rtl.WdoDuplicateObjectException;
import com.vs.wdo.rtl.WdoUnitOfWork;
import java.sql.Timestamp;
import java.util.Date;

class AddUserLuw
implements WdoUnitOfWork {
    AddUserLuw() {
    }

    public void doIt(int n, Object[] objectArray) throws WdoBaseException {
        IlsAdminAPI ilsAdminAPI = (IlsAdminAPI)objectArray[0];
        IlsCmdArgs ilsCmdArgs = ilsAdminAPI.getCmdArgs();
        Object[] objectArray2 = (Object[])objectArray[1];
        String string = (String)objectArray2[0];
        String string2 = (String)objectArray2[1];
        String string3 = (String)objectArray2[2];
        String string4 = (String)objectArray2[3];
        String string5 = (String)objectArray2[4];
        String string6 = (String)objectArray2[5];
        LicenseParamInfo licenseParamInfo = (LicenseParamInfo)objectArray2[6];
        String string7 = (String)objectArray2[7];
        Long l = (Long)objectArray2[8];
        String string8 = (String)objectArray2[9];
        String string9 = (String)objectArray2[10];
        int n2 = (Integer)objectArray2[11];
        ilsAdminAPI.checkAuthorization(string3 != null && string3.startsWith("useradmin") ? 3 : 2);
        long l2 = Product.FindAnyByName((String)string);
        if (l2 == (long)0) {
            ilsCmdArgs.setStatusInfo(102, "Product '" + string + "' has disappeared", null, AlerterJob.MakeEventParams(string, string2, string3));
            WdoBaseException.ThrowProxyWdoException((int)12);
        }
        Product product = Product.GetProduct((long)l2);
        ilsAdminAPI.checkNoAudit(product);
        long l3 = Domain.FindAnyByName((String)string, (String)string2);
        if (l3 == (long)0) {
            ilsCmdArgs.setStatusInfo(102, "Domain '" + string2 + "' has disappeared", null, AlerterJob.MakeEventParams(string, string2, string3));
            WdoBaseException.ThrowProxyWdoException((int)12);
        }
        Domain domain = Domain.GetDomain((long)l3);
        long l4 = User.FindAnyByName((String)string, (String)string2, (String)string3);
        if (l4 != (long)0) {
            ilsCmdArgs.setCmd("UpdateUser");
        }
        AddUserLuw.addUser(ilsAdminAPI, product, domain, l4, string3, string4, string5, string6, licenseParamInfo, string8, string9, string7, l, n2);
    }

    static void addUser(IlsAdminAPI ilsAdminAPI, Product product, Domain domain, long l, String string, String string2, String string3, String string4, LicenseParamInfo licenseParamInfo, String string5, String string6, String string7, Long l2, int n) throws WdoBaseException {
        boolean bl;
        long l3;
        boolean bl2;
        IlsCmdArgs ilsCmdArgs = ilsAdminAPI.getCmdArgs();
        String string8 = product.getName();
        String string9 = domain.getName();
        if (licenseParamInfo == null) {
            licenseParamInfo = new LicenseParamInfo();
        }
        boolean bl3 = string8.equals("system");
        boolean bl4 = domain.getName().equals("system");
        boolean bl5 = false;
        boolean bl6 = string6 != null && string6.equals("RegisterCmd");
        User user = null;
        Date date = new Date();
        String string10 = null;
        IlsLicense ilsLicense = null;
        ProductLicenseCacheEntry productLicenseCacheEntry = null;
        DomainLicenseCacheEntry domainLicenseCacheEntry = null;
        boolean bl7 = domain.getLicenseModel().equals("NUSER");
        boolean bl8 = bl2 = bl7 && string.equals("useradmin");
        if (!bl3) {
            if (!bl4 && !bl2) {
                productLicenseCacheEntry = IlsLicenseCache.getProductCacheEntry(date, product);
                domainLicenseCacheEntry = productLicenseCacheEntry.getDomainEntry(date, domain, bl7);
            }
            l3 = 0L;
            if (!(bl4 || l != (long)0 || bl6 || bl2)) {
                l3 = productLicenseCacheEntry.getCurrLimit() + (long)1;
                IlsUtil.Trace(5, "IlsAdminAPI", "AddUserLuw: found current product user count: " + l3);
            }
            if (!(ilsLicense = new IlsLicense(product.getLicenseKey(), ilsAdminAPI.getServiceName(), product.getName(), l3, product.optionsIsDefined() ? product.getOptions() : "", !product.getInited())).checkLicense(ilsCmdArgs, true)) {
                WdoBaseException.ThrowProxyWdoException((int)12);
            }
            boolean bl9 = bl = IlsCmdAPI.CheckPosthumousActivation(string8, ilsLicense) && l != (long)0;
            if (!bl && !ilsLicense.checkLicense(ilsCmdArgs)) {
                WdoBaseException.ThrowProxyWdoException((int)12);
            }
            if (!(bl4 || l != (long)0 || bl6 || bl2 || domainLicenseCacheEntry.checkLimit(date, ilsCmdArgs, product, domain, 1, domain.getUserLimit()))) {
                ilsCmdArgs.setStatusInfo(26, "Concurrent license limit of " + domain.getUserLimit() + " point(s) for license domain " + domain.getName() + " (product " + product.getName() + ")" + " exceeded", null, AlerterJob.MakeEventParams(string8, string9, string));
                WdoBaseException.ThrowProxyWdoException((int)12);
            }
            string10 = ilsLicense.getKeyInfo().getOptions();
        }
        if (!(string10 == null || product.optionsIsDefined() && string10.equals(product.getOptions()))) {
            product.setOptions(string10);
        }
        if (!((l3 = ilsAdminAPI.getValidatedDomainQuotaLimit(product, domain)) < (long)0 || licenseParamInfo.getQuotaLimited() && licenseParamInfo.getQuota() <= l3)) {
            licenseParamInfo.setQuotaLimited(true);
            licenseParamInfo.setQuota(l3);
            ilsCmdArgs.setStatusInfo(-104, "User is set to quota-limited based on the owning domain's quota limit of " + l3, null, AlerterJob.MakeEventParams(string8, string9, string));
        }
        if (!UserCleanupJob.DoingUserCleanup(ilsCmdArgs)) {
            WdoBaseException.ThrowProxyWdoException((int)12);
        }
        try {
            if (l != (long)0) {
                user = User.GetUser((long)l);
            }
            String string11 = string10 = licenseParamInfo.optionsIsDefined() ? licenseParamInfo.getOptions() : "*";
            if (!string10.equals("")) {
                bl = bl3 ? false : IlsCmdAPI.CheckHosted(string8, ilsLicense);
                if (!IlsCmdAPI.verifyAndMakeOptionSubset(string8, string9, string, ilsCmdArgs, string10, domain.getLicenseParams().optionsIsDefined() ? domain.getLicenseParams().getOptions() : "*", false, bl)) {
                    WdoBaseException.ThrowProxyWdoException((int)12);
                }
                string10 = ilsCmdArgs.getOptions();
                if (IlsUtil.CheckDebug(5)) {
                    System.out.println("addUser: dom-processed options: " + string10);
                }
            }
            if (string10.equals("") && user != null && user.getLicenseParams().optionsIsDefined()) {
                string10 = user.getLicenseParams().getOptions();
            } else if (string10.equals("") && domain.getLicenseParams().optionsIsDefined()) {
                string10 = domain.getLicenseParams().getOptions();
            } else if (string10.equals("") && product.optionsIsDefined()) {
                String string12 = ilsCmdArgs.getOptions();
                if (!IlsCmdAPI.verifyAndMakeOptionSubset(string8, string9, string, ilsCmdArgs, "*", product.optionsIsDefined() ? product.getOptions() : "", false)) {
                    WdoBaseException.ThrowProxyWdoException((int)12);
                }
                string10 = ilsCmdArgs.getOptions();
                ilsCmdArgs.setOptions(string12);
            }
            IlsUtil.Trace(5, "IlsAdminAPI", "AddUserLuw: resultant options: " + string10);
            licenseParamInfo.setOptions(string10.trim());
            if (l == (long)0) {
                try {
                    l = AddUserLuw.AddUser(date, string, string2, product, domain, licenseParamInfo, string3, string4, l2 == null ? -1L : l2, string5, string6);
                }
                catch (WdoDuplicateObjectException wdoDuplicateObjectException) {
                    ilsCmdArgs.setStatusInfo(101, "User '" + string + "' is already defined in domain '" + domain.getName() + "' for product '" + product.getName() + "'", null, AlerterJob.MakeEventParams(string8, string9, string));
                    WdoBaseException.ThrowProxyWdoException((int)12);
                }
                bl5 = true;
                IlsUtil.Trace(1, "IlsAdminAPI", "AddUserLuw: added user '" + string + "' for domain '" + domain.getName() + "', product '" + product.getName() + "'");
                if (!(bl4 || bl6 || bl2)) {
                    domainLicenseCacheEntry.adjustWatermark(date, domain, 1, true);
                }
            }
            if (!bl5) {
                int n2;
                LicenseParamInfo licenseParamInfo2 = (LicenseParamInfo)user.getLicenseParams().clone();
                boolean bl10 = LuwUtil.SyncLicenseParams(licenseParamInfo2, licenseParamInfo);
                if (bl10) {
                    user.setLicenseParams(licenseParamInfo2);
                }
                if (!IlsUtil.GetEncryptedPasswd(string2, string).equals(user.getPasswd())) {
                    IlsUtil.Trace(true, 10, "IlsAdminAPI", new String[]{"Changing user password from " + user.getPasswd() + " to " + string2 + " for user " + string}, false);
                    user.setPasswd(IlsUtil.GetEncryptedPasswd(string2, string));
                    bl10 = true;
                }
                if (!(string3 == null || user.userParamsIsDefined() && string3.equals(user.getUserParams()))) {
                    user.setUserParams(string3);
                    bl10 = true;
                }
                if (!(string4 == null || user.applicationContextIsDefined() && string4.equals(user.getApplicationContext()))) {
                    user.setApplicationContext(string4);
                    bl10 = true;
                }
                if (l2 != null && l2.longValue() != user.getCurrQuotaUsageLevel()) {
                    user.setCurrQuotaUsageLevel(l2.longValue());
                    bl10 = true;
                }
                int n3 = bl3 ? n : (n2 = IlsCmdAPI.getCancelAuthLevel(product.optionsIsDefined() ? product.getOptions() : null));
                if (string5 != null && user.getEnabled() != string5.equals("Yes")) {
                    if (IlsCmdAPI.CheckUserCheckedOut(date, user)) {
                        if (n < n2) {
                            ilsCmdArgs.setStatusInfo(18, "Insufficient privilege level for disabling a checked-out user", null, AlerterJob.MakeEventParams(string8, string9, string));
                            WdoBaseException.ThrowProxyWdoException((int)12);
                        }
                        if (!(string5.equals("Yes") || bl3 || bl4 || bl2)) {
                            domainLicenseCacheEntry.adjustCheckoutWatermark(date, domain, -1, true);
                        }
                    }
                    user.setEnabled(string5.equals("Yes"));
                    if (!(bl7 || bl3 || bl4 || bl2)) {
                        domainLicenseCacheEntry.adjustDisabledUserWatermark(!string5.equals("Yes"), true);
                    }
                    bl10 = true;
                }
                if (string7 != null && user.getCheckoutInfo().getCheckedOut() != string7.equals("Yes")) {
                    if (IlsCmdAPI.CheckUserCheckedOut(date, user) && n < n2) {
                        ilsCmdArgs.setStatusInfo(18, "Insufficient privilege level for cancelling an in-progress checkout", null, AlerterJob.MakeEventParams(string8, string9, string));
                        WdoBaseException.ThrowProxyWdoException((int)12);
                    }
                    if (!(bl3 || bl4 || bl2)) {
                        domainLicenseCacheEntry.adjustCheckoutWatermark(date, domain, string7.equals("Yes") ? 1 : -1, true);
                    }
                    user.getCheckoutInfo().setCheckedOut(string7.equals("Yes"));
                    user.setIsDirty(true);
                    bl10 = true;
                }
                if (string6 != null && !string6.equals(user.getAdminInfo().getNotes())) {
                    user.getAdminInfo().setNotes(string6);
                    user.setIsDirty(true);
                    bl10 = true;
                }
                if (bl10) {
                    user.setIsDirty(true);
                    user.getAdminInfo().setUpdateDate(new Timestamp(date.getTime()));
                    ilsCmdArgs.setStatusInfo(-100, "Updated user '" + user.getName() + "' in domain '" + domain.getName() + "', product '" + product.getName() + "'", null, AlerterJob.MakeEventParams(string8, string9, string));
                } else {
                    IlsUtil.Trace(5, "IlsAdminAPI", "AddUserLuw: user " + user.getName() + " doesn't need updating.");
                    ilsCmdArgs.setStatusInfo(-102, "User '" + string + "' is already defined for domain '" + domain.getName() + "', product '" + product.getName() + "' exactly as specified", null, AlerterJob.MakeEventParams(string8, string9, string));
                }
            }
            Object var36_36 = null;
        }
        catch (Throwable throwable) {
            Object var36_37 = null;
            UserCleanupJob.DoneUserCleanup();
            throw throwable;
        }
        UserCleanupJob.DoneUserCleanup();
    }

    public static long AddUser(Date date, String string, String string2, Product product, Domain domain, LicenseParamInfo licenseParamInfo, String string3, String string4, String string5, String string6) throws WdoBaseException {
        return AddUserLuw.AddUser(date, string, string2, product, domain, licenseParamInfo, string3, string4, -1L, string5, string6);
    }

    public static long AddUser(Date date, String string, String string2, Product product, Domain domain, LicenseParamInfo licenseParamInfo, String string3, String string4, long l, String string5, String string6) throws WdoBaseException {
        User user = User.GetUser();
        user.setName(string);
        IlsUtil.Trace(true, 10, "IlsAdminAPI", new String[]{"AddUser: setting new user password to: " + string2 + " for user: " + string}, false);
        user.setPasswd(IlsUtil.GetEncryptedPasswd(string2, string));
        if (licenseParamInfo.getQuotaGrace() > domain.getLicenseParams().getQuotaGrace()) {
            licenseParamInfo.setQuotaGrace(domain.getLicenseParams().getQuotaGrace());
        }
        user.setLicenseParams(licenseParamInfo);
        user.setCheckoutDurationSec(0L);
        user.setAdminInfo(LuwUtil.SetupAdminInfo(date));
        if (string6 != null) {
            user.getAdminInfo().setNotes(string6);
        }
        if (string3 != null) {
            user.setUserParams(string3);
        }
        if (string4 != null) {
            user.setApplicationContext(string4);
        }
        if (string5 != null) {
            user.setEnabled(string5.equals("Yes"));
        }
        if (l > (long)0) {
            user.setCurrQuotaUsageLevel(l);
        }
        user.setRegistered(true);
        return User.Create((User)user, (long)domain.getDomainId(), (long)product.getProductId());
    }
}

