/*
 * Decompiled with CFR 0.152.
 */
package com.vs.ils;

import com.vs.ezlicgen.EzLicenseFullInfo;
import com.vs.ezlicrun.EzLicExceptionBase;
import com.vs.ezlicrun.EzLicenseInfo;
import com.vs.ezlicrun.PkCrypt;
import com.vs.ils.AddDomainLuw;
import com.vs.ils.AlerterJob;
import com.vs.ils.IlsAdminAPI;
import com.vs.ils.IlsCmdAPI;
import com.vs.ils.IlsCmdArgs;
import com.vs.ils.IlsLicense;
import com.vs.ils.IlsLicenseCache;
import com.vs.ils.IlsUtil;
import com.vs.ils.LuwUtil;
import com.vs.ils.ProductLicenseCacheEntry;
import com.vs.ils.ilsdb.AdminInfo;
import com.vs.ils.ilsdb.Domain;
import com.vs.ils.ilsdb.LicenseParamInfo;
import com.vs.ils.ilsdb.Product;
import com.vs.wdo.rtl.WdoBaseException;
import com.vs.wdo.rtl.WdoDuplicateObjectException;
import com.vs.wdo.rtl.WdoUnitOfWork;
import java.sql.Timestamp;
import java.util.Date;

class AddProductLuw
implements WdoUnitOfWork {
    AddProductLuw() {
    }

    public void doIt(int n, Object[] objectArray) throws WdoBaseException {
        String string;
        String string2;
        long l;
        IlsAdminAPI ilsAdminAPI = (IlsAdminAPI)objectArray[0];
        IlsCmdArgs ilsCmdArgs = ilsAdminAPI.getCmdArgs();
        Object[] objectArray2 = (Object[])objectArray[1];
        String string3 = (String)objectArray2[0];
        String string4 = (String)objectArray2[1];
        String string5 = (String)objectArray2[2];
        String string6 = (String)objectArray2[3];
        IlsUtil.Trace(5, "IlsAdminAPI", "AddProductLuw:doIt:enter.  Options:[" + string6 + "]");
        int n2 = (Integer)objectArray2[4];
        String string7 = (String)objectArray2[5];
        boolean bl = ((String)objectArray2[6]).equals("1");
        IlsLicense ilsLicense = (IlsLicense)objectArray2[7];
        int n3 = (Integer)objectArray2[8];
        ilsAdminAPI.checkAuthorization(4);
        boolean bl2 = IlsCmdAPI.CheckHosted(string3, ilsLicense);
        objectArray2[10] = new Boolean(bl2);
        boolean bl3 = IlsCmdAPI.CheckPosthumousActivation(string3, ilsLicense);
        String string8 = null;
        boolean bl4 = string3.equals("system");
        boolean bl5 = false;
        String string9 = null;
        boolean bl6 = false;
        boolean bl7 = false;
        Date date = new Date();
        Product product = null;
        long l2 = Product.FindAnyByName((String)string3);
        if (l2 == (long)0) {
            EzLicenseFullInfo ezLicenseFullInfo;
            bl6 = true;
            bl7 = true;
            product = Product.GetProduct();
            objectArray2[9] = product;
            product.setName(string3);
            product.setTitle(string4);
            product.setLicenseKey(string5);
            product.setEnabled(bl);
            product.setUserLimit(n2);
            EzLicenseFullInfo ezLicenseFullInfo2 = ezLicenseFullInfo = ilsLicense == null ? null : ilsLicense.getKeyInfo();
            if (ilsLicense != null) {
                if ((ezLicenseFullInfo.getLicenseModeBitmap() & 1) != 0) {
                    product.setTimeLimited(true);
                    product.setExpTs(ezLicenseFullInfo.getExpirationDate().getTime());
                }
                if ((ezLicenseFullInfo.getLicenseModeBitmap() & 2) != 0) {
                    product.setQuotaLimited(true);
                    product.setQuota(ezLicenseFullInfo.getQuotaValue());
                }
            }
            AdminInfo adminInfo = LuwUtil.SetupAdminInfo(date);
            if (string7 != null) {
                adminInfo.setNotes(string7);
            }
            product.setAdminInfo(adminInfo);
            if (ezLicenseFullInfo != null && ezLicenseFullInfo.getOptions() != null && !ezLicenseFullInfo.getOptions().equals("")) {
                product.setOptions(ezLicenseFullInfo.getOptions());
                IlsUtil.Trace(5, "IlsAdminAPI", "AddProductLuw:doIt: setting prod options to keyinfo options: [" + ezLicenseFullInfo.getOptions() + "]");
            }
            try {
                l2 = Product.Create((Product)product);
            }
            catch (WdoDuplicateObjectException wdoDuplicateObjectException) {
                ilsCmdArgs.setStatusInfo(101, "Product '" + product.getName() + "' is already defined", null, AlerterJob.MakeEventParams(product.getName()));
                WdoBaseException.ThrowProxyWdoException((int)12);
            }
            product = Product.GetProduct((long)l2);
            IlsUtil.Trace(1, "IlsAdminAPI", "AddProductLuw: Added product '" + product.getName() + "'");
        } else {
            ilsCmdArgs.setCmd("UpdateProduct");
            product = Product.GetProduct((long)l2);
            objectArray2[9] = product;
            if (!product.getTitle().equals(string4)) {
                IlsUtil.Trace(7, "IlsAdminAPI", "AddProductLuw: updating title to '" + string4 + "'");
                product.setTitle(string4);
            }
            if (string5 != null && !product.getLicenseKey().equals(string5)) {
                EzLicenseFullInfo ezLicenseFullInfo;
                bl7 = true;
                bl5 = true;
                string9 = product.getLicenseKey();
                product.setLicenseKey(string5);
                EzLicenseFullInfo ezLicenseFullInfo3 = ezLicenseFullInfo = ilsLicense == null ? null : ilsLicense.getKeyInfo();
                if (ilsLicense != null) {
                    if ((ezLicenseFullInfo.getLicenseModeBitmap() & 1) != 0) {
                        product.setTimeLimited(true);
                        product.setExpTs(ezLicenseFullInfo.getExpirationDate().getTime());
                    } else {
                        product.setTimeLimited(false);
                    }
                    if ((ezLicenseFullInfo.getLicenseModeBitmap() & 2) != 0) {
                        product.setQuotaLimited(true);
                        product.setQuota(ezLicenseFullInfo.getQuotaValue());
                    } else {
                        product.setQuotaLimited(false);
                    }
                    if (string6 == null) {
                        product.setOptions(ezLicenseFullInfo.getOptions());
                    } else {
                        product.setOptions(string6);
                        IlsUtil.Trace(5, "IlsAdminAPI", "AddProductLuw:doIt:new-key: setting prod options to [" + string6 + "]");
                    }
                    if (product.getInited()) {
                        ilsLicense.setNoNodelockCheck(false);
                    }
                }
            } else if (!(string6 == null || string6.equals("") || product.optionsIsDefined() && product.getOptions().equals(string6))) {
                product.setOptions(string6);
                IlsUtil.Trace(5, "IlsAdminAPI", "AddProductLuw:doIt:same-key: setting prod options to [" + string6 + "]");
            }
            if (n2 > 0 && product.getUserLimit() != n2) {
                IlsUtil.Trace(5, "IlsAdminAPI", "AddProductLuw: updating userLimit to '" + n2 + "'");
                product.setUserLimit(n2);
            }
            if (product.getEnabled() != bl) {
                if (product.getEnabled()) {
                    int n4 = IlsCmdAPI.getCancelAuthLevel(string6);
                    long l3 = product.getCheckoutUserCount(date.getTime());
                    if (l3 > (long)0 && n3 < n4) {
                        ilsCmdArgs.setStatusInfo(18, "Insufficient privileges for disabling a product having checked-out users", null, AlerterJob.MakeEventParams(product.getName()));
                        WdoBaseException.ThrowProxyWdoException((int)12);
                    }
                }
                IlsUtil.Trace(5, "IlsAdminAPI", "AddProductLuw: updating enabled to '" + bl + "'");
                product.setEnabled(bl);
            }
            if (string7 != null && !product.getAdminInfo().getNotes().equals(string7)) {
                product.getAdminInfo().setNotes(string7);
                product.setIsDirty(true);
            }
            if (!product.getIsDirty()) {
                ilsCmdArgs.setStatusInfo(-102, "Product '" + string3 + "' is already defined exactly as specified", null, AlerterJob.MakeEventParams(product.getName()));
                return;
            }
            product.getAdminInfo().setUpdateDate(new Timestamp(date.getTime()));
            ilsCmdArgs.setStatusInfo(-100, "Updated entry for product " + product.getName(), null, AlerterJob.MakeEventParams(product.getName()));
            IlsUtil.Trace(1, "IlsAdminAPI", "AddProductLuw: Updated product '" + product.getName() + "'");
        }
        if (bl7 && !bl4) {
            long l4 = date.getTime();
            long l5 = ilsLicense.getKeyInfo().getCreationTimestamp();
            if (l5 > (long)0) {
                long l6 = 168L;
                if (product.optionsIsDefined() && (l = IlsCmdAPI.GetIlsLongOption(product.getOptions(), "ILS:KEY-SHELF-LIFE-HRS")) > (long)0) {
                    l6 = l;
                }
                if ((l = l4 - l5) < (long)0 && -l / (long)3600000 > (long)6 || l > (l6 *= (long)3600000)) {
                    ilsCmdArgs.setStatusInfo(26, "Either the license server machine clock is not properly set or the key is stale and was not installed in time", null, AlerterJob.MakeEventParams(product.getName()));
                    WdoBaseException.ThrowProxyWdoException((int)12);
                }
            }
            if (bl5) {
                try {
                    if (ilsLicense.getKeyInfo().getChainedKeyId() != null) {
                        IlsLicense ilsLicense2 = new IlsLicense(string9, ilsLicense.serviceName, ilsLicense.productName, 0L);
                        if (!ilsLicense2.checkLicense(ilsCmdArgs, true)) {
                            ilsCmdArgs.setStatusInfo(26, "Previous key is invalid", null, AlerterJob.MakeEventParams(product.getName()));
                            WdoBaseException.ThrowProxyWdoException((int)12);
                        }
                        if (!ilsLicense.getKeyInfo().getChainedKeyId().equals(ilsLicense2.getKeyInfo().getId()) || ilsLicense.getKeyInfo().getCreationTimestamp() <= ilsLicense2.getKeyInfo().getCreationTimestamp()) {
                            IlsUtil.Trace(3, "IlsAdminAPI.addProductLuw", "Key chaining problem: \nChain key id: [" + ilsLicense.getKeyInfo().getChainedKeyId() + "], prev key id: [" + ilsLicense2.getKeyInfo().getId() + "\nChain create ts: " + ilsLicense.getKeyInfo().getCreationTimestamp() + ", prev key create ts: " + ilsLicense2.getKeyInfo().getCreationTimestamp());
                            ilsCmdArgs.setStatusInfo(26, "Replacement key is not for previous key", null, AlerterJob.MakeEventParams(product.getName()));
                            WdoBaseException.ThrowProxyWdoException((int)12);
                        }
                    }
                }
                catch (EzLicExceptionBase ezLicExceptionBase) {
                    ilsCmdArgs.setStatusInfo(1000, "Internal error.  Please have your administrator contact Agilis with the following message: Prev key getid");
                    WdoBaseException.ThrowProxyWdoException((int)12);
                }
            }
            try {
                string2 = ilsLicense.getKeyInfo().getAppPwd();
                if (string2 != null) {
                    string2 = PkCrypt.makePublicKey((String)string2);
                }
                string8 = EzLicenseInfo.createKeyCookieSeed((String)product.getName(), (String)string2, null, (boolean)false);
                product.setKcooky(string8);
            }
            catch (EzLicExceptionBase ezLicExceptionBase) {
                ilsCmdArgs.setStatusInfo(1000, "Internal error.  Please have your administrator contact Agilis with the following message: CreateKeyCookie.  Class: " + ((Object)((Object)ezLicExceptionBase)).getClass().getName() + ", Message: " + ezLicExceptionBase.getMessage());
                WdoBaseException.ThrowProxyWdoException((int)12);
            }
        }
        LicenseParamInfo licenseParamInfo = new LicenseParamInfo();
        if (product.getTimeLimited()) {
            licenseParamInfo.setTimeLimitType("ABST");
            licenseParamInfo.setExpDate(new Timestamp(product.getExpTs()));
        }
        if (product.getQuotaLimited()) {
            licenseParamInfo.setQuotaLimited(true);
            licenseParamInfo.setQuota(product.getQuota());
        }
        LicenseParamInfo licenseParamInfo2 = licenseParamInfo;
        if (bl2 && (product.getTimeLimited() || product.getQuotaLimited())) {
            licenseParamInfo2 = (LicenseParamInfo)licenseParamInfo.clone();
            if (product.getTimeLimited()) {
                licenseParamInfo2.setExpGrace(bl3 ? 10000 : 30);
            }
            if (product.getQuotaLimited()) {
                licenseParamInfo2.setQuotaGrace((long)(bl3 ? 1000000000 : 1000));
            }
        }
        if (bl6 || !product.getInited()) {
            String string10 = string = bl4 || !product.optionsIsDefined() ? null : IlsCmdAPI.GetIlsStringOption(product.getOptions(), "ILS:LOCK-DIR");
            if (string != null && !string.equals("NO") && string.equals("IMMED")) {
                product.setInited(true);
                product.setCurd(System.getProperty("user.dir"));
            }
        }
        if (bl6) {
            if (product.optionsIsDefined()) {
                string = ilsCmdArgs.getOptions();
                if (!IlsCmdAPI.verifyAndMakeOptionSubset(product.getName(), null, null, ilsCmdArgs, "*", product.getOptions(), false)) {
                    WdoBaseException.ThrowProxyWdoException((int)12);
                }
                string6 = ilsCmdArgs.getOptions();
                ilsCmdArgs.setOptions(string);
            }
            long l7 = AddDomainLuw.AddDomain(ilsCmdArgs, date, "system", "IUSER", product, licenseParamInfo2, bl4 ? 4 : 3, product.getUserLimit(), 0L, -1L, true, "Created internally.");
            if (!bl4) {
                if (string6 == null) {
                    string6 = "";
                }
                licenseParamInfo.setOptions(string6);
                long l8 = IlsCmdAPI.GetIlsLongOption(string6, "ILS:DURATION-FLOOR");
                l = IlsCmdAPI.GetIlsLongOption(string6, "ILS:DURATION-CEILING");
                if (l8 < (long)0) {
                    l8 = 0L;
                }
                long l9 = AddDomainLuw.AddDomain(ilsCmdArgs, date, "default-iuser", "IUSER", product, licenseParamInfo, 2L, product.getUserLimit(), l8, l, true, "Created internally.");
                long l10 = AddDomainLuw.AddDomain(ilsCmdArgs, date, "default-nuser", "NUSER", product, licenseParamInfo, 2L, product.getUserLimit(), l8, l, true, "Created internally.");
            }
        } else if (!bl4) {
            ProductLicenseCacheEntry productLicenseCacheEntry;
            long l11 = Domain.FindAnyByName((String)string3, (String)"system");
            string2 = Domain.GetDomain((long)l11);
            boolean bl8 = LuwUtil.SyncLicenseParams(licenseParamInfo2, string2.getLicenseParams());
            if (bl8) {
                string2.setLicenseParams(licenseParamInfo2);
                string2.setIsDirty(true);
            }
            if ((productLicenseCacheEntry = IlsLicenseCache.getProductCacheEntry(date, product)).getCurrLimit() > (long)product.getUserLimit()) {
                ilsCmdArgs.setStatusInfo(17, "New license limit of " + product.getUserLimit() + " point(s) for product " + product.getName() + " will be exceeded if product is updated. " + "Retaining existing limit of " + productLicenseCacheEntry.getLicenseLimit() + " point(s).", null, AlerterJob.MakeEventParams(product.getName()));
                WdoBaseException.ThrowProxyWdoException((int)12);
            }
            productLicenseCacheEntry.setLicenseLimit(product.getUserLimit());
        }
        IlsLicense.KHfile.updateHfile(ilsAdminAPI.getServiceName(), product.getName(), string8, null);
        IlsUtil.Trace(1, "IlsAdminAPI", "AddProductLuw: product '" + product.getName() + "' update / add successful completion");
    }
}

