/*
 * Decompiled with CFR 0.152.
 */
package com.vs.ils;

import com.vs.ils.AddUserLuw;
import com.vs.ils.AlerterJob;
import com.vs.ils.DomainLicenseCacheEntry;
import com.vs.ils.IlsAdminAPI;
import com.vs.ils.IlsCmdAPI;
import com.vs.ils.IlsCmdArgs;
import com.vs.ils.IlsLicense;
import com.vs.ils.IlsLicenseCache;
import com.vs.ils.IlsUtil;
import com.vs.ils.LuwUtil;
import com.vs.ils.ilsdb.AdminInfo;
import com.vs.ils.ilsdb.Domain;
import com.vs.ils.ilsdb.LicenseParamInfo;
import com.vs.ils.ilsdb.Product;
import com.vs.wdo.rtl.WdoBaseException;
import com.vs.wdo.rtl.WdoDuplicateObjectException;
import com.vs.wdo.rtl.WdoUnitOfWork;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;

class AddDomainLuw
implements WdoUnitOfWork {
    AddDomainLuw() {
    }

    public void doIt(int n, Object[] objectArray) throws WdoBaseException {
        String string;
        boolean bl;
        long l;
        long l2;
        int n2;
        IlsUtil.Trace(5, "IlsAdminAPI", "AddDomainLuw: enter");
        IlsAdminAPI ilsAdminAPI = (IlsAdminAPI)objectArray[0];
        IlsCmdArgs ilsCmdArgs = ilsAdminAPI.getCmdArgs();
        Object[] objectArray2 = (Object[])objectArray[1];
        String string2 = (String)objectArray2[0];
        String string3 = (String)objectArray2[1];
        String string4 = (String)objectArray2[2];
        LicenseParamInfo licenseParamInfo = (LicenseParamInfo)objectArray2[3];
        Long l3 = (Long)objectArray2[4];
        Long l4 = (Long)objectArray2[5];
        Long l5 = (Long)objectArray2[6];
        Long l6 = (Long)objectArray2[7];
        Long l7 = (Long)objectArray2[8];
        String string5 = (String)objectArray2[9];
        String string6 = (String)objectArray2[10];
        int n3 = (Integer)objectArray2[11];
        if (licenseParamInfo == null) {
            licenseParamInfo = new LicenseParamInfo();
        }
        IlsUtil.Trace(5, "IlsAdminAPI", new String[]{"AddDomainLuw: enter.  Input license params:", licenseParamInfo.toXML(), "Auth level:" + l3});
        ilsAdminAPI.checkAuthorization(3);
        IlsUtil.Trace(5, "IlsAdminAPI", "AddDomainLuw: looking up product: '" + string2 + "'");
        boolean bl2 = string2.equals("system");
        long l8 = Product.FindAnyByName((String)string2);
        if (l8 == (long)0) {
            IlsUtil.Trace(5, "IlsAdminAPI", "AddDomainLuw: product: '" + string2 + "' not found!");
            ilsCmdArgs.setStatusInfo(102, "Product '" + string2 + "' has disappeared", null, AlerterJob.MakeEventParams(string2, string3));
            return;
        }
        Product product = Product.GetProduct((long)l8);
        ilsAdminAPI.checkNoAudit(product);
        boolean bl3 = false;
        long l9 = Domain.FindAnyByName((String)string2, (String)string3);
        Domain domain = null;
        Date date = new Date();
        IlsUtil.Trace(5, "IlsAdminAPI", "AddDomainLuw: looking up domain: '" + string3 + "'");
        IlsLicense ilsLicense = null;
        if (!bl2) {
            ilsLicense = new IlsLicense(product.getLicenseKey(), ilsAdminAPI.getServiceName(), product.getName(), 0L, product.optionsIsDefined() ? product.getOptions() : "", !product.getInited());
            if (!ilsLicense.checkLicense(ilsCmdArgs, true)) {
                WdoBaseException.ThrowProxyWdoException((int)12);
            }
            int n4 = n2 = IlsCmdAPI.CheckPosthumousActivation(string2, ilsLicense) && l9 != (long)0 ? 1 : 0;
            if (n2 == 0 && !ilsLicense.checkLicense(ilsCmdArgs)) {
                WdoBaseException.ThrowProxyWdoException((int)12);
            }
        }
        n2 = -1;
        if (l4 != null) {
            n2 = (int)l4.longValue();
        }
        if (n2 == -1 || n2 > product.getUserLimit()) {
            n2 = product.getUserLimit();
            ilsCmdArgs.setStatusInfo(-104, "Specified sub-limit of " + n2 + " point(s) for domain " + string3 + " exceeds license limit of " + product.getUserLimit() + " licensed point(s) for associated product " + product.getName() + ".  Adjusted down to product's licensed limit.", null, AlerterJob.MakeEventParams(string2, string3));
            l4 = new Long(n2);
        }
        if (l9 > (long)0 && ((domain = Domain.GetDomain((long)l9)).getUserLimit() < 0 || domain.getUserLimit() > product.getUserLimit())) {
            domain.setUserLimit(product.getUserLimit());
        }
        if (!((l2 = ilsAdminAPI.getValidatedProductQuotaLimit(product)) < (long)0 || licenseParamInfo.getQuotaLimited() && licenseParamInfo.getQuota() <= l2)) {
            licenseParamInfo.setQuotaLimited(true);
            licenseParamInfo.setQuota(l2);
            ilsCmdArgs.setStatusInfo(-104, "Domain is set to quota-limited based on the owning product's quota limit of " + l2, null, AlerterJob.MakeEventParams(string2, string3));
        }
        if ((l = ilsAdminAPI.getValidatedProductExpTs(product)) > (long)0 && (licenseParamInfo.getTimeLimitType().equals("ABST") && licenseParamInfo.getExpDate().getTime() > l || licenseParamInfo.getTimeLimitType().equals("RELT") && licenseParamInfo.getExpDays() * (long)86400000 + date.getTime() > l)) {
            licenseParamInfo.setTimeLimitType("ABST");
            licenseParamInfo.setExpDate(new Timestamp(l));
            ilsCmdArgs.setStatusInfo(-104, "Domain is set to absolute time-limited based on the owning product's expiration date " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z").format(new Date(l)), null, AlerterJob.MakeEventParams(string2, string3));
        }
        if (l9 != (long)0) {
            domain = Domain.GetDomain((long)l9);
        }
        String string7 = licenseParamInfo.optionsIsDefined() ? licenseParamInfo.getOptions() : "";
        boolean bl4 = bl = bl2 ? false : IlsCmdAPI.CheckHosted(string2, ilsLicense);
        if (!string7.equals("")) {
            if (!IlsCmdAPI.verifyAndMakeOptionSubset(string2, string3, null, ilsCmdArgs, string7, product.optionsIsDefined() ? product.getOptions() : "", false, bl)) {
                WdoBaseException.ThrowProxyWdoException((int)12);
            }
            if ((string7 = ilsCmdArgs.getOptions()) == null) {
                string7 = "";
            }
            IlsUtil.Trace(5, "IlsAdminAPI", "AddDomainLuw: prod-processed options: " + string7);
        }
        if (string7.equals("") && domain != null && domain.getLicenseParams().optionsIsDefined()) {
            string7 = domain.getLicenseParams().getOptions();
        } else if (string7.equals("") && product.optionsIsDefined()) {
            string = ilsCmdArgs.getOptions();
            if (!IlsCmdAPI.verifyAndMakeOptionSubset(string2, string3, null, ilsCmdArgs, "*", product.optionsIsDefined() ? product.getOptions() : "", false)) {
                WdoBaseException.ThrowProxyWdoException((int)12);
            }
            string7 = ilsCmdArgs.getOptions();
            ilsCmdArgs.setOptions(string);
            if (string7 == null) {
                string7 = "";
            }
            IlsUtil.Trace(5, "IlsAdminAPI", "AddDomainLuw: prod-processed options: " + string7);
        }
        IlsUtil.Trace(5, "IlsAdminAPI", "AddDomainLuw: resultant options: " + string7);
        licenseParamInfo.setOptions(string7.trim());
        if (l9 == (long)0) {
            IlsUtil.Trace(5, "IlsAdminAPI", "AddDomainLuw: domain: '" + string3 + "' not found, creating");
            l9 = AddDomainLuw.AddDomain(ilsCmdArgs, date, string3, string4, product, licenseParamInfo, l3 == null ? 2L : l3, n2, l5 == null ? -1L : l5, l6 == null ? -1L : l6, l7 == null ? -1L : l7, string5 == null || string5.equalsIgnoreCase("Yes"), string6);
            IlsUtil.Trace(1, "IlsAdminAPI", "AddDomainLuw: added domain '" + string3 + "' for product '" + product.getName() + "'");
            bl3 = true;
        }
        if (!bl3) {
            boolean bl5;
            ilsCmdArgs.setCmd("UpdateDomain");
            IlsUtil.Trace(5, "IlsAdminAPI", new String[]{"AddDomainLuw: domain: '" + string3 + "' found, being updated", "Current domain state:", domain.toXML()});
            if (string4 != null && !domain.getLicenseModel().equals(string4)) {
                domain.setLicenseModel(string4);
            }
            boolean bl6 = bl5 = LuwUtil.SyncLicenseParams((LicenseParamInfo)(string = (LicenseParamInfo)domain.getLicenseParams().clone()), licenseParamInfo) || domain.getIsDirty();
            if (bl5) {
                domain.setLicenseParams((LicenseParamInfo)string);
            }
            if (l3 != null && (int)l3.longValue() != domain.getAuthlevel()) {
                IlsUtil.Trace(7, "IlsAdminAPI", "AddDomainLuw: updating authlevel from " + domain.getAuthlevel() + " to " + String.valueOf(l3));
                domain.setAuthlevel((int)l3.longValue());
                bl5 = true;
            }
            if (l4 != null && (int)l4.longValue() != domain.getUserLimit()) {
                domain.setUserLimit((int)l4.longValue());
                bl5 = true;
            }
            if (l5 != null && l5.longValue() != domain.getMinCheckoutDurationSec()) {
                AddDomainLuw.SetMinDuration(ilsCmdArgs, product.optionsIsDefined() ? product.getOptions() : "", product, domain, l5);
                bl5 = true;
            }
            if (l6 != null && l6.longValue() != domain.getMaxCheckoutDurationSec()) {
                AddDomainLuw.SetMaxDuration(ilsCmdArgs, product.optionsIsDefined() ? product.getOptions() : "", product, domain, l6);
                bl5 = true;
            }
            if (l7 != null && l7.longValue() != domain.getCurrQuotaUsageLevel() && l7 >= (long)0) {
                domain.setCurrQuotaUsageLevel(l7.longValue());
                bl5 = true;
            }
            if (string5 != null && domain.getEnabled() != string5.equals("Yes")) {
                if (domain.getEnabled()) {
                    int n5 = IlsCmdAPI.getCancelAuthLevel(product.optionsIsDefined() ? product.getOptions() : null);
                    long l10 = domain.getCheckoutUserCount(date.getTime());
                    if (l10 > (long)0 && n3 < n5) {
                        ilsCmdArgs.setStatusInfo(18, "Insufficient privileges for disabling a domain having checked-out users", null, AlerterJob.MakeEventParams(string2, string3));
                        WdoBaseException.ThrowProxyWdoException((int)12);
                    }
                }
                domain.setEnabled(!domain.getEnabled());
                bl5 = true;
            }
            if (string6 != null && !domain.getAdminInfo().getNotes().equals(string6)) {
                domain.getAdminInfo().setNotes(string6);
                domain.setIsDirty(true);
            }
            if (bl5) {
                domain.setIsDirty(true);
                domain.getAdminInfo().setUpdateDate(new Timestamp(date.getTime()));
                ilsCmdArgs.setStatusInfo(-100, "Updated domain '" + domain.getName() + "' in product '" + product.getName() + "'", null, AlerterJob.MakeEventParams(string2, string3));
                IlsUtil.Trace(1, "IlsAdminAPI", "AddDomainLuw: updated domain '" + string3 + "' for product '" + product.getName() + "'");
                if (!bl2 && !domain.getName().equals("system")) {
                    DomainLicenseCacheEntry domainLicenseCacheEntry = IlsLicenseCache.getDomainCacheEntry(date, product, domain);
                    if ((long)domain.getUserLimit() < domainLicenseCacheEntry.getCurrLimit()) {
                        ilsCmdArgs.setStatusInfo(17, "New license limit of " + domain.getUserLimit() + " point(s) for product " + product.getName() + ", domain " + domain.getName() + " will be exceeded if domain is updated. " + "Retaining existing limit of " + domainLicenseCacheEntry.getLicenseLimit() + " point(s).", null, AlerterJob.MakeEventParams(string2, string3));
                        WdoBaseException.ThrowProxyWdoException((int)12);
                    }
                    domainLicenseCacheEntry.setLicenseLimit(domain.getUserLimit());
                }
            } else {
                ilsCmdArgs.setStatusInfo(-102, "Domain '" + string3 + "' is already defined for product '" + product.getName() + "' exactly as specified", null, AlerterJob.MakeEventParams(string2, string3));
            }
        }
        objectArray2[12] = domain;
        objectArray2[13] = new Boolean(bl);
    }

    static void SetMinDuration(IlsCmdArgs ilsCmdArgs, String string, Product product, Domain domain, long l) throws WdoBaseException {
        long l2 = IlsCmdAPI.GetIlsLongOption(string, "ILS:DURATION-FLOOR");
        if (l2 >= (long)0 && l < l2) {
            ilsCmdArgs.setStatusInfo(-104, "Specified minimum checkout duration of " + (l > (long)0 ? String.valueOf(l) : "0") + " seconds undercuts the absolute minimum of " + l2 + " seconds specified in the license options, and has been adjusted upwards.  Domain: ", domain.getName(), AlerterJob.MakeEventParams(product.getName(), domain.getName()));
            l = l2;
        }
        domain.setMinCheckoutDurationSec(l);
    }

    static void SetExpirationBoundaries(IlsCmdArgs ilsCmdArgs, String string, LicenseParamInfo licenseParamInfo) throws WdoBaseException {
        long l;
        String string2 = licenseParamInfo.getTimeLimitType();
        if (string2.equals("ABST") || string2.equals("RELT")) {
            l = IlsCmdAPI.GetIlsLongOption(string, "ILS:EXP-DAYS-GRACE");
            if ((long)licenseParamInfo.getExpGrace() > l && l >= (long)0) {
                licenseParamInfo.setExpGrace((int)l);
            }
        }
        if (licenseParamInfo.getQuotaLimited()) {
            l = IlsCmdAPI.GetIlsLongOption(string, "ILS:QUOTA-GRACE");
            if (licenseParamInfo.getQuotaGrace() > l && l >= (long)0) {
                licenseParamInfo.setQuotaGrace(l);
            }
        }
    }

    static void SetMaxDuration(IlsCmdArgs ilsCmdArgs, String string, Product product, Domain domain, long l) throws WdoBaseException {
        long l2 = IlsCmdAPI.GetIlsLongOption(string, "ILS:DURATION-CEILING");
        if (l2 >= (long)0 && (l < (long)0 || l > l2)) {
            l = l2;
            ilsCmdArgs.setStatusInfo(-104, "Specified max checkout duration of " + l + " seconds exceeds the absolute limit of " + l2 + " seconds specified in the license options, and has been adjusted downwards.  Domain: ", domain.getName(), AlerterJob.MakeEventParams(product.getName(), domain.getName()));
        }
        domain.setMaxCheckoutDurationSec(l);
    }

    public static long AddDomain(IlsCmdArgs ilsCmdArgs, Date date, String string, String string2, Product product, LicenseParamInfo licenseParamInfo, long l, long l2, long l3, long l4, boolean bl, String string3) throws WdoBaseException {
        return AddDomainLuw.AddDomain(ilsCmdArgs, date, string, string2, product, licenseParamInfo, l, l2, l3, l4, -1L, bl, string3);
    }

    public static long AddDomain(IlsCmdArgs ilsCmdArgs, Date date, String string, String string2, Product product, LicenseParamInfo licenseParamInfo, long l, long l2, long l3, long l4, long l5, boolean bl, String string3) throws WdoBaseException {
        IlsUtil.Trace(7, "IlsAdminAPI", "AddDomainLuw:AddDomain: enter. Name=" + string + ",product=" + product.getName() + ",authLevel=" + l);
        AdminInfo adminInfo = LuwUtil.SetupAdminInfo(date);
        Domain domain = Domain.GetDomain();
        domain.setName(string);
        domain.setEnabled(bl);
        String string4 = product.optionsIsDefined() ? product.getOptions() : "";
        AddDomainLuw.SetMinDuration(ilsCmdArgs, string4, product, domain, l3);
        AddDomainLuw.SetMaxDuration(ilsCmdArgs, string4, product, domain, l4);
        AddDomainLuw.SetExpirationBoundaries(ilsCmdArgs, string4, licenseParamInfo);
        domain.setLicenseModel(string2);
        domain.setUserLimit(l2 <= (long)0 ? product.getUserLimit() : (int)l2);
        domain.setLicenseParams(licenseParamInfo);
        if (l5 > (long)0) {
            domain.setCurrQuotaUsageLevel(l5);
        }
        domain.setAdminInfo(adminInfo);
        domain.setAuthlevel((int)l);
        if (string3 != null) {
            adminInfo.setNotes(string3);
        }
        long l6 = 0L;
        try {
            l6 = Domain.Create((Domain)domain, (long)product.getProductId());
        }
        catch (WdoDuplicateObjectException wdoDuplicateObjectException) {
            ilsCmdArgs.setStatusInfo(101, "Domain '" + string + "' is already defined for product '" + product.getName() + "'", null, AlerterJob.MakeEventParams(product.getName(), string));
            WdoBaseException.ThrowProxyWdoException((int)12);
        }
        if (l > (long)2 && string.equals("system")) {
            IlsUtil.Trace(5, "IlsAdminAPI", "AddDomain:Adding system user for auth level " + l);
            long l7 = AddUserLuw.AddUser(date, l == (long)3 ? "admin" : "sysadmin", "changeme", product, domain, licenseParamInfo, null, null, null, null);
            IlsUtil.Trace(5, "IlsAdminAPI", "AddDomain: Added system user, assigned user id is: " + l7);
        }
        return l6;
    }
}

