/*
 * Decompiled with CFR 0.152.
 */
package org.crap4j.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.crap4j.util.TestClassChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtil {
    public static void writeFile(String filename, String s) {
        File f = new File(filename);
        FileUtil.writeFile(f, s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(File file, String string) {
        FileUtil.ensureNewFile(file);
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(file));
            out.write(string);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                out.close();
            }
            catch (Exception exception) {}
        }
    }

    private static void ensureNewFile(File file) {
        if (file.exists()) {
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(String filename) {
        StringBuilder s = new StringBuilder();
        BufferedReader in = null;
        try {
            String str;
            in = new BufferedReader(new FileReader("infilename"));
            while ((str = in.readLine()) != null) {
                s.append(str).append("\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        return s.toString();
    }

    public static List<File> getAllFilesInDirMatchingPattern(String directory, final String regex, final boolean first_match2) {
        File directoryFile = new File(directory);
        FileUtil.checkDirectory(directoryFile);
        FilenameFilter fileFilter = new FilenameFilter(){
            private boolean matchedyet = false;

            public boolean accept(File dir, String name) {
                if (first_match2 && this.matchedyet) {
                    return false;
                }
                boolean matched = name.matches(regex);
                if (matched) {
                    this.matchedyet = matched;
                }
                return matched;
            }
        };
        try {
            return FileUtil.listFiles(directoryFile, fileFilter);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("problem adding files matching [" + regex + "] in dir " + directory, e);
        }
    }

    private static List<File> listFiles(File directory, FilenameFilter fileFilter) {
        FileUtil.checkDirectory(directory);
        ArrayList<File> matchingFiles = new ArrayList<File>();
        for (File file : directory.listFiles()) {
            if (FileUtil.passesFilter(directory, fileFilter, file)) {
                matchingFiles.add(file);
            }
            if (!file.isDirectory()) continue;
            matchingFiles.addAll(FileUtil.listFiles(file, fileFilter));
        }
        return matchingFiles;
    }

    private static boolean passesFilter(File directory, FilenameFilter fileFilter, File file) {
        return fileFilter == null || fileFilter.accept(directory, file.getName());
    }

    private static void checkDirectory(File directory) {
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException(directory.getAbsolutePath() + " is not a directory");
        }
    }

    public static void eraseFile(String file) {
        File f = new File(file);
        FileUtil.ensureNewFile(f);
    }

    public static String getTmpFile(String string) {
        return FileUtil.tmpDir() + File.separator + string;
    }

    public static String tmpDir() {
        String tmpDirName = System.getProperty("java.io.tmpDir", "/tmp");
        File f = new File(tmpDirName);
        if (!f.exists()) {
            f.mkdir();
        }
        return tmpDirName;
    }

    public static String getSubTmpDir(String tmpDirName) throws IOException {
        File tmpDir = new File(FileUtil.tmpDir(), tmpDirName);
        tmpDir.mkdir();
        return tmpDir.getCanonicalPath();
    }

    public static List<String> makeRelativePaths(String classDir, List<File> files) {
        ArrayList<String> relativePaths = new ArrayList<String>();
        for (File file : files) {
            int prefixEnd = classDir.length() + 1;
            relativePaths.add(file.getPath().substring(prefixEnd));
        }
        return relativePaths;
    }

    public static void ensureDirectory(String outputDir) {
        File outputDirFile = new File(outputDir);
        if (!outputDirFile.exists()) {
            outputDirFile.mkdirs();
        }
    }

    public static void ensureCleanDirectory(String outputDir) {
        File outputDirFile = new File(outputDir);
        if (outputDirFile.exists()) {
            FileUtil.deleteDirectory(outputDirFile);
        }
        outputDirFile.mkdirs();
    }

    public static void deleteDirectory(File outputDirFile) {
        for (String file : outputDirFile.list()) {
            File f = new File(outputDirFile, file);
            if (f.isDirectory()) {
                FileUtil.deleteDirectory(f);
                continue;
            }
            f.delete();
        }
        outputDirFile.delete();
    }

    public static String joinPath(String basePath, String path) {
        File absolutePath = new File(basePath, path);
        return absolutePath.getAbsolutePath();
    }

    public static boolean isAbsolute(String path) {
        if (path == null) {
            return false;
        }
        return path.startsWith(File.separator) || path.indexOf(58) != -1;
    }

    public static List<File> removeTestClassFiles(List<File> files) {
        ArrayList<File> withoutTestFiles = new ArrayList<File>();
        for (File file : files) {
            if (FileUtil.isTestClass(file)) continue;
            withoutTestFiles.add(file);
        }
        return withoutTestFiles;
    }

    private static boolean isTestClass(File file) {
        return new TestClassChecker().isTestClass(file);
    }

    public static boolean hasTestClassFiles(List<File> files) {
        for (File file : files) {
            if (!FileUtil.isTestClass(file)) continue;
            return true;
        }
        return false;
    }

    private static String getFileNameWithoutExtension(File file) {
        String fileName = file.getName();
        int lastDot = fileName.lastIndexOf(46);
        if (lastDot != -1) {
            fileName = fileName.substring(0, lastDot);
        }
        return fileName;
    }

    private static boolean isTestFile(String fileName) {
        return fileName.indexOf("AgitarTest") != -1 || fileName.endsWith("Test") || fileName.startsWith("Test");
    }

    public static List<File> removeNonTestClassFiles(List<File> classesInDirList) {
        ArrayList<File> withoutNonTestFiles = new ArrayList<File>();
        for (File file : classesInDirList) {
            if (!FileUtil.isTestClass(file)) continue;
            withoutNonTestFiles.add(file);
        }
        return withoutNonTestFiles;
    }

    public static List<String> directoriesOnly(List<String> classDirs) {
        ArrayList<String> directories = new ArrayList<String>();
        for (String pathElement : directories) {
            if (!new File(pathElement).isDirectory()) continue;
            directories.add(pathElement);
        }
        return directories;
    }

    public static List<String> directoriesAndJarsOnly(List<String> classDirs) {
        ArrayList<String> directories = new ArrayList<String>();
        for (String pathElement : classDirs) {
            if (!pathElement.endsWith(".jar") && !new File(pathElement).isDirectory()) continue;
            directories.add(pathElement);
        }
        return directories;
    }
}

