/*
 * Decompiled with CFR 0.152.
 */
package org.crap4j.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class CPStringReader {
    private byte[] b;
    private String className;
    private String superName;
    private String[] strings;
    static final int CLASS = 7;
    static final int FIELD = 9;
    static final int METH = 10;
    static final int IMETH = 11;
    static final int STR = 8;
    static final int INT = 3;
    static final int FLOAT = 4;
    static final int LONG = 5;
    static final int DOUBLE = 6;
    static final int NAME_TYPE = 12;
    static final int UTF8 = 1;

    public CPStringReader(InputStream is) throws IOException {
        this(CPStringReader.readClass(is));
    }

    public CPStringReader(byte[] b) {
        this.b = b;
        int index = 8;
        int cpEntriesCount = this.readUnsignedShort(index);
        int[] cpOffsets = new int[cpEntriesCount];
        index += 2;
        ArrayList<Integer> classAndStringsIndexes = new ArrayList<Integer>();
        int max = 0;
        for (int i = 1; i < cpEntriesCount; ++i) {
            byte cpTag = b[index];
            int size = 0;
            cpOffsets[i] = index + 1;
            switch (cpTag) {
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    size = 5;
                    break;
                }
                case 5: 
                case 6: {
                    size = 9;
                    ++i;
                    break;
                }
                case 1: {
                    classAndStringsIndexes.add(new Integer(i));
                    size = 3 + this.readUnsignedShort(index + 1);
                    if (size <= max) break;
                    max = size;
                    break;
                }
                default: {
                    size = 3;
                }
            }
            index += size;
        }
        char[] stringBuf = new char[max];
        this.strings = new String[classAndStringsIndexes.size()];
        for (int i = 0; i < this.strings.length; ++i) {
            this.strings[i] = this.readUTF8(cpOffsets[(Integer)classAndStringsIndexes.get(i)], stringBuf);
        }
        this.className = this.readUTF8(cpOffsets[this.readUnsignedShort(cpOffsets[this.readUnsignedShort(index + 2)])], stringBuf);
        int v = cpOffsets[this.readUnsignedShort(index + 4)];
        this.superName = v == 0 ? null : this.readUTF8(cpOffsets[this.readUnsignedShort(v)], stringBuf);
    }

    public String getClassName() {
        return this.className.replace('/', '.');
    }

    public String getSuperClassName() {
        return this.superName.replace('/', '.');
    }

    public String[] getConstantPoolStrings() {
        return this.strings;
    }

    private static byte[] readClass(InputStream is) throws IOException {
        if (is == null) {
            throw new IOException("Class not found");
        }
        byte[] b = new byte[is.available()];
        int len = 0;
        while (true) {
            byte[] c;
            int n;
            if ((n = is.read(b, len, b.length - len)) == -1) {
                if (len < b.length) {
                    c = new byte[len];
                    System.arraycopy(b, 0, c, 0, len);
                    b = c;
                }
                return b;
            }
            if ((len += n) != b.length) continue;
            c = new byte[b.length + 1000];
            System.arraycopy(b, 0, c, 0, len);
            b = c;
        }
    }

    private int readUnsignedShort(int index) {
        byte[] b = this.b;
        return (b[index] & 0xFF) << 8 | b[index + 1] & 0xFF;
    }

    private String readUTF8(int index, char[] buf) {
        byte[] b = this.b;
        int length = this.readUnsignedShort(index);
        return this.readUTF(index + 2, length, buf);
    }

    private String readUTF(int index, int utfLen, char[] buf) {
        int endIndex = index + utfLen;
        byte[] b = this.b;
        int strLen = 0;
        block4: while (index < endIndex) {
            byte d;
            int c = b[index++] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    buf[strLen++] = (char)c;
                    continue block4;
                }
                case 12: 
                case 13: {
                    d = b[index++];
                    buf[strLen++] = (char)((c & 0x1F) << 6 | d & 0x3F);
                    continue block4;
                }
            }
            d = b[index++];
            byte e = b[index++];
            buf[strLen++] = (char)((c & 0xF) << 12 | (d & 0x3F) << 6 | e & 0x3F);
        }
        return new String(buf, 0, strLen);
    }
}

