/*
 * Decompiled with CFR 0.152.
 */
package org.crap4j.external;

import com.agitar.coverage.ClassCoverage;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.crap4j.CrapProject;
import org.crap4j.MethodCoverage;
import org.crap4j.external.MyCoveragePoint;
import org.crap4j.util.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuperRunnerCoverageReader {
    private CrapProject project;

    public SuperRunnerCoverageReader(CrapProject p) {
        this.project = p;
    }

    public List<MethodCoverage> read() throws IOException {
        ArrayList<MethodCoverage> list = new ArrayList<MethodCoverage>();
        List<File> covFiles = null;
        try {
            covFiles = FileUtil.getAllFilesInDirMatchingPattern(this.project.getCoverageDir(), ".*.acov", false);
        }
        catch (Exception e1) {
            e1.printStackTrace(System.err);
            return list;
        }
        if (covFiles == null || covFiles.size() < 1) {
            System.err.println("Cannot find coverage results files in " + this.project.getCoverageDir());
            return list;
        }
        for (File covFile : covFiles) {
            try {
                list.addAll(this.readFile(covFile));
            }
            catch (IOException e) {
                System.err.println("Could not read coverage file: " + covFile.getAbsolutePath());
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MethodCoverage> readFile(File f) throws IOException {
        FilterInputStream in = null;
        try {
            in = new DataInputStream(new BufferedInputStream(new FileInputStream(f)));
            List<MethodCoverage> list = this.read((DataInput)((Object)in));
            return list;
        }
        finally {
            in.close();
        }
    }

    public List<MethodCoverage> Xread(DataInput in) throws IOException {
        ArrayList<MethodCoverage> methodCoverages = new ArrayList<MethodCoverage>();
        int fileVersion = in.readInt();
        boolean washerMode = fileVersion < 4 || in.readBoolean();
        String className = in.readUTF();
        in.readUTF();
        in.readLong();
        in.readUTF();
        long originalTimeStamp = fileVersion >= 1 ? in.readLong() : 0L;
        List<String> methodNames = this.readMethods(in, className);
        Map<Integer, List<MyCoveragePoint>> covPoints = this.readCoveragePoints(in);
        return this.createMethodCoverages(methodCoverages, methodNames, covPoints);
    }

    public List<MethodCoverage> read(DataInput in) throws IOException {
        String[] methodNames;
        ArrayList<MethodCoverage> methodCoverages = new ArrayList<MethodCoverage>();
        ClassCoverage cc = new ClassCoverage("unknown", new File(this.project.getCoverageDir()));
        cc.read(in);
        for (String methodName : methodNames = cc.getMethodNames()) {
            int[] totalMethodCoverage = cc.getTotalMethodCoverage(methodName);
            float percentCovered = (float)totalMethodCoverage[1] / (float)totalMethodCoverage[0];
            methodCoverages.add(new MethodCoverage(this.makeFullyQualifiedMethodName(cc.getClassName(), methodName), percentCovered));
        }
        return methodCoverages;
    }

    protected List<MethodCoverage> createMethodCoverages(List<MethodCoverage> methodCoverages, List<String> methodNames, Map<Integer, List<MyCoveragePoint>> covPoints) {
        for (int i = 0; i < methodNames.size(); ++i) {
            String methodName = methodNames.get(i);
            int totalPointsForMethod = 0;
            int coveredPointsForMethod = 0;
            List<MyCoveragePoint> listOfPoints = covPoints.get(i);
            if (listOfPoints == null) {
                listOfPoints = new ArrayList<MyCoveragePoint>();
            }
            for (MyCoveragePoint point : listOfPoints) {
                if (point.getType() == -1) continue;
                ++totalPointsForMethod;
                if (point.getTimesReached() <= 0) continue;
                ++coveredPointsForMethod;
            }
            float percentCovered = (float)coveredPointsForMethod / (float)totalPointsForMethod;
            methodCoverages.add(new MethodCoverage(methodName, percentCovered));
        }
        return methodCoverages;
    }

    private Map<Integer, List<MyCoveragePoint>> readCoveragePoints(DataInput in) throws IOException {
        int pointCount = in.readInt();
        HashMap<Integer, List<MyCoveragePoint>> covPoints = new HashMap<Integer, List<MyCoveragePoint>>();
        for (int i = 0; i < pointCount; ++i) {
            MyCoveragePoint point = new MyCoveragePoint(in);
            if (point.getType() == -1) continue;
            ArrayList<MyCoveragePoint> pointsForMethod = (ArrayList<MyCoveragePoint>)covPoints.get(point.getMethodNumber());
            if (pointsForMethod == null) {
                pointsForMethod = new ArrayList<MyCoveragePoint>();
            }
            pointsForMethod.add(point);
            covPoints.put(point.getMethodNumber(), pointsForMethod);
        }
        return covPoints;
    }

    private List<String> readMethods(DataInput in, String className) throws IOException {
        int methodCount = in.readInt();
        ArrayList<String> methodNames = new ArrayList<String>();
        for (int i = 0; i < methodCount; ++i) {
            String methodName = in.readUTF();
            methodNames.add(this.makeFullyQualifiedMethodName(className, methodName));
            in.readBoolean();
        }
        return methodNames;
    }

    private String makeFullyQualifiedMethodName(String className, String methodName) {
        return className.replace(File.separatorChar, '.') + "." + methodName.replaceAll("\\.", "");
    }
}

