/*
 * Decompiled with CFR 0.152.
 */
package org.crap4j.external;

import java.io.File;
import java.util.ArrayList;
import org.crap4j.util.StreamCopier;

public class AntRunner {
    private String antFile;
    private String junitLib;
    private String antHome;
    private boolean debug;
    private String agitatorEclipseApiPluginDir;

    public AntRunner(String antFile, String antHome, String junitLib, String agitatorEclipseApiPluginDir, boolean debug) {
        this.antFile = antFile;
        this.antHome = antHome;
        this.junitLib = junitLib;
        this.agitatorEclipseApiPluginDir = agitatorEclipseApiPluginDir;
        this.debug = debug;
    }

    public int run() {
        return this.runAsExternalProcess();
    }

    private int runAsExternalProcess() {
        String[] cmdarray = this.buildAntCmdJavaLauncher();
        if (this.isDebug()) {
            this.printCmd(cmdarray);
        }
        int exitStatus = -1;
        try {
            Process out = Runtime.getRuntime().exec(cmdarray);
            new StreamCopier(out.getInputStream(), System.out, false);
            new StreamCopier(out.getErrorStream(), System.out, false);
            exitStatus = out.waitFor();
            this.checkExitStatus(exitStatus);
        }
        catch (Exception e) {
            System.out.println("Could not execute ant file.");
            e.printStackTrace();
        }
        System.out.println("Ant exited with status " + exitStatus);
        return exitStatus;
    }

    private void checkExitStatus(int exitStatus) {
        if (exitStatus != 0) {
            throw new RuntimeException("Ant run failed with status: " + exitStatus);
        }
    }

    private void printCmd(String[] cmdarray) {
        for (String string : cmdarray) {
            System.out.println(string);
        }
    }

    private String[] buildAntCmdJavaLauncher() {
        ArrayList<String> cmdOps = new ArrayList<String>();
        cmdOps.add("java");
        cmdOps.add("-classpath");
        cmdOps.add(this.antLauncherJar());
        cmdOps.add("-Dant.home=" + this.antHome());
        cmdOps.add("-Dant.library.dir=" + this.antHome() + File.separator + "lib");
        cmdOps.add("org.apache.tools.ant.launch.Launcher");
        if (this.isDebug()) {
            cmdOps.add("-v");
        }
        cmdOps.add("-lib");
        cmdOps.add("\"" + this.junitLib() + "\"");
        cmdOps.add("-f");
        cmdOps.add(this.antFile);
        return cmdOps.toArray(new String[cmdOps.size()]);
    }

    private String antLauncherJar() {
        return this.agitatorEclipseApiPluginDir() + File.separator + "lib" + File.separator + "ant-launcher.jar";
    }

    private String agitatorEclipseApiPluginDir() {
        return this.agitatorEclipseApiPluginDir;
    }

    private String junitLib() {
        return this.junitLib;
    }

    private String antHome() {
        return this.antHome;
    }

    private boolean isDebug() {
        return this.debug;
    }
}

