/*
 * Decompiled with CFR 0.152.
 */
package org.crap4j.external;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.crap4j.CrapProject;
import org.crap4j.util.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntBuilder {
    String antFile = "crap_build.xml";
    private String agitatorEclipseCoveragePluginDir;
    private String agitatorEclipseApiPluginDir;

    public AntBuilder(String agitatorEclipseCoveragePluginDir, String agitatorEclipseApiPluginDir) {
        this.agitatorEclipseCoveragePluginDir = agitatorEclipseCoveragePluginDir;
        this.agitatorEclipseApiPluginDir = agitatorEclipseApiPluginDir;
    }

    public String buildFileForProject(CrapProject project) {
        String filename = this.buildFileName(project.projectDir(), this.antFile);
        FileUtil.writeFile(filename, this.buildContent(project));
        return filename;
    }

    protected String buildContent(CrapProject project) {
        String PROJECT_NAME = project.getProjectName();
        String template = this.antFileTemplate();
        template = template.replaceAll("#CLASSPATH_ELEMENTS#", this.replacePathElementsForPattern(this.makeForwardSlashes(project.allClasspaths()), "#CLASS_DIR#", AntBuilder.pathElementTemplate()));
        template = template.replaceAll("#TEST_FILESETS#", this.replaceFileSetWithPattern(this.makeForwardSlashes(project.testClassDirs()), "#CLASS_DIR#", project.projectDir()));
        template = template.replaceAll("#PROJECT_NAME#", PROJECT_NAME);
        template = template.replaceAll("#COVERAGE_PLUGIN_DIR#", this.makeForwardSlash(this.eclipseCoveragePluginDir()));
        template = template.replaceAll("#API_PLUGIN_DIR#", this.makeForwardSlash(this.agitatorEclipseApiPluginDir()));
        return template.replaceAll("\\\\", "");
    }

    private String agitatorEclipseApiPluginDir() {
        return this.agitatorEclipseApiPluginDir;
    }

    private String eclipseCoveragePluginDir() {
        return this.agitatorEclipseCoveragePluginDir;
    }

    private List<String> makeForwardSlashes(List<String> name) {
        ArrayList<String> slashed = new ArrayList<String>();
        for (String string : name) {
            slashed.add(this.makeForwardSlash(string));
        }
        return slashed;
    }

    private String makeForwardSlash(String string) {
        return string.replace('\\', '/');
    }

    private String antFileTemplate() {
        return "<?xml version=\"1.0\" ?>\n<project name=\"#PROJECT_NAME#\" default=\"agitar-all\">\n\n\t<!-- Use of \\${project.dir.#PROJECT_NAME#} allows for the resolution of relative paths even when this file is imported in another build file -->\n\t<dirname file=\"\\${ant.file.#PROJECT_NAME#}\" property=\"import.dir.#PROJECT_NAME#\"/>\n\t<condition property=\"project.dir.#PROJECT_NAME#\" value=\"\\${import.dir.#PROJECT_NAME#}\" else=\"\\${basedir}\">\n<isset property=\"import.dir.#PROJECT_NAME#\"/>\n\t</condition>\n\n<taskdef name=\"super-runner\" classname=\"com.agitar.junit.runner.SuperRunnerTask\">\n<classpath>\n\t\t<pathelement location=\"#COVERAGE_PLUGIN_DIR#/com.agitar.common.jar\" />\n\t\t<pathelement location=\"#COVERAGE_PLUGIN_DIR#/com.agitar.coverage.jar\" />\n\t\t<pathelement location=\"#API_PLUGIN_DIR#/com.agitar.mockingbird.jar\" />\n\t  <pathelement location=\"#API_PLUGIN_DIR#/com.agitar.testrunner.jar\" />\n\t\t<fileset dir=\"#API_PLUGIN_DIR#/lib\">\n\t\t  <include name=\"**/*.jar\" />\n    </fileset>\n    <fileset dir=\"#COVERAGE_PLUGIN_DIR#/lib\">\n\t    <include name=\"**/*.jar\" />\n    </fileset>\n  </classpath>\n</taskdef>\n\t\n\t\n\t<!-- Default target -->\n\t<target name=\"agitar-all\" depends=\"run-tests\"/>\n\t\n\t\n\t<!-- Cleans old agitation results and coverage -->\n\t<target name=\"clean-results\">\n\t\t<delete dir=\"\\${basedir}/agitar/.results\" quiet=\"true\"/>\n\t</target>\n\t\n\t<!-- Run the tests for this project -->\n\n\t<target name=\"run-tests\">\n\t\t<property name=\"test.results.dir\" value=\"\\${project.dir.#PROJECT_NAME#}/agitar/.junitresults\"/>\n\t\t<mkdir dir=\"\\${test.results.dir}\"/>\n\t\t<super-runner dir=\"\\${basedir}\" batchSize=\"5\" printsummary=\"yes\" mergeCoverage=\"true\" haltonfailure=\"no\" resultsDir=\"\\${project.dir.#PROJECT_NAME#}/agitar/.results\">\n\t\t\t<jvmarg value=\"-Xmx512M\"/>\n\t\t\t<jvmarg value=\"-ea\"/>\n\t\t\t<jvmarg value=\"-Djava.awt.headless\"/>\n\t\t\t<formatter type=\"xml\"/>\n\t\t\t<classpath>\n         #CLASSPATH_ELEMENTS#\t\t\t</classpath>\n\t\t\t<batchtest todir=\"\\${test.results.dir}\">\n        #TEST_FILESETS#\t\t\t</batchtest>\n\t\t</super-runner>\n\t</target>\n\t\n</project>";
    }

    public String replacePathElementsForPattern(List<String> paths, String pattern, String pathElementTemplate) {
        StringBuilder pathElements = new StringBuilder();
        for (String classdir : paths) {
            pathElements.append(pathElementTemplate.replaceAll(pattern, classdir)).append("\n");
        }
        return pathElements.toString();
    }

    private String replaceFileSetWithPattern(List<String> paths, String pattern, String projectDir) {
        StringBuilder filesets = new StringBuilder();
        for (String classdir : paths) {
            if (new File(classdir).isDirectory()) {
                filesets.append(AntBuilder.filesetTemplate().replaceAll(pattern, classdir)).append("\n");
                continue;
            }
            filesets.append(AntBuilder.fileTemplate().replaceAll(pattern, classdir)).append("\n");
        }
        return filesets.toString();
    }

    private String shortName(String projectDir, String classdir) {
        return classdir.substring(projectDir.length() + 1);
    }

    public static String pathElementTemplate() {
        return "\t\t\t\t<pathElement location=\"#CLASS_DIR#\"/>";
    }

    public static String filesetTemplate() {
        return "\t\t\t\t<fileset dir=\"#CLASS_DIR#\">\n\t\t\t\t\t<include name=\"**/*Test.class\"/>\n\t\t\t\t\t<include name=\"**/Test*.class\"/>\n\t\t\t\t</fileset>";
    }

    public static String fileTemplate() {
        return "       <file name=\"#CLASS_DIR#\" />\n";
    }

    public static String filesetTestTemplate() {
        return "       <fileset dir=\"#TEST_DIR#\">\n        <include name=\"#CLASS_DIR#\" />\n       </fileset>";
    }

    private String buildFileName(String string, String antFile2) {
        return string + File.separator + antFile2;
    }
}

