/*
 * Decompiled with CFR 0.152.
 */
package org.crap4j.complexity;

import com.agitar.org.objectweb.asm.ClassReader;
import com.agitar.org.objectweb.asm.ClassVisitor;
import com.agitar.org.objectweb.asm.MethodVisitor;
import com.agitar.org.objectweb.asm.signature.SignatureReader;
import com.agitar.org.objectweb.asm.signature.SignatureVisitor;
import com.agitar.org.objectweb.asm.tree.ClassNode;
import com.agitar.org.objectweb.asm.tree.MethodNode;
import com.agitar.org.objectweb.asm.tree.analysis.AnalyzerException;
import com.agitar.org.objectweb.asm.tree.analysis.Frame;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.crap4j.MethodComplexity;
import org.crap4j.complexity.ComplexityMethodVisitor;
import org.crap4j.complexity.MyAnalyzer;
import org.crap4j.complexity.MyTraceSignatureVisitor;
import org.crap4j.complexity.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CyclomaticComplexity {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MethodComplexity> getMethodComplexitiesFor(File classFile) throws IOException, AnalyzerException {
        ArrayList<MethodComplexity> complexities = new ArrayList<MethodComplexity>();
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(classFile));
            ClassReader cr = new ClassReader((InputStream)bufferedInputStream);
            ClassNode cn = new ClassNode();
            cr.accept((ClassVisitor)cn, 2);
            List methods = cn.methods;
            for (int i = 0; i < methods.size(); ++i) {
                MethodNode method = (MethodNode)methods.get(i);
                if (this.shouldIgnore(method)) continue;
                String signature = method.signature;
                signature = method.desc;
                MyTraceSignatureVisitor v = new MyTraceSignatureVisitor(method.access);
                SignatureReader r = new SignatureReader(method.signature != null ? method.signature : method.desc);
                r.accept((SignatureVisitor)v);
                String access = this.buildAccess(method.access);
                String genericDecl = v.getDeclaration();
                String genericReturn = v.getReturnType();
                if (genericReturn.equals("")) {
                    genericReturn = "java.lang.Object";
                }
                String genericExceptions = v.getExceptions();
                String methodDecl = access + " " + genericReturn + " " + method.name + genericDecl;
                MethodComplexity methodComplexity = new MethodComplexity(cn.name.replace('/', '.') + "." + method.name + signature, cn.name.replace('/', '.'), method.name, signature, method.signature, this.newGetCyclomaticComplexity(cn.name, method), methodDecl);
                complexities.add(methodComplexity);
            }
        }
        finally {
            bufferedInputStream.close();
        }
        return complexities;
    }

    private boolean shouldIgnore(MethodNode method) {
        return this.isAbstract(method.access) || this.isNative(method.access) || this.isEmptyMethod(method);
    }

    private boolean isEmptyMethod(MethodNode method) {
        return method.instructions.size() == 0;
    }

    private String buildAccess(int access) {
        StringBuilder b = new StringBuilder();
        this.buildVisibility(access, b);
        this.buildStatic(access, b);
        this.buildFinal(access, b);
        this.buildSynchronized(access, b);
        this.buildNative(access, b);
        this.buildAbstract(access, b);
        return b.toString();
    }

    private void buildAbstract(int access, StringBuilder b) {
        if (this.isAbstract(access)) {
            b.append("abstract ");
        }
    }

    private boolean isAbstract(int access) {
        return (access & 0x400) != 0;
    }

    private void buildNative(int access, StringBuilder b) {
        if (this.isNative(access)) {
            b.append("native ");
        }
    }

    private boolean isNative(int access) {
        return (access & 0x100) != 0;
    }

    private void buildSynchronized(int access, StringBuilder b) {
        if ((access & 0x20) != 0) {
            b.append("synchronized ");
        }
    }

    private void buildFinal(int access, StringBuilder b) {
        if ((access & 0x10) != 0) {
            b.append("final ");
        }
    }

    private void buildStatic(int access, StringBuilder b) {
        if ((access & 8) != 0) {
            b.append("static ");
        }
    }

    private void buildVisibility(int access, StringBuilder b) {
        if ((access & 1) != 0) {
            b.append("public ");
        } else if ((access & 2) != 0) {
            b.append("private ");
        } else if ((access & 4) != 0) {
            b.append("protected ");
        }
    }

    public int newGetCyclomaticComplexity(String owner, MethodNode mn) {
        try {
            ComplexityMethodVisitor complexityCounter = new ComplexityMethodVisitor();
            mn.accept((MethodVisitor)complexityCounter);
            return complexityCounter.complexity;
        }
        catch (RuntimeException e) {
            System.err.println("Caught Exception on method: " + mn.name + " " + e.getMessage());
            e.printStackTrace();
            return 1;
        }
    }

    public int getCyclomaticComplexity(String owner, MethodNode mn) throws AnalyzerException {
        MyAnalyzer a = new MyAnalyzer();
        a.analyze(owner, mn);
        Frame[] frames = a.getFrames();
        int edges = 0;
        int nodes = 0;
        for (int i = 0; i < frames.length; ++i) {
            if (frames[i] == null) continue;
            edges += ((Node)frames[i]).successors.size();
            ++nodes;
        }
        return edges - nodes + 2;
    }
}

