/*
 * Decompiled with CFR 0.152.
 */
package org.crap4j.complexity;

import com.agitar.org.objectweb.asm.AnnotationVisitor;
import com.agitar.org.objectweb.asm.Attribute;
import com.agitar.org.objectweb.asm.Label;
import com.agitar.org.objectweb.asm.MethodVisitor;

class ComplexityMethodVisitor
implements MethodVisitor {
    int[] decisionOpcodes = new int[]{153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 198, 199};
    private int edges;
    private int nodes;
    int complexity = 1;

    ComplexityMethodVisitor() {
    }

    public int compute() {
        return this.edges - this.nodes + 2;
    }

    private void incBoth() {
        ++this.edges;
        ++this.nodes;
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return new NullAnnotationVisitor();
    }

    public AnnotationVisitor visitAnnotationDefault() {
        return new NullAnnotationVisitor();
    }

    public void visitAttribute(Attribute attr) {
    }

    public void visitCode() {
    }

    public void visitEnd() {
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        this.incBoth();
    }

    public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
    }

    public void visitIincInsn(int var, int increment) {
        this.incBoth();
    }

    public void visitInsn(int opcode) {
        this.incBoth();
    }

    public void visitIntInsn(int opcode, int operand) {
        this.incBoth();
    }

    public void visitJumpInsn(int opcode, Label label) {
        this.incBoth();
        ++this.edges;
        for (int currOpcode : this.decisionOpcodes) {
            if (opcode != currOpcode) continue;
            ++this.complexity;
            return;
        }
    }

    public void visitLabel(Label label) {
        ++this.nodes;
    }

    public void visitLdcInsn(Object cst) {
        this.incBoth();
    }

    public void visitLineNumber(int line, Label start) {
    }

    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        ++this.nodes;
        this.edges += labels.length;
        this.complexity += labels.length;
    }

    public void visitMaxs(int maxStack, int maxLocals) {
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        this.incBoth();
    }

    public void visitMultiANewArrayInsn(String desc, int dims) {
        this.incBoth();
    }

    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        return new NullAnnotationVisitor();
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        ++this.nodes;
        this.edges += labels.length;
        this.complexity += labels.length;
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
    }

    public void visitTypeInsn(int opcode, String desc) {
        this.incBoth();
    }

    public void visitVarInsn(int opcode, int var) {
        this.incBoth();
    }

    public static class NullAnnotationVisitor
    implements AnnotationVisitor {
        public void visit(String name, Object value) {
        }

        public AnnotationVisitor visitAnnotation(String name, String desc) {
            return new NullAnnotationVisitor();
        }

        public AnnotationVisitor visitArray(String name) {
            return new NullAnnotationVisitor();
        }

        public void visitEnd() {
        }

        public void visitEnum(String name, String desc, String value) {
        }
    }
}

