/*
 * Decompiled with CFR 0.152.
 */
package org.crap4j.benchmark;

import java.net.URL;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.StatusLine;
import org.apache.commons.httpclient.methods.GetMethod;
import org.crap4j.benchmark.GlobalStats;

public class StatsDownloader {
    public static final float NO_RESULT = -99.0f;
    String host;

    public StatsDownloader() {
        this("http://www.crap4j.org/benchmark/");
    }

    public StatsDownloader(String host) {
        if (host == null) {
            throw new IllegalArgumentException("Need valid host");
        }
        this.host = host;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public GlobalStats getAverage(boolean downloadAverages) {
        if (!downloadAverages) {
            return GlobalStats.NULL_STATS;
        }
        try {
            URL statsUrl = new URL(this.host + "stats/average_crap/1");
            HttpClient httpclient = new HttpClient();
            httpclient.setConnectionTimeout(5000);
            GetMethod httpget = new GetMethod(statsUrl.toString());
            httpget.addRequestHeader("Accept", "text/xml");
            try {
                httpclient.executeMethod((HttpMethod)httpget);
                StatusLine resultStatus = httpget.getStatusLine();
                if (resultStatus.getStatusCode() != 200) return GlobalStats.NULL_STATS;
                String responseBodyAsString = httpget.getResponseBodyAsString();
                GlobalStats globalStats = new GlobalStats(Float.parseFloat(responseBodyAsString), -1.0f, -1.0f, -1.0f);
                return globalStats;
            }
            finally {
                httpget.releaseConnection();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return GlobalStats.NULL_STATS;
    }

    public static void main(String[] args) {
        new StatsDownloader("http://localhost:3000/").getAverage(true);
    }
}

