/*
 * Decompiled with CFR 0.152.
 */
package org.crap4j.anttask;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.crap4j.CrapProject;
import org.crap4j.Main;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Crap4jAntTask
extends Task {
    private String crap4jHome;
    private boolean debug;
    private boolean dontTest;
    private boolean downloadAverages = true;
    private String server;
    private File projectDir;
    private File outputDir;
    private Path libClasspath;
    private Path classes;
    private Path srces;
    private Path testClasses;
    private Project antProject;

    public Crap4jAntTask(Project p) {
        this.antProject = p;
    }

    public Path createClasses() {
        if (this.classes == null) {
            this.classes = new Path(this.antProject);
        }
        return this.classes.createPath();
    }

    public Path createSrces() {
        if (this.srces == null) {
            this.srces = new Path(this.antProject);
        }
        return this.srces.createPath();
    }

    public Path createTestClasses() {
        if (this.testClasses == null) {
            this.testClasses = new Path(this.antProject);
        }
        return this.testClasses.createPath();
    }

    public Path createLibClasspath() {
        if (this.libClasspath == null) {
            this.libClasspath = new Path(this.antProject);
        }
        return this.libClasspath.createPath();
    }

    public String getServer() {
        this.server = "http://www.crap4j.org/benchmark/";
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public void execute() throws BuildException {
        this.validate(this.getProjectDir());
        this.validate("classes", this.getClasses());
        if (this.isDebug()) {
            this.dumpAttributes();
        }
        CrapProject p = this.createCrapProject();
        try {
            Main.createMain().run(p, this.isDebug(), this.isDontTest(), this.isDownloadAverages(), this.getServer());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BuildException((Throwable)e);
        }
    }

    private void dumpAttributes() {
        System.out.println("projectDir is " + this.getProjectDir());
        System.out.println("outputDir is " + this.getOutputDir());
        System.out.println("srcDir is " + this.getSrces());
        System.out.println("classDirs is " + Crap4jAntTask.stringOf(this.getClasses()));
        System.out.println("testClassDirs is " + Crap4jAntTask.stringOf(this.getTestClasses()));
        System.out.println("libClasspath is " + Crap4jAntTask.stringOf(this.getLibClasspath()));
        System.out.println("server is " + this.getServer());
        System.out.println("downloadAverages is " + this.isDownloadAverages());
        System.out.println("debug is " + this.isDebug());
        System.out.println("dontTest is " + this.isDontTest());
    }

    private void validate(File projectDir2) {
        if (projectDir2 == null) {
            throw new BuildException("Project Dir, " + projectDir2 + " is null");
        }
        if (!projectDir2.exists()) {
            throw new BuildException("Project Dir, " + projectDir2 + " does not exist");
        }
        if (!projectDir2.isDirectory()) {
            throw new BuildException("Project Dir, " + projectDir2 + " is not a directory");
        }
    }

    private void validate(String attributeName, Path path) {
        if (path == null || path.list().length == 0) {
            throw new BuildException(attributeName + " cannot be empty.");
        }
    }

    public static String stringOf(Path classDirs2) {
        StringBuilder b = new StringBuilder();
        for (String s : classDirs2.list()) {
            b.append(s);
            b.append(", ");
        }
        return b.toString();
    }

    private CrapProject createCrapProject() {
        CrapProject p = new CrapProject(this.getProjectDir().getAbsolutePath(), this.makeListFrom(this.getLibClasspath()), this.makeListFrom(this.getTestClasses()), this.makeListFrom(this.getClasses()), this.makeListFrom(this.getSrces()), this.getOutputDir() != null ? this.getOutputDir().getAbsolutePath() : null);
        return p;
    }

    private List<String> makeListFrom(Path path) {
        ArrayList<String> list = new ArrayList<String>();
        if (path == null) {
            return list;
        }
        for (String string : path.list()) {
            list.add(string);
        }
        return list;
    }

    public String getCrap4jHome() {
        return this.crap4jHome;
    }

    public void setCrap4jHome(String crap4jHome) {
        this.crap4jHome = crap4jHome;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isDontTest() {
        return this.dontTest;
    }

    public void setDontTest(boolean dontTest) {
        this.dontTest = dontTest;
    }

    public Path getLibClasspath() {
        return this.libClasspath;
    }

    public void setLibClasspath(Path path) {
        this.libClasspath = path;
    }

    public File getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(File outputDir) {
        this.outputDir = outputDir;
    }

    public File getProjectDir() {
        return this.projectDir;
    }

    public void setProjectDir(File projectDir) {
        this.projectDir = projectDir;
    }

    public Path getSrces() {
        return this.srces;
    }

    public void setSrces(Path path) {
        this.srces = path;
    }

    public Path getTestClasses() {
        return this.testClasses;
    }

    public void setTestClasses(Path path) {
        this.testClasses = path;
    }

    public Path getClasses() {
        return this.classes;
    }

    public void setClasses(Path path) {
        this.classes = path;
    }

    public boolean isDownloadAverages() {
        return this.downloadAverages;
    }

    public void setDownloadAverages(boolean downloadAverages) {
        this.downloadAverages = downloadAverages;
    }
}

