/*
 * Decompiled with CFR 0.152.
 */
package org.crap4j;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URLEncoder;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.crap4j.Crap;
import org.crap4j.CrapProject;
import org.crap4j.MethodCrap;
import org.crap4j.benchmark.GlobalStats;
import org.crap4j.gauge.CrapImageGenerator;
import org.crap4j.gauge.NewCrapImageGenerator;
import org.crap4j.util.FileUtil;
import org.crap4j.util.FormatUtil;
import org.crap4j.util.MyStringBuilder;
import org.crap4j.util.StreamCopier;
import org.crap4j.util.XmlUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemCrapStats {
    private float total;
    private float crapNumber;
    private float median;
    private float average;
    private double stdDev;
    private int methodCount;
    private List<? extends Crap> crapSubjects;
    private String name;
    private CrapProject crapProject;
    private int crapMethodCount;
    private float crapThreshold = 8.0f;
    private int crapWorkLoad;
    private float crapPercentWarningThreshold;
    private float crapPercentCriticalThreshold;
    private GlobalStats globalStats;
    private String server;

    public SystemCrapStats(List<? extends Crap> crapValues, String name, CrapProject crapProject, float crapThreshold, float crapPercentWarningThreshold, float crapPercentCriticalThreshold, GlobalStats globalStats, String server) {
        this.validateParams(crapValues);
        this.name = name;
        this.crapProject = crapProject;
        this.total = 0.0f;
        this.crapSubjects = crapValues;
        this.crapThreshold = crapThreshold;
        this.crapPercentWarningThreshold = crapPercentWarningThreshold;
        this.crapPercentCriticalThreshold = crapPercentCriticalThreshold;
        this.methodCount = this.crapSubjects.size();
        this.total = this.computeTotalCrap(crapValues);
        this.crapNumber = this.average = this.total / (float)this.methodCount;
        this.median = this.computeMedian();
        this.stdDev = this.computeStdDev();
        this.crapMethodCount = this.countCrapMethods(crapValues);
        this.crapWorkLoad = this.computeCrapWorkLoad(crapValues);
        this.globalStats = globalStats;
        this.server = server;
    }

    private int computeCrapWorkLoad(List<? extends Crap> crapValues) {
        int crapLoad = 0;
        for (Crap crap : crapValues) {
            crapLoad += crap.getCrapLoad(this.crapThreshold);
        }
        return crapLoad;
    }

    private int countCrapMethods(List<? extends Crap> crapValues) {
        int count = 0;
        for (Crap crap : crapValues) {
            if (!(crap.getCrap() >= this.crapThreshold)) continue;
            ++count;
        }
        return count;
    }

    private float computeTotalCrap(List<? extends Crap> crapValues) {
        float totalCrap = 0.0f;
        for (Crap crap : crapValues) {
            totalCrap += crap.getCrap();
        }
        return totalCrap;
    }

    private void validateParams(List<? extends Crap> crapValues) {
        if (crapValues == null) {
            throw new IllegalArgumentException("Cannot compute for null values");
        }
    }

    public float getCrapNumber() {
        return this.crapNumber;
    }

    public float getAverage() {
        return this.average;
    }

    public float getMedian() {
        return this.median;
    }

    public double getStdDev() {
        return this.stdDev;
    }

    public float getTotal() {
        return this.total;
    }

    public int getSubjectCount() {
        return this.methodCount;
    }

    private double computeStdDev() {
        return Math.sqrt(this.computeVariance() / (float)this.getSubjectCount());
    }

    private float computeVariance() {
        float[] crapScores = this.crapScores(this.crapSubjects);
        float variance = 0.0f;
        for (int i = 0; i < crapScores.length; ++i) {
            float diff = crapScores[i] - this.getAverage();
            variance = (float)((double)variance + Math.pow(diff, 2.0));
        }
        return variance;
    }

    private float computeMedian() {
        float[] crapNumbers = this.crapScores(this.crapSubjects);
        if (crapNumbers.length == 0) {
            return 0.0f;
        }
        if (crapNumbers.length == 1) {
            return crapNumbers[0];
        }
        Arrays.sort(crapNumbers);
        return crapNumbers[crapNumbers.length / 2];
    }

    private float[] crapScores(List<? extends Crap> list) {
        float[] crapNumbers = new float[this.crapSubjects.size()];
        for (int i = 0; i < list.size(); ++i) {
            crapNumbers[i] = list.get(i).getCrap();
        }
        return crapNumbers;
    }

    public String toString() {
        NumberFormat nf = FormatUtil.getNumberFormatter();
        StringBuilder buf = new StringBuilder();
        buf.append(this.name).append("\n_____________________\n");
        buf.append("Total Crap: ").append(nf.format(this.total)).append(", ");
        buf.append("Crap: ").append(nf.format(this.crapNumber)).append(", ");
        buf.append("Median: ").append(nf.format(this.median)).append(", ");
        buf.append("Average: ").append(nf.format(this.average)).append(", ");
        buf.append("Std Dev: ").append(nf.format(this.stdDev)).append(", ");
        buf.append("Method Count: ").append(this.methodCount).append(", ");
        buf.append("crapMethodCount: ").append(nf.format(this.crapMethodCount)).append(", ");
        buf.append("crapMethodPercent: ").append(nf.format(this.crapMethodPercent())).append("%");
        return buf.toString();
    }

    public List<? extends Crap> getSubjects() {
        return this.crapSubjects;
    }

    public void printAllSubjectComplexities() {
        List<? extends Crap> crapValues = this.getSubjects();
        System.out.println("Subject breakdown");
        System.out.println("----------------------");
        Collections.sort(crapValues, Crap.comparator);
        for (Crap crap : crapValues) {
            System.out.println(crap);
        }
    }

    public String toXml() {
        MyStringBuilder s = new MyStringBuilder();
        s.start("<crap_result>");
        this.crapProject.toXml(s);
        s.start("<stats>");
        XmlUtil.itemToXml(s, "name", this.name);
        NumberFormat nf = FormatUtil.getNumberFormatter();
        XmlUtil.itemToXml(s, "totalCrap", nf.format(this.total));
        XmlUtil.itemToXml(s, "crap", nf.format(this.crapNumber));
        XmlUtil.itemToXml(s, "median", nf.format(this.median));
        XmlUtil.itemToXml(s, "average", nf.format(this.average));
        XmlUtil.itemToXml(s, "stdDev", nf.format(this.stdDev));
        XmlUtil.itemToXml(s, "methodCount", Integer.toString(this.methodCount));
        XmlUtil.itemToXml(s, "crapMethodCount", Integer.toString(this.crapMethodCount));
        XmlUtil.itemToXml(s, "crapMethodPercent", nf.format(this.crapMethodPercent()));
        XmlUtil.itemToXml(s, "crapLoad", Integer.toString(this.crapWorkLoad));
        XmlUtil.itemToXml(s, "crapThreshold", Integer.toString((int)this.crapThreshold));
        XmlUtil.itemToXml(s, "globalAverage", nf.format(this.globalStats.getCrapAverage()));
        XmlUtil.itemToXml(s, "globalCraploadAverage", nf.format(this.globalStats.getCrapLoadAverage()));
        XmlUtil.itemToXml(s, "globalCrapMethodAverage", nf.format(this.globalStats.getCrapMethodAverage()));
        XmlUtil.itemToXml(s, "globalTotalMethodAverage", nf.format(this.globalStats.getTotalMethodAverage()));
        XmlUtil.itemToXml(s, "globalAverageDiff", nf.format(this.globalStats.getCrapAverageDiff(this.crapNumber)));
        XmlUtil.itemToXml(s, "globalCraploadAverageDiff", nf.format(this.globalStats.getCrapLoadAverageDiff(this.crapWorkLoad)));
        XmlUtil.itemToXml(s, "globalCrapMethodAverageDiff", nf.format(this.globalStats.getCrapMethodAverageDiff(this.crapMethodCount)));
        XmlUtil.itemToXml(s, "globalTotalMethodAverageDiff", nf.format(this.globalStats.getTotalMethodAverageDiff(this.methodCount)));
        String projectName = URLEncoder.encode(this.crapProject.getProjectName());
        int ones = this.crapLessThan(2.0f);
        int twos = this.crapBetween(2.0f, 4.0f);
        int fours = this.crapBetween(4.0f, 8.0f);
        int eights = this.crapBetween(8.0f, 16.0f);
        int sixteens = this.crapBetween(16.0f, 32.0f);
        int thirtytwos = this.crapBetween(32.0f, 64.0f);
        int sixtyfours = this.crapBetween(64.0f, 128.0f);
        int one28s = this.crapBetween(128.0f, 256.0f);
        int two56s = this.crapGE(256.0f);
        String url = this.server + "stats/new?stat[project_hash]=" + this.crapProject.getProjectId().toString() + "&amp;stat[project_url]=" + projectName + "&amp;stat[crap]=" + URLEncoder.encode(FormatUtil.getUSNumberFormatter().format(this.crapMethodPercent())) + "&amp;stat[crap_load]=" + Integer.toString(this.crapWorkLoad) + "&amp;stat[crap_methods]=" + Integer.toString(this.crapMethodCount) + "&amp;stat[total_methods]=" + Integer.toString(this.methodCount) + "&amp;stat[ones]=" + Integer.toString(ones) + "&amp;stat[twos]=" + Integer.toString(twos) + "&amp;stat[fours]=" + Integer.toString(fours) + "&amp;stat[eights]=" + Integer.toString(eights) + "&amp;stat[sixteens]=" + Integer.toString(sixteens) + "&amp;stat[thirtytwos]=" + Integer.toString(thirtytwos) + "&amp;stat[sixtyfours]=" + Integer.toString(sixtyfours) + "&amp;stat[one28s]=" + Integer.toString(one28s) + "&amp;stat[two56s]=" + Integer.toString(two56s);
        XmlUtil.itemToXml(s, "shareStatsUrl", url);
        s.start("<histogram>");
        int[] places = new int[]{ones, twos, fours, eights, sixteens, thirtytwos, sixtyfours, one28s, two56s};
        Arrays.sort(places);
        int largest = places[places.length - 1];
        float scale = 170.0f / (float)largest;
        int minHeight = 20;
        this.makeHist(s, "one", Integer.toString(ones), nf.format(this.adjustedHeight(ones, scale)));
        this.makeHist(s, "two", Integer.toString(twos), nf.format(this.adjustedHeight(twos, scale)));
        this.makeHist(s, "four", Integer.toString(fours), nf.format(this.adjustedHeight(fours, scale)));
        this.makeHist(s, "eight", Integer.toString(eights), nf.format(this.adjustedHeight(eights, scale)));
        this.makeHist(s, "sixteen", Integer.toString(sixteens), nf.format(this.adjustedHeight(sixteens, scale)));
        this.makeHist(s, "thirtytwo", Integer.toString(thirtytwos), nf.format(this.adjustedHeight(thirtytwos, scale)));
        this.makeHist(s, "sixtyfour", Integer.toString(sixtyfours), nf.format(this.adjustedHeight(sixtyfours, scale)));
        this.makeHist(s, "one28", Integer.toString(one28s), nf.format(this.adjustedHeight(one28s, scale)));
        this.makeHist(s, "two56", Integer.toString(two56s), nf.format(this.adjustedHeight(two56s, scale)));
        s.end("</histogram>");
        s.end("</stats>");
        s.start("<methods>");
        List<? extends Crap> crapValues = this.getSubjects();
        Collections.sort(crapValues, Crap.comparator);
        MethodCrap.setCrapLoadThreshold(this.crapThreshold);
        for (Crap crap : crapValues) {
            crap.toXml(s);
        }
        s.end("</methods>");
        s.end("</crap_result>");
        return s.toString();
    }

    private float adjustedHeight(int ones, float scale) {
        float minHeight = 28.0f;
        if (ones > 0) {
            return Math.max((float)ones * scale, minHeight);
        }
        return 0.0f;
    }

    private void makeHist(MyStringBuilder s, String place, String value, String height) {
        s.start("<hist>");
        XmlUtil.itemToXml(s, "place", place);
        XmlUtil.itemToXml(s, "value", value);
        XmlUtil.itemToXml(s, "height", height + "px");
        s.end("</hist>");
    }

    private int crapBetween(float f, float f2) {
        int count = 0;
        for (Crap crap : this.crapSubjects) {
            if (!(crap.getCrap() >= f) || !(crap.getCrap() < f2)) continue;
            ++count;
        }
        return count;
    }

    private int crapLessThan(float f) {
        int count = 0;
        for (Crap crap : this.crapSubjects) {
            if (!(crap.getCrap() < f)) continue;
            ++count;
        }
        return count;
    }

    private int crapGE(float f) {
        int count = 0;
        for (Crap crap : this.crapSubjects) {
            if (!(crap.getCrap() >= f)) continue;
            ++count;
        }
        return count;
    }

    private float crapMethodPercent() {
        return (float)this.crapMethodCount / (float)this.methodCount * 100.0f;
    }

    public void writeXmlToFile(String statsXml) {
        File out = this.getXmlReportFile();
        FileUtil.writeFile(out, statsXml);
    }

    private File getXmlReportFile() {
        return this.crapProject.getReportFile();
    }

    public void generatePicture() {
        CrapImageGenerator cig = new CrapImageGenerator(this.crapMethodPercent(), this.crapProject.outputDir(), "crapGauge.png", this.crapPercentWarningThreshold, this.crapPercentCriticalThreshold);
        cig.makeGaugeAndWriteToFile();
    }

    public void generateBarPicture() {
        NewCrapImageGenerator cig = new NewCrapImageGenerator(this.crapMethodPercent(), this.crapProject.outputDir(), "crapBar.png", false, this.crapPercentCriticalThreshold * 100.0f, this.globalStats.getCrapAverage());
        cig.makeGaugeAndWriteToFile();
    }

    public void generateHtml() {
        this.copyImages();
        try {
            StreamSource xmlFile = new StreamSource(this.getXmlReportFile());
            this.generateMainPage(xmlFile);
            this.generateDetailCrapPage(xmlFile);
            this.generateDetailCrapLoadPage(xmlFile);
            this.generateDetailComplexityPage(xmlFile);
            this.generateDetailCoveragePage(xmlFile);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void copyImages() {
        this.copyFile(this.getRelativeResource("g_backbar.gif"), new File(this.crapProject.outputDir(), "g_backbar.gif"));
        this.copyFile(this.getRelativeResource("g_colorbar3.jpg"), new File(this.crapProject.outputDir(), "g_colorbar3.jpg"));
    }

    public void copyFile(InputStream stream, File outFile) {
        try {
            BufferedInputStream f = new BufferedInputStream(new DataInputStream(stream));
            BufferedOutputStream out = new BufferedOutputStream(new DataOutputStream(new FileOutputStream(outFile)));
            new StreamCopier(f, out, false);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private void makeHtml(StreamSource xmlFile, InputStream xslt, File outDetail) throws TransformerConfigurationException, TransformerFactoryConfigurationError, TransformerException {
        StreamSource xsltFile = new StreamSource(xslt);
        Transformer transformer = TransformerFactory.newInstance().newTransformer(xsltFile);
        transformer.transform(xmlFile, new StreamResult(outDetail));
    }

    private void generateMainPage(StreamSource xmlFile) throws FileNotFoundException, TransformerFactoryConfigurationError, TransformerConfigurationException, TransformerException {
        InputStream xslt = this.getRelativeResource("report.xslt");
        File outDetail = this.crapProject.getReportHtmlFile();
        this.makeHtml(xmlFile, xslt, outDetail);
    }

    private void generateDetailCrapPage(StreamSource xmlFile) throws FileNotFoundException, TransformerFactoryConfigurationError, TransformerConfigurationException, TransformerException {
        InputStream xslt = this.getRelativeResource("detail_crap.xslt");
        File outDetail = new File(this.crapProject.outputDir(), "detail_crap.html");
        this.makeHtml(xmlFile, xslt, outDetail);
    }

    private void generateDetailCrapLoadPage(StreamSource xmlFile) throws FileNotFoundException, TransformerFactoryConfigurationError, TransformerConfigurationException, TransformerException {
        InputStream xslt = this.getRelativeResource("detail_crap_load.xslt");
        File outDetail = new File(this.crapProject.outputDir(), "detail_crap_load.html");
        this.makeHtml(xmlFile, xslt, outDetail);
    }

    private void generateDetailComplexityPage(StreamSource xmlFile) throws FileNotFoundException, TransformerFactoryConfigurationError, TransformerConfigurationException, TransformerException {
        InputStream xslt = this.getRelativeResource("detail_complexity.xslt");
        File outDetail = new File(this.crapProject.outputDir(), "detail_complexity.html");
        this.makeHtml(xmlFile, xslt, outDetail);
    }

    private void generateDetailCoveragePage(StreamSource xmlFile) throws FileNotFoundException, TransformerFactoryConfigurationError, TransformerConfigurationException, TransformerException {
        InputStream xslt = this.getRelativeResource("detail_coverage.xslt");
        File outDetail = new File(this.crapProject.outputDir(), "detail_coverage.html");
        this.makeHtml(xmlFile, xslt, outDetail);
    }

    public InputStream getRelativeResource(String file) {
        return SystemCrapStats.class.getResourceAsStream(file);
    }

    public void writeReport() {
        this.writeXmlToFile(this.toXml());
        this.generateBarPicture();
        this.generateHtml();
    }
}

