/*
 * Decompiled with CFR 0.152.
 */
package org.crap4j;

import org.crap4j.MethodInfo;

public class MethodComplexity
extends MethodInfo
implements Comparable {
    private int complexity;
    private String pkgclassName;
    private String methodName;
    private String methodDescriptor;
    private String java5Signature;
    private String packageName;
    private String className;
    private String prettyMethodSignature;

    public MethodComplexity(String methodSignature, String pkgclassName, String methodName, String methodDescriptor, String java5Signature, int complexity, String prettyMethodSignature) {
        this.matchingMethodSignature = pkgclassName.replace('/', '.') + "." + methodName + methodDescriptor;
        this.prettyMethodSignature = prettyMethodSignature;
        this.complexity = complexity;
        this.pkgclassName = pkgclassName;
        this.packageName = this.makePackageName();
        this.className = this.makeClassName();
        this.methodName = methodName;
        this.methodDescriptor = methodDescriptor;
        this.java5Signature = java5Signature;
    }

    public int getComplexity() {
        return this.complexity;
    }

    public String toString() {
        return this.matchingMethodSignature + " : " + this.complexity;
    }

    public String getJava5Signature() {
        return this.java5Signature;
    }

    public String getMethodDescriptor() {
        return this.methodDescriptor;
    }

    public String getSigOrDescriptor() {
        if (this.java5Signature != null && this.java5Signature.length() > 0) {
            return this.java5Signature;
        }
        return this.methodDescriptor;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String prettyMethodSignature() {
        return this.prettyMethodSignature;
    }

    public String getPackageName() {
        return this.packageName;
    }

    private String makePackageName() {
        int lastIndexOf = this.pkgclassName.lastIndexOf(46);
        if (lastIndexOf == -1) {
            return "";
        }
        return this.pkgclassName.substring(0, lastIndexOf);
    }

    private String makeClassName() {
        return this.pkgclassName.substring(this.packageName.length() > 0 ? this.packageName.length() + 1 : 0);
    }

    public String getClassName() {
        return this.className;
    }
}

