/*
 * Decompiled with CFR 0.152.
 */
package org.crap4j;

import com.agitar.org.objectweb.asm.tree.analysis.AnalyzerException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import org.crap4j.AntSuperrunnerCoverageStrategy;
import org.crap4j.Crap4jRunner;
import org.crap4j.CrapProject;
import org.crap4j.Options;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;

public class Main {
    public String crap4jHome;
    public String antHome;
    public String agitatorEclipseApiPluginDir;
    public String agitatorEclipseCoveragePluginDir;
    public String junitLib;

    public static Main createMain() {
        String crap4jHome = Main.getCrap4jHome();
        String agitatorEclipseApiPlugin = Main.getAgitatorEclipseApiPlugin(crap4jHome);
        String agitatorEclipseCoveragePluginDir = Main.getAgitatorEclipseCoveragePluginDir(crap4jHome);
        String junitLib = Main.getJunitLib(agitatorEclipseApiPlugin);
        String antHome = Main.getAntHome(agitatorEclipseApiPlugin);
        Main main = Main.createMain(crap4jHome, agitatorEclipseApiPlugin, agitatorEclipseCoveragePluginDir, junitLib, antHome);
        return main;
    }

    public static Main createMain(String crap4jHome, String agitatorEclipseApiPlugin, String agitatorEclipseCoveragePluginDir, String junitLib, String antHome) {
        return new Main(crap4jHome, agitatorEclipseApiPlugin, agitatorEclipseCoveragePluginDir, junitLib, antHome);
    }

    private Main(String crap4jHome, String agitatorEclipseApiPlugin, String agitatorEclipseCoveragePluginDir, String junitLib, String antHome) {
        try {
            this.crap4jHome = crap4jHome;
            this.agitatorEclipseApiPluginDir = agitatorEclipseApiPlugin;
            this.agitatorEclipseCoveragePluginDir = agitatorEclipseCoveragePluginDir;
            this.junitLib = junitLib;
            this.antHome = antHome;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getAntHome(String apiPluginDir) {
        return System.getProperty("ANT_HOME", apiPluginDir);
    }

    public static String getJunitLib(String apiPluginDir) {
        return apiPluginDir + File.separator + "lib" + File.separator + "junit.jar";
    }

    public static String getAgitatorEclipseCoveragePluginDir(String crap4jHome) {
        return crap4jHome + File.separator + "lib" + File.separator + "com.agitar.eclipse.coverage_4.2.0.401405";
    }

    public static String getAgitatorEclipseApiPlugin(String crap4jHome) {
        return crap4jHome + File.separator + "lib" + File.separator + "com.agitar.eclipse.api_4.2.0.401405";
    }

    public static String getCrap4jHome() {
        String crap4jHome = System.getProperty("CRAP4J_HOME");
        if (Main.isBlank(crap4jHome) && Main.isAbsoluteWindowsPath(crap4jHome = Main.getCrap4jHomeFromClass().replace('/', File.separatorChar).replace("%20", " "))) {
            crap4jHome = Main.removeDriveLetter(crap4jHome);
        }
        return crap4jHome;
    }

    private static String removeDriveLetter(String crap4jHome) {
        return crap4jHome.substring(1);
    }

    private static boolean isAbsoluteWindowsPath(String crap4jHome) {
        return crap4jHome.indexOf(58) != -1 && crap4jHome.startsWith("\\");
    }

    private static boolean isBlank(String crap4jHome) {
        return crap4jHome == null || crap4jHome.equals("");
    }

    private static String getCrap4jHomeFromClass() {
        URL foo = Main.class.getResource("foo");
        String filePath = foo.getPath();
        int lastIndexOf = filePath.lastIndexOf(File.separator + "lib" + File.separator);
        if (lastIndexOf == -1) {
            int lastIndexOfBin = filePath.lastIndexOf(File.separator + "bin" + File.separator);
            if (lastIndexOfBin != -1 && lastIndexOfBin < filePath.length()) {
                return filePath.substring(0, lastIndexOfBin);
            }
            throw new IllegalArgumentException("Cannot figure out Crap4j Home!!");
        }
        return filePath.substring(5, lastIndexOf);
    }

    public static void main(String[] args) {
        Options options = Main.parseArgs(args);
        if (!options.valid()) {
            System.exit(1);
        }
        CrapProject p = new CrapProject(options.getProjectDir(), options.getLibClasspaths(), options.getTestClassDirs(), options.getClassDirs(), options.getSourceDirs(), options.getOutputDir());
        try {
            Main main = Main.createMain();
            main.run(p, options.getDebug(), options.getDontTest(), options.getDownloadAverages(), options.getServer());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void run(CrapProject project, boolean debug, boolean dontTest, boolean downloadAverages, String server) throws IOException, AnalyzerException {
        Crap4jRunner runner = new Crap4jRunner(debug, dontTest, downloadAverages, new AntSuperrunnerCoverageStrategy(this), 30.0f, 10.0f, 5.0f, server);
        runner.doProject(project);
    }

    public static Options parseArgs(String[] args) {
        Options options = new Options();
        CmdLineParser parser = new CmdLineParser((Object)options);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            Main.printUsage(parser);
        }
        if (!options.valid()) {
            Main.printUsage(parser);
        }
        return options;
    }

    private static void printUsage(CmdLineParser parser) {
        System.err.println("crap4j.[ sh | bat ] [parameters]");
        System.err.println("\twhere parameters are:");
        parser.printUsage((OutputStream)System.err);
    }
}

