/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.ImageMath;
import com.jhlabs.image.WholeImageFilter;
import java.awt.Rectangle;

public abstract class TransformFilter
extends WholeImageFilter {
    public static final int ZERO = 0;
    public static final int CLAMP = 1;
    public static final int WRAP = 2;
    public static final int NEAREST_NEIGHBOUR = 0;
    public static final int BILINEAR = 1;
    protected int edgeAction = 0;
    protected int interpolation = 1;

    public void setEdgeAction(int edgeAction) {
        this.edgeAction = edgeAction;
    }

    public int getEdgeAction() {
        return this.edgeAction;
    }

    public void setInterpolation(int interpolation) {
        this.interpolation = interpolation;
    }

    public int getInterpolation() {
        return this.interpolation;
    }

    protected abstract void transformInverse(int var1, int var2, float[] var3);

    protected void transformSpace(Rectangle rect) {
    }

    protected int[] filterPixels(int width, int height, int[] inPixels, Rectangle transformedSpace) {
        if (this.interpolation == 0) {
            return this.filterPixelsNN(width, height, inPixels, transformedSpace);
        }
        int srcWidth = width;
        int srcHeight = height;
        int srcWidth1 = width - 1;
        int srcHeight1 = height - 1;
        int outWidth = transformedSpace.width;
        int outHeight = transformedSpace.height;
        int index = 0;
        int[] outPixels = new int[outWidth * outHeight];
        int outX = transformedSpace.x;
        int outY = transformedSpace.y;
        float[] out = new float[2];
        for (int y = 0; y < outHeight; ++y) {
            for (int x = 0; x < outWidth; ++x) {
                int se;
                int sw;
                int ne;
                int nw;
                this.transformInverse(outX + x, outY + y, out);
                int srcX = (int)Math.floor(out[0]);
                int srcY = (int)Math.floor(out[1]);
                float xWeight = out[0] - (float)srcX;
                float yWeight = out[1] - (float)srcY;
                if (srcX >= 0 && srcX < srcWidth1 && srcY >= 0 && srcY < srcHeight1) {
                    int i = srcWidth * srcY + srcX;
                    nw = inPixels[i];
                    ne = inPixels[i + 1];
                    sw = inPixels[i + srcWidth];
                    se = inPixels[i + srcWidth + 1];
                } else {
                    nw = this.getPixel(inPixels, srcX, srcY, srcWidth, srcHeight);
                    ne = this.getPixel(inPixels, srcX + 1, srcY, srcWidth, srcHeight);
                    sw = this.getPixel(inPixels, srcX, srcY + 1, srcWidth, srcHeight);
                    se = this.getPixel(inPixels, srcX + 1, srcY + 1, srcWidth, srcHeight);
                }
                outPixels[index++] = ImageMath.bilinearInterpolate(xWeight, yWeight, nw, ne, sw, se);
            }
        }
        return outPixels;
    }

    private final int getPixel(int[] pixels, int x, int y, int width, int height) {
        if (x < 0 || x >= width || y < 0 || y >= height) {
            switch (this.edgeAction) {
                default: {
                    return 0;
                }
                case 2: {
                    return pixels[ImageMath.mod(y, height) * width + ImageMath.mod(x, width)];
                }
                case 1: 
            }
            return pixels[ImageMath.clamp(y, 0, height - 1) * width + ImageMath.clamp(x, 0, width - 1)];
        }
        return pixels[y * width + x];
    }

    protected int[] filterPixelsNN(int width, int height, int[] inPixels, Rectangle transformedSpace) {
        int srcWidth = width;
        int srcHeight = height;
        int outWidth = transformedSpace.width;
        int outHeight = transformedSpace.height;
        int index = 0;
        int[] outPixels = new int[outWidth * outHeight];
        int outX = transformedSpace.x;
        int outY = transformedSpace.y;
        int[] rgb = new int[4];
        float[] out = new float[2];
        for (int y = 0; y < outHeight; ++y) {
            for (int x = 0; x < outWidth; ++x) {
                this.transformInverse(outX + x, outY + y, out);
                int srcX = (int)out[0];
                int srcY = (int)out[1];
                if (out[0] < 0.0f || srcX >= srcWidth || out[1] < 0.0f || srcY >= srcHeight) {
                    int p;
                    switch (this.edgeAction) {
                        default: {
                            p = 0;
                            break;
                        }
                        case 2: {
                            p = inPixels[ImageMath.mod(srcY, srcHeight) * srcWidth + ImageMath.mod(srcX, srcWidth)];
                            break;
                        }
                        case 1: {
                            p = inPixels[ImageMath.clamp(srcY, 0, srcHeight - 1) * srcWidth + ImageMath.clamp(srcX, 0, srcWidth - 1)];
                        }
                    }
                    outPixels[index++] = p;
                    continue;
                }
                int i = srcWidth * srcY + srcX;
                rgb[0] = inPixels[i];
                outPixels[index++] = inPixels[i];
            }
        }
        return outPixels;
    }
}

