/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.PointFilter;

public class OvalFilter
extends PointFilter {
    private float centreX = 0.0f;
    private float centreY = 0.0f;
    private float a = 0.0f;
    private float b = 0.0f;
    private float a2 = 0.0f;
    private float b2 = 0.0f;

    public void setDimensions(int width, int height) {
        super.setDimensions(width, height);
        this.centreX = this.a = (float)(width / 2);
        this.centreY = this.b = (float)(height / 2);
        this.a2 = this.a * this.a;
        this.b2 = this.b * this.b;
    }

    public int filterRGB(int x, int y, int rgb) {
        float dy = (float)y - this.centreY;
        float y2 = dy * dy;
        float dx = (float)x - this.centreX;
        float x2 = dx * dx;
        if (y2 >= this.b2 - this.b2 * x2 / this.a2) {
            return 0;
        }
        return rgb;
    }

    public String toString() {
        return "Stylize/Oval...";
    }
}

