/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.ImageMath;
import com.jhlabs.image.TransformFilter;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class Map3DFilter
extends TransformFilter {
    private float angleX = 0.0f;
    private float angleY = 0.0f;
    private float angleZ = 0.0f;
    private float centreX = 0.5f;
    private float centreY = 0.5f;
    private float radius = 0.5f;
    private float radius2 = 0.0f;
    private float icentreX;
    private float icentreY;
    private float width;
    private float height;
    private Vector3f equator = new Vector3f(0.0f, 0.0f, -1.0f);
    private Vector3f north = new Vector3f(0.0f, 1.0f, 0.0f);
    private Vector3f view = new Vector3f(0.5f, 0.5f, 5.0f);
    private Vector3f sphere = new Vector3f(0.5f, 0.5f, 0.0f);
    private Vector3f ray = new Vector3f();
    private Vector3f t = new Vector3f();
    private Vector3f s = new Vector3f();
    private Vector3f n = new Vector3f();
    private Vector3f c = new Vector3f();

    public void setAngleX(float angleX) {
        this.angleX = angleX;
    }

    public float getAngleX() {
        return this.angleX;
    }

    public void setAngleY(float angleY) {
        this.angleY = angleY;
    }

    public float getAngleY() {
        return this.angleY;
    }

    public void setAngleZ(float angleZ) {
        this.angleZ = angleZ;
    }

    public float getAngleZ() {
        return this.angleZ;
    }

    public void setCentreX(float centreX) {
        this.centreX = centreX;
    }

    public float getCentreX() {
        return this.centreX;
    }

    public void setCentreY(float centreY) {
        this.centreY = centreY;
    }

    public float getCentreY() {
        return this.centreY;
    }

    public void setCentre(Point2D centre) {
        this.centreX = (float)centre.getX();
        this.centreY = (float)centre.getY();
    }

    public Point2D getCentre() {
        return new Point2D.Float(this.centreX, this.centreY);
    }

    public void setRadius(float radius) {
        this.radius = radius;
    }

    public float getRadius() {
        return this.radius;
    }

    protected int[] filterPixels(int width, int height, int[] inPixels, Rectangle transformedSpace) {
        Matrix4f m;
        this.width = width;
        this.height = height;
        this.icentreX = (float)width * this.centreX;
        this.icentreY = (float)height * this.centreY;
        if (this.radius == 0.0f) {
            this.radius = Math.min(this.icentreX, this.icentreY);
        }
        this.radius2 = this.radius * this.radius;
        this.sphere.x = this.centreX;
        this.sphere.y = this.centreY;
        this.equator = new Vector3f(0.0f, 0.0f, -1.0f);
        this.north = new Vector3f(0.0f, 1.0f, 0.0f);
        if (this.angleX != 0.0f) {
            m = new Matrix4f();
            m.rotX(this.angleX);
            m.transform(this.north);
            m.transform(this.equator);
        }
        if (this.angleY != 0.0f) {
            m = new Matrix4f();
            m.rotY(this.angleY);
            m.transform(this.north);
            m.transform(this.equator);
        }
        if (this.angleZ != 0.0f) {
            m = new Matrix4f();
            m.rotZ(this.angleZ);
            m.transform(this.north);
            m.transform(this.equator);
        }
        return super.filterPixels(width, height, inPixels, transformedSpace);
    }

    protected void transformInverse(int x, int y, float[] out) {
        this.ray.set((float)x / this.height, (float)y / this.height, 0.0f);
        this.ray.sub((Tuple3f)this.view);
        this.ray.normalize();
        this.t.sub((Tuple3f)this.sphere, (Tuple3f)this.view);
        float alpha = this.t.dot(this.ray);
        float beta = this.t.dot(this.t);
        float tau = alpha * alpha - beta + this.radius * this.radius;
        if (tau >= 0.0f) {
            float u;
            float s1;
            float s2 = alpha - (tau = (float)Math.sqrt(tau));
            if (s2 < (s1 = alpha + tau)) {
                s1 = s2;
            }
            this.s.scaleAdd(s1, (Tuple3f)this.ray, (Tuple3f)this.view);
            this.n.sub((Tuple3f)this.s, (Tuple3f)this.sphere);
            this.n.normalize();
            float a = (float)Math.acos(-this.north.dot(this.n));
            float v = a / (float)Math.PI;
            if (v == 0.0f || v == 1.0f) {
                u = 0.0f;
            } else {
                float f = this.equator.dot(this.n) / (float)Math.sin(a);
                f = ImageMath.clamp(f, -1.0f, 1.0f);
                u = (float)Math.acos(f) / ((float)Math.PI * 2);
                this.c.cross(this.north, this.equator);
                if (this.c.dot(this.n) < 0.0f) {
                    u = 1.0f - u;
                }
            }
            out[0] = u * this.width;
            out[1] = v * this.height;
        } else {
            out[0] = -1.0f;
            out[1] = -1.0f;
        }
    }

    public String toString() {
        return "Distort/3D Sphere...";
    }
}

