/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.wizard;

import java.awt.Color;
import java.awt.Component;
import java.beans.Beans;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreePath;
import org.netbeans.spi.wizard.GenericListener;
import org.netbeans.spi.wizard.Wizard;
import org.netbeans.spi.wizard.WizardController;
import org.netbeans.spi.wizard.WizardControllerImplementation;
import org.netbeans.spi.wizard.WizardException;
import org.netbeans.spi.wizard.WizardPanel;
import org.netbeans.spi.wizard.WizardPanelNavResult;
import org.netbeans.spi.wizard.WizardPanelProvider;

public class WizardPage
extends JPanel
implements WizardPanel {
    private static final Logger logger = Logger.getLogger(WizardPage.class.getName());
    private final String description;
    private final String id;
    private Map wizardData;
    private WizardControllerImplementation wc = new WC();
    private WizardController controller = new WizardController(this.wc);
    private boolean inBeginUIChanged = false;
    private boolean inUiChanged = false;
    private final CustomComponentListener ccl;
    private boolean inValidateContents = false;
    private String longDescription;

    public WizardPage(String stepId, String stepDescription, boolean autoListen) {
        this.id = stepId;
        this.description = stepDescription;
        if (autoListen) {
            this.ccl = this.createCustomComponentListener();
            GenericListener genericListener = new GenericListener(this, this.ccl, this.ccl == null ? null : new CustomComponentNotifierImpl(this));
        } else {
            this.ccl = this.createCustomComponentListener();
            if (this.ccl != null) {
                throw new IllegalStateException("CustomComponentListener will never be called if the autoListen parameter is false");
            }
        }
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    public WizardPage(String stepId, String stepDescription) {
        this(stepId, stepDescription, true);
    }

    protected WizardPage(boolean autoListen) {
        this(null, null, autoListen);
    }

    protected WizardPage() {
        this(true);
    }

    protected CustomComponentListener createCustomComponentListener() {
        return null;
    }

    private String getID() {
        return this.id;
    }

    private String getDescription() {
        return this.description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotify() {
        super.addNotify();
        this.renderingPage();
        this.inValidateContents = true;
        try {
            this.setProblem(this.validateContents(null, null));
        }
        finally {
            this.inValidateContents = false;
        }
    }

    public WizardPanelNavResult allowBack(String stepName, Map settings, Wizard wizard) {
        return WizardPanelNavResult.PROCEED;
    }

    public WizardPanelNavResult allowFinish(String stepName, Map settings, Wizard wizard) {
        return WizardPanelNavResult.PROCEED;
    }

    public WizardPanelNavResult allowNext(String stepName, Map settings, Wizard wizard) {
        return WizardPanelNavResult.PROCEED;
    }

    protected void renderingPage() {
    }

    public static Wizard createWizard(WizardPage[] contents, WizardResultProducer finisher) {
        return new WPP(contents, finisher).createWizard();
    }

    public static Wizard createWizard(String title, WizardPage[] contents, WizardResultProducer finisher) {
        return new WPP(title, contents, finisher).createWizard();
    }

    public static Wizard createWizard(String title, WizardPage[] contents) {
        return WizardPage.createWizard(title, contents, WizardResultProducer.NO_OP);
    }

    public static Wizard createWizard(WizardPage[] contents) {
        return WizardPage.createWizard(contents, WizardResultProducer.NO_OP);
    }

    public static Wizard createWizard(Class[] wizardPageClasses, WizardResultProducer finisher) {
        return new CWPP(wizardPageClasses, finisher).createWizard();
    }

    public static Wizard createWizard(String title, Class[] wizardPageClasses, WizardResultProducer finisher) {
        return new CWPP(title, wizardPageClasses, finisher).createWizard();
    }

    public static Wizard createWizard(String title, Class[] wizardPageClasses) {
        return new CWPP(title, wizardPageClasses, WizardResultProducer.NO_OP).createWizard();
    }

    public static Wizard createWizard(Class[] wizardPageClasses) {
        return WizardPage.createWizard(wizardPageClasses, WizardResultProducer.NO_OP);
    }

    void setWizardDataMap(Map m) {
        if (m == null) {
            this.wizardData = new HashMap();
        } else {
            if (this.wizardData instanceof HashMap) {
                Iterator iter = this.wizardData.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    Object key = entry.getKey();
                    if (m.containsKey(key)) continue;
                    m.put(key, entry.getValue());
                }
            }
            this.wizardData = m;
        }
    }

    void setController(WizardController controller) {
        if (controller.getImpl() instanceof WC) {
            ((WC)controller.getImpl()).configure(controller);
        }
        this.controller = controller;
    }

    private WizardController getController() {
        return this.controller;
    }

    protected final void setProblem(String value) {
        this.getController().setProblem(value);
    }

    protected final void setForwardNavigationMode(int value) {
        this.getController().setForwardNavigationMode(value);
    }

    protected final void setBusy(boolean busy) {
        this.getController().setBusy(busy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void putWizardData(Object key, Object value) {
        logger.fine("putWizardData " + key + "=" + value);
        this.getWizardDataMap().put(key, value);
        if (!this.inBeginUIChanged && !this.inValidateContents) {
            this.inValidateContents = true;
            try {
                this.setProblem(this.validateContents(null, null));
            }
            finally {
                this.inValidateContents = false;
            }
        }
    }

    protected final Object[] getWizardDataKeys() {
        return this.getWizardDataMap().keySet().toArray();
    }

    protected final Object getWizardData(Object key) {
        return this.getWizardDataMap().get(key);
    }

    protected final boolean wizardDataContainsKey(Object key) {
        return this.getWizardDataMap().containsKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void userInputReceived(Component source, Object event) {
        if (this.inBeginUIChanged) {
            logger.fine("Ignoring recursive entry to userInputReceived while updating map");
            return;
        }
        this.inBeginUIChanged = true;
        if (source != null) {
            try {
                this.maybeUpdateMap(source);
            }
            finally {
                this.inBeginUIChanged = false;
            }
        }
        if (this.inUiChanged) {
            logger.fine("Ignoring recursive entry to userInputReceieved from validateContents");
            return;
        }
        this.inUiChanged = true;
        this.inValidateContents = true;
        try {
            this.setProblem(this.validateContents(source, event));
        }
        finally {
            this.inUiChanged = false;
            this.inValidateContents = false;
        }
    }

    void maybeUpdateMap(Component comp) {
        Object mapKey;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Maybe update map for " + comp.getClass().getName() + " named " + comp.getName());
        }
        if ((mapKey = this.getMapKeyFor(comp)) != null) {
            Object value = this.valueFrom(comp);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("maybeUpdateMap putting " + mapKey + "," + value + " into settings");
            }
            this.putWizardData(mapKey, value);
        }
    }

    void removeFromMap(Object key) {
        logger.fine("removeFromMap: " + key);
        this.getWizardDataMap().remove(key);
    }

    protected Object valueFrom(Component comp) {
        if (this.ccl != null && this.ccl.accept(comp)) {
            return this.ccl.valueFor(comp);
        }
        if (comp instanceof JRadioButton || comp instanceof JCheckBox || comp instanceof JToggleButton) {
            return ((AbstractButton)comp).getModel().isSelected() ? Boolean.TRUE : Boolean.FALSE;
        }
        if (comp instanceof JTree) {
            TreePath path = ((JTree)comp).getSelectionPath();
            if (path != null) {
                return path.getLastPathComponent();
            }
        } else if (comp instanceof JList) {
            Object[] o = ((JList)comp).getSelectedValues();
            if (o != null) {
                if (o.length > 1) {
                    return o;
                }
                if (o.length == 1) {
                    return o[0];
                }
            }
        } else {
            if (comp instanceof JTextComponent) {
                return ((JTextComponent)comp).getText();
            }
            if (comp instanceof JComboBox) {
                return ((JComboBox)comp).getSelectedItem();
            }
            if (comp instanceof JColorChooser) {
                return ((JColorChooser)comp).getSelectionModel().getSelectedColor();
            }
            if (comp instanceof JSpinner) {
                return ((JSpinner)comp).getValue();
            }
            if (comp instanceof JSlider) {
                return new Integer(((JSlider)comp).getValue());
            }
        }
        return null;
    }

    protected void valueTo(Map settings, Component comp) {
        String name = comp.getName();
        Object value = settings.get(name);
        if (comp instanceof JRadioButton || comp instanceof JCheckBox || comp instanceof JToggleButton) {
            if (value instanceof Boolean) {
                ((AbstractButton)comp).getModel().setSelected((Boolean)value);
            }
        } else if (comp instanceof JList) {
            if (value instanceof Object[]) {
                throw new IllegalArgumentException("can't handle multi-select lists");
            }
            ((JList)comp).setSelectedValue(value, true);
        } else if (comp instanceof JTextComponent) {
            ((JTextComponent)comp).setText((String)value);
        } else if (comp instanceof JComboBox) {
            ((JComboBox)comp).setSelectedItem(value);
        } else if (comp instanceof JColorChooser) {
            ((JColorChooser)comp).getSelectionModel().setSelectedColor((Color)value);
        } else if (comp instanceof JSpinner) {
            ((JSpinner)comp).setValue(value);
        } else if (comp instanceof JSlider) {
            ((JSlider)comp).setValue((Integer)value);
        }
    }

    protected Object getMapKeyFor(Component c) {
        if (this.ccl != null && this.ccl.accept(c)) {
            return this.ccl.keyFor(c);
        }
        return c.getName();
    }

    protected String validateContents(Component component, Object event) {
        return null;
    }

    protected void recycle() {
        this.setProblem(this.validateContents(null, null));
    }

    protected Map getWizardDataMap() {
        if (this.wizardData == null) {
            this.wizardData = new HashMap();
        }
        return this.wizardData;
    }

    protected void setLongDescription(String desc) {
        if (!Beans.isDesignTime() && this.longDescription != null) {
            throw new IllegalStateException("Long description already set to " + desc);
        }
        this.longDescription = desc;
    }

    public final String getLongDescription() {
        return this.longDescription;
    }

    static WizardPanelProvider createWizardPanelProvider(WizardPage page) {
        return new WPP(new WizardPage[]{page}, WizardResultProducer.NO_OP);
    }

    static WizardPanelProvider createWizardPanelProvider(WizardPage[] page) {
        return new WPP(page, WizardResultProducer.NO_OP);
    }

    private static String[] getSteps(WizardPage[] pages) {
        String[] result = new String[pages.length];
        for (int i = 0; i < pages.length; ++i) {
            result[i] = pages[i].getID();
            if (result[i] != null) continue;
            result[i] = WizardPage.getIDFromStaticMethod(pages[i].getClass());
        }
        return result;
    }

    private static String[] getDescriptions(WizardPage[] pages) {
        String[] result = new String[pages.length];
        for (int i = 0; i < pages.length; ++i) {
            result[i] = pages[i].getDescription();
            if (result[i] != null) continue;
            result[i] = WizardPage.getDescriptionFromStaticMethod(pages[i].getClass());
        }
        return result;
    }

    private static String getIDFromStaticMethod(Class clazz) {
        String result = null;
        try {
            Method m = clazz.getDeclaredMethod("getStep", new Class[0]);
            result = (String)m.invoke((Object)clazz, (Object[])null);
            if (result == null) {
                throw new NullPointerException("getStep may not return null");
            }
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException("error getting id for " + clazz, ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException("error getting id for " + clazz, ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException("error getting id for " + clazz, ex);
        }
        catch (SecurityException ex) {
            throw new RuntimeException("error getting id for " + clazz, ex);
        }
        catch (NoSuchMethodException ex) {
            result = clazz.getName();
            logger.warning("There is no static getStep method in " + result);
        }
        return result;
    }

    private static String[] getSteps(Class[] pages) {
        if (pages == null) {
            throw new NullPointerException("Null array of classes");
        }
        String[] result = new String[pages.length];
        for (int i = 0; i < pages.length; ++i) {
            if (pages[i] == null) {
                throw new NullPointerException("Null at " + i + " in array " + "of panel classes");
            }
            if (!(class$org$netbeans$spi$wizard$WizardPage == null ? WizardPage.class$("org.netbeans.spi.wizard.WizardPage") : class$org$netbeans$spi$wizard$WizardPage).isAssignableFrom(pages[i])) {
                throw new IllegalArgumentException(pages[i].getName() + " is not a subclass of WizardPage");
            }
            result[i] = WizardPage.getIDFromStaticMethod(pages[i]);
            if (result[i] != null) continue;
            result[i] = pages[i].getName();
        }
        return result;
    }

    private static String[] getDescriptions(Class[] pages) {
        String[] result = new String[pages.length];
        for (int i = 0; i < pages.length; ++i) {
            result[i] = WizardPage.getDescriptionFromStaticMethod(pages[i]);
        }
        return result;
    }

    private static String getDescriptionFromStaticMethod(Class clazz) {
        Method m;
        String result = null;
        try {
            m = clazz.getDeclaredMethod("getDescription", null);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not find or access public static String " + clazz.getName() + ".getStep() - make sure it exists");
        }
        if (m.getReturnType() != String.class) {
            throw new IllegalArgumentException("getStep has wrong  return type: " + m.getReturnType() + " on " + clazz);
        }
        if (!Modifier.isStatic(m.getModifiers())) {
            throw new IllegalArgumentException("getStep is not static on " + clazz);
        }
        try {
            result = (String)m.invoke(null, (Object[])null);
        }
        catch (InvocationTargetException ite) {
            throw new IllegalArgumentException("Could not invoke public static String " + clazz.getName() + ".getStep() - make sure it exists.");
        }
        catch (IllegalAccessException iae) {
            throw new IllegalArgumentException("Could not invoke public static String " + clazz.getName() + ".getStep() - make sure it exists.");
        }
        return result;
    }

    public static interface WizardResultProducer {
        public static final WizardResultProducer NO_OP = new WizardResultProducer(){

            public Object finish(Map wizardData) {
                return null;
            }

            public boolean cancel(Map settings) {
                return true;
            }

            public String toString() {
                return "NO_OP WizardResultProducer";
            }
        };

        public Object finish(Map var1) throws WizardException;

        public boolean cancel(Map var1);
    }

    private static final class WC
    implements WizardControllerImplementation {
        private String problem = null;
        private int canFinish = -1;
        private Boolean busy = null;

        private WC() {
        }

        public void setProblem(String value) {
            this.problem = value;
        }

        public void setForwardNavigationMode(int value) {
            switch (value) {
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException(Integer.toString(value));
                }
            }
            this.canFinish = value;
        }

        public void setBusy(boolean busy) {
            this.busy = busy ? Boolean.TRUE : Boolean.FALSE;
        }

        void configure(WizardController other) {
            if (other == null) {
                return;
            }
            if (this.busy != null) {
                other.setBusy(this.busy);
            }
            if (this.canFinish != -1) {
                other.setForwardNavigationMode(this.canFinish);
            }
            if (this.problem != null) {
                other.setProblem(this.problem);
            }
        }
    }

    private static final class CWPP
    extends WizardPanelProvider {
        private final Class[] classes;
        private final WizardResultProducer finish;
        private final String[] longDescriptions;

        CWPP(String title, Class[] classes, WizardResultProducer finish) {
            super(title, WizardPage.getSteps(classes), WizardPage.getDescriptions(classes));
            this._validateArgs(classes, finish);
            this.finish = finish;
            this.classes = classes;
            this.longDescriptions = new String[classes.length];
        }

        private void _validateArgs(Class[] classes, WizardResultProducer finish) {
            if (classes == null) {
                throw new RuntimeException("Class array may not be null");
            }
            if (new HashSet<Class>(Arrays.asList(classes)).size() != classes.length) {
                throw new RuntimeException("Duplicate entries in class array");
            }
            if (finish == null) {
                throw new RuntimeException("WizardResultProducer may not be null");
            }
        }

        CWPP(Class[] classes, WizardResultProducer finish) {
            super(WizardPage.getSteps(classes), WizardPage.getDescriptions(classes));
            this.longDescriptions = new String[classes.length];
            this._validateArgs(classes, finish);
            this.classes = classes;
            this.finish = finish;
        }

        protected JComponent createPanel(WizardController controller, String id, Map wizardData) {
            int idx = this.indexOfStep(id);
            if (idx == -1) {
                throw new RuntimeException("Bad ID passed to createPanel: " + id);
            }
            try {
                WizardPage result = (WizardPage)this.classes[idx].newInstance();
                this.longDescriptions[idx] = result.getLongDescription();
                result.setController(controller);
                result.setWizardDataMap(wizardData);
                return result;
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Could not instantiate " + this.classes[idx], e);
                throw new RuntimeException("Could not instantiate " + this.classes[idx], e);
            }
        }

        protected Object finish(Map settings) throws WizardException {
            return this.finish.finish(settings);
        }

        public boolean cancel(Map settings) {
            return this.finish.cancel(settings);
        }

        public String toString() {
            return super.toString() + " for " + this.finish;
        }

        public String getLongDescription(String stepId) {
            int idx = this.indexOfStep(stepId);
            if (idx != -1) {
                return this.descriptions[idx];
            }
            return null;
        }
    }

    static final class WPP
    extends WizardPanelProvider {
        private final WizardPage[] pages;
        private final WizardResultProducer finish;

        WPP(WizardPage[] pages, WizardResultProducer finish) {
            super(WizardPage.getSteps(pages), WizardPage.getDescriptions(pages));
            String v = this.valid(pages);
            if (v != null) {
                throw new RuntimeException(v);
            }
            if (finish == null) {
                throw new RuntimeException("finish must not be null");
            }
            this.pages = pages;
            this.finish = finish;
        }

        WPP(String title, WizardPage[] pages, WizardResultProducer finish) {
            super(title, WizardPage.getSteps(pages), WizardPage.getDescriptions(pages));
            String v = this.valid(pages);
            if (v != null) {
                throw new RuntimeException(v);
            }
            if (finish == null) {
                throw new RuntimeException("finish must not be null");
            }
            this.pages = pages;
            this.finish = finish;
        }

        protected JComponent createPanel(WizardController controller, String id, Map wizardData) {
            int idx = this.indexOfStep(id);
            if (idx == -1) {
                throw new RuntimeException("Bad ID passed to createPanel: " + id);
            }
            this.pages[idx].setController(controller);
            this.pages[idx].setWizardDataMap(wizardData);
            return this.pages[idx];
        }

        private String valid(WizardPage[] pages) {
            if (new HashSet<WizardPage>(Arrays.asList(pages)).size() != pages.length) {
                return "Duplicate entry in array: " + Arrays.asList(pages);
            }
            for (int i = 0; i < pages.length; ++i) {
                if (pages[i] != null) continue;
                return "Null entry at " + i + " in pages array";
            }
            return null;
        }

        protected Object finish(Map settings) throws WizardException {
            return this.finish.finish(settings);
        }

        public boolean cancel(Map settings) {
            return this.finish.cancel(settings);
        }

        public String getLongDescription(String stepId) {
            for (int i = 0; i < this.pages.length; ++i) {
                WizardPage wizardPage = this.pages[i];
                if (!stepId.equals(wizardPage.getID())) continue;
                return wizardPage.getLongDescription();
            }
            return null;
        }
    }

    private static final class CustomComponentNotifierImpl
    extends CustomComponentNotifier {
        private final WizardPage page;

        private CustomComponentNotifierImpl(WizardPage page) {
            this.page = page;
        }

        public void userInputReceived(Component c, Object event) {
            if (!this.page.ccl.accept(c)) {
                return;
            }
            this.page.userInputReceived(c, event);
        }
    }

    public static abstract class CustomComponentNotifier {
        private CustomComponentNotifier() {
        }

        public abstract void userInputReceived(Component var1, Object var2);
    }

    public static abstract class CustomComponentListener {
        public abstract boolean accept(Component var1);

        public abstract void startListeningTo(Component var1, CustomComponentNotifier var2);

        public abstract void stopListeningTo(Component var1);

        public boolean isContainer(Component c) {
            return false;
        }

        public String keyFor(Component c) {
            return c.getName();
        }

        public abstract Object valueFor(Component var1);
    }
}

