/*
 * Decompiled with CFR 0.152.
 */
package beans2nbm.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import org.netbeans.spi.wizard.WizardPage;

public class SelectTaskPanel
extends WizardPage {
    private JRadioButton beanModule;
    private ButtonGroup buttonGroup1;
    private JRadioButton lafModule;
    private JRadioButton libModule;

    public SelectTaskPanel() {
        this.initComponents();
    }

    public static String getStep() {
        return "taskChoice";
    }

    public static String getDescription() {
        return "Pick Module Type";
    }

    public String getID() {
        return SelectTaskPanel.getStep();
    }

    protected String validateContents(Component component, Object event) {
        String selName = null;
        Component[] c = this.getComponents();
        for (int i = 0; i < c.length; ++i) {
            JRadioButton jb;
            if (!(c[i] instanceof JRadioButton) || !(jb = (JRadioButton)c[i]).isSelected()) continue;
            selName = jb.getName();
            assert (selName != null) : "Unnamed radio button present:" + jb;
        }
        if (selName == null) {
            return "Select a task";
        }
        if (selName == this.beanModule.getName()) {
            this.putWizardData("title", "BeanNetter - Create a plugin for Swing/AWT components");
        } else if (selName == this.libModule.getName()) {
            this.putWizardData("title", "BeanNetter - Create a plugin to provide a library");
        } else if (selName == this.lafModule.getName()) {
            this.putWizardData("title", "BeanNetter - Create a plugin to provide a look and feel");
        } else {
            this.putWizardData("title", null);
        }
        this.updateDlgTitle();
        return null;
    }

    public void addNotify() {
        super.addNotify();
        this.updateDlgTitle();
    }

    private void updateDlgTitle() {
        JDialog dlg = (JDialog)SwingUtilities.getAncestorOfClass(JDialog.class, this);
        if (dlg != null) {
            String ttl = (String)this.getWizardData("title");
            if (ttl == null) {
                dlg.setTitle("BeanNetter - the NetBeans Module Generator");
            } else {
                dlg.setTitle(ttl);
            }
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.beanModule = new JRadioButton();
        this.libModule = new JRadioButton();
        this.lafModule = new JRadioButton();
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setMinimumSize(new Dimension(500, 400));
        this.setPreferredSize(new Dimension(500, 375));
        this.setLayout(new GridBagLayout());
        this.buttonGroup1.add(this.beanModule);
        this.beanModule.setText("Create a Module that adds some Swing/AWT components to the palette");
        this.beanModule.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.beanModule.setMargin(new Insets(0, 0, 0, 0));
        this.beanModule.setName("beansModule");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.add((Component)this.beanModule, gridBagConstraints);
        this.buttonGroup1.add(this.libModule);
        this.libModule.setText("Create a Module that provides a library");
        this.libModule.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.libModule.setMargin(new Insets(0, 0, 0, 0));
        this.libModule.setName("libsModule");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(30, 0, 0, 0);
        this.add((Component)this.libModule, gridBagConstraints);
        this.buttonGroup1.add(this.lafModule);
        this.lafModule.setText("Create a module that installs a Look and Feel");
        this.lafModule.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.lafModule.setEnabled(false);
        this.lafModule.setMargin(new Insets(0, 0, 0, 0));
        this.lafModule.setName("lafModule");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(30, 0, 0, 0);
        this.add((Component)this.lafModule, gridBagConstraints);
    }
}

