/*
 * Decompiled with CFR 0.152.
 */
package beans2nbm.ui;

import beans2nbm.gen.JarInfo;
import beans2nbm.ui.BeanItem;
import beans2nbm.ui.BeansListModel;
import beans2nbm.ui.EntriesListModel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Arrays;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.spi.wizard.WizardPage;

public class SelectBeansPage
extends WizardPage
implements JarInfo.ScanObserver,
ListDataListener {
    private JarInfo info;
    boolean failed = false;
    private JButton jButton1;
    private JButton jButton2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JList jList1;
    private JList jList2;
    private JProgressBar jProgressBar1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    boolean isAqua = "Aqua".equals(UIManager.getLookAndFeel().getID());
    int SPACE = this.isAqua ? 12 : 5;

    public SelectBeansPage() {
        super(false);
        this.initComponents();
        this.jList1.setModel(new DefaultListModel());
        this.jList2.setModel(new DefaultListModel());
        this.setLayout(null);
    }

    public void addNotify() {
        super.addNotify();
        String s = (String)this.getWizardData("jarFileName");
        if (s != null) {
            if (!new File(s).isFile()) {
                this.setProblem("Jar file not specified or not found");
            } else if (this.info == null || !this.info.getFileName().equals(s)) {
                this.jProgressBar1.setValue(0);
                this.jProgressBar1.setVisible(true);
                this.info = new JarInfo(s);
                this.info.scan(this);
                super.putWizardData("jarInfo", this.info);
            }
        }
    }

    public void removeNotify() {
        super.removeNotify();
    }

    public static String getStep() {
        return "selectBeans";
    }

    public static String getDescription() {
        return "Select JavaBeans";
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.jScrollPane2 = new JScrollPane();
        this.jList2 = new JList();
        this.jLabel2 = new JLabel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jProgressBar1 = new JProgressBar();
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.jLabel1.setLabelFor(this.jList1);
        this.jLabel1.setText("Classes");
        this.jLabel1.setEnabled(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jList1.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            public int getSize() {
                return this.strings.length;
            }

            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jList1.setEnabled(false);
        this.jList1.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                SelectBeansPage.this.jList1ValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jList2.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            public int getSize() {
                return this.strings.length;
            }

            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jList2.setEnabled(false);
        this.jList2.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                SelectBeansPage.this.jList2ValueChanged(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.jList2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane2, gridBagConstraints);
        this.jLabel2.setLabelFor(this.jList2);
        this.jLabel2.setText("JavaBeans");
        this.jLabel2.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.jButton1.setText("Add ->");
        this.jButton1.setEnabled(false);
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectBeansPage.this.jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.jButton1, gridBagConstraints);
        this.jButton2.setText("<- Remove");
        this.jButton2.setEnabled(false);
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectBeansPage.this.jButton2ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jButton2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets = new Insets(5, 22, 5, 22);
        this.add((Component)this.jProgressBar1, gridBagConstraints);
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        int[] ixs = this.jList2.getSelectedIndices();
        Arrays.sort(ixs);
        if (ixs.length > 0) {
            for (int i = ixs.length - 1; i >= 0; --i) {
                BeanItem item = (BeanItem)this.jList2.getModel().getElementAt(ixs[i]);
                BeansListModel mdl = (BeansListModel)this.jList2.getModel();
                mdl.remove(item);
                if (mdl.getSize() != 0) continue;
                this.setProblem("No JavaBeans selected");
            }
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        int[] ixs = this.jList1.getSelectedIndices();
        if (ixs.length > 0) {
            for (int i = 0; i < ixs.length; ++i) {
                BeanItem item = (BeanItem)this.jList1.getModel().getElementAt(ixs[i]);
                BeansListModel mdl = (BeansListModel)this.jList2.getModel();
                mdl.add(item);
            }
        }
    }

    private void jList2ValueChanged(ListSelectionEvent evt) {
        int[] ixs = this.jList2.getSelectedIndices();
        this.jButton2.setEnabled(ixs.length > 0);
    }

    private void jList1ValueChanged(ListSelectionEvent evt) {
        int[] ixs = this.jList1.getSelectedIndices();
        if (ixs.length > 0) {
            boolean enableAdd = false;
            for (int i = 0; i < ixs.length; ++i) {
                Object o = this.jList1.getModel().getElementAt(ixs[i]);
                if (!(o instanceof BeanItem)) {
                    return;
                }
                BeanItem item = (BeanItem)o;
                if (this.info.getBeans().contains(item)) continue;
                enableAdd = true;
                break;
            }
            this.jButton1.setEnabled(enableAdd);
        } else {
            this.jButton1.setEnabled(false);
        }
    }

    public void start() {
        this.setBusy(true);
        this.jProgressBar1.setVisible(true);
        this.jLabel1.setEnabled(false);
        this.jLabel2.setEnabled(false);
        this.jList1.setEnabled(false);
        this.jList2.setEnabled(false);
        this.jButton1.setEnabled(false);
        this.jButton2.setEnabled(false);
        this.failed = false;
    }

    public void progress(int progress) {
        if (progress != Integer.MIN_VALUE && progress != Integer.MAX_VALUE) {
            this.jProgressBar1.setValue(progress);
        } else if (progress == Integer.MAX_VALUE) {
            this.jProgressBar1.setValue(100);
        }
    }

    public void fail(String msg) {
        this.failed = true;
        this.setProblem(msg);
    }

    public void done() {
        BeansListModel beans = new BeansListModel(this.info);
        EntriesListModel entries = new EntriesListModel(this.info);
        this.jList1.setModel(entries);
        this.jList2.setModel(beans);
        this.jList1.setEnabled(!this.failed);
        this.jList2.setEnabled(!this.failed);
        this.jLabel1.setEnabled(!this.failed);
        this.jLabel2.setEnabled(!this.failed);
        this.jProgressBar1.setVisible(false);
        this.setBusy(false);
        beans.addListDataListener(this);
        this.updateCodeName();
        if (this.jList1.getSelectedIndices().length == 0 && this.jList1.getModel().getSize() > 0) {
            this.jList1.setSelectedIndex(0);
        }
        if (beans.getSize() == 0) {
            this.setProblem("Add some classes to the list of components");
        }
        this.doLayout();
    }

    public void intervalAdded(ListDataEvent e) {
        this.updateCodeName();
    }

    public void intervalRemoved(ListDataEvent e) {
        this.updateCodeName();
    }

    public void contentsChanged(ListDataEvent e) {
        this.updateCodeName();
    }

    public void requestFocus() {
        if (this.jList1.getSelectedIndices().length == 0 && this.jList1.getModel().getSize() > 0) {
            this.jList1.setSelectedIndex(0);
        }
        this.jList1.requestFocus();
    }

    private void updateCodeName() {
        String s;
        if (this.jList2.getModel() instanceof BeansListModel && (s = ((BeansListModel)this.jList2.getModel()).getLikelyCodeName()) != null) {
            this.putWizardData("codename", s);
        }
    }

    public void doLayout() {
        int buttonPreferredSize = Math.max(this.jButton1.getPreferredSize().width, this.jButton2.getPreferredSize().width);
        Insets ins = this.getInsets();
        int workingWidth = this.getWidth() - (ins.left + ins.right);
        int x = ins.left;
        int y = ins.top;
        int workingHeight = this.getHeight() - (ins.top + ins.bottom);
        int buttonGap = buttonPreferredSize + this.SPACE * 2;
        int listWidth = (workingWidth - buttonGap) / 2;
        int lblHeight = Math.max(this.jLabel1.getPreferredSize().height, this.jLabel2.getPreferredSize().height);
        int listsY = y + lblHeight + this.SPACE;
        if (this.jProgressBar1.isVisible()) {
            int h = this.jProgressBar1.getPreferredSize().height;
            this.jProgressBar1.setBounds(x, this.getHeight() / 2 - h / 2, workingWidth, h);
            this.jScrollPane1.setBounds(0, 0, 0, 0);
            this.jScrollPane2.setBounds(0, 0, 0, 0);
            this.jButton1.setBounds(0, 0, 0, 0);
            this.jButton2.setBounds(0, 0, 0, 0);
            this.jLabel1.setBounds(0, 0, 0, 0);
            this.jLabel2.setBounds(0, 0, 0, 0);
            return;
        }
        this.jScrollPane1.setBounds(x, listsY, listWidth, workingHeight - listsY);
        this.jScrollPane2.setBounds(x + listWidth + buttonGap, listsY, listWidth, workingHeight - listsY);
        this.jLabel1.setBounds(x, y, this.jLabel1.getPreferredSize().width, lblHeight);
        this.jLabel2.setBounds(x + listWidth + buttonGap, y, this.jLabel2.getPreferredSize().width, lblHeight);
        int button1height = this.jButton1.getPreferredSize().height;
        this.jButton1.setBounds(x + listWidth + this.SPACE, listsY, buttonPreferredSize, button1height);
        this.jButton2.setBounds(x + listWidth + this.SPACE, listsY + button1height + this.SPACE, buttonPreferredSize, this.jButton2.getPreferredSize().height);
    }
}

