/*
 * Decompiled with CFR 0.152.
 */
package beans2nbm.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.JTextComponent;
import org.netbeans.spi.wizard.WizardPage;

public class OutputLocationPage
extends WizardPage {
    private static final String KEY_OUTPATH = "OutputPath";
    private JFileChooser jfc = null;
    private JTextField fileField;
    private JTextField folderField;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel2;

    public OutputLocationPage() {
        this.initComponents();
    }

    public static String getStep() {
        return "destination";
    }

    public static String getDescription() {
        return "Choose Output Location";
    }

    public void addNotify() {
        super.addNotify();
        String s = (String)this.getWizardData("codename");
        if (s != null) {
            char[] c = s.toCharArray();
            for (int i = 0; i < c.length; ++i) {
                if (c[i] != '.') continue;
                c[i] = 45;
            }
            this.fileField.setText(new String(c) + ".nbm");
        } else {
            String dir = Preferences.userNodeForPackage(this.getClass()).get(KEY_OUTPATH, null);
            if (new File(dir).exists()) {
                this.fileField.setText(dir);
            }
        }
    }

    protected String validateContents(Component component, Object event) {
        String s = this.fileField.getText();
        if (s.trim().length() == 0) {
            return "Enter a file name ending with .nbm";
        }
        if (!s.endsWith(".nbm")) {
            return "File name must end with .nbm";
        }
        if (s.indexOf("\\") > 0 || s.indexOf("/") > 0) {
            return "File name contains illegal characters";
        }
        if (s.indexOf(" ") > 0) {
            return "File names containing spaces are not recommended";
        }
        String fld = this.folderField.getText();
        File f = new File(fld);
        if (f.isFile()) {
            return f.getName() + " is a file, not a directory";
        }
        if (!f.exists()) {
            return "Directory " + f.getName() + " does not exist";
        }
        Preferences.userNodeForPackage(this.getClass()).put(KEY_OUTPATH, f.getPath());
        return null;
    }

    public void requestFocus() {
        this.folderField.requestFocus();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.folderField = new JTextField();
        this.jButton1 = new JButton();
        this.jLabel2 = new JLabel();
        this.fileField = new JTextField();
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.jLabel1.setText("Destination Folder");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 5, 5);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.folderField.setName("destFolder");
        this.folderField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                OutputLocationPage.this.folderFieldFocusGained(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.add((Component)this.folderField, gridBagConstraints);
        this.jButton1.setText("Browse");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OutputLocationPage.this.jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.jButton1, gridBagConstraints);
        this.jLabel2.setText("File Name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 0, 5);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.fileField.setName("destFileName");
        this.fileField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                OutputLocationPage.this.folderFieldFocusGained(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.fileField, gridBagConstraints);
    }

    private void folderFieldFocusGained(FocusEvent evt) {
        JTextComponent jtc = (JTextComponent)evt.getSource();
        jtc.selectAll();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        if (this.jfc == null) {
            File f;
            this.jfc = new JFileChooser();
            String dir = Preferences.userNodeForPackage(this.getClass()).get(KEY_OUTPATH, null);
            this.jfc.setFileHidingEnabled(true);
            this.jfc.setFileSelectionMode(1);
            this.jfc.setMultiSelectionEnabled(false);
            if (dir != null && (f = new File(dir)).exists() && f.isDirectory()) {
                this.jfc.setCurrentDirectory(f);
            }
        }
        if (this.jfc.showOpenDialog(this) == 0) {
            File sel = this.jfc.getSelectedFile();
            this.setOutputDir(sel);
            Preferences.userNodeForPackage(this.getClass()).put(KEY_OUTPATH, sel.getPath());
        }
    }

    private void setOutputDir(File f) {
        this.folderField.setText(f.getPath());
    }

    private static final class FF
    extends FileFilter {
        private FF() {
        }

        public String getDescription() {
            return "Folders";
        }

        public boolean accept(File f) {
            return f.isDirectory();
        }
    }
}

