/*
 * Decompiled with CFR 0.152.
 */
package beans2nbm.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.JTextComponent;
import org.netbeans.spi.wizard.WizardPage;

public class LocateJarPage
extends WizardPage {
    private JFileChooser jfc;
    public static final String KEY_PATH = "LastKnownPath";
    private JButton browseForJarButton;
    private JButton browseForJavadocButton;
    private JButton browseForSourcesButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JTextField jTextField1;
    private JTextField jTextField2;
    private JTextField jTextField3;

    public LocateJarPage() {
        super(true);
        this.initComponents();
    }

    public static String getStep() {
        return "locateJar";
    }

    public static String getDescription() {
        return "Locate JAR";
    }

    public void addNotify() {
        super.addNotify();
        this.userInputReceived(this.jTextField1, null);
        JDialog dlg = (JDialog)SwingUtilities.getAncestorOfClass(JDialog.class, this);
        if (dlg != null) {
            dlg.setTitle("BeanNetter - the NetBeans Module Generator");
        }
    }

    protected String validateContents(Component component, Object event) {
        String s = this.jTextField1.getText();
        if (s.trim().length() == 0) {
            return "Type path to or browse for a JAR file";
        }
        File f = new File(s);
        if (!f.exists()) {
            return s + " does not exist";
        }
        if (!f.getName().endsWith(".jar")) {
            return s + " is not a jar file";
        }
        if (!f.canRead()) {
            return "Cannot read " + f.getName();
        }
        s = this.jTextField2.getText();
        f = new File(s);
        if (!"".equals(s) && f.exists() && !f.canRead()) {
            return "Cannot read " + f.getName();
        }
        if (!"".equals(s) && !f.isFile()) {
            return f.getName() + " is not a file";
        }
        s = this.jTextField3.getText();
        if (!"".equals(s) && f.exists() && !f.canRead()) {
            return "Cannot read " + f.getName();
        }
        if (!"".equals(s) && !f.isFile()) {
            return f.getName() + " is not a file";
        }
        return null;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextField1 = new JTextField();
        this.browseForJarButton = new JButton();
        this.jLabel2 = new JLabel();
        this.jTextField2 = new JTextField();
        this.browseForSourcesButton = new JButton();
        this.jLabel3 = new JLabel();
        this.jTextField3 = new JTextField();
        this.browseForJavadocButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.jLabel1.setText("Jar File");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 0, 0, 5);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jTextField1.setName("jarFileName");
        this.jTextField1.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                LocateJarPage.this.jTextField1FocusGained(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 200;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jTextField1, gridBagConstraints);
        this.browseForJarButton.setText("Browse");
        this.browseForJarButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LocateJarPage.this.browseForJarButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.browseForJarButton, gridBagConstraints);
        this.jLabel2.setText("Sources JAR/Zip (optional)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(2, 0, 0, 5);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.jTextField2.setName("sourceJar");
        this.jTextField2.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                LocateJarPage.this.jTextField1FocusGained(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 200;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jTextField2, gridBagConstraints);
        this.browseForSourcesButton.setText("Browse");
        this.browseForSourcesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LocateJarPage.this.browseForJarButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.add((Component)this.browseForSourcesButton, gridBagConstraints);
        this.jLabel3.setText("Javadoc JAR/Zip (optional)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(2, 0, 0, 5);
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.jTextField3.setName("docsJar");
        this.jTextField3.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                LocateJarPage.this.jTextField1FocusGained(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 200;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jTextField3, gridBagConstraints);
        this.browseForJavadocButton.setText("Browse");
        this.browseForJavadocButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LocateJarPage.this.browseForJarButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.browseForJavadocButton, gridBagConstraints);
    }

    private void jTextField1FocusGained(FocusEvent evt) {
        JTextComponent jtc = (JTextComponent)evt.getSource();
        jtc.selectAll();
    }

    private void browseForJarButtonActionPerformed(ActionEvent evt) {
        if (this.jfc == null) {
            File f;
            this.jfc = new JFileChooser();
            String dir = Preferences.userNodeForPackage(this.getClass()).get(KEY_PATH, null);
            this.jfc.setFileHidingEnabled(true);
            this.jfc.setFileFilter(new FF());
            if (dir != null && (f = new File(dir)).exists() && f.isDirectory()) {
                this.jfc.setCurrentDirectory(f);
            }
        }
        if (this.jfc.showOpenDialog(this) == 0) {
            File sel = this.jfc.getSelectedFile();
            if (evt.getSource() == this.browseForJarButton) {
                this.setFile(sel);
            } else if (evt.getSource() == this.browseForSourcesButton) {
                this.setSourceFile(sel);
            } else {
                this.setDocsFile(sel);
            }
            if (sel.getParent() != null) {
                Preferences.userNodeForPackage(this.getClass()).put(KEY_PATH, sel.getParent());
            }
        }
    }

    private void setFile(File f) {
        this.jTextField1.setText(f.getPath());
    }

    private void setSourceFile(File f) {
        this.jTextField2.setText(f.getPath());
    }

    private void setDocsFile(File f) {
        this.jTextField3.setText(f.getPath());
    }

    public void requestFocus() {
        this.browseForJarButton.requestFocus();
    }

    private static final class FF
    extends FileFilter {
        private FF() {
        }

        public String getDescription() {
            return "JAR Files";
        }

        public boolean accept(File f) {
            return f.isDirectory() || f.exists() && f.isFile() && (f.getName().endsWith(".jar") || f.getName().endsWith(".JAR") || f.getName().endsWith(".zip") || f.getName().endsWith(".ZIP"));
        }
    }
}

