/*
 * Decompiled with CFR 0.152.
 */
package beans2nbm.ui;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import org.netbeans.spi.wizard.WizardPage;

public class LibDataPage
extends WizardPage {
    private JTextArea descriptionField;
    private JLabel descriptionLabel;
    private JTextField displayNameField;
    private JComboBox jComboBox1;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JLabel libNameLabel;
    private JTextField uidField;
    private JLabel uniqueIdLabel;
    private JTextField versionField;
    private JLabel versionLabel;

    public LibDataPage() {
        this.initComponents();
    }

    public void addNotify() {
        String s;
        super.addNotify();
        String codeName = (String)this.getWizardData("codename");
        if (codeName != null) {
            this.uidField.setText(codeName);
        }
        if ((s = this.validateContents(null, null)) != null) {
            this.setProblem(s);
        }
    }

    public void requestFocus() {
        this.displayNameField.requestFocus();
    }

    protected String validateContents(Component component, Object event) {
        String txt = this.displayNameField.getText();
        if (txt.trim().length() == 0) {
            return "Enter a name for the library containing your JavaBeans";
        }
        if (txt.indexOf("\\") > 0 || txt.indexOf("/") > 0) {
            return "Display name may not contain / or \\ characters";
        }
        if (txt.indexOf(38) > 0 || txt.indexOf(59) > 0 || txt.indexOf(58) > 0) {
            return "Display name may not contain & : or ; characters";
        }
        txt = this.uidField.getText();
        if (txt.length() == 0) {
            return "Enter a unique ID";
        }
        if (txt.length() < 5) {
            return "Unique ID should be at least 5 characters in length";
        }
        char[] c = txt.toCharArray();
        boolean dotFound = false;
        if (Character.isDigit(c[0])) {
            return "Unique ID may not start with a number";
        }
        if (c[c.length - 1] == '.') {
            return "Unique ID may not end with a dot";
        }
        for (int i = 0; i < c.length; ++i) {
            dotFound |= c[i] == '.';
            if (Character.isWhitespace(c[i])) {
                return "Unique ID cannot contain whitespace - try a package name";
            }
            if (c[i] != '/' && c[i] != '\\') continue;
            return "Unique ID cannot contain \\ or / characters - try a package name";
        }
        if (!dotFound) {
            return "Unique ID should contain at least 1 dot character - try a package name";
        }
        String s = this.versionField.getText();
        try {
            Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            return "Not a decimal number: " + s;
        }
        return null;
    }

    public static String getStep() {
        return "libInfo";
    }

    public static String getDescription() {
        return "Library Description";
    }

    private void initComponents() {
        this.libNameLabel = new JLabel();
        this.displayNameField = new JTextField();
        this.descriptionLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.descriptionField = new JTextArea();
        this.uniqueIdLabel = new JLabel();
        this.uidField = new JTextField();
        this.versionLabel = new JLabel();
        this.versionField = new JTextField();
        this.jLabel1 = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.setLayout(new GridBagLayout());
        this.libNameLabel.setLabelFor(this.displayNameField);
        this.libNameLabel.setText("Library Display Name");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 0, 5, 5);
        this.add((Component)this.libNameLabel, gridBagConstraints);
        this.displayNameField.setToolTipText("The name of your company, or whatever category should be used in the component palette");
        this.displayNameField.setName("displayName");
        this.displayNameField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                LibDataPage.this.displayNameFieldFocusGained(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.displayNameField, gridBagConstraints);
        this.descriptionLabel.setText("Description");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 0, 5, 0);
        this.add((Component)this.descriptionLabel, gridBagConstraints);
        this.descriptionField.setColumns(20);
        this.descriptionField.setFont(UIManager.getFont("Label.font") == null ? new Font("SansSerif", 12, 1) : UIManager.getFont("Label.font"));
        this.descriptionField.setLineWrap(true);
        this.descriptionField.setRows(5);
        this.descriptionField.setToolTipText("Will be shown in the Module Manager dialog in the IDE");
        this.descriptionField.setWrapStyleWord(true);
        this.descriptionField.setName("description");
        this.jScrollPane1.setViewportView(this.descriptionField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.75;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.uniqueIdLabel.setText("Unique ID");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 0, 5, 5);
        this.add((Component)this.uniqueIdLabel, gridBagConstraints);
        this.uidField.setText("org.foo.mylib");
        this.uidField.setToolTipText("Should be something resembling a java package name");
        this.uidField.setName("codeName");
        this.uidField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                LibDataPage.this.displayNameFieldFocusGained(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.uidField, gridBagConstraints);
        this.versionLabel.setText("Version");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 0, 5, 5);
        this.add((Component)this.versionLabel, gridBagConstraints);
        this.versionField.setText("1.0");
        this.versionField.setToolTipText("A dewey decimal format number such as 1.2");
        this.versionField.setName("libversion");
        this.versionField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                LibDataPage.this.displayNameFieldFocusGained(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.versionField, gridBagConstraints);
        this.jLabel1.setText("Minimum Java Version");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 5, 5);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"1.4", "1.5", "1.6"}));
        this.jComboBox1.setName("javaVersion");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.jComboBox1, gridBagConstraints);
    }

    private void displayNameFieldFocusGained(FocusEvent evt) {
        JTextComponent jtc = (JTextComponent)evt.getSource();
        jtc.selectAll();
    }
}

