/*
 * Decompiled with CFR 0.152.
 */
package beans2nbm.ui;

import beans2nbm.gen.JarInfo;
import beans2nbm.ui.BeanItem;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class BeansListModel
implements ListModel {
    private final JarInfo info;
    private final List listeners = Collections.synchronizedList(new LinkedList());

    public BeansListModel(JarInfo info) {
        this.info = info;
    }

    public int getSize() {
        return this.info.getBeans().size();
    }

    public Object getElementAt(int index) {
        return new BeanItem(this.info.getBeans().get(index).toString());
    }

    public void addListDataListener(ListDataListener l) {
        this.listeners.add(l);
    }

    public void removeListDataListener(ListDataListener l) {
        this.listeners.remove(l);
    }

    public String getLikelyCodeName() {
        if (this.getSize() > 0) {
            BeanItem item = (BeanItem)this.getElementAt(0);
            return item.getPackageName();
        }
        return "com.foo.mycom";
    }

    public void add(BeanItem item) {
        List l = this.info.getBeans();
        if (!l.contains(item.getPath())) {
            this.info.getBeans().add(item.getPath());
            ListDataEvent lde = new ListDataEvent(this, 1, l.size(), l.size());
            ListDataListener[] ll = this.listeners.toArray(new ListDataListener[this.listeners.size()]);
            for (int i = 0; i < ll.length; ++i) {
                ll[i].intervalAdded(lde);
            }
        }
    }

    public void remove(BeanItem item) {
        List l = this.info.getBeans();
        int ix = l.indexOf(item.getPath());
        if (ix >= 0) {
            l.remove(ix);
            ListDataEvent lde = new ListDataEvent(this, 1, ix, ix);
            ListDataListener[] ll = this.listeners.toArray(new ListDataListener[this.listeners.size()]);
            for (int i = 0; i < ll.length; ++i) {
                ll[i].intervalRemoved(lde);
            }
        }
    }
}

